/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.transport.ip;

import freenet.io.AddressIdentifier;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class HostnameUtil {
    private static volatile boolean logDEBUG;

    public static boolean isValidHostname(String hn, boolean allowIPAddress) {
        if (allowIPAddress) {
            AddressIdentifier.AddressType addressType = AddressIdentifier.getAddressType(hn, true);
            if (logDEBUG) {
                Logger.debug(null, "Address type of '" + hn + "' appears to be '" + (Object)((Object)addressType) + '\'');
            }
            if (!addressType.toString().equals("Other")) {
                return true;
            }
        }
        if (!hn.matches("(?:[-!#\\$%&'\\*+\\\\/0-9=?A-Z^_`a-z{|}]+\\.)+[a-zA-Z]{2,6}")) {
            System.err.println("Failed to match " + hn + " as a hostname or IPv4/IPv6 IP address");
            return false;
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

