/* A Bison parser, made by GNU Bison 3.7.2.  */

/* Skeleton implementation for Bison GLR parsers in C

   Copyright (C) 2002-2015, 2018-2020 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C GLR parser skeleton written by Paul Hilfinger.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.7.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "glr.c"

/* Pure parsers.  */
#define YYPURE 1






/* First part of user prologue.  */
#line 1 "config_parser.yy"

#define YYDEBUG 1

/* Icinga 2 | (c) 2012 Icinga GmbH | GPLv2+ */

#include "config/i2-config.hpp"
#include "config/configcompiler.hpp"
#include "config/expression.hpp"
#include "config/applyrule.hpp"
#include "config/objectrule.hpp"
#include "base/value.hpp"
#include "base/utility.hpp"
#include "base/exception.hpp"
#include "base/configtype.hpp"
#include "base/exception.hpp"
#include <sstream>
#include <stack>

#define YYLTYPE icinga::CompilerDebugInfo
#define YYERROR_VERBOSE

#define YYLLOC_DEFAULT(Current, Rhs, N)					\
do {									\
	if (N) {							\
		(Current).Path = YYRHSLOC(Rhs, 1).Path;			\
		(Current).FirstLine = YYRHSLOC(Rhs, 1).FirstLine;	\
		(Current).FirstColumn = YYRHSLOC(Rhs, 1).FirstColumn;	\
		(Current).LastLine = YYRHSLOC(Rhs, N).LastLine;		\
		(Current).LastColumn = YYRHSLOC(Rhs, N).LastColumn;	\
	} else {							\
		(Current).Path = YYRHSLOC(Rhs, 0).Path;			\
		(Current).FirstLine = (Current).LastLine =		\
		YYRHSLOC(Rhs, 0).LastLine;				\
		(Current).FirstColumn = (Current).LastColumn =		\
		YYRHSLOC(Rhs, 0).LastColumn;				\
	}								\
} while (0)

#define YY_LOCATION_PRINT(file, loc)			\
do {							\
	std::ostringstream msgbuf;			\
	msgbuf << loc;					\
	std::string str = msgbuf.str();			\
	fputs(str.c_str(), file);			\
} while (0)

#define YYINITDEPTH 10000

using namespace icinga;

template<typename T>
static void MakeRBinaryOp(Expression** result, Expression *left, Expression *right, const DebugInfo& diLeft, const DebugInfo& diRight)
{
	*result = new T(std::unique_ptr<Expression>(left), std::unique_ptr<Expression>(right), DebugInfoRange(diLeft, diRight));
}


#line 116 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "config_parser.hh"

/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_NEWLINE = 3,                  /* "new-line"  */
  YYSYMBOL_T_STRING = 4,                   /* T_STRING  */
  YYSYMBOL_T_STRING_ANGLE = 5,             /* T_STRING_ANGLE  */
  YYSYMBOL_T_NUMBER = 6,                   /* T_NUMBER  */
  YYSYMBOL_T_BOOLEAN = 7,                  /* T_BOOLEAN  */
  YYSYMBOL_T_NULL = 8,                     /* T_NULL  */
  YYSYMBOL_T_IDENTIFIER = 9,               /* T_IDENTIFIER  */
  YYSYMBOL_T_SET = 10,                     /* "= (T_SET)"  */
  YYSYMBOL_T_SET_ADD = 11,                 /* "+= (T_SET_ADD)"  */
  YYSYMBOL_T_SET_SUBTRACT = 12,            /* "-= (T_SET_SUBTRACT)"  */
  YYSYMBOL_T_SET_MULTIPLY = 13,            /* "*= (T_SET_MULTIPLY)"  */
  YYSYMBOL_T_SET_DIVIDE = 14,              /* "/= (T_SET_DIVIDE)"  */
  YYSYMBOL_T_SET_MODULO = 15,              /* "%= (T_SET_MODULO)"  */
  YYSYMBOL_T_SET_XOR = 16,                 /* "^= (T_SET_XOR)"  */
  YYSYMBOL_T_SET_BINARY_AND = 17,          /* "&= (T_SET_BINARY_AND)"  */
  YYSYMBOL_T_SET_BINARY_OR = 18,           /* "|= (T_SET_BINARY_OR)"  */
  YYSYMBOL_T_SHIFT_LEFT = 19,              /* "<< (T_SHIFT_LEFT)"  */
  YYSYMBOL_T_SHIFT_RIGHT = 20,             /* ">> (T_SHIFT_RIGHT)"  */
  YYSYMBOL_T_EQUAL = 21,                   /* "== (T_EQUAL)"  */
  YYSYMBOL_T_NOT_EQUAL = 22,               /* "!= (T_NOT_EQUAL)"  */
  YYSYMBOL_T_IN = 23,                      /* "in (T_IN)"  */
  YYSYMBOL_T_NOT_IN = 24,                  /* "!in (T_NOT_IN)"  */
  YYSYMBOL_T_LOGICAL_AND = 25,             /* "&& (T_LOGICAL_AND)"  */
  YYSYMBOL_T_LOGICAL_OR = 26,              /* "|| (T_LOGICAL_OR)"  */
  YYSYMBOL_T_LESS_THAN_OR_EQUAL = 27,      /* "<= (T_LESS_THAN_OR_EQUAL)"  */
  YYSYMBOL_T_GREATER_THAN_OR_EQUAL = 28,   /* ">= (T_GREATER_THAN_OR_EQUAL)"  */
  YYSYMBOL_T_PLUS = 29,                    /* "+ (T_PLUS)"  */
  YYSYMBOL_T_MINUS = 30,                   /* "- (T_MINUS)"  */
  YYSYMBOL_T_MULTIPLY = 31,                /* "* (T_MULTIPLY)"  */
  YYSYMBOL_T_DIVIDE_OP = 32,               /* "/ (T_DIVIDE_OP)"  */
  YYSYMBOL_T_MODULO = 33,                  /* "% (T_MODULO)"  */
  YYSYMBOL_T_XOR = 34,                     /* "^ (T_XOR)"  */
  YYSYMBOL_T_BINARY_AND = 35,              /* "& (T_BINARY_AND)"  */
  YYSYMBOL_T_BINARY_OR = 36,               /* "| (T_BINARY_OR)"  */
  YYSYMBOL_T_LESS_THAN = 37,               /* "< (T_LESS_THAN)"  */
  YYSYMBOL_T_GREATER_THAN = 38,            /* "> (T_GREATER_THAN)"  */
  YYSYMBOL_T_VAR = 39,                     /* "var (T_VAR)"  */
  YYSYMBOL_T_GLOBALS = 40,                 /* "globals (T_GLOBALS)"  */
  YYSYMBOL_T_LOCALS = 41,                  /* "locals (T_LOCALS)"  */
  YYSYMBOL_T_CONST = 42,                   /* "const (T_CONST)"  */
  YYSYMBOL_T_DEFAULT = 43,                 /* "default (T_DEFAULT)"  */
  YYSYMBOL_T_IGNORE_ON_ERROR = 44,         /* "ignore_on_error (T_IGNORE_ON_ERROR)"  */
  YYSYMBOL_T_CURRENT_FILENAME = 45,        /* "current_filename (T_CURRENT_FILENAME)"  */
  YYSYMBOL_T_CURRENT_LINE = 46,            /* "current_line (T_CURRENT_LINE)"  */
  YYSYMBOL_T_DEBUGGER = 47,                /* "debugger (T_DEBUGGER)"  */
  YYSYMBOL_T_NAMESPACE = 48,               /* "namespace (T_NAMESPACE)"  */
  YYSYMBOL_T_USE = 49,                     /* "use (T_USE)"  */
  YYSYMBOL_T_USING = 50,                   /* "using (T_USING)"  */
  YYSYMBOL_T_OBJECT = 51,                  /* "object (T_OBJECT)"  */
  YYSYMBOL_T_TEMPLATE = 52,                /* "template (T_TEMPLATE)"  */
  YYSYMBOL_T_INCLUDE = 53,                 /* "include (T_INCLUDE)"  */
  YYSYMBOL_T_INCLUDE_RECURSIVE = 54,       /* "include_recursive (T_INCLUDE_RECURSIVE)"  */
  YYSYMBOL_T_INCLUDE_ZONES = 55,           /* "include_zones (T_INCLUDE_ZONES)"  */
  YYSYMBOL_T_LIBRARY = 56,                 /* "library (T_LIBRARY)"  */
  YYSYMBOL_T_APPLY = 57,                   /* "apply (T_APPLY)"  */
  YYSYMBOL_T_TO = 58,                      /* "to (T_TO)"  */
  YYSYMBOL_T_WHERE = 59,                   /* "where (T_WHERE)"  */
  YYSYMBOL_T_IMPORT = 60,                  /* "import (T_IMPORT)"  */
  YYSYMBOL_T_ASSIGN = 61,                  /* "assign (T_ASSIGN)"  */
  YYSYMBOL_T_IGNORE = 62,                  /* "ignore (T_IGNORE)"  */
  YYSYMBOL_T_FUNCTION = 63,                /* "function (T_FUNCTION)"  */
  YYSYMBOL_T_RETURN = 64,                  /* "return (T_RETURN)"  */
  YYSYMBOL_T_BREAK = 65,                   /* "break (T_BREAK)"  */
  YYSYMBOL_T_CONTINUE = 66,                /* "continue (T_CONTINUE)"  */
  YYSYMBOL_T_FOR = 67,                     /* "for (T_FOR)"  */
  YYSYMBOL_T_IF = 68,                      /* "if (T_IF)"  */
  YYSYMBOL_T_ELSE = 69,                    /* "else (T_ELSE)"  */
  YYSYMBOL_T_WHILE = 70,                   /* "while (T_WHILE)"  */
  YYSYMBOL_T_THROW = 71,                   /* "throw (T_THROW)"  */
  YYSYMBOL_T_TRY = 72,                     /* "try (T_TRY)"  */
  YYSYMBOL_T_EXCEPT = 73,                  /* "except (T_EXCEPT)"  */
  YYSYMBOL_T_FOLLOWS = 74,                 /* "=> (T_FOLLOWS)"  */
  YYSYMBOL_T_NULLARY_LAMBDA_BEGIN = 75,    /* "{{ (T_NULLARY_LAMBDA_BEGIN)"  */
  YYSYMBOL_T_NULLARY_LAMBDA_END = 76,      /* "}} (T_NULLARY_LAMBDA_END)"  */
  YYSYMBOL_77_ = 77,                       /* '?'  */
  YYSYMBOL_78_ = 78,                       /* ':'  */
  YYSYMBOL_UNARY_MINUS = 79,               /* UNARY_MINUS  */
  YYSYMBOL_UNARY_PLUS = 80,                /* UNARY_PLUS  */
  YYSYMBOL_REF_OP = 81,                    /* REF_OP  */
  YYSYMBOL_DEREF_OP = 82,                  /* DEREF_OP  */
  YYSYMBOL_83_ = 83,                       /* '!'  */
  YYSYMBOL_84_ = 84,                       /* '~'  */
  YYSYMBOL_85_ = 85,                       /* '.'  */
  YYSYMBOL_86_ = 86,                       /* '('  */
  YYSYMBOL_87_ = 87,                       /* '['  */
  YYSYMBOL_T_THIS = 88,                    /* T_THIS  */
  YYSYMBOL_89_ = 89,                       /* ';'  */
  YYSYMBOL_90_ = 90,                       /* ','  */
  YYSYMBOL_91_ = 91,                       /* ')'  */
  YYSYMBOL_92_ = 92,                       /* ']'  */
  YYSYMBOL_93_ = 93,                       /* '{'  */
  YYSYMBOL_94_ = 94,                       /* '}'  */
  YYSYMBOL_YYACCEPT = 95,                  /* $accept  */
  YYSYMBOL_script = 96,                    /* script  */
  YYSYMBOL_statements = 97,                /* statements  */
  YYSYMBOL_lterm_items = 98,               /* lterm_items  */
  YYSYMBOL_lterm_items_inner = 99,         /* lterm_items_inner  */
  YYSYMBOL_identifier = 100,               /* identifier  */
  YYSYMBOL_object = 101,                   /* object  */
  YYSYMBOL_102_1 = 102,                    /* $@1  */
  YYSYMBOL_103_2 = 103,                    /* $@2  */
  YYSYMBOL_object_declaration = 104,       /* object_declaration  */
  YYSYMBOL_identifier_items = 105,         /* identifier_items  */
  YYSYMBOL_identifier_items_inner = 106,   /* identifier_items_inner  */
  YYSYMBOL_combined_set_op = 107,          /* combined_set_op  */
  YYSYMBOL_optional_var = 108,             /* optional_var  */
  YYSYMBOL_lterm = 109,                    /* lterm  */
  YYSYMBOL_110_3 = 110,                    /* $@3  */
  YYSYMBOL_111_4 = 111,                    /* $@4  */
  YYSYMBOL_112_5 = 112,                    /* $@5  */
  YYSYMBOL_113_6 = 113,                    /* $@6  */
  YYSYMBOL_114_7 = 114,                    /* $@7  */
  YYSYMBOL_115_8 = 115,                    /* $@8  */
  YYSYMBOL_116_9 = 116,                    /* $@9  */
  YYSYMBOL_rterm_items = 117,              /* rterm_items  */
  YYSYMBOL_rterm_items_inner = 118,        /* rterm_items_inner  */
  YYSYMBOL_rterm_array = 119,              /* rterm_array  */
  YYSYMBOL_120_10 = 120,                   /* $@10  */
  YYSYMBOL_rterm_dict = 121,               /* rterm_dict  */
  YYSYMBOL_122_11 = 122,                   /* $@11  */
  YYSYMBOL_rterm_scope_require_side_effect = 123, /* rterm_scope_require_side_effect  */
  YYSYMBOL_124_12 = 124,                   /* $@12  */
  YYSYMBOL_rterm_scope = 125,              /* rterm_scope  */
  YYSYMBOL_126_13 = 126,                   /* $@13  */
  YYSYMBOL_else_if_branch = 127,           /* else_if_branch  */
  YYSYMBOL_else_if_branches = 128,         /* else_if_branches  */
  YYSYMBOL_rterm_side_effect = 129,        /* rterm_side_effect  */
  YYSYMBOL_rterm_no_side_effect_no_dict = 130, /* rterm_no_side_effect_no_dict  */
  YYSYMBOL_131_14 = 131,                   /* $@14  */
  YYSYMBOL_132_15 = 132,                   /* $@15  */
  YYSYMBOL_133_16 = 133,                   /* $@16  */
  YYSYMBOL_134_17 = 134,                   /* $@17  */
  YYSYMBOL_135_18 = 135,                   /* $@18  */
  YYSYMBOL_rterm_no_side_effect = 136,     /* rterm_no_side_effect  */
  YYSYMBOL_rterm = 137,                    /* rterm  */
  YYSYMBOL_target_type_specifier = 138,    /* target_type_specifier  */
  YYSYMBOL_default_specifier = 139,        /* default_specifier  */
  YYSYMBOL_ignore_specifier = 140,         /* ignore_specifier  */
  YYSYMBOL_use_specifier = 141,            /* use_specifier  */
  YYSYMBOL_use_specifier_items = 142,      /* use_specifier_items  */
  YYSYMBOL_use_specifier_item = 143,       /* use_specifier_item  */
  YYSYMBOL_apply_for_specifier = 144,      /* apply_for_specifier  */
  YYSYMBOL_optional_rterm = 145,           /* optional_rterm  */
  YYSYMBOL_apply = 146,                    /* apply  */
  YYSYMBOL_147_19 = 147,                   /* $@19  */
  YYSYMBOL_148_20 = 148,                   /* $@20  */
  YYSYMBOL_newlines = 149,                 /* newlines  */
  YYSYMBOL_optional_newlines = 150,        /* optional_newlines  */
  YYSYMBOL_sep = 151                       /* sep  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Default (constant) value used for initialization for null
   right-hand sides.  Unlike the standard yacc.c template, here we set
   the default value of $$ to a zeroed-out value.  Since the default
   value is undefined, this behavior is technically correct.  */
static YYSTYPE yyval_default;
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;

/* Second part of user prologue.  */
#line 221 "config_parser.yy"


int yylex(YYSTYPE *lvalp, YYLTYPE *llocp, void *scanner);

extern int yydebug;

void yyerror(const YYLTYPE *locp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *, ConfigCompiler *context, const char *err)
{
	bool incomplete = context && context->m_Eof && (context->m_OpenBraces > 0);
	BOOST_THROW_EXCEPTION(ScriptError(err, *locp, incomplete));
}

int yyparse(std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context);

static void BeginFlowControlBlock(ConfigCompiler *compiler, int allowedTypes, bool inherit)
{
	if (inherit)
		allowedTypes |= compiler->m_FlowControlInfo.top();

	compiler->m_FlowControlInfo.push(allowedTypes);
}

static void EndFlowControlBlock(ConfigCompiler *compiler)
{
	compiler->m_FlowControlInfo.pop();
}

static void UseFlowControl(ConfigCompiler *compiler, FlowControlType type, const CompilerDebugInfo& location)
{
	int fci = compiler->m_FlowControlInfo.top();

	if ((type & fci) != type)
		BOOST_THROW_EXCEPTION(ScriptError("Invalid flow control statement.", location));
}

std::unique_ptr<Expression> ConfigCompiler::Compile()
{
	std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > llist;

	//yydebug = 1;

	m_IgnoreNewlines.push(false);
	BeginFlowControlBlock(this, 0, false);

	if (yyparse(&llist, this) != 0)
		return NULL;

	EndFlowControlBlock(this);
	m_IgnoreNewlines.pop();

	std::vector<std::unique_ptr<Expression> > dlist;
	decltype(llist.size()) num = 0;
	for (auto& litem : llist) {
		if (!litem.second.SideEffect && num != llist.size() - 1) {
			yyerror(&litem.second.DebugInfo, NULL, NULL, "Value computed is not used.");
		}
		dlist.emplace_back(std::move(litem.first));
		num++;
	}

	std::unique_ptr<DictExpression> expr{new DictExpression(std::move(dlist))};
	expr->MakeInline();
	return std::move(expr);
}

#define scanner (context->GetScanner())


#line 382 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"


#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif
#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YYFREE
# define YYFREE free
#endif
#ifndef YYMALLOC
# define YYMALLOC malloc
#endif
#ifndef YYREALLOC
# define YYREALLOC realloc
#endif

#ifdef __cplusplus
  typedef bool yybool;
# define yytrue true
# define yyfalse false
#else
  /* When we move to stdbool, get rid of the various casts to yybool.  */
  typedef signed char yybool;
# define yytrue 1
# define yyfalse 0
#endif

#ifndef YYSETJMP
# include <setjmp.h>
# define YYJMP_BUF jmp_buf
# define YYSETJMP(Env) setjmp (Env)
/* Pacify Clang and ICC.  */
# define YYLONGJMP(Env, Val)                    \
 do {                                           \
   longjmp (Env, Val);                          \
   YY_ASSERT (0);                               \
 } while (yyfalse)
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* The _Noreturn keyword of C11.  */
#ifndef _Noreturn
# if (defined __cplusplus \
      && ((201103 <= __cplusplus && !(__GNUC__ == 4 && __GNUC_MINOR__ == 7)) \
          || (defined _MSC_VER && 1900 <= _MSC_VER)))
#  define _Noreturn [[noreturn]]
# elif (!defined __cplusplus                     \
        && (201112 <= (defined __STDC_VERSION__ ? __STDC_VERSION__ : 0)  \
            || 4 < __GNUC__ + (7 <= __GNUC_MINOR__) \
            || (defined __apple_build_version__ \
                ? 6000000 <= __apple_build_version__ \
                : 3 < __clang_major__ + (5 <= __clang_minor__))))
   /* _Noreturn works as-is.  */
# elif 2 < __GNUC__ + (8 <= __GNUC_MINOR__) || 0x5110 <= __SUNPRO_C
#  define _Noreturn __attribute__ ((__noreturn__))
# elif 1200 <= (defined _MSC_VER ? _MSC_VER : 0)
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  7
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2144

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  95
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  57
/* YYNRULES -- Number of rules.  */
#define YYNRULES  174
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  328
/* YYMAXRHS -- Maximum number of symbols on right-hand side of rule.  */
#define YYMAXRHS 12
/* YYMAXLEFT -- Maximum number of symbols to the left of a handle
   accessed by $0, $-1, etc., in any rule.  */
#define YYMAXLEFT 0

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   336

/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    83,     2,     2,     2,     2,     2,     2,
      86,    91,     2,     2,    90,     2,    85,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    78,    89,
       2,     2,     2,    77,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    87,     2,    92,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    93,     2,    94,    84,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    79,    80,    81,    82,    88
};

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   291,   291,   298,   305,   308,   309,   312,   317,   322,
     333,   346,   347,   351,   359,   351,   406,   410,   417,   420,
     421,   424,   430,   442,   443,   444,   445,   446,   447,   448,
     449,   450,   453,   454,   457,   461,   465,   469,   474,   478,
     482,   486,   490,   495,   494,   514,   531,   530,   550,   566,
     571,   576,   581,   586,   585,   597,   603,   604,   606,   605,
     618,   617,   629,   628,   643,   648,   654,   661,   660,   670,
     674,   678,   682,   685,   686,   687,   690,   695,   703,   702,
     715,   714,   737,   736,   758,   757,   780,   787,   790,   798,
     803,   818,   835,   841,   846,   850,   854,   858,   863,   867,
     872,   876,   880,   884,   888,   892,   896,   900,   904,   908,
     912,   917,   916,   930,   941,   940,   952,   960,   962,   961,
     970,   971,   972,   973,   974,   975,   976,   977,   978,   979,
     980,   981,   982,   983,   984,   985,   986,   987,   988,   989,
     991,   990,  1003,  1002,  1027,  1028,  1037,  1038,  1042,  1045,
    1052,  1055,  1062,  1065,  1072,  1075,  1081,  1087,  1095,  1101,
    1108,  1109,  1119,  1131,  1134,  1138,  1149,  1138,  1229,  1230,
    1233,  1234,  1238,  1239,  1240
};
#endif

#define YYPACT_NINF (-258)
#define YYTABLE_NINF (-166)

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      15,    15,    42,  -258,  -258,   301,  -258,  -258,   -37,  -258,
    -258,  -258,   -26,   856,   856,   856,   856,   856,  -258,  -258,
      36,  -258,  -258,  -258,   856,   856,   806,   856,   856,   856,
     856,    -8,     1,    25,   856,  -258,  -258,   -29,   -15,    -9,
     856,   -12,  -258,   856,   856,    22,  -258,  -258,  -258,  -258,
      58,    12,  -258,    16,  -258,  -258,  -258,     4,  -258,    70,
    1240,  -258,    35,    14,  -258,  -258,     3,     3,     3,     3,
    1240,    89,  1887,  1887,  -258,  1887,  1706,  1726,  1887,  1887,
     906,   956,  -258,  -258,    65,    20,  1887,  -258,    68,   856,
     856,  1887,  -258,    39,    15,     3,     3,  -258,    45,    53,
     856,    15,    15,    15,    15,  -258,   301,  1006,  -258,  -258,
     856,  -258,  -258,  -258,  -258,  -258,  -258,  -258,  -258,  -258,
     856,   856,   856,   856,   856,   856,   856,   856,   856,   856,
     856,   856,   856,   856,   856,   856,   856,   856,   856,   856,
     856,   141,   856,   856,   856,    65,   856,   856,    60,   856,
     856,   -12,  1887,   -12,  1887,    63,    65,  -258,    65,  1334,
    1354,    15,   -12,    80,   109,    65,  1427,   856,    67,  -258,
    -258,  -258,    79,   -12,  1887,   741,   161,   161,  1311,  1311,
    2037,  2037,  1976,  1907,  2057,  2057,   165,   165,     3,     3,
       3,   770,  2016,  1996,  2057,  2057,  1818,  -258,    76,    24,
    1887,  1260,  1887,  1056,  1887,  1887,  -258,  -258,  1887,  1798,
    -258,  -258,   109,    83,     9,   -12,  -258,    77,  -258,  -258,
      84,   101,  -258,  -258,    85,  -258,  -258,   856,   856,   856,
     856,   174,  1106,   109,   856,  -258,    15,  -258,  -258,   117,
      15,   856,  -258,   109,   856,    68,  -258,   -12,  -258,    65,
    1156,  -258,   389,   477,   565,   653,    12,   142,  1887,   856,
     100,   129,    94,  1887,   -12,  -258,  1447,    65,   120,  -258,
     185,    19,  -258,   -12,  1887,  -258,   156,  1887,    68,    65,
     109,  -258,  -258,   -12,  -258,   178,   -35,  -258,   856,    65,
    -258,  -258,  -258,  -258,    65,  -258,   156,  -258,    60,   856,
     116,  -258,  1887,  -258,    60,    13,  -258,  -258,  1520,   856,
    -258,   856,    68,    60,  -258,  1540,  1613,    65,  -258,    60,
     -12,  -258,   183,  -258,  -258,   856,  1633,  -258
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
     170,   168,     0,     2,   171,     4,   169,     1,    93,    94,
      95,    96,    99,     0,     0,     0,     0,     0,   107,   108,
       0,   109,   110,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   163,    50,    51,     0,     0,     0,
       0,     0,   142,     0,     0,   118,    78,   106,    80,     3,
       5,     0,    57,     0,     7,   117,   145,   146,   144,   147,
       0,    56,     0,     0,   146,   147,   104,   105,   100,   101,
      65,     0,    53,    55,    37,    36,    38,     0,    34,    42,
       0,     0,    12,    11,    18,     0,   164,    49,    32,     0,
       0,    69,    84,     0,   170,   102,   103,    21,     0,    19,
       0,   170,   170,   170,   170,   174,     6,     0,    16,    17,
       0,    23,    24,    25,    26,    27,    28,    29,    30,    31,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    72,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,    48,     0,    18,    33,     0,     0,
       0,   170,     0,     0,   154,    20,     0,    72,     0,   173,
     172,     9,   147,     0,   113,   163,   132,   133,   126,   127,
     124,   125,   121,   120,   129,   131,   134,   135,   136,   137,
     138,   139,   123,   122,   128,   130,     0,    97,     0,    73,
      76,     0,    35,   163,    66,    64,    82,    54,    39,    40,
      44,    47,   154,     0,     0,     0,    67,     0,    70,   143,
       0,     0,    22,   119,     0,    81,   112,     0,     0,     0,
       0,    18,    78,   154,     0,    89,   170,    75,    98,   160,
     170,     0,   140,   154,     0,    32,    87,     0,    85,     0,
       0,    79,   104,   105,   100,   101,    21,   150,    92,    74,
       0,   148,     0,    41,     0,    62,     0,     0,    90,    68,
     158,     0,   156,     0,   116,   151,   152,    77,    32,     0,
     154,    83,   141,     0,    60,     0,     0,    88,     0,     0,
     155,   115,   153,    14,     0,   149,   152,    63,     0,     0,
       0,    91,   159,   157,     0,     0,   166,    61,     0,     0,
      15,     0,    32,     0,    58,     0,     0,     0,   167,     0,
       0,   162,     0,    59,    86,     0,     0,   161
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -258,  -258,   -89,  -258,  -258,     7,  -258,  -258,  -258,  -258,
     -78,  -258,   137,  -215,   102,  -258,  -258,  -258,  -258,  -258,
    -258,  -258,    43,  -258,  -258,  -258,  -258,  -258,  -257,  -258,
    -107,  -258,  -258,  -258,    -3,  -258,  -258,  -258,  -258,  -258,
    -258,    -2,    -5,  -258,  -258,   -85,  -184,  -258,   -77,  -258,
    -160,  -258,  -258,  -258,     0,   -87,  -258
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     2,     3,    49,    50,    51,    52,    53,   304,   110,
      98,    99,   144,   158,    54,   151,   153,   148,   319,   298,
     283,   247,   198,   199,    55,   101,    56,   102,   207,   240,
      93,   161,   287,   268,    64,    58,   173,   273,   100,   264,
      94,    65,    86,   280,   276,   293,   221,   271,   272,   261,
      87,    61,    62,   313,     4,     5,   106
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      60,     6,    57,    59,   -71,   163,   155,   -71,    66,    67,
      68,    69,    70,   168,   167,   233,   169,   170,     1,    72,
      73,    75,    76,    77,    78,    79,    82,     1,   242,    82,
     267,    83,   244,   300,    83,    91,   311,   -12,    95,    96,
      85,   307,     7,   239,   210,    71,   211,   310,   -11,   257,
     105,    80,    97,   -12,   -12,   218,   318,    88,    92,   265,
      81,     1,   323,   294,   -11,   -11,   226,   108,   109,    82,
      -8,    89,   217,    -8,    83,   152,   154,    90,   213,   -10,
     -71,    92,   -10,   245,   159,   160,   107,   312,   141,   142,
     143,    97,   145,   -71,   -71,   166,   296,   317,   -71,   147,
      84,    60,   174,    57,   172,   175,   156,   157,   246,   289,
     290,    84,   162,   -18,   236,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   164,   200,   201,   202,
     269,   204,   205,   165,   208,   209,    -8,   103,   104,   259,
     197,   262,   203,   206,   212,   -10,   219,   282,   220,    -8,
      -8,   225,   200,    97,    -8,   214,   291,   235,   -10,   -10,
     249,   248,   222,   -10,   243,   250,   297,   251,     8,   301,
       9,    10,    11,    12,   260,   275,   278,   279,   281,   286,
     130,   131,   132,   133,   134,   288,   132,   133,   134,   237,
     292,   299,   309,    13,    14,    15,   325,   146,   171,    16,
     224,   306,   303,   324,    18,    19,     0,     0,     0,    21,
      22,     0,   252,   253,   254,   255,   200,   201,     0,   258,
       0,     0,     0,     0,     0,     0,   263,    63,   256,   266,
       0,     0,    38,     0,     0,   274,   141,   142,   143,    42,
     141,   142,   143,     0,   277,     0,   270,    43,    44,     0,
      45,    46,    47,     0,     0,   -18,     0,    48,     0,     0,
       0,     0,     0,     0,   285,     0,     0,     0,     0,     0,
       0,     0,     0,   302,     0,     0,   295,     0,     0,     0,
       0,     0,     0,     0,   308,     0,   270,     0,     0,     0,
       0,   305,     0,     0,   315,     8,   316,     9,    10,    11,
      12,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,     0,     0,     0,   322,     0,     0,     0,     0,     0,
      13,    14,    15,     0,     0,     0,    16,     0,     0,     0,
      17,    18,    19,    20,     0,     0,    21,    22,    23,    24,
       0,    25,   -13,   -13,    26,    27,    28,    29,  -165,     0,
       0,    30,    31,    32,    33,    34,    35,    36,    37,    38,
       0,    39,    40,    41,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,    43,    44,     0,    45,    46,    47,
       0,     0,     0,  -134,    48,  -134,  -134,  -134,  -134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -104,  -104,
    -104,  -104,  -104,  -104,  -104,  -104,  -104,  -104,  -104,  -104,
    -104,  -104,  -104,  -104,  -104,  -104,  -104,  -104,     0,  -134,
    -134,     0,  -104,  -104,  -134,  -134,     0,     0,  -104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -134,     0,     0,     0,     0,  -134,     0,     0,
       0,     0,     0,     0,  -134,     0,  -104,     0,     0,     0,
       0,     0,  -134,  -134,   141,   142,   143,  -134,     0,     0,
       0,  -135,  -104,  -135,  -135,  -135,  -135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -105,  -105,  -105,  -105,
    -105,  -105,  -105,  -105,  -105,  -105,  -105,  -105,  -105,  -105,
    -105,  -105,  -105,  -105,  -105,  -105,     0,  -135,  -135,     0,
    -105,  -105,  -135,  -135,     0,     0,  -105,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -135,     0,     0,     0,     0,  -135,     0,     0,     0,     0,
       0,     0,  -135,     0,  -105,     0,     0,     0,     0,     0,
    -135,  -135,   141,   142,   143,  -135,     0,     0,     0,  -136,
    -105,  -136,  -136,  -136,  -136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -100,  -100,  -100,  -100,  -100,  -100,
    -100,  -100,  -100,  -100,  -100,  -100,  -100,  -100,  -100,  -100,
    -100,  -100,  -100,  -100,     0,  -136,  -136,     0,  -100,  -100,
    -136,  -136,     0,     0,  -100,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -136,     0,
       0,     0,     0,  -136,     0,     0,     0,     0,     0,     0,
    -136,     0,  -100,     0,     0,     0,     0,     0,  -136,  -136,
     141,   142,   143,  -136,     0,     0,     0,  -123,  -100,  -123,
    -123,  -123,  -123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -101,  -101,  -101,  -101,  -101,  -101,  -101,  -101,
    -101,  -101,  -101,  -101,  -101,  -101,  -101,  -101,  -101,  -101,
    -101,  -101,     0,  -123,  -123,     0,  -101,  -101,  -123,  -123,
       0,     0,  -101,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -123,     0,     0,     0,
       0,  -123,     0,     0,     0,     0,     0,     0,  -123,     0,
    -101,     0,     0,     0,     0,     0,  -123,  -123,   141,   142,
     143,  -123,     0,     0,     0,     8,  -101,     9,    10,    11,
      12,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     227,   228,   229,   133,   134,   135,   230,   137,   138,   139,
       0,    18,    19,     0,     0,     0,    21,    22,     0,   120,
     121,   122,   123,   124,   125,     0,     0,   128,   129,   130,
     131,   132,   133,   134,    63,   136,     0,   138,   139,    38,
       8,    74,     9,    10,    11,    12,    42,     0,   140,     0,
       0,     0,     0,     0,    43,    44,   141,   231,   232,    47,
       0,     0,     0,     0,    48,    13,    14,    15,     0,     0,
       0,    16,     0,     0,     0,     0,    18,    19,     0,     0,
       0,    21,    22,     0,     0,   141,   142,   143,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     9,    10,    11,    12,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    13,    14,    15,     0,    43,
      44,    16,    45,    46,    47,     0,    18,    19,     0,    48,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    63,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,    43,
      44,     0,    45,    46,    47,     0,     0,     0,     0,    48,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,   141,   142,   143,     0,     0,
     120,   121,  -166,  -166,   124,   125,     0,   140,   128,   129,
     130,   131,   132,   133,   134,   141,   142,   143,   138,   139,
       0,     0,   238,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,     0,     0,     0,   141,   142,   143,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,     0,   141,
     142,   143,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,     0,   141,
     142,   143,     0,     0,     0,   216,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143,     0,     0,     0,   223,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143,     0,     0,     0,   284,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,   141,   142,   143,     0,     0,
       0,   314,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,   141,   142,   143,     0,     0,
       0,   320,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,   141,   142,
     143,     0,     0,     0,   321,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,   141,   142,
     143,     0,     0,     0,   327,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,   141,   142,   143,     0,     0,   149,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,   141,   142,   143,     0,     0,   150,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,     0,   141,   142,   143,     0,     0,   241,     0,
       0,     0,     0,     0,     0,   140,   234,     0,     0,     0,
       0,     0,     0,   141,   142,   143,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   120,   121,   122,   123,
     124,   125,   126,     0,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143,   120,   121,   122,   123,   124,
     125,     0,     0,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   120,   121,   122,   123,   124,
     125,     0,     0,   128,   129,   130,   131,   132,   133,   134,
     135,   136,     0,   138,   139,   120,   121,   122,   123,   124,
     125,     0,     0,   128,   129,   130,   131,   132,   133,   134,
       0,     0,     0,   138,   139,     0,   120,   121,     0,     0,
       0,   141,   142,   143,   128,   129,   130,   131,   132,   133,
     134,     0,     0,     0,   138,   139,   120,   121,     0,     0,
       0,   141,   142,   143,  -166,  -166,   130,   131,   132,   133,
     134,     0,     0,     0,  -166,  -166,     0,     0,     0,     0,
       0,   141,   142,   143,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   141,   142,   143
};

static const yytype_int16 yycheck[] =
{
       5,     1,     5,     5,     0,    94,    84,     3,    13,    14,
      15,    16,    17,   102,   101,   175,   103,   104,     3,    24,
      25,    26,    27,    28,    29,    30,     4,     3,   212,     4,
     245,     9,    23,    68,     9,    40,    23,    74,    43,    44,
      33,   298,     0,   203,   151,     9,   153,   304,    74,   233,
      50,    59,    45,    90,    91,   162,   313,    86,    93,   243,
      59,     3,   319,   278,    90,    91,   173,    51,    52,     4,
       0,    86,   161,     3,     9,    80,    81,    86,   156,     0,
      76,    93,     3,    74,    89,    90,    74,    74,    85,    86,
      87,    84,    57,    89,    90,   100,   280,   312,    94,    10,
      86,   106,   107,   106,   106,   110,    86,    39,   215,    90,
      91,    86,    73,    91,    90,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,    91,   142,   143,   144,
     247,   146,   147,    90,   149,   150,    76,    89,    90,   236,
       9,   240,   145,    93,    91,    76,    76,   264,    49,    89,
      90,    94,   167,   156,    94,   158,   273,    91,    89,    90,
      86,    94,   165,    94,    91,    74,   283,    92,     4,   286,
       6,     7,     8,     9,    67,    43,    86,    58,    94,    69,
      29,    30,    31,    32,    33,    10,    31,    32,    33,   199,
      44,    23,    86,    29,    30,    31,    23,    70,   106,    35,
     167,   296,   289,   320,    40,    41,    -1,    -1,    -1,    45,
      46,    -1,   227,   228,   229,   230,   231,   232,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    63,   231,   244,
      -1,    -1,    68,    -1,    -1,   250,    85,    86,    87,    75,
      85,    86,    87,    -1,   259,    -1,   249,    83,    84,    -1,
      86,    87,    88,    -1,    -1,    91,    -1,    93,    -1,    -1,
      -1,    -1,    -1,    -1,   267,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   288,    -1,    -1,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   299,    -1,   289,    -1,    -1,    -1,
      -1,   294,    -1,    -1,   309,     4,   311,     6,     7,     8,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     325,    -1,    -1,    -1,   317,    -1,    -1,    -1,    -1,    -1,
      29,    30,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    40,    41,    42,    -1,    -1,    45,    46,    47,    48,
      -1,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      -1,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    70,    71,    72,    -1,    -1,    75,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    84,    -1,    86,    87,    88,
      -1,    -1,    -1,     4,    93,     6,     7,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    44,    45,    46,    -1,    -1,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    83,    84,    85,    86,    87,    88,    -1,    -1,
      -1,     4,    93,     6,     7,     8,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    44,    45,    46,    -1,    -1,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      83,    84,    85,    86,    87,    88,    -1,    -1,    -1,     4,
      93,     6,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    44,
      45,    46,    -1,    -1,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    -1,    77,    -1,    -1,    -1,    -1,    -1,    83,    84,
      85,    86,    87,    88,    -1,    -1,    -1,     4,    93,     6,
       7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    44,    45,    46,
      -1,    -1,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    83,    84,    85,    86,
      87,    88,    -1,    -1,    -1,     4,    93,     6,     7,     8,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    -1,    -1,    45,    46,    -1,    19,
      20,    21,    22,    23,    24,    -1,    -1,    27,    28,    29,
      30,    31,    32,    33,    63,    35,    -1,    37,    38,    68,
       4,     5,     6,     7,     8,     9,    75,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    83,    84,    85,    86,    87,    88,
      -1,    -1,    -1,    -1,    93,    29,    30,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    40,    41,    -1,    -1,
      -1,    45,    46,    -1,    -1,    85,    86,    87,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    29,    30,    31,    -1,    83,
      84,    35,    86,    87,    88,    -1,    40,    41,    -1,    93,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      84,    -1,    86,    87,    88,    -1,    -1,    -1,    -1,    93,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,
      19,    20,    21,    22,    23,    24,    -1,    77,    27,    28,
      29,    30,    31,    32,    33,    85,    86,    87,    37,    38,
      -1,    -1,    92,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    -1,    -1,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      86,    87,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      86,    87,    -1,    -1,    -1,    91,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    -1,    -1,    -1,    91,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,
      -1,    91,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    86,
      87,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    86,
      87,    -1,    -1,    -1,    91,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    86,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    86,    87,    -1,    -1,    90,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    86,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    86,    87,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    19,    20,    21,    22,
      23,    24,    25,    -1,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    19,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    19,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    19,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    31,    32,    33,
      -1,    -1,    -1,    37,    38,    -1,    19,    20,    -1,    -1,
      -1,    85,    86,    87,    27,    28,    29,    30,    31,    32,
      33,    -1,    -1,    -1,    37,    38,    19,    20,    -1,    -1,
      -1,    85,    86,    87,    27,    28,    29,    30,    31,    32,
      33,    -1,    -1,    -1,    37,    38,    -1,    -1,    -1,    -1,
      -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,    96,    97,   149,   150,   149,     0,     4,     6,
       7,     8,     9,    29,    30,    31,    35,    39,    40,    41,
      42,    45,    46,    47,    48,    50,    53,    54,    55,    56,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    70,
      71,    72,    75,    83,    84,    86,    87,    88,    93,    98,
      99,   100,   101,   102,   109,   119,   121,   129,   130,   136,
     137,   146,   147,    63,   129,   136,   137,   137,   137,   137,
     137,     9,   137,   137,     5,   137,   137,   137,   137,   137,
      59,    59,     4,     9,    86,   100,   137,   145,    86,    86,
      86,   137,    93,   125,   135,   137,   137,   100,   105,   106,
     133,   120,   122,    89,    90,   149,   151,    74,    51,    52,
     104,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      77,    85,    86,    87,   107,    57,   107,    10,   112,    90,
      90,   110,   137,   111,   137,   105,    86,    39,   108,   137,
     137,   126,    73,    97,    91,    90,   137,   150,    97,   150,
     150,   109,   136,   131,   137,   137,   137,   137,   137,   137,
     137,   137,   137,   137,   137,   137,   137,   137,   137,   137,
     137,   137,   137,   137,   137,   137,   137,     9,   117,   118,
     137,   137,   137,   100,   137,   137,    93,   123,   137,   137,
     125,   125,    91,   105,   100,    91,    91,    97,   125,    76,
      49,   141,   100,    91,   117,    94,   125,    29,    30,    31,
      35,    86,    87,   145,    78,    91,    90,   149,    92,   145,
     124,    90,   141,    91,    23,    74,   125,   116,    94,    86,
      74,    92,   137,   137,   137,   137,   100,   141,   137,   150,
      67,   144,    97,   137,   134,   141,   137,   108,   128,   125,
     100,   142,   143,   132,   137,    43,   139,   137,    86,    58,
     138,    94,   125,   115,    91,   100,    69,   127,    10,    90,
      91,   125,    44,   140,   108,   100,   141,   125,   114,    23,
      68,   125,   137,   143,   103,   100,   140,   123,   137,    86,
     123,    23,    74,   148,    91,   137,   137,   108,   123,   113,
      91,    91,   100,   123,   125,    23,   137,    91
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    95,    96,    97,    98,    98,    98,    99,    99,    99,
      99,   100,   100,   102,   103,   101,   104,   104,   105,   105,
     105,   106,   106,   107,   107,   107,   107,   107,   107,   107,
     107,   107,   108,   108,   109,   109,   109,   109,   109,   109,
     109,   109,   109,   110,   109,   109,   111,   109,   109,   109,
     109,   109,   109,   112,   109,   109,   109,   109,   113,   109,
     114,   109,   115,   109,   109,   109,   109,   116,   109,   109,
     109,   109,   117,   117,   117,   117,   118,   118,   120,   119,
     122,   121,   124,   123,   126,   125,   127,   128,   128,   129,
     129,   129,   129,   130,   130,   130,   130,   130,   130,   130,
     130,   130,   130,   130,   130,   130,   130,   130,   130,   130,
     130,   131,   130,   130,   132,   130,   130,   130,   133,   130,
     130,   130,   130,   130,   130,   130,   130,   130,   130,   130,
     130,   130,   130,   130,   130,   130,   130,   130,   130,   130,
     134,   130,   135,   130,   136,   136,   137,   137,   138,   138,
     139,   139,   140,   140,   141,   141,   142,   142,   143,   143,
     144,   144,   144,   145,   145,   147,   148,   146,   149,   149,
     150,   150,   151,   151,   151
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     0,     1,     2,     1,     1,     3,
       3,     1,     1,     0,     0,     9,     1,     1,     0,     1,
       2,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     2,     3,     2,     2,     2,     4,
       4,     6,     2,     0,     4,     3,     0,     4,     3,     2,
       1,     1,     1,     0,     4,     2,     1,     1,     0,    12,
       0,     9,     0,     8,     4,     2,     4,     0,     6,     2,
       4,     1,     0,     1,     3,     2,     1,     4,     0,     5,
       0,     4,     0,     4,     0,     4,     6,     0,     2,     4,
       6,     8,     5,     1,     1,     1,     1,     3,     4,     1,
       2,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     0,     4,     3,     0,     7,     6,     1,     0,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       0,     7,     0,     4,     1,     1,     1,     1,     0,     2,
       0,     1,     0,     1,     0,     4,     1,     3,     1,     3,
       0,    10,     7,     0,     1,     0,     0,    10,     1,     2,
       0,     1,     2,     2,     1
};


/* YYDPREC[RULE-NUM] -- Dynamic precedence of rule #RULE-NUM (0 if none).  */
static const yytype_int8 yydprec[] =
{
       0,     0,     0,     0,     0,     0,     0,     2,     0,     1,
       1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     2,     1,     0,     2,     1,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     2,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     2,     1,     0,     2,     1,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     1,     2,     2,     1,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0
};

/* YYMERGER[RULE-NUM] -- Index of merging function for rule #RULE-NUM.  */
static const yytype_int8 yymerger[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0
};

/* YYIMMEDIATE[RULE-NUM] -- True iff rule #RULE-NUM is not to be deferred, as
   in the case of predicates.  */
static const yybool yyimmediate[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0
};

/* YYCONFLP[YYPACT[STATE-NUM]] -- Pointer into YYCONFL of start of
   list of conflicting reductions corresponding to action entry for
   state STATE-NUM in yytable.  0 means no conflicts.  The list in
   yyconfl is terminated by a rule number of 0.  */
static const yytype_int16 yyconflp[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     9,     0,     0,     0,
       0,    11,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     1,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     7,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    23,     0,
      25,    27,    29,    31,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,    35,    37,     0,     0,     0,    39,
       0,     0,     0,     0,    41,    43,     0,     0,     0,    45,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,     0,    51,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,    55,    57,     0,
      59,    61,    63,     0,     0,    65,     0,    67,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,     0,     0,
       0,     0,   155,   157,     0,     0,     0,     0,   159,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   165,   167,   169,   171,
     173,   175,   177,   179,   181,   183,   185,   187,   189,   191,
     193,   195,   197,   199,   201,   203,     0,     0,     0,     0,
     205,   207,     0,     0,     0,     0,   209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,   217,   219,   221,   223,   225,
     227,   229,   231,   233,   235,   237,   239,   241,   243,   245,
     247,   249,   251,   253,     0,     0,     0,     0,   255,   257,
       0,     0,     0,     0,   259,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   261,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   263,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   265,   267,   269,   271,   273,   275,   277,   279,
     281,   283,   285,   287,   289,   291,   293,   295,   297,   299,
     301,   303,     0,     0,     0,     0,   305,   307,     0,     0,
       0,     0,   309,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    13,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    15,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    17,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      69,     0,    71,    73,    75,    77,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    79,    81,    83,     0,     0,
       0,    85,     0,     0,     0,     0,    87,    89,     0,    21,
       0,    91,    93,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    95,
       0,     0,     0,     0,    97,     0,     0,     0,     0,     0,
       0,    99,     0,     0,     0,     0,     0,     0,     0,   101,
     103,     0,   105,   107,   109,     0,     0,     0,     0,   111,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   113,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0
};

/* YYCONFL[I] -- lists of conflicting rule numbers, each terminated by
   0, pointed into by YYCONFLP.  */
static const short yyconfl[] =
{
       0,    93,     0,    93,     0,    99,     0,    99,     0,   118,
       0,   118,     0,    43,     0,    46,     0,   111,     0,   163,
       0,   163,     0,   118,     0,   118,     0,   118,     0,   118,
       0,   118,     0,   118,     0,   118,     0,   118,     0,   118,
       0,   118,     0,   118,     0,   118,     0,   118,     0,   118,
       0,   118,     0,   118,     0,   118,     0,   118,     0,   118,
       0,   118,     0,   118,     0,    72,     0,   118,     0,    78,
       0,    78,     0,    78,     0,    78,     0,    78,     0,    78,
       0,    78,     0,    78,     0,    78,     0,    78,     0,    78,
       0,    78,     0,    78,     0,    78,     0,    78,     0,    78,
       0,    78,     0,    78,     0,    78,     0,    78,     0,    78,
       0,    78,     0,   114,     0,   134,     0,   134,     0,   134,
       0,   134,     0,   134,     0,   134,     0,   134,     0,   134,
       0,   134,     0,   134,     0,   134,     0,   134,     0,   134,
       0,   134,     0,   134,     0,   134,     0,   134,     0,   134,
       0,   134,     0,   134,     0,   134,     0,   134,     0,   134,
       0,   134,     0,   134,     0,   135,     0,   135,     0,   135,
       0,   135,     0,   135,     0,   135,     0,   135,     0,   135,
       0,   135,     0,   135,     0,   135,     0,   135,     0,   135,
       0,   135,     0,   135,     0,   135,     0,   135,     0,   135,
       0,   135,     0,   135,     0,   135,     0,   135,     0,   135,
       0,   135,     0,   135,     0,   136,     0,   136,     0,   136,
       0,   136,     0,   136,     0,   136,     0,   136,     0,   136,
       0,   136,     0,   136,     0,   136,     0,   136,     0,   136,
       0,   136,     0,   136,     0,   136,     0,   136,     0,   136,
       0,   136,     0,   136,     0,   136,     0,   136,     0,   136,
       0,   136,     0,   136,     0,   123,     0,   123,     0,   123,
       0,   123,     0,   123,     0,   123,     0,   123,     0,   123,
       0,   123,     0,   123,     0,   123,     0,   123,     0,   123,
       0,   123,     0,   123,     0,   123,     0,   123,     0,   123,
       0,   123,     0,   123,     0,   123,     0,   123,     0,   123,
       0,   123,     0,   123,     0
};


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

# define YYRHSLOC(Rhs, K) ((Rhs)[K].yystate.yyloc)



#undef yynerrs
#define yynerrs (yystackp->yyerrcnt)
#undef yychar
#define yychar (yystackp->yyrawchar)
#undef yylval
#define yylval (yystackp->yyval)
#undef yylloc
#define yylloc (yystackp->yyloc)


enum { YYENOMEM = -2 };

typedef enum { yyok, yyaccept, yyabort, yyerr } YYRESULTTAG;

#define YYCHK(YYE)                              \
  do {                                          \
    YYRESULTTAG yychk_flag = YYE;               \
    if (yychk_flag != yyok)                     \
      return yychk_flag;                        \
  } while (0)

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYMAXDEPTH * sizeof (GLRStackItem)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

/* Minimum number of free items on the stack allowed after an
   allocation.  This is to allow allocation and initialization
   to be completed by functions that call yyexpandGLRStack before the
   stack is expanded, thus insuring that all necessary pointers get
   properly redirected to new data.  */
#define YYHEADROOM 2

#ifndef YYSTACKEXPANDABLE
#  define YYSTACKEXPANDABLE 1
#endif

#if YYSTACKEXPANDABLE
# define YY_RESERVE_GLRSTACK(Yystack)                   \
  do {                                                  \
    if (Yystack->yyspaceLeft < YYHEADROOM)              \
      yyexpandGLRStack (Yystack);                       \
  } while (0)
#else
# define YY_RESERVE_GLRSTACK(Yystack)                   \
  do {                                                  \
    if (Yystack->yyspaceLeft < YYHEADROOM)              \
      yyMemoryExhausted (Yystack);                      \
  } while (0)
#endif

/** State numbers. */
typedef int yy_state_t;

/** Rule numbers. */
typedef int yyRuleNum;

/** Item references. */
typedef short yyItemNum;

typedef struct yyGLRState yyGLRState;
typedef struct yyGLRStateSet yyGLRStateSet;
typedef struct yySemanticOption yySemanticOption;
typedef union yyGLRStackItem yyGLRStackItem;
typedef struct yyGLRStack yyGLRStack;

struct yyGLRState {
  /** Type tag: always true.  */
  yybool yyisState;
  /** Type tag for yysemantics.  If true, yysval applies, otherwise
   *  yyfirstVal applies.  */
  yybool yyresolved;
  /** Number of corresponding LALR(1) machine state.  */
  yy_state_t yylrState;
  /** Preceding state in this stack */
  yyGLRState* yypred;
  /** Source position of the last token produced by my symbol */
  YYPTRDIFF_T yyposn;
  union {
    /** First in a chain of alternative reductions producing the
     *  nonterminal corresponding to this state, threaded through
     *  yynext.  */
    yySemanticOption* yyfirstVal;
    /** Semantic value for this state.  */
    YYSTYPE yysval;
  } yysemantics;
  /** Source location for this state.  */
  YYLTYPE yyloc;
};

struct yyGLRStateSet {
  yyGLRState** yystates;
  /** During nondeterministic operation, yylookaheadNeeds tracks which
   *  stacks have actually needed the current lookahead.  During deterministic
   *  operation, yylookaheadNeeds[0] is not maintained since it would merely
   *  duplicate yychar != YYEMPTY.  */
  yybool* yylookaheadNeeds;
  YYPTRDIFF_T yysize;
  YYPTRDIFF_T yycapacity;
};

struct yySemanticOption {
  /** Type tag: always false.  */
  yybool yyisState;
  /** Rule number for this reduction */
  yyRuleNum yyrule;
  /** The last RHS state in the list of states to be reduced.  */
  yyGLRState* yystate;
  /** The lookahead for this reduction.  */
  int yyrawchar;
  YYSTYPE yyval;
  YYLTYPE yyloc;
  /** Next sibling in chain of options.  To facilitate merging,
   *  options are chained in decreasing order by address.  */
  yySemanticOption* yynext;
};

/** Type of the items in the GLR stack.  The yyisState field
 *  indicates which item of the union is valid.  */
union yyGLRStackItem {
  yyGLRState yystate;
  yySemanticOption yyoption;
};

struct yyGLRStack {
  int yyerrState;
  /* To compute the location of the error token.  */
  yyGLRStackItem yyerror_range[3];

  int yyerrcnt;
  int yyrawchar;
  YYSTYPE yyval;
  YYLTYPE yyloc;

  YYJMP_BUF yyexception_buffer;
  yyGLRStackItem* yyitems;
  yyGLRStackItem* yynextFree;
  YYPTRDIFF_T yyspaceLeft;
  yyGLRState* yysplitPoint;
  yyGLRState* yylastDeleted;
  yyGLRStateSet yytops;
};

#if YYSTACKEXPANDABLE
static void yyexpandGLRStack (yyGLRStack* yystackp);
#endif

_Noreturn static void
yyFail (yyGLRStack* yystackp, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context, const char* yymsg)
{
  if (yymsg != YY_NULLPTR)
    yyerror (yylocp, llist, context, yymsg);
  YYLONGJMP (yystackp->yyexception_buffer, 1);
}

_Noreturn static void
yyMemoryExhausted (yyGLRStack* yystackp)
{
  YYLONGJMP (yystackp->yyexception_buffer, 2);
}

/** Accessing symbol of state YYSTATE.  */
static inline yysymbol_kind_t
yy_accessing_symbol (yy_state_t yystate)
{
  return YY_CAST (yysymbol_kind_t, yystos[yystate]);
}

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"new-line\"",
  "T_STRING", "T_STRING_ANGLE", "T_NUMBER", "T_BOOLEAN", "T_NULL",
  "T_IDENTIFIER", "\"= (T_SET)\"", "\"+= (T_SET_ADD)\"",
  "\"-= (T_SET_SUBTRACT)\"", "\"*= (T_SET_MULTIPLY)\"",
  "\"/= (T_SET_DIVIDE)\"", "\"%= (T_SET_MODULO)\"", "\"^= (T_SET_XOR)\"",
  "\"&= (T_SET_BINARY_AND)\"", "\"|= (T_SET_BINARY_OR)\"",
  "\"<< (T_SHIFT_LEFT)\"", "\">> (T_SHIFT_RIGHT)\"", "\"== (T_EQUAL)\"",
  "\"!= (T_NOT_EQUAL)\"", "\"in (T_IN)\"", "\"!in (T_NOT_IN)\"",
  "\"&& (T_LOGICAL_AND)\"", "\"|| (T_LOGICAL_OR)\"",
  "\"<= (T_LESS_THAN_OR_EQUAL)\"", "\">= (T_GREATER_THAN_OR_EQUAL)\"",
  "\"+ (T_PLUS)\"", "\"- (T_MINUS)\"", "\"* (T_MULTIPLY)\"",
  "\"/ (T_DIVIDE_OP)\"", "\"% (T_MODULO)\"", "\"^ (T_XOR)\"",
  "\"& (T_BINARY_AND)\"", "\"| (T_BINARY_OR)\"", "\"< (T_LESS_THAN)\"",
  "\"> (T_GREATER_THAN)\"", "\"var (T_VAR)\"", "\"globals (T_GLOBALS)\"",
  "\"locals (T_LOCALS)\"", "\"const (T_CONST)\"",
  "\"default (T_DEFAULT)\"", "\"ignore_on_error (T_IGNORE_ON_ERROR)\"",
  "\"current_filename (T_CURRENT_FILENAME)\"",
  "\"current_line (T_CURRENT_LINE)\"", "\"debugger (T_DEBUGGER)\"",
  "\"namespace (T_NAMESPACE)\"", "\"use (T_USE)\"", "\"using (T_USING)\"",
  "\"object (T_OBJECT)\"", "\"template (T_TEMPLATE)\"",
  "\"include (T_INCLUDE)\"", "\"include_recursive (T_INCLUDE_RECURSIVE)\"",
  "\"include_zones (T_INCLUDE_ZONES)\"", "\"library (T_LIBRARY)\"",
  "\"apply (T_APPLY)\"", "\"to (T_TO)\"", "\"where (T_WHERE)\"",
  "\"import (T_IMPORT)\"", "\"assign (T_ASSIGN)\"",
  "\"ignore (T_IGNORE)\"", "\"function (T_FUNCTION)\"",
  "\"return (T_RETURN)\"", "\"break (T_BREAK)\"",
  "\"continue (T_CONTINUE)\"", "\"for (T_FOR)\"", "\"if (T_IF)\"",
  "\"else (T_ELSE)\"", "\"while (T_WHILE)\"", "\"throw (T_THROW)\"",
  "\"try (T_TRY)\"", "\"except (T_EXCEPT)\"", "\"=> (T_FOLLOWS)\"",
  "\"{{ (T_NULLARY_LAMBDA_BEGIN)\"", "\"}} (T_NULLARY_LAMBDA_END)\"",
  "'?'", "':'", "UNARY_MINUS", "UNARY_PLUS", "REF_OP", "DEREF_OP", "'!'",
  "'~'", "'.'", "'('", "'['", "T_THIS", "';'", "','", "')'", "']'", "'{'",
  "'}'", "$accept", "script", "statements", "lterm_items",
  "lterm_items_inner", "identifier", "object", "$@1", "$@2",
  "object_declaration", "identifier_items", "identifier_items_inner",
  "combined_set_op", "optional_var", "lterm", "$@3", "$@4", "$@5", "$@6",
  "$@7", "$@8", "$@9", "rterm_items", "rterm_items_inner", "rterm_array",
  "$@10", "rterm_dict", "$@11", "rterm_scope_require_side_effect", "$@12",
  "rterm_scope", "$@13", "else_if_branch", "else_if_branches",
  "rterm_side_effect", "rterm_no_side_effect_no_dict", "$@14", "$@15",
  "$@16", "$@17", "$@18", "rterm_no_side_effect", "rterm",
  "target_type_specifier", "default_specifier", "ignore_specifier",
  "use_specifier", "use_specifier_items", "use_specifier_item",
  "apply_for_specifier", "optional_rterm", "apply", "$@19", "$@20",
  "newlines", "optional_newlines", "sep", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#if YYDEBUG

# ifndef YYFPRINTF
#  define YYFPRINTF fprintf
# endif

# define YY_FPRINTF                             \
  YY_IGNORE_USELESS_CAST_BEGIN YY_FPRINTF_

# define YY_FPRINTF_(Args)                      \
  do {                                          \
    YYFPRINTF Args;                             \
    YY_IGNORE_USELESS_CAST_END                  \
  } while (0)

# define YY_DPRINTF                             \
  YY_IGNORE_USELESS_CAST_BEGIN YY_DPRINTF_

# define YY_DPRINTF_(Args)                      \
  do {                                          \
    if (yydebug)                                \
      YYFPRINTF Args;                           \
    YY_IGNORE_USELESS_CAST_END                  \
  } while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YY_LOCATION_PRINT
#  if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#   define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

#  else
#   define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#  endif
# endif /* !defined YY_LOCATION_PRINT */



/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (llist);
  YYUSE (context);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, llist, context);
  YYFPRINTF (yyo, ")");
}

# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                  \
  do {                                                                  \
    if (yydebug)                                                        \
      {                                                                 \
        YY_FPRINTF ((stderr, "%s ", Title));                            \
        yy_symbol_print (stderr, Kind, Value, Location, llist, context);        \
        YY_FPRINTF ((stderr, "\n"));                                    \
      }                                                                 \
  } while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;

static void yypstack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
  YY_ATTRIBUTE_UNUSED;
static void yypdumpstack (yyGLRStack* yystackp)
  YY_ATTRIBUTE_UNUSED;

#else /* !YYDEBUG */

# define YY_DPRINTF(Args) do {} while (yyfalse)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)

#endif /* !YYDEBUG */

#ifndef yystrlen
# define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


/** Fill in YYVSP[YYLOW1 .. YYLOW0-1] from the chain of states starting
 *  at YYVSP[YYLOW0].yystate.yypred.  Leaves YYVSP[YYLOW1].yystate.yypred
 *  containing the pointer to the next state in the chain.  */
static void yyfillin (yyGLRStackItem *, int, int) YY_ATTRIBUTE_UNUSED;
static void
yyfillin (yyGLRStackItem *yyvsp, int yylow0, int yylow1)
{
  int i;
  yyGLRState *s = yyvsp[yylow0].yystate.yypred;
  for (i = yylow0-1; i >= yylow1; i -= 1)
    {
#if YYDEBUG
      yyvsp[i].yystate.yylrState = s->yylrState;
#endif
      yyvsp[i].yystate.yyresolved = s->yyresolved;
      if (s->yyresolved)
        yyvsp[i].yystate.yysemantics.yysval = s->yysemantics.yysval;
      else
        /* The effect of using yysval or yyloc (in an immediate rule) is
         * undefined.  */
        yyvsp[i].yystate.yysemantics.yyfirstVal = YY_NULLPTR;
      yyvsp[i].yystate.yyloc = s->yyloc;
      s = yyvsp[i].yystate.yypred = s->yypred;
    }
}


/** If yychar is empty, fetch the next token.  */
static inline yysymbol_kind_t
yygetToken (int *yycharp, yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  yysymbol_kind_t yytoken;
  YYUSE (llist);
  YYUSE (context);
  if (*yycharp == YYEMPTY)
    {
      YY_DPRINTF ((stderr, "Reading a token\n"));
      *yycharp = yylex (&yylval, &yylloc, scanner);
    }
  if (*yycharp <= YYEOF)
    {
      *yycharp = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YY_DPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (*yycharp);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }
  return yytoken;
}

/* Do nothing if YYNORMAL or if *YYLOW <= YYLOW1.  Otherwise, fill in
 * YYVSP[YYLOW1 .. *YYLOW-1] as in yyfillin and set *YYLOW = YYLOW1.
 * For convenience, always return YYLOW1.  */
static inline int yyfill (yyGLRStackItem *, int *, int, yybool)
     YY_ATTRIBUTE_UNUSED;
static inline int
yyfill (yyGLRStackItem *yyvsp, int *yylow, int yylow1, yybool yynormal)
{
  if (!yynormal && yylow1 < *yylow)
    {
      yyfillin (yyvsp, *yylow, yylow1);
      *yylow = yylow1;
    }
  return yylow1;
}

/** Perform user action for rule number YYN, with RHS length YYRHSLEN,
 *  and top stack item YYVSP.  YYLVALP points to place to put semantic
 *  value ($$), and yylocp points to place for location information
 *  (@$).  Returns yyok for normal return, yyaccept for YYACCEPT,
 *  yyerr for YYERROR, yyabort for YYABORT.  */
static YYRESULTTAG
yyuserAction (yyRuleNum yyn, int yyrhslen, yyGLRStackItem* yyvsp,
              yyGLRStack* yystackp,
              YYSTYPE* yyvalp, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  yybool yynormal YY_ATTRIBUTE_UNUSED = yystackp->yysplitPoint == YY_NULLPTR;
  int yylow;
  YYUSE (yyvalp);
  YYUSE (yylocp);
  YYUSE (llist);
  YYUSE (context);
  YYUSE (yyrhslen);
# undef yyerrok
# define yyerrok (yystackp->yyerrState = 0)
# undef YYACCEPT
# define YYACCEPT return yyaccept
# undef YYABORT
# define YYABORT return yyabort
# undef YYERROR
# define YYERROR return yyerrok, yyerr
# undef YYRECOVERING
# define YYRECOVERING() (yystackp->yyerrState != 0)
# undef yyclearin
# define yyclearin (yychar = YYEMPTY)
# undef YYFILL
# define YYFILL(N) yyfill (yyvsp, &yylow, (N), yynormal)
# undef YYBACKUP
# define YYBACKUP(Token, Value)                                              \
  return yyerror (yylocp, llist, context, YY_("syntax error: cannot back up")),     \
         yyerrok, yyerr

  yylow = 1;
  if (yyrhslen == 0)
    *yyvalp = yyval_default;
  else
    *yyvalp = yyvsp[YYFILL (1-yyrhslen)].yystate.yysemantics.yysval;
  /* Default location. */
  YYLLOC_DEFAULT ((*yylocp), (yyvsp - yyrhslen), yyrhslen);
  yystackp->yyerror_range[1].yystate.yyloc = *yylocp;

  switch (yyn)
    {
  case 2: /* script: statements  */
#line 292 "config_parser.yy"
        {
		llist->swap(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.llist));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.llist);
	}
#line 2272 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 3: /* statements: optional_newlines lterm_items  */
#line 299 "config_parser.yy"
        {
		((*yyvalp).llist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.llist);
	}
#line 2280 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 4: /* lterm_items: %empty  */
#line 305 "config_parser.yy"
        {
		((*yyvalp).llist) = new std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> >();
	}
#line 2288 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 7: /* lterm_items_inner: lterm  */
#line 313 "config_parser.yy"
        {
		((*yyvalp).llist) = new std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> >();
		((*yyvalp).llist)->emplace_back(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), EItemInfo{true, (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)});
	}
#line 2297 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 8: /* lterm_items_inner: rterm_no_side_effect  */
#line 318 "config_parser.yy"
        {
		((*yyvalp).llist) = new std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> >();
		((*yyvalp).llist)->emplace_back(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), EItemInfo{false, (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)});
	}
#line 2306 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 9: /* lterm_items_inner: lterm_items_inner sep lterm  */
#line 323 "config_parser.yy"
        {
		if ((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.llist))
			((*yyvalp).llist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.llist);
		else
			((*yyvalp).llist) = new std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> >();

		if ((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)) {
			((*yyvalp).llist)->emplace_back(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), EItemInfo{true, (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)});
		}
	}
#line 2321 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 10: /* lterm_items_inner: lterm_items_inner sep rterm_no_side_effect  */
#line 334 "config_parser.yy"
        {
		if ((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.llist))
			((*yyvalp).llist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.llist);
		else
			((*yyvalp).llist) = new std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> >();

		if ((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)) {
			((*yyvalp).llist)->emplace_back(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), EItemInfo{false, (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)});
		}
	}
#line 2336 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 13: /* $@1: %empty  */
#line 351 "config_parser.yy"
        {
		context->m_ObjectAssign.push(true);
		context->m_SeenAssign.push(false);
		context->m_SeenIgnore.push(false);
		context->m_Assign.push(0);
		context->m_Ignore.push(0);
	}
#line 2348 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 14: /* $@2: %empty  */
#line 359 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 2356 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 15: /* object: $@1 object_declaration rterm optional_rterm use_specifier default_specifier ignore_specifier $@2 rterm_scope_require_side_effect  */
#line 363 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		context->m_ObjectAssign.pop();

		bool abstract = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yysval.num);
		bool defaultTmpl = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.boolean);

		if (!abstract && defaultTmpl)
			BOOST_THROW_EXCEPTION(ScriptError("'default' keyword is invalid for object definitions", (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yyloc)));

		bool seen_assign = context->m_SeenAssign.top();
		context->m_SeenAssign.pop();

		bool seen_ignore = context->m_SeenIgnore.top();
		context->m_SeenIgnore.pop();

		std::unique_ptr<Expression> ignore{std::move(context->m_Ignore.top())};
		context->m_Ignore.pop();

		std::unique_ptr<Expression> assign{std::move(context->m_Assign.top())};
		context->m_Assign.pop();

		std::unique_ptr<Expression> filter;

		if (seen_assign) {
			if (ignore) {
				std::unique_ptr<Expression> rex{new LogicalNegateExpression(std::move(ignore), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yyloc)))};

				filter.reset(new LogicalAndExpression(std::move(assign), std::move(rex), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yyloc))));
			} else
				filter.swap(assign);
		} else if (seen_ignore) {
			BOOST_THROW_EXCEPTION(ScriptError("object rule 'ignore where' cannot be used without 'assign where'", DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yyloc))));
		}

		((*yyvalp).expr) = new ObjectExpression(abstract, std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.expr)),
			std::move(filter), context->GetZone(), context->GetPackage(), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.cvlist)), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.boolean), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.boolean),
			std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.cvlist);
	}
#line 2402 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 16: /* object_declaration: "object (T_OBJECT)"  */
#line 407 "config_parser.yy"
        {
		((*yyvalp).num) = false;
	}
#line 2410 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 17: /* object_declaration: "template (T_TEMPLATE)"  */
#line 411 "config_parser.yy"
        {
		((*yyvalp).num) = true;
	}
#line 2418 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 18: /* identifier_items: %empty  */
#line 417 "config_parser.yy"
        {
		((*yyvalp).slist) = new std::vector<String>();
	}
#line 2426 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 21: /* identifier_items_inner: identifier  */
#line 425 "config_parser.yy"
        {
		((*yyvalp).slist) = new std::vector<String>();
		((*yyvalp).slist)->emplace_back(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 2436 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 22: /* identifier_items_inner: identifier_items_inner ',' identifier  */
#line 431 "config_parser.yy"
        {
		if ((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.slist))
			((*yyvalp).slist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.slist);
		else
			((*yyvalp).slist) = new std::vector<String>();

		((*yyvalp).slist)->emplace_back(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 2450 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 34: /* lterm: "library (T_LIBRARY)" rterm  */
#line 458 "config_parser.yy"
        {
		((*yyvalp).expr) = new LibraryExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 2458 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 35: /* lterm: rterm combined_set_op rterm  */
#line 462 "config_parser.yy"
        {
		((*yyvalp).expr) = new SetExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.csop), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 2466 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 36: /* lterm: "include (T_INCLUDE)" rterm  */
#line 466 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), NULL, NULL, IncludeRegular, false, context->GetZone(), context->GetPackage(), (*yylocp));
	}
#line 2474 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 37: /* lterm: "include (T_INCLUDE)" T_STRING_ANGLE  */
#line 470 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), MakeLiteral(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text))), NULL, NULL, IncludeRegular, true, context->GetZone(), context->GetPackage(), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 2483 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 38: /* lterm: "include_recursive (T_INCLUDE_RECURSIVE)" rterm  */
#line 475 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), MakeLiteral("*.conf"), NULL, IncludeRecursive, false, context->GetZone(), context->GetPackage(), (*yylocp));
	}
#line 2491 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 39: /* lterm: "include_recursive (T_INCLUDE_RECURSIVE)" rterm ',' rterm  */
#line 479 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), NULL, IncludeRecursive, false, context->GetZone(), context->GetPackage(), (*yylocp));
	}
#line 2499 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 40: /* lterm: "include_zones (T_INCLUDE_ZONES)" rterm ',' rterm  */
#line 483 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), MakeLiteral("*.conf"), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), IncludeZones, false, context->GetZone(), context->GetPackage(), (*yylocp));
	}
#line 2507 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 41: /* lterm: "include_zones (T_INCLUDE_ZONES)" rterm ',' rterm ',' rterm  */
#line 487 "config_parser.yy"
        {
		((*yyvalp).expr) = new IncludeExpression(Utility::DirName(context->GetPath()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.expr)), IncludeZones, false, context->GetZone(), context->GetPackage(), (*yylocp));
	}
#line 2515 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 42: /* lterm: "import (T_IMPORT)" rterm  */
#line 491 "config_parser.yy"
        {
		((*yyvalp).expr) = new ImportExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 2523 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 43: /* $@3: %empty  */
#line 495 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 2531 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 44: /* lterm: "assign (T_ASSIGN)" "where (T_WHERE)" $@3 rterm_scope  */
#line 499 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		if ((context->m_Apply.empty() || !context->m_Apply.top()) && (context->m_ObjectAssign.empty() || !context->m_ObjectAssign.top()))
			BOOST_THROW_EXCEPTION(ScriptError("'assign' keyword not valid in this context.", (*yylocp)));

		context->m_SeenAssign.top() = true;

		if (context->m_Assign.top())
			context->m_Assign.top() = new LogicalOrExpression(std::unique_ptr<Expression>(context->m_Assign.top()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		else
			context->m_Assign.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr);

		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 2551 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 45: /* lterm: "assign (T_ASSIGN)" "where (T_WHERE)" rterm  */
#line 515 "config_parser.yy"
        {
		ASSERT(!dynamic_cast<DictExpression *>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)));

		if ((context->m_Apply.empty() || !context->m_Apply.top()) && (context->m_ObjectAssign.empty() || !context->m_ObjectAssign.top()))
			BOOST_THROW_EXCEPTION(ScriptError("'assign' keyword not valid in this context.", (*yylocp)));

		context->m_SeenAssign.top() = true;

		if (context->m_Assign.top())
			context->m_Assign.top() = new LogicalOrExpression(std::unique_ptr<Expression>(context->m_Assign.top()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
		else
			context->m_Assign.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr);

		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 2571 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 46: /* $@4: %empty  */
#line 531 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 2579 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 47: /* lterm: "ignore (T_IGNORE)" "where (T_WHERE)" $@4 rterm_scope  */
#line 535 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		if ((context->m_Apply.empty() || !context->m_Apply.top()) && (context->m_ObjectAssign.empty() || !context->m_ObjectAssign.top()))
			BOOST_THROW_EXCEPTION(ScriptError("'ignore' keyword not valid in this context.", (*yylocp)));

		context->m_SeenIgnore.top() = true;

		if (context->m_Ignore.top())
			context->m_Ignore.top() = new LogicalOrExpression(std::unique_ptr<Expression>(context->m_Ignore.top()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		else
			context->m_Ignore.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr);

		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 2599 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 48: /* lterm: "ignore (T_IGNORE)" "where (T_WHERE)" rterm  */
#line 551 "config_parser.yy"
        {
		ASSERT(!dynamic_cast<DictExpression *>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)));

		if ((context->m_Apply.empty() || !context->m_Apply.top()) && (context->m_ObjectAssign.empty() || !context->m_ObjectAssign.top()))
			BOOST_THROW_EXCEPTION(ScriptError("'ignore' keyword not valid in this context.", (*yylocp)));

		context->m_SeenIgnore.top() = true;

		if (context->m_Ignore.top())
			context->m_Ignore.top() = new LogicalOrExpression(std::unique_ptr<Expression>(context->m_Ignore.top()), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
		else
			context->m_Ignore.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr);

		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 2619 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 49: /* lterm: "return (T_RETURN)" optional_rterm  */
#line 567 "config_parser.yy"
        {
		UseFlowControl(context, FlowControlReturn, (*yylocp));
		((*yyvalp).expr) = new ReturnExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 2628 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 50: /* lterm: "break (T_BREAK)"  */
#line 572 "config_parser.yy"
        {
		UseFlowControl(context, FlowControlBreak, (*yylocp));
		((*yyvalp).expr) = new BreakExpression((*yylocp));
	}
#line 2637 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 51: /* lterm: "continue (T_CONTINUE)"  */
#line 577 "config_parser.yy"
        {
		UseFlowControl(context, FlowControlContinue, (*yylocp));
		((*yyvalp).expr) = new ContinueExpression((*yylocp));
	}
#line 2646 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 52: /* lterm: "debugger (T_DEBUGGER)"  */
#line 582 "config_parser.yy"
        {
		((*yyvalp).expr) = new BreakpointExpression((*yylocp));
	}
#line 2654 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 53: /* $@5: %empty  */
#line 586 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 2662 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 54: /* lterm: "namespace (T_NAMESPACE)" rterm $@5 rterm_scope_require_side_effect  */
#line 590 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		std::unique_ptr<Expression> expr{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)};
		BindToScope(expr, ScopeGlobal);
		((*yyvalp).expr) = new SetExpression(std::move(expr), OpSetLiteral, std::unique_ptr<Expression>(new NamespaceExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp))), (*yylocp));
	}
#line 2674 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 55: /* lterm: "using (T_USING)" rterm  */
#line 598 "config_parser.yy"
        {
		Expression::Ptr expr{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)};
		context->AddImport(std::move(expr));
		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 2684 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 58: /* $@6: %empty  */
#line 606 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlContinue | FlowControlBreak, true);
	}
#line 2692 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 59: /* lterm: "for (T_FOR)" '(' optional_var identifier "=> (T_FOLLOWS)" optional_var identifier "in (T_IN)" rterm ')' $@6 rterm_scope_require_side_effect  */
#line 610 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		((*yyvalp).expr) = new ForExpression(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yysemantics.yysval.text)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.text)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yysemantics.yysval.text);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.text);
	}
#line 2704 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 60: /* $@7: %empty  */
#line 618 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlContinue | FlowControlBreak, true);
	}
#line 2712 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 61: /* lterm: "for (T_FOR)" '(' optional_var identifier "in (T_IN)" rterm ')' $@7 rterm_scope_require_side_effect  */
#line 622 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		((*yyvalp).expr) = new ForExpression(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.text)), "", std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.text);
	}
#line 2723 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 62: /* $@8: %empty  */
#line 629 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 2731 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 63: /* lterm: "function (T_FUNCTION)" identifier '(' identifier_items ')' use_specifier $@8 rterm_scope  */
#line 633 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		std::unique_ptr<FunctionExpression> fexpr{new FunctionExpression(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.text), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp))};
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist);

		((*yyvalp).expr) = new SetExpression(MakeIndexer(ScopeThis, std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.text))), OpSetLiteral, std::move(fexpr), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.text);
	}
#line 2746 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 64: /* lterm: "const (T_CONST)" T_IDENTIFIER "= (T_SET)" rterm  */
#line 644 "config_parser.yy"
        {
		((*yyvalp).expr) = new SetConstExpression(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text);
	}
#line 2755 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 65: /* lterm: "var (T_VAR)" rterm  */
#line 649 "config_parser.yy"
        {
		std::unique_ptr<Expression> expr{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)};
		BindToScope(expr, ScopeLocal);
		((*yyvalp).expr) = new SetExpression(std::move(expr), OpSetLiteral, MakeLiteral(), (*yylocp));
	}
#line 2765 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 66: /* lterm: "var (T_VAR)" rterm combined_set_op rterm  */
#line 655 "config_parser.yy"
        {
		std::unique_ptr<Expression> expr{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)};
		BindToScope(expr, ScopeLocal);
		((*yyvalp).expr) = new SetExpression(std::move(expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.csop), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 2775 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 67: /* $@9: %empty  */
#line 661 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlContinue | FlowControlBreak, true);
	}
#line 2783 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 68: /* lterm: "while (T_WHILE)" '(' rterm ')' $@9 rterm_scope  */
#line 665 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		((*yyvalp).expr) = new WhileExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
	}
#line 2793 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 69: /* lterm: "throw (T_THROW)" rterm  */
#line 671 "config_parser.yy"
        {
		((*yyvalp).expr) = new ThrowExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), false, (*yylocp));
	}
#line 2801 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 70: /* lterm: "try (T_TRY)" rterm_scope "except (T_EXCEPT)" rterm_scope  */
#line 675 "config_parser.yy"
        {
		((*yyvalp).expr) = new TryExceptExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.dexpr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
	}
#line 2809 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 72: /* rterm_items: %empty  */
#line 682 "config_parser.yy"
        {
		((*yyvalp).elist) = new std::vector<std::unique_ptr<Expression> >();
	}
#line 2817 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 76: /* rterm_items_inner: rterm  */
#line 691 "config_parser.yy"
        {
		((*yyvalp).elist) = new std::vector<std::unique_ptr<Expression> >();
		((*yyvalp).elist)->emplace_back((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr));
	}
#line 2826 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 77: /* rterm_items_inner: rterm_items_inner ',' optional_newlines rterm  */
#line 696 "config_parser.yy"
        {
		((*yyvalp).elist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.elist);
		((*yyvalp).elist)->emplace_back((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr));
	}
#line 2835 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 78: /* $@10: %empty  */
#line 703 "config_parser.yy"
        {
		context->m_OpenBraces++;
	}
#line 2843 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 79: /* rterm_array: '[' $@10 optional_newlines rterm_items ']'  */
#line 707 "config_parser.yy"
        {
		context->m_OpenBraces--;
		((*yyvalp).expr) = new ArrayExpression(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.elist)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.elist);
	}
#line 2853 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 80: /* $@11: %empty  */
#line 715 "config_parser.yy"
        {
		BeginFlowControlBlock(context, 0, false);
		context->m_IgnoreNewlines.push(false);
		context->m_OpenBraces++;
	}
#line 2863 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 81: /* rterm_dict: '{' $@11 statements '}'  */
#line 721 "config_parser.yy"
        {
		EndFlowControlBlock(context);
		context->m_OpenBraces--;
		context->m_IgnoreNewlines.pop();
		std::vector<std::unique_ptr<Expression> > dlist;
		for (auto& litem : *(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)) {
			if (!litem.second.SideEffect)
				yyerror(&litem.second.DebugInfo, NULL, NULL, "Value computed is not used.");
			dlist.emplace_back(std::move(litem.first));
		}
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist);
		((*yyvalp).dexpr) = new DictExpression(std::move(dlist), (*yylocp));
	}
#line 2881 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 82: /* $@12: %empty  */
#line 737 "config_parser.yy"
        {
		context->m_IgnoreNewlines.push(false);
		context->m_OpenBraces++;
	}
#line 2890 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 83: /* rterm_scope_require_side_effect: '{' $@12 statements '}'  */
#line 742 "config_parser.yy"
        {
		context->m_OpenBraces--;
		context->m_IgnoreNewlines.pop();
		std::vector<std::unique_ptr<Expression> > dlist;
		for (auto& litem : *(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)) {
			if (!litem.second.SideEffect)
				yyerror(&litem.second.DebugInfo, NULL, NULL, "Value computed is not used.");
			dlist.emplace_back(std::move(litem.first));
		}
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist);
		((*yyvalp).dexpr) = new DictExpression(std::move(dlist), (*yylocp));
		((*yyvalp).dexpr)->MakeInline();
	}
#line 2908 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 84: /* $@13: %empty  */
#line 758 "config_parser.yy"
        {
		context->m_IgnoreNewlines.push(false);
		context->m_OpenBraces++;
	}
#line 2917 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 85: /* rterm_scope: '{' $@13 statements '}'  */
#line 763 "config_parser.yy"
        {
		context->m_OpenBraces--;
		context->m_IgnoreNewlines.pop();
		std::vector<std::unique_ptr<Expression> > dlist;
		decltype((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)->size()) num = 0;
		for (auto& litem : *(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)) {
			if (!litem.second.SideEffect && num != (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)->size() - 1)
				yyerror(&litem.second.DebugInfo, NULL, NULL, "Value computed is not used.");
			dlist.emplace_back(std::move(litem.first));
			num++;
		}
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist);
		((*yyvalp).dexpr) = new DictExpression(std::move(dlist), (*yylocp));
		((*yyvalp).dexpr)->MakeInline();
	}
#line 2937 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 86: /* else_if_branch: "else (T_ELSE)" "if (T_IF)" '(' rterm ')' rterm_scope  */
#line 781 "config_parser.yy"
        {
		((*yyvalp).ebranch) = new std::pair<std::unique_ptr<Expression>, std::unique_ptr<Expression> >(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)));
	}
#line 2945 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 87: /* else_if_branches: %empty  */
#line 787 "config_parser.yy"
        {
		((*yyvalp).ebranchlist) = new std::vector<std::pair<std::unique_ptr<Expression>, std::unique_ptr<Expression> > >();
	}
#line 2953 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 88: /* else_if_branches: else_if_branches else_if_branch  */
#line 791 "config_parser.yy"
        {
		((*yyvalp).ebranchlist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.ebranchlist);
		((*yyvalp).ebranchlist)->emplace_back(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.ebranch)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.ebranch);
	}
#line 2963 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 89: /* rterm_side_effect: rterm '(' rterm_items ')'  */
#line 799 "config_parser.yy"
        {
		((*yyvalp).expr) = new FunctionCallExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.elist)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.elist);
	}
#line 2972 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 90: /* rterm_side_effect: "if (T_IF)" '(' rterm ')' rterm_scope else_if_branches  */
#line 804 "config_parser.yy"
        {
		std::vector<std::pair<std::unique_ptr<Expression>, std::unique_ptr<Expression> > > ebranches;
		(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.ebranchlist)->swap(ebranches);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.ebranchlist);

		std::unique_ptr<Expression> afalse;

		for (int i = ebranches.size() - 1; i >= 0; i--) {
			auto& ebranch = ebranches[i];
			afalse.reset(new ConditionalExpression(std::move(ebranch.first), std::move(ebranch.second), std::move(afalse), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)));
		}

		((*yyvalp).expr) = new ConditionalExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.dexpr)), std::move(afalse), (*yylocp));
	}
#line 2991 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 91: /* rterm_side_effect: "if (T_IF)" '(' rterm ')' rterm_scope else_if_branches "else (T_ELSE)" rterm_scope  */
#line 819 "config_parser.yy"
        {
		std::vector<std::pair<std::unique_ptr<Expression>, std::unique_ptr<Expression> > > ebranches;
		(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.ebranchlist)->swap(ebranches);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.ebranchlist);

		(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)->MakeInline();

		std::unique_ptr<Expression> afalse{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)};

		for (int i = ebranches.size() - 1; i >= 0; i--) {
			auto& ebranch = ebranches[i];
			afalse.reset(new ConditionalExpression(std::move(ebranch.first), std::move(ebranch.second), std::move(afalse), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc)));
		}

		((*yyvalp).expr) = new ConditionalExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.dexpr)), std::move(afalse), (*yylocp));
	}
#line 3012 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 92: /* rterm_side_effect: rterm '?' rterm ':' rterm  */
#line 836 "config_parser.yy"
        {
		((*yyvalp).expr) = new ConditionalExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3020 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 93: /* rterm_no_side_effect_no_dict: T_STRING  */
#line 842 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 3029 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 94: /* rterm_no_side_effect_no_dict: T_NUMBER  */
#line 847 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.num));
	}
#line 3037 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 95: /* rterm_no_side_effect_no_dict: T_BOOLEAN  */
#line 851 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.boolean));
	}
#line 3045 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 96: /* rterm_no_side_effect_no_dict: T_NULL  */
#line 855 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 3053 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 97: /* rterm_no_side_effect_no_dict: rterm '.' T_IDENTIFIER  */
#line 859 "config_parser.yy"
        {
		((*yyvalp).expr) = new IndexerExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr)), MakeLiteral(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text))), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 3062 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 98: /* rterm_no_side_effect_no_dict: rterm '[' rterm ']'  */
#line 864 "config_parser.yy"
        {
		((*yyvalp).expr) = new IndexerExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.expr)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3070 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 99: /* rterm_no_side_effect_no_dict: T_IDENTIFIER  */
#line 868 "config_parser.yy"
        {
		((*yyvalp).expr) = new VariableExpression(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text)), context->GetImports(), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 3079 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 100: /* rterm_no_side_effect_no_dict: "* (T_MULTIPLY)" rterm  */
#line 873 "config_parser.yy"
        {
		((*yyvalp).expr) = new DerefExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3087 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 101: /* rterm_no_side_effect_no_dict: "& (T_BINARY_AND)" rterm  */
#line 877 "config_parser.yy"
        {
		((*yyvalp).expr) = new RefExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3095 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 102: /* rterm_no_side_effect_no_dict: '!' rterm  */
#line 881 "config_parser.yy"
        {
		((*yyvalp).expr) = new LogicalNegateExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3103 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 103: /* rterm_no_side_effect_no_dict: '~' rterm  */
#line 885 "config_parser.yy"
        {
		((*yyvalp).expr) = new NegateExpression(std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3111 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 104: /* rterm_no_side_effect_no_dict: "+ (T_PLUS)" rterm  */
#line 889 "config_parser.yy"
        {
		((*yyvalp).expr) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr);
	}
#line 3119 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 105: /* rterm_no_side_effect_no_dict: "- (T_MINUS)" rterm  */
#line 893 "config_parser.yy"
        {
		((*yyvalp).expr) = new SubtractExpression(MakeLiteral(0), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3127 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 106: /* rterm_no_side_effect_no_dict: T_THIS  */
#line 897 "config_parser.yy"
        {
		((*yyvalp).expr) = new GetScopeExpression(ScopeThis);
	}
#line 3135 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 107: /* rterm_no_side_effect_no_dict: "globals (T_GLOBALS)"  */
#line 901 "config_parser.yy"
        {
		((*yyvalp).expr) = new GetScopeExpression(ScopeGlobal);
	}
#line 3143 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 108: /* rterm_no_side_effect_no_dict: "locals (T_LOCALS)"  */
#line 905 "config_parser.yy"
        {
		((*yyvalp).expr) = new GetScopeExpression(ScopeLocal);
	}
#line 3151 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 109: /* rterm_no_side_effect_no_dict: "current_filename (T_CURRENT_FILENAME)"  */
#line 909 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw((*yylocp).Path);
	}
#line 3159 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 110: /* rterm_no_side_effect_no_dict: "current_line (T_CURRENT_LINE)"  */
#line 913 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw((*yylocp).FirstLine);
	}
#line 3167 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 111: /* $@14: %empty  */
#line 917 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 3175 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 112: /* rterm_no_side_effect_no_dict: identifier "=> (T_FOLLOWS)" $@14 rterm_scope  */
#line 921 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		std::vector<String> args;
		args.emplace_back(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text);

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", std::move(args), {}, std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
	}
#line 3189 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 113: /* rterm_no_side_effect_no_dict: identifier "=> (T_FOLLOWS)" rterm  */
#line 931 "config_parser.yy"
        {
		ASSERT(!dynamic_cast<DictExpression *>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)));

		std::vector<String> args;
		args.emplace_back(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text);

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", std::move(args), {}, std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
	}
#line 3203 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 114: /* $@15: %empty  */
#line 941 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 3211 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 115: /* rterm_no_side_effect_no_dict: '(' identifier_items ')' use_specifier "=> (T_FOLLOWS)" $@15 rterm_scope  */
#line 945 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.slist)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.cvlist)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yysval.slist);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.cvlist);
	}
#line 3223 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 116: /* rterm_no_side_effect_no_dict: '(' identifier_items ')' use_specifier "=> (T_FOLLOWS)" rterm  */
#line 953 "config_parser.yy"
        {
		ASSERT(!dynamic_cast<DictExpression *>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)));

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist);
	}
#line 3235 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 118: /* $@16: %empty  */
#line 962 "config_parser.yy"
        {
		context->m_OpenBraces++;
	}
#line 3243 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 119: /* rterm_no_side_effect_no_dict: '(' $@16 rterm ')'  */
#line 966 "config_parser.yy"
        {
		context->m_OpenBraces--;
		((*yyvalp).expr) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.expr);
	}
#line 3252 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 120: /* rterm_no_side_effect_no_dict: rterm "|| (T_LOGICAL_OR)" rterm  */
#line 970 "config_parser.yy"
                                   { MakeRBinaryOp<LogicalOrExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3258 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 121: /* rterm_no_side_effect_no_dict: rterm "&& (T_LOGICAL_AND)" rterm  */
#line 971 "config_parser.yy"
                                    { MakeRBinaryOp<LogicalAndExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3264 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 122: /* rterm_no_side_effect_no_dict: rterm "| (T_BINARY_OR)" rterm  */
#line 972 "config_parser.yy"
                                  { MakeRBinaryOp<BinaryOrExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3270 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 123: /* rterm_no_side_effect_no_dict: rterm "& (T_BINARY_AND)" rterm  */
#line 973 "config_parser.yy"
                                   { MakeRBinaryOp<BinaryAndExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3276 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 124: /* rterm_no_side_effect_no_dict: rterm "in (T_IN)" rterm  */
#line 974 "config_parser.yy"
                           { MakeRBinaryOp<InExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3282 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 125: /* rterm_no_side_effect_no_dict: rterm "!in (T_NOT_IN)" rterm  */
#line 975 "config_parser.yy"
                               { MakeRBinaryOp<NotInExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3288 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 126: /* rterm_no_side_effect_no_dict: rterm "== (T_EQUAL)" rterm  */
#line 976 "config_parser.yy"
                              { MakeRBinaryOp<EqualExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3294 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 127: /* rterm_no_side_effect_no_dict: rterm "!= (T_NOT_EQUAL)" rterm  */
#line 977 "config_parser.yy"
                                  { MakeRBinaryOp<NotEqualExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3300 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 128: /* rterm_no_side_effect_no_dict: rterm "< (T_LESS_THAN)" rterm  */
#line 978 "config_parser.yy"
                                  { MakeRBinaryOp<LessThanExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3306 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 129: /* rterm_no_side_effect_no_dict: rterm "<= (T_LESS_THAN_OR_EQUAL)" rterm  */
#line 979 "config_parser.yy"
                                           { MakeRBinaryOp<LessThanOrEqualExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3312 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 130: /* rterm_no_side_effect_no_dict: rterm "> (T_GREATER_THAN)" rterm  */
#line 980 "config_parser.yy"
                                     { MakeRBinaryOp<GreaterThanExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3318 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 131: /* rterm_no_side_effect_no_dict: rterm ">= (T_GREATER_THAN_OR_EQUAL)" rterm  */
#line 981 "config_parser.yy"
                                              { MakeRBinaryOp<GreaterThanOrEqualExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3324 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 132: /* rterm_no_side_effect_no_dict: rterm "<< (T_SHIFT_LEFT)" rterm  */
#line 982 "config_parser.yy"
                                   { MakeRBinaryOp<ShiftLeftExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3330 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 133: /* rterm_no_side_effect_no_dict: rterm ">> (T_SHIFT_RIGHT)" rterm  */
#line 983 "config_parser.yy"
                                    { MakeRBinaryOp<ShiftRightExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3336 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 134: /* rterm_no_side_effect_no_dict: rterm "+ (T_PLUS)" rterm  */
#line 984 "config_parser.yy"
                             { MakeRBinaryOp<AddExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3342 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 135: /* rterm_no_side_effect_no_dict: rterm "- (T_MINUS)" rterm  */
#line 985 "config_parser.yy"
                              { MakeRBinaryOp<SubtractExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3348 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 136: /* rterm_no_side_effect_no_dict: rterm "* (T_MULTIPLY)" rterm  */
#line 986 "config_parser.yy"
                                 { MakeRBinaryOp<MultiplyExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3354 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 137: /* rterm_no_side_effect_no_dict: rterm "/ (T_DIVIDE_OP)" rterm  */
#line 987 "config_parser.yy"
                                  { MakeRBinaryOp<DivideExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3360 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 138: /* rterm_no_side_effect_no_dict: rterm "% (T_MODULO)" rterm  */
#line 988 "config_parser.yy"
                               { MakeRBinaryOp<ModuloExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3366 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 139: /* rterm_no_side_effect_no_dict: rterm "^ (T_XOR)" rterm  */
#line 989 "config_parser.yy"
                            { MakeRBinaryOp<XorExpression>(&((*yyvalp).expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)); }
#line 3372 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 140: /* $@17: %empty  */
#line 991 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 3380 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 141: /* rterm_no_side_effect_no_dict: "function (T_FUNCTION)" '(' identifier_items ')' use_specifier $@17 rterm_scope  */
#line 995 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist)), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), (*yylocp));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.slist);
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist);
	}
#line 3392 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 142: /* $@18: %empty  */
#line 1003 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 3400 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 143: /* rterm_no_side_effect_no_dict: "{{ (T_NULLARY_LAMBDA_BEGIN)" $@18 statements "}} (T_NULLARY_LAMBDA_END)"  */
#line 1007 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		std::vector<std::unique_ptr<Expression> > dlist;
		decltype(dlist.size()) num = 0;
		for (auto& litem : *(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)) {
			if (!litem.second.SideEffect && num != (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist)->size() - 1)
				yyerror(&litem.second.DebugInfo, NULL, NULL, "Value computed is not used.");
			dlist.emplace_back(std::move(litem.first));
			num++;
		}
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.llist);
		std::unique_ptr<DictExpression> aexpr{new DictExpression(std::move(dlist), (*yylocp))};
		aexpr->MakeInline();

		((*yyvalp).expr) = new FunctionExpression("<anonymous>", {}, {}, std::move(aexpr), (*yylocp));
	}
#line 3422 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 145: /* rterm_no_side_effect: rterm_dict  */
#line 1029 "config_parser.yy"
        {
		std::unique_ptr<Expression> expr{(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)};
		BindToScope(expr, ScopeThis);
		((*yyvalp).expr) = expr.release();
	}
#line 3432 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 148: /* target_type_specifier: %empty  */
#line 1042 "config_parser.yy"
        {
		((*yyvalp).text) = new String();
	}
#line 3440 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 149: /* target_type_specifier: "to (T_TO)" identifier  */
#line 1046 "config_parser.yy"
        {
		((*yyvalp).text) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 3448 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 150: /* default_specifier: %empty  */
#line 1052 "config_parser.yy"
        {
		((*yyvalp).boolean) = false;
	}
#line 3456 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 151: /* default_specifier: "default (T_DEFAULT)"  */
#line 1056 "config_parser.yy"
        {
		((*yyvalp).boolean) = true;
	}
#line 3464 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 152: /* ignore_specifier: %empty  */
#line 1062 "config_parser.yy"
        {
		((*yyvalp).boolean) = false;
	}
#line 3472 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 153: /* ignore_specifier: "ignore_on_error (T_IGNORE_ON_ERROR)"  */
#line 1066 "config_parser.yy"
        {
		((*yyvalp).boolean) = true;
	}
#line 3480 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 154: /* use_specifier: %empty  */
#line 1072 "config_parser.yy"
        {
		((*yyvalp).cvlist) = new std::map<String, std::unique_ptr<Expression> >();
	}
#line 3488 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 155: /* use_specifier: "use (T_USE)" '(' use_specifier_items ')'  */
#line 1076 "config_parser.yy"
        {
		((*yyvalp).cvlist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.cvlist);
	}
#line 3496 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 156: /* use_specifier_items: use_specifier_item  */
#line 1082 "config_parser.yy"
        {
		((*yyvalp).cvlist) = new std::map<String, std::unique_ptr<Expression> >();
		((*yyvalp).cvlist)->emplace(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.cvitem)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.cvitem);
	}
#line 3506 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 157: /* use_specifier_items: use_specifier_items ',' use_specifier_item  */
#line 1088 "config_parser.yy"
        {
		((*yyvalp).cvlist) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.cvlist);
		((*yyvalp).cvlist)->emplace(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.cvitem)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.cvitem);
	}
#line 3516 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 158: /* use_specifier_item: identifier  */
#line 1096 "config_parser.yy"
        {
		std::unique_ptr<Expression> var (new VariableExpression(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text), context->GetImports(), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yyloc)));
		((*yyvalp).cvitem) = new std::pair<String, std::unique_ptr<Expression> >(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text)), std::move(var));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.text);
	}
#line 3526 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 159: /* use_specifier_item: identifier "= (T_SET)" rterm  */
#line 1102 "config_parser.yy"
        {
		((*yyvalp).cvitem) = new std::pair<String, std::unique_ptr<Expression> >(std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text)), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.expr)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.text);
	}
#line 3535 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 161: /* apply_for_specifier: "for (T_FOR)" '(' optional_var identifier "=> (T_FOLLOWS)" optional_var identifier "in (T_IN)" rterm ')'  */
#line 1110 "config_parser.yy"
        {
		context->m_FKVar.top() = std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.text));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.text);

		context->m_FVVar.top() = std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text);

		context->m_FTerm.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.expr);
	}
#line 3549 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 162: /* apply_for_specifier: "for (T_FOR)" '(' optional_var identifier "in (T_IN)" rterm ')'  */
#line 1120 "config_parser.yy"
        {
		context->m_FKVar.top() = std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.text);

		context->m_FVVar.top() = "";

		context->m_FTerm.top() = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yysval.expr);
	}
#line 3562 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 163: /* optional_rterm: %empty  */
#line 1131 "config_parser.yy"
        {
		((*yyvalp).expr) = MakeLiteralRaw();
	}
#line 3570 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 165: /* $@19: %empty  */
#line 1138 "config_parser.yy"
        {
		context->m_Apply.push(true);
		context->m_SeenAssign.push(false);
		context->m_SeenIgnore.push(false);
		context->m_Assign.push(NULL);
		context->m_Ignore.push(NULL);
		context->m_FKVar.push("");
		context->m_FVVar.push("");
		context->m_FTerm.push(NULL);
	}
#line 3585 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 166: /* $@20: %empty  */
#line 1149 "config_parser.yy"
        {
		BeginFlowControlBlock(context, FlowControlReturn, false);
	}
#line 3593 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;

  case 167: /* apply: $@19 "apply (T_APPLY)" identifier optional_rterm apply_for_specifier target_type_specifier use_specifier ignore_specifier $@20 rterm_scope_require_side_effect  */
#line 1153 "config_parser.yy"
        {
		EndFlowControlBlock(context);

		context->m_Apply.pop();

		String type = std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yysval.text));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yysval.text);
		String target = std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.text));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yysval.text);

		if (!ApplyRule::IsValidSourceType(type))
			BOOST_THROW_EXCEPTION(ScriptError("'apply' cannot be used with type '" + type + "'", (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc)));

		if (!ApplyRule::IsValidTargetType(type, target)) {
			if (target == "") {
				std::vector<String> types = ApplyRule::GetTargetTypes(type);
				String typeNames;

				for (std::vector<String>::size_type i = 0; i < types.size(); i++) {
					if (typeNames != "") {
						if (i == types.size() - 1)
							typeNames += " or ";
						else
							typeNames += ", ";
					}

					typeNames += "'" + types[i] + "'";
				}

				BOOST_THROW_EXCEPTION(ScriptError("'apply' target type is ambiguous (can be one of " + typeNames + "): use 'to' to specify a type", DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc))));
			} else
				BOOST_THROW_EXCEPTION(ScriptError("'apply' target type '" + target + "' is invalid", (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yyloc)));
		}

		bool seen_assign = context->m_SeenAssign.top();
		context->m_SeenAssign.pop();

		// assign && !ignore
		if (!seen_assign && !context->m_FTerm.top())
			BOOST_THROW_EXCEPTION(ScriptError("'apply' is missing 'assign'/'for'", DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yyloc))));

		std::unique_ptr<Expression> ignore{context->m_Ignore.top()};
		context->m_Ignore.pop();

		std::unique_ptr<Expression> assign;

		if (!seen_assign)
			assign = MakeLiteral(true);
		else
			assign.reset(context->m_Assign.top());

		context->m_Assign.pop();

		std::unique_ptr<Expression> filter;

		if (ignore) {
			std::unique_ptr<Expression>rex{new LogicalNegateExpression(std::move(ignore), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yyloc)))};

			filter.reset(new LogicalAndExpression(std::move(assign), std::move(rex), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yyloc))));
		} else
			filter.swap(assign);

		String fkvar = std::move(context->m_FKVar.top());
		context->m_FKVar.pop();

		String fvvar = std::move(context->m_FVVar.top());
		context->m_FVVar.pop();

		std::unique_ptr<Expression> fterm{context->m_FTerm.top()};
		context->m_FTerm.pop();

		((*yyvalp).expr) = new ApplyExpression(std::move(type), std::move(target), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yysval.expr)), std::move(filter), context->GetPackage(), std::move(fkvar), std::move(fvvar), std::move(fterm), std::move(*(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.cvlist)), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yysval.boolean), std::unique_ptr<Expression>((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yysval.dexpr)), DebugInfoRange((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yyloc), (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yyloc)));
		delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yysval.cvlist);
	}
#line 3672 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"
    break;


#line 3676 "/build/icinga2/src/icinga2-2.12.3/build/lib/config/config_parser.cc"

      default: break;
    }

  return yyok;
# undef yyerrok
# undef YYABORT
# undef YYACCEPT
# undef YYERROR
# undef YYBACKUP
# undef yyclearin
# undef YYRECOVERING
}


static void
yyuserMerge (int yyn, YYSTYPE* yy0, YYSTYPE* yy1)
{
  YYUSE (yy0);
  YYUSE (yy1);

  switch (yyn)
    {

      default: break;
    }
}

                              /* Bison grammar-table manipulation.  */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (llist);
  YYUSE (context);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}

/** Number of symbols composing the right hand side of rule #RULE.  */
static inline int
yyrhsLength (yyRuleNum yyrule)
{
  return yyr2[yyrule];
}

static void
yydestroyGLRState (char const *yymsg, yyGLRState *yys, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (yys->yyresolved)
    yydestruct (yymsg, yy_accessing_symbol (yys->yylrState),
                &yys->yysemantics.yysval, &yys->yyloc, llist, context);
  else
    {
#if YYDEBUG
      if (yydebug)
        {
          if (yys->yysemantics.yyfirstVal)
            YY_FPRINTF ((stderr, "%s unresolved", yymsg));
          else
            YY_FPRINTF ((stderr, "%s incomplete", yymsg));
          YY_SYMBOL_PRINT ("", yy_accessing_symbol (yys->yylrState), YY_NULLPTR, &yys->yyloc);
        }
#endif

      if (yys->yysemantics.yyfirstVal)
        {
          yySemanticOption *yyoption = yys->yysemantics.yyfirstVal;
          yyGLRState *yyrh;
          int yyn;
          for (yyrh = yyoption->yystate, yyn = yyrhsLength (yyoption->yyrule);
               yyn > 0;
               yyrh = yyrh->yypred, yyn -= 1)
            yydestroyGLRState (yymsg, yyrh, llist, context);
        }
    }
}

/** Left-hand-side symbol for rule #YYRULE.  */
static inline yysymbol_kind_t
yylhsNonterm (yyRuleNum yyrule)
{
  return YY_CAST (yysymbol_kind_t, yyr1[yyrule]);
}

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

/** True iff LR state YYSTATE has only a default reduction (regardless
 *  of token).  */
static inline yybool
yyisDefaultedState (yy_state_t yystate)
{
  return yypact_value_is_default (yypact[yystate]);
}

/** The default reduction for YYSTATE, assuming it has one.  */
static inline yyRuleNum
yydefaultAction (yy_state_t yystate)
{
  return yydefact[yystate];
}

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/** The action to take in YYSTATE on seeing YYTOKEN.
 *  Result R means
 *    R < 0:  Reduce on rule -R.
 *    R = 0:  Error.
 *    R > 0:  Shift to state R.
 *  Set *YYCONFLICTS to a pointer into yyconfl to a 0-terminated list
 *  of conflicting reductions.
 */
static inline int
yygetLRActions (yy_state_t yystate, yysymbol_kind_t yytoken, const short** yyconflicts)
{
  int yyindex = yypact[yystate] + yytoken;
  if (yytoken == YYSYMBOL_YYerror)
    {
      // This is the error token.
      *yyconflicts = yyconfl;
      return 0;
    }
  else if (yyisDefaultedState (yystate)
           || yyindex < 0 || YYLAST < yyindex || yycheck[yyindex] != yytoken)
    {
      *yyconflicts = yyconfl;
      return -yydefact[yystate];
    }
  else if (! yytable_value_is_error (yytable[yyindex]))
    {
      *yyconflicts = yyconfl + yyconflp[yyindex];
      return yytable[yyindex];
    }
  else
    {
      *yyconflicts = yyconfl + yyconflp[yyindex];
      return 0;
    }
}

/** Compute post-reduction state.
 * \param yystate   the current state
 * \param yysym     the nonterminal to push on the stack
 */
static inline yy_state_t
yyLRgotoState (yy_state_t yystate, yysymbol_kind_t yysym)
{
  int yyr = yypgoto[yysym - YYNTOKENS] + yystate;
  if (0 <= yyr && yyr <= YYLAST && yycheck[yyr] == yystate)
    return yytable[yyr];
  else
    return yydefgoto[yysym - YYNTOKENS];
}

static inline yybool
yyisShiftAction (int yyaction)
{
  return 0 < yyaction;
}

static inline yybool
yyisErrorAction (int yyaction)
{
  return yyaction == 0;
}

                                /* GLRStates */

/** Return a fresh GLRStackItem in YYSTACKP.  The item is an LR state
 *  if YYISSTATE, and otherwise a semantic option.  Callers should call
 *  YY_RESERVE_GLRSTACK afterwards to make sure there is sufficient
 *  headroom.  */

static inline yyGLRStackItem*
yynewGLRStackItem (yyGLRStack* yystackp, yybool yyisState)
{
  yyGLRStackItem* yynewItem = yystackp->yynextFree;
  yystackp->yyspaceLeft -= 1;
  yystackp->yynextFree += 1;
  yynewItem->yystate.yyisState = yyisState;
  return yynewItem;
}

/** Add a new semantic action that will execute the action for rule
 *  YYRULE on the semantic values in YYRHS to the list of
 *  alternative actions for YYSTATE.  Assumes that YYRHS comes from
 *  stack #YYK of *YYSTACKP. */
static void
yyaddDeferredAction (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyGLRState* yystate,
                     yyGLRState* yyrhs, yyRuleNum yyrule)
{
  yySemanticOption* yynewOption =
    &yynewGLRStackItem (yystackp, yyfalse)->yyoption;
  YY_ASSERT (!yynewOption->yyisState);
  yynewOption->yystate = yyrhs;
  yynewOption->yyrule = yyrule;
  if (yystackp->yytops.yylookaheadNeeds[yyk])
    {
      yynewOption->yyrawchar = yychar;
      yynewOption->yyval = yylval;
      yynewOption->yyloc = yylloc;
    }
  else
    yynewOption->yyrawchar = YYEMPTY;
  yynewOption->yynext = yystate->yysemantics.yyfirstVal;
  yystate->yysemantics.yyfirstVal = yynewOption;

  YY_RESERVE_GLRSTACK (yystackp);
}

                                /* GLRStacks */

/** Initialize YYSET to a singleton set containing an empty stack.  */
static yybool
yyinitStateSet (yyGLRStateSet* yyset)
{
  yyset->yysize = 1;
  yyset->yycapacity = 16;
  yyset->yystates
    = YY_CAST (yyGLRState**,
               YYMALLOC (YY_CAST (YYSIZE_T, yyset->yycapacity)
                         * sizeof yyset->yystates[0]));
  if (! yyset->yystates)
    return yyfalse;
  yyset->yystates[0] = YY_NULLPTR;
  yyset->yylookaheadNeeds
    = YY_CAST (yybool*,
               YYMALLOC (YY_CAST (YYSIZE_T, yyset->yycapacity)
                         * sizeof yyset->yylookaheadNeeds[0]));
  if (! yyset->yylookaheadNeeds)
    {
      YYFREE (yyset->yystates);
      return yyfalse;
    }
  memset (yyset->yylookaheadNeeds,
          0,
          YY_CAST (YYSIZE_T, yyset->yycapacity) * sizeof yyset->yylookaheadNeeds[0]);
  return yytrue;
}

static void yyfreeStateSet (yyGLRStateSet* yyset)
{
  YYFREE (yyset->yystates);
  YYFREE (yyset->yylookaheadNeeds);
}

/** Initialize *YYSTACKP to a single empty stack, with total maximum
 *  capacity for all stacks of YYSIZE.  */
static yybool
yyinitGLRStack (yyGLRStack* yystackp, YYPTRDIFF_T yysize)
{
  yystackp->yyerrState = 0;
  yynerrs = 0;
  yystackp->yyspaceLeft = yysize;
  yystackp->yyitems
    = YY_CAST (yyGLRStackItem*,
               YYMALLOC (YY_CAST (YYSIZE_T, yysize)
                         * sizeof yystackp->yynextFree[0]));
  if (!yystackp->yyitems)
    return yyfalse;
  yystackp->yynextFree = yystackp->yyitems;
  yystackp->yysplitPoint = YY_NULLPTR;
  yystackp->yylastDeleted = YY_NULLPTR;
  return yyinitStateSet (&yystackp->yytops);
}


#if YYSTACKEXPANDABLE
# define YYRELOC(YYFROMITEMS, YYTOITEMS, YYX, YYTYPE)                   \
  &((YYTOITEMS)                                                         \
    - ((YYFROMITEMS) - YY_REINTERPRET_CAST (yyGLRStackItem*, (YYX))))->YYTYPE

/** If *YYSTACKP is expandable, extend it.  WARNING: Pointers into the
    stack from outside should be considered invalid after this call.
    We always expand when there are 1 or fewer items left AFTER an
    allocation, so that we can avoid having external pointers exist
    across an allocation.  */
static void
yyexpandGLRStack (yyGLRStack* yystackp)
{
  yyGLRStackItem* yynewItems;
  yyGLRStackItem* yyp0, *yyp1;
  YYPTRDIFF_T yynewSize;
  YYPTRDIFF_T yyn;
  YYPTRDIFF_T yysize = yystackp->yynextFree - yystackp->yyitems;
  if (YYMAXDEPTH - YYHEADROOM < yysize)
    yyMemoryExhausted (yystackp);
  yynewSize = 2*yysize;
  if (YYMAXDEPTH < yynewSize)
    yynewSize = YYMAXDEPTH;
  yynewItems
    = YY_CAST (yyGLRStackItem*,
               YYMALLOC (YY_CAST (YYSIZE_T, yynewSize)
                         * sizeof yynewItems[0]));
  if (! yynewItems)
    yyMemoryExhausted (yystackp);
  for (yyp0 = yystackp->yyitems, yyp1 = yynewItems, yyn = yysize;
       0 < yyn;
       yyn -= 1, yyp0 += 1, yyp1 += 1)
    {
      *yyp1 = *yyp0;
      if (*YY_REINTERPRET_CAST (yybool *, yyp0))
        {
          yyGLRState* yys0 = &yyp0->yystate;
          yyGLRState* yys1 = &yyp1->yystate;
          if (yys0->yypred != YY_NULLPTR)
            yys1->yypred =
              YYRELOC (yyp0, yyp1, yys0->yypred, yystate);
          if (! yys0->yyresolved && yys0->yysemantics.yyfirstVal != YY_NULLPTR)
            yys1->yysemantics.yyfirstVal =
              YYRELOC (yyp0, yyp1, yys0->yysemantics.yyfirstVal, yyoption);
        }
      else
        {
          yySemanticOption* yyv0 = &yyp0->yyoption;
          yySemanticOption* yyv1 = &yyp1->yyoption;
          if (yyv0->yystate != YY_NULLPTR)
            yyv1->yystate = YYRELOC (yyp0, yyp1, yyv0->yystate, yystate);
          if (yyv0->yynext != YY_NULLPTR)
            yyv1->yynext = YYRELOC (yyp0, yyp1, yyv0->yynext, yyoption);
        }
    }
  if (yystackp->yysplitPoint != YY_NULLPTR)
    yystackp->yysplitPoint = YYRELOC (yystackp->yyitems, yynewItems,
                                      yystackp->yysplitPoint, yystate);

  for (yyn = 0; yyn < yystackp->yytops.yysize; yyn += 1)
    if (yystackp->yytops.yystates[yyn] != YY_NULLPTR)
      yystackp->yytops.yystates[yyn] =
        YYRELOC (yystackp->yyitems, yynewItems,
                 yystackp->yytops.yystates[yyn], yystate);
  YYFREE (yystackp->yyitems);
  yystackp->yyitems = yynewItems;
  yystackp->yynextFree = yynewItems + yysize;
  yystackp->yyspaceLeft = yynewSize - yysize;
}
#endif

static void
yyfreeGLRStack (yyGLRStack* yystackp)
{
  YYFREE (yystackp->yyitems);
  yyfreeStateSet (&yystackp->yytops);
}

/** Assuming that YYS is a GLRState somewhere on *YYSTACKP, update the
 *  splitpoint of *YYSTACKP, if needed, so that it is at least as deep as
 *  YYS.  */
static inline void
yyupdateSplit (yyGLRStack* yystackp, yyGLRState* yys)
{
  if (yystackp->yysplitPoint != YY_NULLPTR && yystackp->yysplitPoint > yys)
    yystackp->yysplitPoint = yys;
}

/** Invalidate stack #YYK in *YYSTACKP.  */
static inline void
yymarkStackDeleted (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  if (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
    yystackp->yylastDeleted = yystackp->yytops.yystates[yyk];
  yystackp->yytops.yystates[yyk] = YY_NULLPTR;
}

/** Undelete the last stack in *YYSTACKP that was marked as deleted.  Can
    only be done once after a deletion, and only when all other stacks have
    been deleted.  */
static void
yyundeleteLastStack (yyGLRStack* yystackp)
{
  if (yystackp->yylastDeleted == YY_NULLPTR || yystackp->yytops.yysize != 0)
    return;
  yystackp->yytops.yystates[0] = yystackp->yylastDeleted;
  yystackp->yytops.yysize = 1;
  YY_DPRINTF ((stderr, "Restoring last deleted stack as stack #0.\n"));
  yystackp->yylastDeleted = YY_NULLPTR;
}

static inline void
yyremoveDeletes (yyGLRStack* yystackp)
{
  YYPTRDIFF_T yyi, yyj;
  yyi = yyj = 0;
  while (yyj < yystackp->yytops.yysize)
    {
      if (yystackp->yytops.yystates[yyi] == YY_NULLPTR)
        {
          if (yyi == yyj)
            YY_DPRINTF ((stderr, "Removing dead stacks.\n"));
          yystackp->yytops.yysize -= 1;
        }
      else
        {
          yystackp->yytops.yystates[yyj] = yystackp->yytops.yystates[yyi];
          /* In the current implementation, it's unnecessary to copy
             yystackp->yytops.yylookaheadNeeds[yyi] since, after
             yyremoveDeletes returns, the parser immediately either enters
             deterministic operation or shifts a token.  However, it doesn't
             hurt, and the code might evolve to need it.  */
          yystackp->yytops.yylookaheadNeeds[yyj] =
            yystackp->yytops.yylookaheadNeeds[yyi];
          if (yyj != yyi)
            YY_DPRINTF ((stderr, "Rename stack %ld -> %ld.\n",
                        YY_CAST (long, yyi), YY_CAST (long, yyj)));
          yyj += 1;
        }
      yyi += 1;
    }
}

/** Shift to a new state on stack #YYK of *YYSTACKP, corresponding to LR
 * state YYLRSTATE, at input position YYPOSN, with (resolved) semantic
 * value *YYVALP and source location *YYLOCP.  */
static inline void
yyglrShift (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yy_state_t yylrState,
            YYPTRDIFF_T yyposn,
            YYSTYPE* yyvalp, YYLTYPE* yylocp)
{
  yyGLRState* yynewState = &yynewGLRStackItem (yystackp, yytrue)->yystate;

  yynewState->yylrState = yylrState;
  yynewState->yyposn = yyposn;
  yynewState->yyresolved = yytrue;
  yynewState->yypred = yystackp->yytops.yystates[yyk];
  yynewState->yysemantics.yysval = *yyvalp;
  yynewState->yyloc = *yylocp;
  yystackp->yytops.yystates[yyk] = yynewState;

  YY_RESERVE_GLRSTACK (yystackp);
}

/** Shift stack #YYK of *YYSTACKP, to a new state corresponding to LR
 *  state YYLRSTATE, at input position YYPOSN, with the (unresolved)
 *  semantic value of YYRHS under the action for YYRULE.  */
static inline void
yyglrShiftDefer (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yy_state_t yylrState,
                 YYPTRDIFF_T yyposn, yyGLRState* yyrhs, yyRuleNum yyrule)
{
  yyGLRState* yynewState = &yynewGLRStackItem (yystackp, yytrue)->yystate;
  YY_ASSERT (yynewState->yyisState);

  yynewState->yylrState = yylrState;
  yynewState->yyposn = yyposn;
  yynewState->yyresolved = yyfalse;
  yynewState->yypred = yystackp->yytops.yystates[yyk];
  yynewState->yysemantics.yyfirstVal = YY_NULLPTR;
  yystackp->yytops.yystates[yyk] = yynewState;

  /* Invokes YY_RESERVE_GLRSTACK.  */
  yyaddDeferredAction (yystackp, yyk, yynewState, yyrhs, yyrule);
}

#if !YYDEBUG
# define YY_REDUCE_PRINT(Args)
#else
# define YY_REDUCE_PRINT(Args)          \
  do {                                  \
    if (yydebug)                        \
      yy_reduce_print Args;             \
  } while (0)

/*----------------------------------------------------------------------.
| Report that stack #YYK of *YYSTACKP is going to be reduced by YYRULE. |
`----------------------------------------------------------------------*/

static inline void
yy_reduce_print (yybool yynormal, yyGLRStackItem* yyvsp, YYPTRDIFF_T yyk,
                 yyRuleNum yyrule, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  int yynrhs = yyrhsLength (yyrule);
  int yylow = 1;
  int yyi;
  YY_FPRINTF ((stderr, "Reducing stack %ld by rule %d (line %d):\n",
               YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule]));
  if (! yynormal)
    yyfillin (yyvsp, 1, -yynrhs);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YY_FPRINTF ((stderr, "   $%d = ", yyi + 1));
      yy_symbol_print (stderr,
                       yy_accessing_symbol (yyvsp[yyi - yynrhs + 1].yystate.yylrState),
                       &yyvsp[yyi - yynrhs + 1].yystate.yysemantics.yysval,
                       &(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL ((yyi + 1) - (yynrhs))].yystate.yyloc)                       , llist, context);
      if (!yyvsp[yyi - yynrhs + 1].yystate.yyresolved)
        YY_FPRINTF ((stderr, " (unresolved)"));
      YY_FPRINTF ((stderr, "\n"));
    }
}
#endif

/** Pop the symbols consumed by reduction #YYRULE from the top of stack
 *  #YYK of *YYSTACKP, and perform the appropriate semantic action on their
 *  semantic values.  Assumes that all ambiguities in semantic values
 *  have been previously resolved.  Set *YYVALP to the resulting value,
 *  and *YYLOCP to the computed location (if any).  Return value is as
 *  for userAction.  */
static inline YYRESULTTAG
yydoAction (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyRuleNum yyrule,
            YYSTYPE* yyvalp, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  int yynrhs = yyrhsLength (yyrule);

  if (yystackp->yysplitPoint == YY_NULLPTR)
    {
      /* Standard special case: single stack.  */
      yyGLRStackItem* yyrhs
        = YY_REINTERPRET_CAST (yyGLRStackItem*, yystackp->yytops.yystates[yyk]);
      YY_ASSERT (yyk == 0);
      yystackp->yynextFree -= yynrhs;
      yystackp->yyspaceLeft += yynrhs;
      yystackp->yytops.yystates[0] = & yystackp->yynextFree[-1].yystate;
      YY_REDUCE_PRINT ((yytrue, yyrhs, yyk, yyrule, llist, context));
      return yyuserAction (yyrule, yynrhs, yyrhs, yystackp,
                           yyvalp, yylocp, llist, context);
    }
  else
    {
      yyGLRStackItem yyrhsVals[YYMAXRHS + YYMAXLEFT + 1];
      yyGLRState* yys = yyrhsVals[YYMAXRHS + YYMAXLEFT].yystate.yypred
        = yystackp->yytops.yystates[yyk];
      int yyi;
      if (yynrhs == 0)
        /* Set default location.  */
        yyrhsVals[YYMAXRHS + YYMAXLEFT - 1].yystate.yyloc = yys->yyloc;
      for (yyi = 0; yyi < yynrhs; yyi += 1)
        {
          yys = yys->yypred;
          YY_ASSERT (yys);
        }
      yyupdateSplit (yystackp, yys);
      yystackp->yytops.yystates[yyk] = yys;
      YY_REDUCE_PRINT ((yyfalse, yyrhsVals + YYMAXRHS + YYMAXLEFT - 1, yyk, yyrule, llist, context));
      return yyuserAction (yyrule, yynrhs, yyrhsVals + YYMAXRHS + YYMAXLEFT - 1,
                           yystackp, yyvalp, yylocp, llist, context);
    }
}

/** Pop items off stack #YYK of *YYSTACKP according to grammar rule YYRULE,
 *  and push back on the resulting nonterminal symbol.  Perform the
 *  semantic action associated with YYRULE and store its value with the
 *  newly pushed state, if YYFORCEEVAL or if *YYSTACKP is currently
 *  unambiguous.  Otherwise, store the deferred semantic action with
 *  the new state.  If the new state would have an identical input
 *  position, LR state, and predecessor to an existing state on the stack,
 *  it is identified with that existing state, eliminating stack #YYK from
 *  *YYSTACKP.  In this case, the semantic value is
 *  added to the options for the existing state's semantic value.
 */
static inline YYRESULTTAG
yyglrReduce (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyRuleNum yyrule,
             yybool yyforceEval, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  YYPTRDIFF_T yyposn = yystackp->yytops.yystates[yyk]->yyposn;

  if (yyforceEval || yystackp->yysplitPoint == YY_NULLPTR)
    {
      YYSTYPE yysval;
      YYLTYPE yyloc;

      YYRESULTTAG yyflag = yydoAction (yystackp, yyk, yyrule, &yysval, &yyloc, llist, context);
      if (yyflag == yyerr && yystackp->yysplitPoint != YY_NULLPTR)
        YY_DPRINTF ((stderr,
                     "Parse on stack %ld rejected by rule %d (line %d).\n",
                     YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule - 1]));
      if (yyflag != yyok)
        return yyflag;
      YY_SYMBOL_PRINT ("-> $$ =", yylhsNonterm (yyrule), &yysval, &yyloc);
      yyglrShift (yystackp, yyk,
                  yyLRgotoState (yystackp->yytops.yystates[yyk]->yylrState,
                                 yylhsNonterm (yyrule)),
                  yyposn, &yysval, &yyloc);
    }
  else
    {
      YYPTRDIFF_T yyi;
      int yyn;
      yyGLRState* yys, *yys0 = yystackp->yytops.yystates[yyk];
      yy_state_t yynewLRState;

      for (yys = yystackp->yytops.yystates[yyk], yyn = yyrhsLength (yyrule);
           0 < yyn; yyn -= 1)
        {
          yys = yys->yypred;
          YY_ASSERT (yys);
        }
      yyupdateSplit (yystackp, yys);
      yynewLRState = yyLRgotoState (yys->yylrState, yylhsNonterm (yyrule));
      YY_DPRINTF ((stderr,
                   "Reduced stack %ld by rule %d (line %d); action deferred.  "
                   "Now in state %d.\n",
                   YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule - 1],
                   yynewLRState));
      for (yyi = 0; yyi < yystackp->yytops.yysize; yyi += 1)
        if (yyi != yyk && yystackp->yytops.yystates[yyi] != YY_NULLPTR)
          {
            yyGLRState *yysplit = yystackp->yysplitPoint;
            yyGLRState *yyp = yystackp->yytops.yystates[yyi];
            while (yyp != yys && yyp != yysplit && yyp->yyposn >= yyposn)
              {
                if (yyp->yylrState == yynewLRState && yyp->yypred == yys)
                  {
                    yyaddDeferredAction (yystackp, yyk, yyp, yys0, yyrule);
                    yymarkStackDeleted (yystackp, yyk);
                    YY_DPRINTF ((stderr, "Merging stack %ld into stack %ld.\n",
                                 YY_CAST (long, yyk), YY_CAST (long, yyi)));
                    return yyok;
                  }
                yyp = yyp->yypred;
              }
          }
      yystackp->yytops.yystates[yyk] = yys;
      yyglrShiftDefer (yystackp, yyk, yynewLRState, yyposn, yys0, yyrule);
    }
  return yyok;
}

static YYPTRDIFF_T
yysplitStack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  if (yystackp->yysplitPoint == YY_NULLPTR)
    {
      YY_ASSERT (yyk == 0);
      yystackp->yysplitPoint = yystackp->yytops.yystates[yyk];
    }
  if (yystackp->yytops.yycapacity <= yystackp->yytops.yysize)
    {
      YYPTRDIFF_T state_size = YYSIZEOF (yystackp->yytops.yystates[0]);
      YYPTRDIFF_T half_max_capacity = YYSIZE_MAXIMUM / 2 / state_size;
      if (half_max_capacity < yystackp->yytops.yycapacity)
        yyMemoryExhausted (yystackp);
      yystackp->yytops.yycapacity *= 2;

      {
        yyGLRState** yynewStates
          = YY_CAST (yyGLRState**,
                     YYREALLOC (yystackp->yytops.yystates,
                                (YY_CAST (YYSIZE_T, yystackp->yytops.yycapacity)
                                 * sizeof yynewStates[0])));
        if (yynewStates == YY_NULLPTR)
          yyMemoryExhausted (yystackp);
        yystackp->yytops.yystates = yynewStates;
      }

      {
        yybool* yynewLookaheadNeeds
          = YY_CAST (yybool*,
                     YYREALLOC (yystackp->yytops.yylookaheadNeeds,
                                (YY_CAST (YYSIZE_T, yystackp->yytops.yycapacity)
                                 * sizeof yynewLookaheadNeeds[0])));
        if (yynewLookaheadNeeds == YY_NULLPTR)
          yyMemoryExhausted (yystackp);
        yystackp->yytops.yylookaheadNeeds = yynewLookaheadNeeds;
      }
    }
  yystackp->yytops.yystates[yystackp->yytops.yysize]
    = yystackp->yytops.yystates[yyk];
  yystackp->yytops.yylookaheadNeeds[yystackp->yytops.yysize]
    = yystackp->yytops.yylookaheadNeeds[yyk];
  yystackp->yytops.yysize += 1;
  return yystackp->yytops.yysize - 1;
}

/** True iff YYY0 and YYY1 represent identical options at the top level.
 *  That is, they represent the same rule applied to RHS symbols
 *  that produce the same terminal symbols.  */
static yybool
yyidenticalOptions (yySemanticOption* yyy0, yySemanticOption* yyy1)
{
  if (yyy0->yyrule == yyy1->yyrule)
    {
      yyGLRState *yys0, *yys1;
      int yyn;
      for (yys0 = yyy0->yystate, yys1 = yyy1->yystate,
           yyn = yyrhsLength (yyy0->yyrule);
           yyn > 0;
           yys0 = yys0->yypred, yys1 = yys1->yypred, yyn -= 1)
        if (yys0->yyposn != yys1->yyposn)
          return yyfalse;
      return yytrue;
    }
  else
    return yyfalse;
}

/** Assuming identicalOptions (YYY0,YYY1), destructively merge the
 *  alternative semantic values for the RHS-symbols of YYY1 and YYY0.  */
static void
yymergeOptionSets (yySemanticOption* yyy0, yySemanticOption* yyy1)
{
  yyGLRState *yys0, *yys1;
  int yyn;
  for (yys0 = yyy0->yystate, yys1 = yyy1->yystate,
       yyn = yyrhsLength (yyy0->yyrule);
       0 < yyn;
       yys0 = yys0->yypred, yys1 = yys1->yypred, yyn -= 1)
    {
      if (yys0 == yys1)
        break;
      else if (yys0->yyresolved)
        {
          yys1->yyresolved = yytrue;
          yys1->yysemantics.yysval = yys0->yysemantics.yysval;
        }
      else if (yys1->yyresolved)
        {
          yys0->yyresolved = yytrue;
          yys0->yysemantics.yysval = yys1->yysemantics.yysval;
        }
      else
        {
          yySemanticOption** yyz0p = &yys0->yysemantics.yyfirstVal;
          yySemanticOption* yyz1 = yys1->yysemantics.yyfirstVal;
          while (yytrue)
            {
              if (yyz1 == *yyz0p || yyz1 == YY_NULLPTR)
                break;
              else if (*yyz0p == YY_NULLPTR)
                {
                  *yyz0p = yyz1;
                  break;
                }
              else if (*yyz0p < yyz1)
                {
                  yySemanticOption* yyz = *yyz0p;
                  *yyz0p = yyz1;
                  yyz1 = yyz1->yynext;
                  (*yyz0p)->yynext = yyz;
                }
              yyz0p = &(*yyz0p)->yynext;
            }
          yys1->yysemantics.yyfirstVal = yys0->yysemantics.yyfirstVal;
        }
    }
}

/** Y0 and Y1 represent two possible actions to take in a given
 *  parsing state; return 0 if no combination is possible,
 *  1 if user-mergeable, 2 if Y0 is preferred, 3 if Y1 is preferred.  */
static int
yypreference (yySemanticOption* y0, yySemanticOption* y1)
{
  yyRuleNum r0 = y0->yyrule, r1 = y1->yyrule;
  int p0 = yydprec[r0], p1 = yydprec[r1];

  if (p0 == p1)
    {
      if (yymerger[r0] == 0 || yymerger[r0] != yymerger[r1])
        return 0;
      else
        return 1;
    }
  if (p0 == 0 || p1 == 0)
    return 0;
  if (p0 < p1)
    return 3;
  if (p1 < p0)
    return 2;
  return 0;
}

static YYRESULTTAG yyresolveValue (yyGLRState* yys,
                                   yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context);


/** Resolve the previous YYN states starting at and including state YYS
 *  on *YYSTACKP. If result != yyok, some states may have been left
 *  unresolved possibly with empty semantic option chains.  Regardless
 *  of whether result = yyok, each state has been left with consistent
 *  data so that yydestroyGLRState can be invoked if necessary.  */
static YYRESULTTAG
yyresolveStates (yyGLRState* yys, int yyn,
                 yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (0 < yyn)
    {
      YY_ASSERT (yys->yypred);
      YYCHK (yyresolveStates (yys->yypred, yyn-1, yystackp, llist, context));
      if (! yys->yyresolved)
        YYCHK (yyresolveValue (yys, yystackp, llist, context));
    }
  return yyok;
}

/** Resolve the states for the RHS of YYOPT on *YYSTACKP, perform its
 *  user action, and return the semantic value and location in *YYVALP
 *  and *YYLOCP.  Regardless of whether result = yyok, all RHS states
 *  have been destroyed (assuming the user action destroys all RHS
 *  semantic values if invoked).  */
static YYRESULTTAG
yyresolveAction (yySemanticOption* yyopt, yyGLRStack* yystackp,
                 YYSTYPE* yyvalp, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  yyGLRStackItem yyrhsVals[YYMAXRHS + YYMAXLEFT + 1];
  int yynrhs = yyrhsLength (yyopt->yyrule);
  YYRESULTTAG yyflag =
    yyresolveStates (yyopt->yystate, yynrhs, yystackp, llist, context);
  if (yyflag != yyok)
    {
      yyGLRState *yys;
      for (yys = yyopt->yystate; yynrhs > 0; yys = yys->yypred, yynrhs -= 1)
        yydestroyGLRState ("Cleanup: popping", yys, llist, context);
      return yyflag;
    }

  yyrhsVals[YYMAXRHS + YYMAXLEFT].yystate.yypred = yyopt->yystate;
  if (yynrhs == 0)
    /* Set default location.  */
    yyrhsVals[YYMAXRHS + YYMAXLEFT - 1].yystate.yyloc = yyopt->yystate->yyloc;
  {
    int yychar_current = yychar;
    YYSTYPE yylval_current = yylval;
    YYLTYPE yylloc_current = yylloc;
    yychar = yyopt->yyrawchar;
    yylval = yyopt->yyval;
    yylloc = yyopt->yyloc;
    yyflag = yyuserAction (yyopt->yyrule, yynrhs,
                           yyrhsVals + YYMAXRHS + YYMAXLEFT - 1,
                           yystackp, yyvalp, yylocp, llist, context);
    yychar = yychar_current;
    yylval = yylval_current;
    yylloc = yylloc_current;
  }
  return yyflag;
}

#if YYDEBUG
static void
yyreportTree (yySemanticOption* yyx, int yyindent)
{
  int yynrhs = yyrhsLength (yyx->yyrule);
  int yyi;
  yyGLRState* yys;
  yyGLRState* yystates[1 + YYMAXRHS];
  yyGLRState yyleftmost_state;

  for (yyi = yynrhs, yys = yyx->yystate; 0 < yyi; yyi -= 1, yys = yys->yypred)
    yystates[yyi] = yys;
  if (yys == YY_NULLPTR)
    {
      yyleftmost_state.yyposn = 0;
      yystates[0] = &yyleftmost_state;
    }
  else
    yystates[0] = yys;

  if (yyx->yystate->yyposn < yys->yyposn + 1)
    YY_FPRINTF ((stderr, "%*s%s -> <Rule %d, empty>\n",
                 yyindent, "", yysymbol_name (yylhsNonterm (yyx->yyrule)),
                 yyx->yyrule - 1));
  else
    YY_FPRINTF ((stderr, "%*s%s -> <Rule %d, tokens %ld .. %ld>\n",
                 yyindent, "", yysymbol_name (yylhsNonterm (yyx->yyrule)),
                 yyx->yyrule - 1, YY_CAST (long, yys->yyposn + 1),
                 YY_CAST (long, yyx->yystate->yyposn)));
  for (yyi = 1; yyi <= yynrhs; yyi += 1)
    {
      if (yystates[yyi]->yyresolved)
        {
          if (yystates[yyi-1]->yyposn+1 > yystates[yyi]->yyposn)
            YY_FPRINTF ((stderr, "%*s%s <empty>\n", yyindent+2, "",
                         yysymbol_name (yy_accessing_symbol (yystates[yyi]->yylrState))));
          else
            YY_FPRINTF ((stderr, "%*s%s <tokens %ld .. %ld>\n", yyindent+2, "",
                         yysymbol_name (yy_accessing_symbol (yystates[yyi]->yylrState)),
                         YY_CAST (long, yystates[yyi-1]->yyposn + 1),
                         YY_CAST (long, yystates[yyi]->yyposn)));
        }
      else
        yyreportTree (yystates[yyi]->yysemantics.yyfirstVal, yyindent+2);
    }
}
#endif

static YYRESULTTAG
yyreportAmbiguity (yySemanticOption* yyx0,
                   yySemanticOption* yyx1, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  YYUSE (yyx0);
  YYUSE (yyx1);

#if YYDEBUG
  YY_FPRINTF ((stderr, "Ambiguity detected.\n"));
  YY_FPRINTF ((stderr, "Option 1,\n"));
  yyreportTree (yyx0, 2);
  YY_FPRINTF ((stderr, "\nOption 2,\n"));
  yyreportTree (yyx1, 2);
  YY_FPRINTF ((stderr, "\n"));
#endif

  yyerror (yylocp, llist, context, YY_("syntax is ambiguous"));
  return yyabort;
}

/** Resolve the locations for each of the YYN1 states in *YYSTACKP,
 *  ending at YYS1.  Has no effect on previously resolved states.
 *  The first semantic option of a state is always chosen.  */
static void
yyresolveLocations (yyGLRState *yys1, int yyn1,
                    yyGLRStack *yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (0 < yyn1)
    {
      yyresolveLocations (yys1->yypred, yyn1 - 1, yystackp, llist, context);
      if (!yys1->yyresolved)
        {
          yyGLRStackItem yyrhsloc[1 + YYMAXRHS];
          int yynrhs;
          yySemanticOption *yyoption = yys1->yysemantics.yyfirstVal;
          YY_ASSERT (yyoption);
          yynrhs = yyrhsLength (yyoption->yyrule);
          if (0 < yynrhs)
            {
              yyGLRState *yys;
              int yyn;
              yyresolveLocations (yyoption->yystate, yynrhs,
                                  yystackp, llist, context);
              for (yys = yyoption->yystate, yyn = yynrhs;
                   yyn > 0;
                   yys = yys->yypred, yyn -= 1)
                yyrhsloc[yyn].yystate.yyloc = yys->yyloc;
            }
          else
            {
              /* Both yyresolveAction and yyresolveLocations traverse the GSS
                 in reverse rightmost order.  It is only necessary to invoke
                 yyresolveLocations on a subforest for which yyresolveAction
                 would have been invoked next had an ambiguity not been
                 detected.  Thus the location of the previous state (but not
                 necessarily the previous state itself) is guaranteed to be
                 resolved already.  */
              yyGLRState *yyprevious = yyoption->yystate;
              yyrhsloc[0].yystate.yyloc = yyprevious->yyloc;
            }
          YYLLOC_DEFAULT ((yys1->yyloc), yyrhsloc, yynrhs);
        }
    }
}

/** Resolve the ambiguity represented in state YYS in *YYSTACKP,
 *  perform the indicated actions, and set the semantic value of YYS.
 *  If result != yyok, the chain of semantic options in YYS has been
 *  cleared instead or it has been left unmodified except that
 *  redundant options may have been removed.  Regardless of whether
 *  result = yyok, YYS has been left with consistent data so that
 *  yydestroyGLRState can be invoked if necessary.  */
static YYRESULTTAG
yyresolveValue (yyGLRState* yys, yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  yySemanticOption* yyoptionList = yys->yysemantics.yyfirstVal;
  yySemanticOption* yybest = yyoptionList;
  yySemanticOption** yypp;
  yybool yymerge = yyfalse;
  YYSTYPE yysval;
  YYRESULTTAG yyflag;
  YYLTYPE *yylocp = &yys->yyloc;

  for (yypp = &yyoptionList->yynext; *yypp != YY_NULLPTR; )
    {
      yySemanticOption* yyp = *yypp;

      if (yyidenticalOptions (yybest, yyp))
        {
          yymergeOptionSets (yybest, yyp);
          *yypp = yyp->yynext;
        }
      else
        {
          switch (yypreference (yybest, yyp))
            {
            case 0:
              yyresolveLocations (yys, 1, yystackp, llist, context);
              return yyreportAmbiguity (yybest, yyp, yylocp, llist, context);
              break;
            case 1:
              yymerge = yytrue;
              break;
            case 2:
              break;
            case 3:
              yybest = yyp;
              yymerge = yyfalse;
              break;
            default:
              /* This cannot happen so it is not worth a YY_ASSERT (yyfalse),
                 but some compilers complain if the default case is
                 omitted.  */
              break;
            }
          yypp = &yyp->yynext;
        }
    }

  if (yymerge)
    {
      yySemanticOption* yyp;
      int yyprec = yydprec[yybest->yyrule];
      yyflag = yyresolveAction (yybest, yystackp, &yysval, yylocp, llist, context);
      if (yyflag == yyok)
        for (yyp = yybest->yynext; yyp != YY_NULLPTR; yyp = yyp->yynext)
          {
            if (yyprec == yydprec[yyp->yyrule])
              {
                YYSTYPE yysval_other;
                YYLTYPE yydummy;
                yyflag = yyresolveAction (yyp, yystackp, &yysval_other, &yydummy, llist, context);
                if (yyflag != yyok)
                  {
                    yydestruct ("Cleanup: discarding incompletely merged value for",
                                yy_accessing_symbol (yys->yylrState),
                                &yysval, yylocp, llist, context);
                    break;
                  }
                yyuserMerge (yymerger[yyp->yyrule], &yysval, &yysval_other);
              }
          }
    }
  else
    yyflag = yyresolveAction (yybest, yystackp, &yysval, yylocp, llist, context);

  if (yyflag == yyok)
    {
      yys->yyresolved = yytrue;
      yys->yysemantics.yysval = yysval;
    }
  else
    yys->yysemantics.yyfirstVal = YY_NULLPTR;
  return yyflag;
}

static YYRESULTTAG
yyresolveStack (yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (yystackp->yysplitPoint != YY_NULLPTR)
    {
      yyGLRState* yys;
      int yyn;

      for (yyn = 0, yys = yystackp->yytops.yystates[0];
           yys != yystackp->yysplitPoint;
           yys = yys->yypred, yyn += 1)
        continue;
      YYCHK (yyresolveStates (yystackp->yytops.yystates[0], yyn, yystackp
                             , llist, context));
    }
  return yyok;
}

static void
yycompressStack (yyGLRStack* yystackp)
{
  yyGLRState* yyp, *yyq, *yyr;

  if (yystackp->yytops.yysize != 1 || yystackp->yysplitPoint == YY_NULLPTR)
    return;

  for (yyp = yystackp->yytops.yystates[0], yyq = yyp->yypred, yyr = YY_NULLPTR;
       yyp != yystackp->yysplitPoint;
       yyr = yyp, yyp = yyq, yyq = yyp->yypred)
    yyp->yypred = yyr;

  yystackp->yyspaceLeft += yystackp->yynextFree - yystackp->yyitems;
  yystackp->yynextFree = YY_REINTERPRET_CAST (yyGLRStackItem*, yystackp->yysplitPoint) + 1;
  yystackp->yyspaceLeft -= yystackp->yynextFree - yystackp->yyitems;
  yystackp->yysplitPoint = YY_NULLPTR;
  yystackp->yylastDeleted = YY_NULLPTR;

  while (yyr != YY_NULLPTR)
    {
      yystackp->yynextFree->yystate = *yyr;
      yyr = yyr->yypred;
      yystackp->yynextFree->yystate.yypred = &yystackp->yynextFree[-1].yystate;
      yystackp->yytops.yystates[0] = &yystackp->yynextFree->yystate;
      yystackp->yynextFree += 1;
      yystackp->yyspaceLeft -= 1;
    }
}

static YYRESULTTAG
yyprocessOneStack (yyGLRStack* yystackp, YYPTRDIFF_T yyk,
                   YYPTRDIFF_T yyposn, YYLTYPE *yylocp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  while (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
    {
      yy_state_t yystate = yystackp->yytops.yystates[yyk]->yylrState;
      YY_DPRINTF ((stderr, "Stack %ld Entering state %d\n",
                   YY_CAST (long, yyk), yystate));

      YY_ASSERT (yystate != YYFINAL);

      if (yyisDefaultedState (yystate))
        {
          YYRESULTTAG yyflag;
          yyRuleNum yyrule = yydefaultAction (yystate);
          if (yyrule == 0)
            {
              YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              return yyok;
            }
          yyflag = yyglrReduce (yystackp, yyk, yyrule, yyimmediate[yyrule], llist, context);
          if (yyflag == yyerr)
            {
              YY_DPRINTF ((stderr,
                           "Stack %ld dies "
                           "(predicate failure or explicit user error).\n",
                           YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              return yyok;
            }
          if (yyflag != yyok)
            return yyflag;
        }
      else
        {
          yysymbol_kind_t yytoken = yygetToken (&yychar, yystackp, llist, context);
          const short* yyconflicts;
          const int yyaction = yygetLRActions (yystate, yytoken, &yyconflicts);
          yystackp->yytops.yylookaheadNeeds[yyk] = yytrue;

          for (/* nothing */; *yyconflicts; yyconflicts += 1)
            {
              YYRESULTTAG yyflag;
              YYPTRDIFF_T yynewStack = yysplitStack (yystackp, yyk);
              YY_DPRINTF ((stderr, "Splitting off stack %ld from %ld.\n",
                           YY_CAST (long, yynewStack), YY_CAST (long, yyk)));
              yyflag = yyglrReduce (yystackp, yynewStack,
                                    *yyconflicts,
                                    yyimmediate[*yyconflicts], llist, context);
              if (yyflag == yyok)
                YYCHK (yyprocessOneStack (yystackp, yynewStack,
                                          yyposn, yylocp, llist, context));
              else if (yyflag == yyerr)
                {
                  YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yynewStack)));
                  yymarkStackDeleted (yystackp, yynewStack);
                }
              else
                return yyflag;
            }

          if (yyisShiftAction (yyaction))
            break;
          else if (yyisErrorAction (yyaction))
            {
              YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              break;
            }
          else
            {
              YYRESULTTAG yyflag = yyglrReduce (yystackp, yyk, -yyaction,
                                                yyimmediate[-yyaction], llist, context);
              if (yyflag == yyerr)
                {
                  YY_DPRINTF ((stderr,
                               "Stack %ld dies "
                               "(predicate failure or explicit user error).\n",
                               YY_CAST (long, yyk)));
                  yymarkStackDeleted (yystackp, yyk);
                  break;
                }
              else if (yyflag != yyok)
                return yyflag;
            }
        }
    }
  return yyok;
}

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYSTACKP, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  */
static int
yypcontext_expected_tokens (const yyGLRStack* yystackp,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[yystackp->yytops.yystates[0]->yylrState];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}

static int
yy_syntax_error_arguments (const yyGLRStack* yystackp,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  yysymbol_kind_t yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.b4_lac_if([
       In the first two cases, it might appear that the current syntax
       error should have been detected in the previous state when yy_lac
       was invoked.  However, at that time, there might have been a
       different syntax error that discarded a different initial context
       during error recovery, leaving behind the current lookahead.], [
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.])
  */
  if (yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yystackp,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}



static void
yyreportSyntaxError (yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (yystackp->yyerrState != 0)
    return;
  {
  yybool yysize_overflow = yyfalse;
  char* yymsg = YY_NULLPTR;
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount
    = yy_syntax_error_arguments (yystackp, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    yyMemoryExhausted (yystackp);

  switch (yycount)
    {
#define YYCASE_(N, S)                   \
      case N:                           \
        yyformat = S;                   \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysz
          = yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (YYSIZE_MAXIMUM - yysize < yysz)
          yysize_overflow = yytrue;
        else
          yysize += yysz;
      }
  }

  if (!yysize_overflow)
    yymsg = YY_CAST (char *, YYMALLOC (YY_CAST (YYSIZE_T, yysize)));

  if (yymsg)
    {
      char *yyp = yymsg;
      int yyi = 0;
      while ((*yyp = *yyformat))
        {
          if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
            {
              yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
              yyformat += 2;
            }
          else
            {
              ++yyp;
              ++yyformat;
            }
        }
      yyerror (&yylloc, llist, context, yymsg);
      YYFREE (yymsg);
    }
  else
    {
      yyerror (&yylloc, llist, context, YY_("syntax error"));
      yyMemoryExhausted (yystackp);
    }
  }
  yynerrs += 1;
}

/* Recover from a syntax error on *YYSTACKP, assuming that *YYSTACKP->YYTOKENP,
   yylval, and yylloc are the syntactic category, semantic value, and location
   of the lookahead.  */
static void
yyrecoverSyntaxError (yyGLRStack* yystackp, std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  if (yystackp->yyerrState == 3)
    /* We just shifted the error token and (perhaps) took some
       reductions.  Skip tokens until we can proceed.  */
    while (yytrue)
      {
        yysymbol_kind_t yytoken;
        int yyj;
        if (yychar == YYEOF)
          yyFail (yystackp, &yylloc, llist, context, YY_NULLPTR);
        if (yychar != YYEMPTY)
          {
            /* We throw away the lookahead, but the error range
               of the shifted error token must take it into account.  */
            yyGLRState *yys = yystackp->yytops.yystates[0];
            yyGLRStackItem yyerror_range[3];
            yyerror_range[1].yystate.yyloc = yys->yyloc;
            yyerror_range[2].yystate.yyloc = yylloc;
            YYLLOC_DEFAULT ((yys->yyloc), yyerror_range, 2);
            yytoken = YYTRANSLATE (yychar);
            yydestruct ("Error: discarding",
                        yytoken, &yylval, &yylloc, llist, context);
            yychar = YYEMPTY;
          }
        yytoken = yygetToken (&yychar, yystackp, llist, context);
        yyj = yypact[yystackp->yytops.yystates[0]->yylrState];
        if (yypact_value_is_default (yyj))
          return;
        yyj += yytoken;
        if (yyj < 0 || YYLAST < yyj || yycheck[yyj] != yytoken)
          {
            if (yydefact[yystackp->yytops.yystates[0]->yylrState] != 0)
              return;
          }
        else if (! yytable_value_is_error (yytable[yyj]))
          return;
      }

  /* Reduce to one stack.  */
  {
    YYPTRDIFF_T yyk;
    for (yyk = 0; yyk < yystackp->yytops.yysize; yyk += 1)
      if (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
        break;
    if (yyk >= yystackp->yytops.yysize)
      yyFail (yystackp, &yylloc, llist, context, YY_NULLPTR);
    for (yyk += 1; yyk < yystackp->yytops.yysize; yyk += 1)
      yymarkStackDeleted (yystackp, yyk);
    yyremoveDeletes (yystackp);
    yycompressStack (yystackp);
  }

  /* Pop stack until we find a state that shifts the error token.  */
  yystackp->yyerrState = 3;
  while (yystackp->yytops.yystates[0] != YY_NULLPTR)
    {
      yyGLRState *yys = yystackp->yytops.yystates[0];
      int yyj = yypact[yys->yylrState];
      if (! yypact_value_is_default (yyj))
        {
          yyj += YYSYMBOL_YYerror;
          if (0 <= yyj && yyj <= YYLAST && yycheck[yyj] == YYSYMBOL_YYerror
              && yyisShiftAction (yytable[yyj]))
            {
              /* Shift the error token.  */
              int yyaction = yytable[yyj];
              /* First adjust its location.*/
              YYLTYPE yyerrloc;
              yystackp->yyerror_range[2].yystate.yyloc = yylloc;
              YYLLOC_DEFAULT (yyerrloc, (yystackp->yyerror_range), 2);
              YY_SYMBOL_PRINT ("Shifting", yy_accessing_symbol (yyaction),
                               &yylval, &yyerrloc);
              yyglrShift (yystackp, 0, yyaction,
                          yys->yyposn, &yylval, &yyerrloc);
              yys = yystackp->yytops.yystates[0];
              break;
            }
        }
      yystackp->yyerror_range[1].yystate.yyloc = yys->yyloc;
      if (yys->yypred != YY_NULLPTR)
        yydestroyGLRState ("Error: popping", yys, llist, context);
      yystackp->yytops.yystates[0] = yys->yypred;
      yystackp->yynextFree -= 1;
      yystackp->yyspaceLeft += 1;
    }
  if (yystackp->yytops.yystates[0] == YY_NULLPTR)
    yyFail (yystackp, &yylloc, llist, context, YY_NULLPTR);
}

#define YYCHK1(YYE)                                                          \
  do {                                                                       \
    switch (YYE) {                                                           \
    case yyok:                                                               \
      break;                                                                 \
    case yyabort:                                                            \
      goto yyabortlab;                                                       \
    case yyaccept:                                                           \
      goto yyacceptlab;                                                      \
    case yyerr:                                                              \
      goto yyuser_error;                                                     \
    default:                                                                 \
      goto yybuglab;                                                         \
    }                                                                        \
  } while (0)

/*----------.
| yyparse.  |
`----------*/

int
yyparse (std::vector<std::pair<std::unique_ptr<Expression>, EItemInfo> > *llist, ConfigCompiler *context)
{
  int yyresult;
  yyGLRStack yystack;
  yyGLRStack* const yystackp = &yystack;
  YYPTRDIFF_T yyposn;

  YY_DPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY;
  yylval = yyval_default;
  yylloc = yyloc_default;

  if (! yyinitGLRStack (yystackp, YYINITDEPTH))
    goto yyexhaustedlab;
  switch (YYSETJMP (yystack.yyexception_buffer))
    {
    case 0: break;
    case 1: goto yyabortlab;
    case 2: goto yyexhaustedlab;
    default: goto yybuglab;
    }
  yyglrShift (&yystack, 0, 0, 0, &yylval, &yylloc);
  yyposn = 0;

  while (yytrue)
    {
      /* For efficiency, we have two loops, the first of which is
         specialized to deterministic operation (single stack, no
         potential ambiguity).  */
      /* Standard mode. */
      while (yytrue)
        {
          yy_state_t yystate = yystack.yytops.yystates[0]->yylrState;
          YY_DPRINTF ((stderr, "Entering state %d\n", yystate));
          if (yystate == YYFINAL)
            goto yyacceptlab;
          if (yyisDefaultedState (yystate))
            {
              yyRuleNum yyrule = yydefaultAction (yystate);
              if (yyrule == 0)
                {
                  yystack.yyerror_range[1].yystate.yyloc = yylloc;
                  yyreportSyntaxError (&yystack, llist, context);
                  goto yyuser_error;
                }
              YYCHK1 (yyglrReduce (&yystack, 0, yyrule, yytrue, llist, context));
            }
          else
            {
              yysymbol_kind_t yytoken = yygetToken (&yychar, yystackp, llist, context);
              const short* yyconflicts;
              int yyaction = yygetLRActions (yystate, yytoken, &yyconflicts);
              if (*yyconflicts)
                /* Enter nondeterministic mode.  */
                break;
              if (yyisShiftAction (yyaction))
                {
                  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
                  yychar = YYEMPTY;
                  yyposn += 1;
                  yyglrShift (&yystack, 0, yyaction, yyposn, &yylval, &yylloc);
                  if (0 < yystack.yyerrState)
                    yystack.yyerrState -= 1;
                }
              else if (yyisErrorAction (yyaction))
                {
                  yystack.yyerror_range[1].yystate.yyloc = yylloc;
                  /* Issue an error message unless the scanner already
                     did. */
                  if (yychar != YYerror)
                    yyreportSyntaxError (&yystack, llist, context);
                  goto yyuser_error;
                }
              else
                YYCHK1 (yyglrReduce (&yystack, 0, -yyaction, yytrue, llist, context));
            }
        }

      /* Nondeterministic mode. */
      while (yytrue)
        {
          yysymbol_kind_t yytoken_to_shift;
          YYPTRDIFF_T yys;

          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            yystackp->yytops.yylookaheadNeeds[yys] = yychar != YYEMPTY;

          /* yyprocessOneStack returns one of three things:

              - An error flag.  If the caller is yyprocessOneStack, it
                immediately returns as well.  When the caller is finally
                yyparse, it jumps to an error label via YYCHK1.

              - yyok, but yyprocessOneStack has invoked yymarkStackDeleted
                (&yystack, yys), which sets the top state of yys to NULL.  Thus,
                yyparse's following invocation of yyremoveDeletes will remove
                the stack.

              - yyok, when ready to shift a token.

             Except in the first case, yyparse will invoke yyremoveDeletes and
             then shift the next token onto all remaining stacks.  This
             synchronization of the shift (that is, after all preceding
             reductions on all stacks) helps prevent double destructor calls
             on yylval in the event of memory exhaustion.  */

          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            YYCHK1 (yyprocessOneStack (&yystack, yys, yyposn, &yylloc, llist, context));
          yyremoveDeletes (&yystack);
          if (yystack.yytops.yysize == 0)
            {
              yyundeleteLastStack (&yystack);
              if (yystack.yytops.yysize == 0)
                yyFail (&yystack, &yylloc, llist, context, YY_("syntax error"));
              YYCHK1 (yyresolveStack (&yystack, llist, context));
              YY_DPRINTF ((stderr, "Returning to deterministic operation.\n"));
              yystack.yyerror_range[1].yystate.yyloc = yylloc;
              yyreportSyntaxError (&yystack, llist, context);
              goto yyuser_error;
            }

          /* If any yyglrShift call fails, it will fail after shifting.  Thus,
             a copy of yylval will already be on stack 0 in the event of a
             failure in the following loop.  Thus, yychar is set to YYEMPTY
             before the loop to make sure the user destructor for yylval isn't
             called twice.  */
          yytoken_to_shift = YYTRANSLATE (yychar);
          yychar = YYEMPTY;
          yyposn += 1;
          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            {
              yy_state_t yystate = yystack.yytops.yystates[yys]->yylrState;
              const short* yyconflicts;
              int yyaction = yygetLRActions (yystate, yytoken_to_shift,
                              &yyconflicts);
              /* Note that yyconflicts were handled by yyprocessOneStack.  */
              YY_DPRINTF ((stderr, "On stack %ld, ", YY_CAST (long, yys)));
              YY_SYMBOL_PRINT ("shifting", yytoken_to_shift, &yylval, &yylloc);
              yyglrShift (&yystack, yys, yyaction, yyposn,
                          &yylval, &yylloc);
              YY_DPRINTF ((stderr, "Stack %ld now in state #%d\n",
                           YY_CAST (long, yys),
                           yystack.yytops.yystates[yys]->yylrState));
            }

          if (yystack.yytops.yysize == 1)
            {
              YYCHK1 (yyresolveStack (&yystack, llist, context));
              YY_DPRINTF ((stderr, "Returning to deterministic operation.\n"));
              yycompressStack (&yystack);
              break;
            }
        }
      continue;
    yyuser_error:
      yyrecoverSyntaxError (&yystack, llist, context);
      yyposn = yystack.yytops.yystates[0]->yyposn;
    }

 yyacceptlab:
  yyresult = 0;
  goto yyreturn;

 yybuglab:
  YY_ASSERT (yyfalse);
  goto yyabortlab;

 yyabortlab:
  yyresult = 1;
  goto yyreturn;

 yyexhaustedlab:
  yyerror (&yylloc, llist, context, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;

 yyreturn:
  if (yychar != YYEMPTY)
    yydestruct ("Cleanup: discarding lookahead",
                YYTRANSLATE (yychar), &yylval, &yylloc, llist, context);

  /* If the stack is well-formed, pop the stack until it is empty,
     destroying its entries as we go.  But free the stack regardless
     of whether it is well-formed.  */
  if (yystack.yyitems)
    {
      yyGLRState** yystates = yystack.yytops.yystates;
      if (yystates)
        {
          YYPTRDIFF_T yysize = yystack.yytops.yysize;
          YYPTRDIFF_T yyk;
          for (yyk = 0; yyk < yysize; yyk += 1)
            if (yystates[yyk])
              {
                while (yystates[yyk])
                  {
                    yyGLRState *yys = yystates[yyk];
                    yystack.yyerror_range[1].yystate.yyloc = yys->yyloc;
                    if (yys->yypred != YY_NULLPTR)
                      yydestroyGLRState ("Cleanup: popping", yys, llist, context);
                    yystates[yyk] = yys->yypred;
                    yystack.yynextFree -= 1;
                    yystack.yyspaceLeft += 1;
                  }
                break;
              }
        }
      yyfreeGLRStack (&yystack);
    }

  return yyresult;
}

/* DEBUGGING ONLY */
#if YYDEBUG
static void
yy_yypstack (yyGLRState* yys)
{
  if (yys->yypred)
    {
      yy_yypstack (yys->yypred);
      YY_FPRINTF ((stderr, " -> "));
    }
  YY_FPRINTF ((stderr, "%d@%ld", yys->yylrState, YY_CAST (long, yys->yyposn)));
}

static void
yypstates (yyGLRState* yyst)
{
  if (yyst == YY_NULLPTR)
    YY_FPRINTF ((stderr, "<null>"));
  else
    yy_yypstack (yyst);
  YY_FPRINTF ((stderr, "\n"));
}

static void
yypstack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  yypstates (yystackp->yytops.yystates[yyk]);
}

static void
yypdumpstack (yyGLRStack* yystackp)
{
#define YYINDEX(YYX)                                                    \
  YY_CAST (long,                                                        \
           ((YYX)                                                       \
            ? YY_REINTERPRET_CAST (yyGLRStackItem*, (YYX)) - yystackp->yyitems \
            : -1))

  yyGLRStackItem* yyp;
  for (yyp = yystackp->yyitems; yyp < yystackp->yynextFree; yyp += 1)
    {
      YY_FPRINTF ((stderr, "%3ld. ",
                   YY_CAST (long, yyp - yystackp->yyitems)));
      if (*YY_REINTERPRET_CAST (yybool *, yyp))
        {
          YY_ASSERT (yyp->yystate.yyisState);
          YY_ASSERT (yyp->yyoption.yyisState);
          YY_FPRINTF ((stderr, "Res: %d, LR State: %d, posn: %ld, pred: %ld",
                       yyp->yystate.yyresolved, yyp->yystate.yylrState,
                       YY_CAST (long, yyp->yystate.yyposn),
                       YYINDEX (yyp->yystate.yypred)));
          if (! yyp->yystate.yyresolved)
            YY_FPRINTF ((stderr, ", firstVal: %ld",
                         YYINDEX (yyp->yystate.yysemantics.yyfirstVal)));
        }
      else
        {
          YY_ASSERT (!yyp->yystate.yyisState);
          YY_ASSERT (!yyp->yyoption.yyisState);
          YY_FPRINTF ((stderr, "Option. rule: %d, state: %ld, next: %ld",
                       yyp->yyoption.yyrule - 1,
                       YYINDEX (yyp->yyoption.yystate),
                       YYINDEX (yyp->yyoption.yynext)));
        }
      YY_FPRINTF ((stderr, "\n"));
    }

  YY_FPRINTF ((stderr, "Tops:"));
  {
    YYPTRDIFF_T yyi;
    for (yyi = 0; yyi < yystackp->yytops.yysize; yyi += 1)
      YY_FPRINTF ((stderr, "%ld: %ld; ", YY_CAST (long, yyi),
                   YYINDEX (yystackp->yytops.yystates[yyi])));
    YY_FPRINTF ((stderr, "\n"));
  }
#undef YYINDEX
}
#endif

#undef yylval
#undef yychar
#undef yynerrs
#undef yylloc




#line 1243 "config_parser.yy"

