/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class Clazz
implements Serializable {
    private final String name;
    private final Set<String> signatures;
    private final String superClass;
    private final String[] superInterfaces;
    private static final long serialVersionUID = 1L;

    public Clazz(String string, Set<String> set, String string2, String[] stringArray) {
        this.name = string;
        this.signatures = set;
        this.superClass = string2;
        this.superInterfaces = (String[])stringArray.clone();
    }

    public Clazz(Clazz clazz, Clazz clazz2) {
        if (!clazz.name.equals(clazz2.name)) {
            throw new ClassCastException("Cannot merge different classes: " + clazz.name + " and " + clazz2.name);
        }
        if (!clazz.superClass.equals(clazz2.superClass)) {
            throw new ClassCastException("Cannot merger class " + clazz2.name + " as it has changed superclass:");
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (clazz.superInterfaces != null) {
            hashSet.addAll(Arrays.asList(clazz.superInterfaces));
        }
        if (clazz2.superInterfaces != null) {
            hashSet.addAll(Arrays.asList(clazz2.superInterfaces));
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(clazz.signatures);
        hashSet2.addAll(clazz2.signatures);
        this.name = clazz.getName();
        this.signatures = hashSet2;
        this.superClass = clazz.superClass;
        this.superInterfaces = hashSet.toArray(new String[hashSet.size()]);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getSignatures() {
        return this.signatures;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getSuperInterfaces() {
        return this.superInterfaces;
    }
}

