/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.util.regex.Pattern;

public final class RegexUtils {
    public static final String REGEX_QUOTE_END = "\\E";
    public static final String REGEX_QUOTE_START = "\\Q";
    public static final String REGEX_QUOTE_END_ESCAPED = "\\E\\\\E\\Q";

    private RegexUtils() {
        throw new IllegalAccessError("Utility classes should never be instantiated");
    }

    public static String quote(String string) {
        int n = string.indexOf(REGEX_QUOTE_END);
        if (n == -1) {
            return REGEX_QUOTE_START + string + REGEX_QUOTE_END;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        stringBuffer.append(REGEX_QUOTE_START);
        int n2 = 0;
        do {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(REGEX_QUOTE_END_ESCAPED);
        } while ((n = string.indexOf(REGEX_QUOTE_END, n2 = n + REGEX_QUOTE_END.length())) != -1);
        stringBuffer.append(string.substring(n2, string.length()));
        stringBuffer.append(REGEX_QUOTE_END);
        return stringBuffer.toString();
    }

    public static String convertWildcardsToRegex(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            int n3 = string.indexOf(63, n);
            int n4 = string.indexOf(42, n);
            if (n3 == -1 && n4 == -1) {
                stringBuffer.append(RegexUtils.quote(string.substring(n)));
                break;
            }
            int n5 = n3 == -1 ? n4 : (n4 == -1 ? n3 : Math.min(n3, n4));
            if (n < n5) {
                stringBuffer.append(RegexUtils.quote(string.substring(n, n5)));
            }
            if ((c = string.charAt(n5)) == '?') {
                stringBuffer.append('.');
            } else {
                stringBuffer.append(".*");
            }
            n = n5 + 1;
        }
        if (!bl) {
            stringBuffer.append(".*");
        }
        return stringBuffer.toString();
    }

    public static Pattern compileWildcard(String string) {
        return Pattern.compile(RegexUtils.convertWildcardsToRegex(string, true));
    }
}

