/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;

public class DefaultComponentManager
implements ComponentManager {
    private final HashMap m_components = new HashMap();
    private final ComponentManager m_parent;
    private boolean m_readOnly;

    public DefaultComponentManager() {
        this(null);
    }

    public DefaultComponentManager(ComponentManager componentManager) {
        this.m_parent = componentManager;
    }

    public Component lookup(String string) throws ComponentException {
        Component component = (Component)this.m_components.get(string);
        if (null != component) {
            return component;
        }
        if (null != this.m_parent) {
            return this.m_parent.lookup(string);
        }
        throw new ComponentException(string, "Unable to provide implementation.");
    }

    public boolean hasComponent(String string) {
        boolean bl = false;
        try {
            this.release(this.lookup(string));
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public void put(String string, Component component) {
        this.checkWriteable();
        this.m_components.put(string, component);
    }

    public void release(Component component) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.m_components.keySet().iterator();
        stringBuffer.append("Components:");
        while (iterator.hasNext()) {
            stringBuffer.append("[");
            stringBuffer.append(iterator.next());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected final ComponentManager getParent() {
        return this.m_parent;
    }

    protected final Map getComponentMap() {
        return this.m_components;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ComponentManager is read only and can not be modified");
        }
    }
}

