/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.logger;

import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public final class LogKit2AvalonLoggerAdapter
implements LogTarget {
    private final Logger m_logger;

    public static org.apache.log.Logger createLogger(Logger logger) {
        Hierarchy hierarchy = new Hierarchy();
        org.apache.log.Logger logger2 = hierarchy.getLoggerFor("");
        LogKit2AvalonLoggerAdapter logKit2AvalonLoggerAdapter = new LogKit2AvalonLoggerAdapter(logger);
        logger2.setLogTargets(new LogTarget[]{logKit2AvalonLoggerAdapter});
        if (logger.isDebugEnabled()) {
            logger2.setPriority(Priority.DEBUG);
        } else if (logger.isInfoEnabled()) {
            logger2.setPriority(Priority.INFO);
        } else if (logger.isWarnEnabled()) {
            logger2.setPriority(Priority.WARN);
        } else if (logger.isErrorEnabled()) {
            logger2.setPriority(Priority.ERROR);
        } else if (logger.isFatalErrorEnabled()) {
            logger2.setPriority(Priority.FATAL_ERROR);
        }
        return logger2;
    }

    public LogKit2AvalonLoggerAdapter(Logger logger) {
        if (null == logger) {
            throw new NullPointerException("logger");
        }
        this.m_logger = logger;
    }

    public void processEvent(LogEvent logEvent) {
        String string = logEvent.getMessage();
        Throwable throwable = logEvent.getThrowable();
        Priority priority = logEvent.getPriority();
        if (Priority.DEBUG == priority) {
            this.m_logger.debug(string, throwable);
        } else if (Priority.INFO == priority) {
            this.m_logger.info(string, throwable);
        } else if (Priority.WARN == priority) {
            this.m_logger.warn(string, throwable);
        } else if (Priority.ERROR == priority) {
            this.m_logger.error(string, throwable);
        } else {
            this.m_logger.fatalError(string, throwable);
        }
    }
}

