/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;

public class PrintCommandListener
implements ProtocolCommandListener {
    private final PrintWriter __writer;
    private final boolean __nologin;
    private final char __eolMarker;
    private final boolean __directionMarker;

    public PrintCommandListener(PrintStream printStream) {
        this(new PrintWriter(printStream));
    }

    public PrintCommandListener(PrintStream printStream, boolean bl) {
        this(new PrintWriter(printStream), bl);
    }

    public PrintCommandListener(PrintStream printStream, boolean bl, char c) {
        this(new PrintWriter(printStream), bl, c);
    }

    public PrintCommandListener(PrintStream printStream, boolean bl, char c, boolean bl2) {
        this(new PrintWriter(printStream), bl, c, bl2);
    }

    public PrintCommandListener(PrintWriter printWriter) {
        this(printWriter, false);
    }

    public PrintCommandListener(PrintWriter printWriter, boolean bl) {
        this(printWriter, bl, '\u0000');
    }

    public PrintCommandListener(PrintWriter printWriter, boolean bl, char c) {
        this(printWriter, bl, c, false);
    }

    public PrintCommandListener(PrintWriter printWriter, boolean bl, char c, boolean bl2) {
        this.__writer = printWriter;
        this.__nologin = bl;
        this.__eolMarker = c;
        this.__directionMarker = bl2;
    }

    @Override
    public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
        if (this.__directionMarker) {
            this.__writer.print("> ");
        }
        if (this.__nologin) {
            String string = protocolCommandEvent.getCommand();
            if ("PASS".equalsIgnoreCase(string) || "USER".equalsIgnoreCase(string)) {
                this.__writer.print(string);
                this.__writer.println(" *******");
            } else if ("LOGIN".equalsIgnoreCase(string)) {
                String string2 = protocolCommandEvent.getMessage();
                string2 = string2.substring(0, string2.indexOf("LOGIN") + "LOGIN".length());
                this.__writer.print(string2);
                this.__writer.println(" *******");
            } else {
                this.__writer.print(this.getPrintableString(protocolCommandEvent.getMessage()));
            }
        } else {
            this.__writer.print(this.getPrintableString(protocolCommandEvent.getMessage()));
        }
        this.__writer.flush();
    }

    private String getPrintableString(String string) {
        if (this.__eolMarker == '\u0000') {
            return string;
        }
        int n = string.indexOf("\r\n");
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append(this.__eolMarker);
            stringBuilder.append(string.substring(n));
            return stringBuilder.toString();
        }
        return string;
    }

    @Override
    public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
        if (this.__directionMarker) {
            this.__writer.print("< ");
        }
        this.__writer.print(protocolCommandEvent.getMessage());
        this.__writer.flush();
    }
}

