/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.Searcher;
import org.hamcrest.generator.qdox.directorywalker.DirectoryScanner;
import org.hamcrest.generator.qdox.directorywalker.FileVisitor;
import org.hamcrest.generator.qdox.directorywalker.SuffixFilter;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.DefaultDocletTagFactory;
import org.hamcrest.generator.qdox.model.DocletTagFactory;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaPackage;
import org.hamcrest.generator.qdox.model.JavaSource;
import org.hamcrest.generator.qdox.model.ModelBuilder;
import org.hamcrest.generator.qdox.parser.ParseException;
import org.hamcrest.generator.qdox.parser.impl.JFlexLexer;
import org.hamcrest.generator.qdox.parser.impl.Parser;
import org.hamcrest.generator.qdox.parser.structs.ClassDef;
import org.hamcrest.generator.qdox.parser.structs.FieldDef;
import org.hamcrest.generator.qdox.parser.structs.MethodDef;
import org.hamcrest.generator.qdox.parser.structs.PackageDef;
import org.hamcrest.generator.qdox.parser.structs.TypeDef;

public class JavaDocBuilder
implements Serializable {
    private final JavaClassContext context;
    private Set packages = new HashSet();
    private List sources = new ArrayList();
    private DocletTagFactory docletTagFactory;
    private String encoding = System.getProperty("file.encoding");
    private boolean debugLexer;
    private boolean debugParser;
    private ErrorHandler errorHandler = new DefaultErrorHandler();

    public JavaDocBuilder() {
        this(new DefaultDocletTagFactory());
    }

    public JavaDocBuilder(DocletTagFactory docletTagFactory) {
        this.docletTagFactory = docletTagFactory;
        ClassLibrary classLibrary = new ClassLibrary();
        classLibrary.addDefaultLoader();
        this.context = new JavaClassContext(this);
        this.context.setClassLibrary(classLibrary);
    }

    public JavaDocBuilder(ClassLibrary classLibrary) {
        this(new DefaultDocletTagFactory(), classLibrary);
    }

    public JavaDocBuilder(DocletTagFactory docletTagFactory, ClassLibrary classLibrary) {
        this.docletTagFactory = docletTagFactory;
        this.context = new JavaClassContext(this);
        this.context.setClassLibrary(classLibrary);
    }

    private void addClasses(JavaSource javaSource) {
        HashSet hashSet = new HashSet();
        this.addClassesRecursive(javaSource, hashSet);
        JavaClass[] javaClassArray = hashSet.toArray(new JavaClass[hashSet.size()]);
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            this.addClass(javaClass);
        }
    }

    private void addClass(JavaClass javaClass) {
        this.context.add(javaClass);
        javaClass.setJavaClassContext(this.context);
    }

    public JavaClass getClassByName(String string) {
        if (string == null) {
            return null;
        }
        return this.context.getClassByName(string);
    }

    protected JavaClass createSourceClass(String string) {
        File file = this.context.getClassLibrary().getSourceFile(string);
        if (file != null) {
            try {
                JavaSource javaSource = this.addSource(file);
                for (int i = 0; i < javaSource.getClasses().length; ++i) {
                    JavaClass javaClass = javaSource.getClasses()[i];
                    if (!string.equals(javaClass.getFullyQualifiedName())) continue;
                    return javaClass;
                }
                return javaSource.getNestedClassByName(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected JavaClass createUnknownClass(String string) {
        ModelBuilder modelBuilder = new ModelBuilder(this.context, this.docletTagFactory, new HashMap());
        ClassDef classDef = new ClassDef();
        classDef.name = string;
        modelBuilder.beginClass(classDef);
        modelBuilder.endClass();
        JavaSource javaSource = modelBuilder.getSource();
        JavaClass javaClass = javaSource.getClasses()[0];
        return javaClass;
    }

    protected JavaClass createBinaryClass(String string) {
        Class clazz = this.context.getClass(string);
        if (clazz == null) {
            return null;
        }
        try {
            Class<?> clazz2;
            ModelBuilder modelBuilder = new ModelBuilder(this.context, this.docletTagFactory, new HashMap());
            String string2 = this.getPackageName(string);
            modelBuilder.addPackage(new PackageDef(string2));
            ClassDef classDef = new ClassDef();
            classDef.name = this.getClassName(string);
            Class<?>[] classArray = clazz.getInterfaces();
            if (clazz.isInterface()) {
                classDef.type = "interface";
                for (int i = 0; i < classArray.length; ++i) {
                    clazz2 = classArray[i];
                    classDef.extendz.add(new TypeDef(clazz2.getName()));
                }
            } else {
                for (int i = 0; i < classArray.length; ++i) {
                    clazz2 = classArray[i];
                    classDef.implementz.add(new TypeDef(clazz2.getName()));
                }
                Class clazz3 = clazz.getSuperclass();
                if (clazz3 != null) {
                    classDef.extendz.add(new TypeDef(clazz3.getName()));
                }
            }
            this.addModifiers(classDef.modifiers, clazz.getModifiers());
            modelBuilder.beginClass(classDef);
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                this.addMethodOrConstructor(constructorArray[i], modelBuilder);
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                this.addMethodOrConstructor(methodArray[i], modelBuilder);
            }
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                this.addField(fieldArray[i], modelBuilder);
            }
            modelBuilder.endClass();
            JavaSource javaSource = modelBuilder.getSource();
            JavaClass javaClass = javaSource.getClasses()[0];
            return javaClass;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private void addModifiers(Set set, int n) {
        String string = Modifier.toString(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field, ModelBuilder modelBuilder) {
        FieldDef fieldDef = new FieldDef();
        Class<?> clazz = field.getType();
        fieldDef.name = field.getName();
        fieldDef.type = JavaDocBuilder.getTypeDef(clazz);
        fieldDef.dimensions = JavaDocBuilder.getDimension(clazz);
        this.addModifiers(fieldDef.modifiers, field.getModifiers());
        modelBuilder.addField(fieldDef);
    }

    private void addMethodOrConstructor(Member member, ModelBuilder modelBuilder) {
        Object object;
        int n;
        Class<?>[] classArray;
        Class<?>[] classArray2;
        MethodDef methodDef = new MethodDef();
        int n2 = member.getName().lastIndexOf(46);
        methodDef.name = member.getName().substring(n2 + 1);
        this.addModifiers(methodDef.modifiers, member.getModifiers());
        if (member instanceof Method) {
            methodDef.constructor = false;
            classArray2 = ((Method)member).getExceptionTypes();
            classArray = ((Method)member).getParameterTypes();
            Class<?> clazz = ((Method)member).getReturnType();
            methodDef.returnType = JavaDocBuilder.getTypeDef(clazz);
            methodDef.dimensions = JavaDocBuilder.getDimension(clazz);
        } else {
            methodDef.constructor = true;
            classArray2 = ((Constructor)member).getExceptionTypes();
            classArray = ((Constructor)member).getParameterTypes();
        }
        for (n = 0; n < classArray2.length; ++n) {
            object = classArray2[n];
            methodDef.exceptions.add(((Class)object).getName());
        }
        modelBuilder.addMethod(methodDef);
        for (n = 0; n < classArray.length; ++n) {
            object = new FieldDef();
            Class<?> clazz = classArray[n];
            ((FieldDef)object).name = "p" + n;
            ((FieldDef)object).type = JavaDocBuilder.getTypeDef(clazz);
            ((FieldDef)object).dimensions = JavaDocBuilder.getDimension(clazz);
            modelBuilder.addParameter((FieldDef)object);
        }
    }

    private static final int getDimension(Class clazz) {
        return clazz.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class clazz) {
        return clazz.getComponentType() != null ? clazz.getComponentType().getName() : clazz.getName();
    }

    private static TypeDef getTypeDef(Class clazz) {
        return new TypeDef(JavaDocBuilder.getTypeName(clazz));
    }

    private String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    private String getClassName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public JavaSource addSource(Reader reader) {
        return this.addSource(reader, "UNKNOWN SOURCE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSource addSource(Reader reader, String string) {
        ModelBuilder modelBuilder = new ModelBuilder(this.context, this.docletTagFactory, null);
        JFlexLexer jFlexLexer = new JFlexLexer(reader);
        Parser parser = new Parser(jFlexLexer, modelBuilder);
        parser.setDebugLexer(this.debugLexer);
        parser.setDebugParser(this.debugParser);
        try {
            parser.parse();
        }
        catch (ParseException parseException) {
            parseException.setSourceInfo(string);
            this.errorHandler.handle(parseException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        JavaSource javaSource = modelBuilder.getSource();
        this.sources.add(javaSource);
        this.addClasses(javaSource);
        JavaPackage javaPackage = this.context.getPackageByName(javaSource.getPackageName());
        if (!this.packages.contains(javaPackage)) {
            this.packages.add(javaPackage);
        }
        return javaSource;
    }

    public JavaSource addSource(File file) throws IOException, FileNotFoundException {
        return this.addSource(file.toURL());
    }

    public JavaSource addSource(URL uRL) throws IOException, FileNotFoundException {
        JavaSource javaSource = this.addSource(new InputStreamReader(uRL.openStream(), this.encoding), uRL.toExternalForm());
        javaSource.setURL(uRL);
        return javaSource;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public JavaSource[] getSources() {
        return this.sources.toArray(new JavaSource[this.sources.size()]);
    }

    public JavaClass[] getClasses() {
        HashSet hashSet = new HashSet();
        JavaSource[] javaSourceArray = this.getSources();
        for (int i = 0; i < javaSourceArray.length; ++i) {
            JavaSource javaSource = javaSourceArray[i];
            this.addClassesRecursive(javaSource, hashSet);
        }
        JavaClass[] javaClassArray = hashSet.toArray(new JavaClass[hashSet.size()]);
        return javaClassArray;
    }

    public JavaPackage[] getPackages() {
        return this.packages.toArray(new JavaPackage[this.packages.size()]);
    }

    private void addClassesRecursive(JavaSource javaSource, Set set) {
        JavaClass[] javaClassArray = javaSource.getClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            this.addClassesRecursive(javaClass, set);
        }
    }

    private void addClassesRecursive(JavaClass javaClass, Set set) {
        set.add(javaClass);
        JavaClass[] javaClassArray = javaClass.getNestedClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass2 = javaClassArray[i];
            this.addClassesRecursive(javaClass2, set);
        }
    }

    public void addSourceTree(File file) {
        FileVisitor fileVisitor = new FileVisitor(){

            @Override
            public void visitFile(File file) {
                throw new RuntimeException("Cannot read file : " + file.getName());
            }
        };
        this.addSourceTree(file, fileVisitor);
    }

    public void addSourceTree(File file, final FileVisitor fileVisitor) {
        DirectoryScanner directoryScanner = new DirectoryScanner(file);
        directoryScanner.addFilter(new SuffixFilter(".java"));
        directoryScanner.scan(new FileVisitor(){

            @Override
            public void visitFile(File file) {
                try {
                    JavaDocBuilder.this.addSource(file);
                }
                catch (IOException iOException) {
                    fileVisitor.visitFile(file);
                }
            }
        });
    }

    public List search(Searcher searcher) {
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        for (String string : this.context.getClassLibrary().all()) {
            JavaClass javaClass = this.getClassByName(string);
            if (!searcher.eval(javaClass)) continue;
            linkedList.add(javaClass);
        }
        return linkedList;
    }

    public ClassLibrary getClassLibrary() {
        return this.context.getClassLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(this);
        }
        finally {
            objectOutputStream.close();
            fileOutputStream.close();
        }
    }

    public static JavaDocBuilder load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        JavaDocBuilder javaDocBuilder = null;
        try {
            javaDocBuilder = (JavaDocBuilder)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Couldn't load class : " + classNotFoundException.getMessage());
        }
        finally {
            objectInputStream.close();
            fileInputStream.close();
        }
        return javaDocBuilder;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDebugLexer(boolean bl) {
        this.debugLexer = bl;
    }

    public void setDebugParser(boolean bl) {
        this.debugParser = bl;
    }

    public JavaPackage getPackageByName(String string) {
        if (string != null) {
            for (JavaPackage javaPackage : this.packages) {
                if (!string.equals(javaPackage.getName())) continue;
                return javaPackage;
            }
        }
        return null;
    }

    public static class DefaultErrorHandler
    implements ErrorHandler,
    Serializable {
        @Override
        public void handle(ParseException parseException) {
            throw parseException;
        }
    }

    public static interface ErrorHandler {
        public void handle(ParseException var1);
    }
}

