/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.io.Serializable;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaMethod;
import org.hamcrest.generator.qdox.model.Type;

public class JavaParameter
extends AbstractBaseJavaEntity
implements Serializable {
    public static final JavaParameter[] EMPTY_ARRAY = new JavaParameter[0];
    private String name;
    private Type type;
    private JavaMethod parentMethod;
    private boolean varArgs;

    public JavaParameter(Type type, String string) {
        this(type, string, false);
    }

    public JavaParameter(Type type, String string, boolean bl) {
        this.name = string;
        this.type = type;
        this.varArgs = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        JavaParameter javaParameter = (JavaParameter)object;
        return this.getType().equals(javaParameter.getType());
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public JavaMethod getParentMethod() {
        return this.parentMethod;
    }

    public void setParentMethod(JavaMethod javaMethod) {
        this.parentMethod = javaMethod;
    }

    @Override
    public JavaClass getParentClass() {
        return this.getParentMethod().getParentClass();
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public String toString() {
        return this.getResolvedValue() + " " + this.name;
    }

    public String getResolvedValue() {
        return this.type.getResolvedValue(this.getParentMethod().getTypeParameters());
    }

    public String getResolvedGenericValue() {
        return this.type.getResolvedGenericValue(this.getParentMethod().getTypeParameters());
    }
}

