/*
 * Decompiled with CFR 0.152.
 */
package jline;

import jline.JLineTestCase;

public class TestEditLine
extends JLineTestCase {
    public TestEditLine(String test) {
        super(test);
    }

    public void testDeletePreviousWord() throws Exception {
        JLineTestCase.Buffer b = new JLineTestCase.Buffer("This is a test");
        b = b.op((short)-16);
        this.assertBuffer("This is a ", b);
        b = b.op((short)-16);
        this.assertBuffer("This is ", b);
        b = b.op((short)-16);
        this.assertBuffer("This ", b);
        b = b.op((short)-16);
        this.assertBuffer("", b);
        b = b.op((short)-16);
        this.assertBuffer("", b);
        b = b.op((short)-16);
        this.assertBuffer("", b);
    }

    public void testMoveToEnd() throws Exception {
        JLineTestCase.Buffer b = new JLineTestCase.Buffer("This is a test");
        this.assertBuffer("This is a XtestX", new JLineTestCase.Buffer("This is a test").op((short)-43).append(88).op((short)-3).append(88));
        this.assertBuffer("This is Xa testX", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).append(88).op((short)-3).append(88));
        this.assertBuffer("This Xis a testX", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).op((short)-43).append(88).op((short)-3).append(88));
    }

    public void testPreviousWord() throws Exception {
        this.assertBuffer("This is a Xtest", new JLineTestCase.Buffer("This is a test").op((short)-43).append(88));
        this.assertBuffer("This is Xa test", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).append(88));
        this.assertBuffer("This Xis a test", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).op((short)-43).append(88));
        this.assertBuffer("XThis is a test", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).op((short)-43).op((short)-43).append(88));
        this.assertBuffer("XThis is a test", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).op((short)-43).op((short)-43).op((short)-43).append(88));
        this.assertBuffer("XThis is a test", new JLineTestCase.Buffer("This is a test").op((short)-43).op((short)-43).op((short)-43).op((short)-43).op((short)-43).op((short)-43).append(88));
    }

    public void testLineStart() throws Exception {
        this.assertBuffer("XThis is a test", new JLineTestCase.Buffer("This is a test").ctrlA().append(88));
        this.assertBuffer("TXhis is a test", new JLineTestCase.Buffer("This is a test").ctrlA().right().append(88));
    }

    public void testClearLine() throws Exception {
        this.assertBuffer("", new JLineTestCase.Buffer("This is a test").ctrlU());
        this.assertBuffer("t", new JLineTestCase.Buffer("This is a test").left().ctrlU());
        this.assertBuffer("st", new JLineTestCase.Buffer("This is a test").left().left().ctrlU());
    }

    public void testRight() throws Exception {
        JLineTestCase.Buffer b = new JLineTestCase.Buffer("This is a test");
        b = b.left().right().back();
        this.assertBuffer("This is a tes", b);
        b = b.left().left().left().right().left().back();
        this.assertBuffer("This is ates", b);
        b.append(88);
        this.assertBuffer("This is aXtes", b);
    }

    public void testLeft() throws Exception {
        JLineTestCase.Buffer b = new JLineTestCase.Buffer("This is a test");
        b = b.left().left().left();
        b = b.back();
        this.assertBuffer("This is a est", b);
        b = b.back();
        this.assertBuffer("This is aest", b);
        b = b.back();
        this.assertBuffer("This is est", b);
        b = b.back();
        this.assertBuffer("This isest", b);
        b = b.back();
        this.assertBuffer("This iest", b);
        b = b.back();
        this.assertBuffer("This est", b);
        b = b.back();
        this.assertBuffer("Thisest", b);
        b = b.back();
        this.assertBuffer("Thiest", b);
        b = b.back();
        this.assertBuffer("Thest", b);
        b = b.back();
        this.assertBuffer("Test", b);
        b = b.back();
        this.assertBuffer("est", b);
        b = b.back();
        this.assertBuffer("est", b);
        b = b.back();
        this.assertBuffer("est", b);
        b = b.back();
        this.assertBuffer("est", b);
        b = b.back();
        this.assertBuffer("est", b);
    }

    public void testBackspace() throws Exception {
        JLineTestCase.Buffer b = new JLineTestCase.Buffer("This is a test");
        b = b.back();
        this.assertBuffer("This is a tes", b);
        b = b.back();
        this.assertBuffer("This is a te", b);
        b = b.back();
        this.assertBuffer("This is a t", b);
        b = b.back();
        this.assertBuffer("This is a ", b);
        b = b.back();
        this.assertBuffer("This is a", b);
        b = b.back();
        this.assertBuffer("This is ", b);
        b = b.back();
        this.assertBuffer("This is", b);
        b = b.back();
        this.assertBuffer("This i", b);
        b = b.back();
        this.assertBuffer("This ", b);
        b = b.back();
        this.assertBuffer("This", b);
        b = b.back();
        this.assertBuffer("Thi", b);
        b = b.back();
        this.assertBuffer("Th", b);
        b = b.back();
        this.assertBuffer("T", b);
        b = b.back();
        this.assertBuffer("", b);
        b = b.back();
        this.assertBuffer("", b);
        b = b.back();
        this.assertBuffer("", b);
        b = b.back();
        this.assertBuffer("", b);
        b = b.back();
        this.assertBuffer("", b);
    }

    public void testBuffer() throws Exception {
        this.assertBuffer("This is a test", new JLineTestCase.Buffer("This is a test"));
    }
}

