/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.util.ArrayList;

public abstract class ConnectorFactory {
    protected String connectors = "pageant,ssh-agent";
    protected String usocketFactories = "nc,jna";

    public void setPreferredConnectors(String string) {
        this.connectors = string;
    }

    public String getPreferredConnectors() {
        return this.connectors;
    }

    public void setPreferredUSocketFactories(String string) {
        this.usocketFactories = string;
    }

    public String getPreferredUSocketFactories() {
        return this.usocketFactories;
    }

    public Connector createConnector() throws AgentProxyException {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.connectors.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("pageant")) {
                if (!PageantConnector.isConnectorAvailable()) continue;
                try {
                    return new PageantConnector();
                }
                catch (AgentProxyException agentProxyException) {
                    arrayList.add("pageant");
                    continue;
                }
            }
            if (!stringArray[i].trim().equals("ssh-agent") || !SSHAgentConnector.isConnectorAvailable()) continue;
            object = this.usocketFactories.split(",");
            for (n = 0; n < ((String[])object).length; ++n) {
                NCUSocketFactory nCUSocketFactory;
                if (object[n].trim().equals("nc")) {
                    try {
                        nCUSocketFactory = new NCUSocketFactory();
                        return new SSHAgentConnector((USocketFactory)nCUSocketFactory);
                    }
                    catch (AgentProxyException agentProxyException) {
                        arrayList.add("ssh-agent:nc");
                        continue;
                    }
                }
                if (!object[n].trim().equals("jna")) continue;
                try {
                    nCUSocketFactory = new JNAUSocketFactory();
                    return new SSHAgentConnector((USocketFactory)nCUSocketFactory);
                }
                catch (AgentProxyException agentProxyException) {
                    arrayList.add("ssh-agent:jna");
                }
            }
        }
        String string = "connector is not available: ";
        object = "";
        for (n = 0; n < arrayList.size(); ++n) {
            string = string + (String)object + (String)arrayList.get(n);
            object = ",";
        }
        throw new AgentProxyException(string);
    }

    public static ConnectorFactory getDefault() {
        return new Default();
    }

    static class Default
    extends ConnectorFactory {
        Default() {
            String string = System.getProperty("os.name");
            if (string != null && !string.startsWith("Windows")) {
                this.setPreferredConnectors("ssh-agent");
            }
        }
    }
}

