/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl.imageio;

import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.imageio.ImageIOUtil;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderImageIO
extends AbstractImagePreloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException, ImageException {
        Object object;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        Throwable throwable = null;
        IIOMetadata iIOMetadata = null;
        ImageSize imageSize = null;
        String string2 = null;
        while (iterator.hasNext()) {
            imageInputStream.mark();
            object = iterator.next();
            try {
                ((ImageReader)object).setInput(ImageUtil.ignoreFlushing(imageInputStream), true, false);
                iIOMetadata = ((ImageReader)object).getImageMetadata(0);
                imageSize = new ImageSize();
                imageSize.setSizeInPixels(((ImageReader)object).getWidth(0), ((ImageReader)object).getHeight(0));
                string2 = ((ImageReader)object).getOriginatingProvider().getMIMETypes()[0];
                break;
            }
            catch (IOException iOException) {
                if (throwable != null) continue;
                throwable = iOException;
            }
            finally {
                ((ImageReader)object).dispose();
                imageInputStream.reset();
            }
        }
        if (iIOMetadata == null) {
            if (throwable == null) {
                throw new ImageException("Could not extract image metadata");
            }
            throw new ImageException("I/O error while extracting image metadata" + (throwable.getMessage() != null ? ": " + throwable.getMessage() : ""), throwable);
        }
        imageSize.setResolution(imageContext.getSourceResolution());
        ImageIOUtil.extractResolution(iIOMetadata, imageSize);
        if (imageSize.getWidthPx() <= 0 || imageSize.getHeightPx() <= 0) {
            return null;
        }
        if (imageSize.getWidthMpt() == 0) {
            imageSize.calcSizeFromPixels();
        }
        object = new ImageInfo(string, string2);
        ((ImageInfo)object).getCustomObjects().put(ImageIOUtil.IMAGEIO_METADATA, iIOMetadata);
        ((ImageInfo)object).setSize(imageSize);
        return object;
    }

    @Override
    public int getPriority() {
        return 2000;
    }
}

