/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Arrays;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class ColorWithAlternatives
extends Color {
    private static final long serialVersionUID = -6125884937776779150L;
    private Color[] alternativeColors;

    public ColorWithAlternatives(float f, float f2, float f3, float f4, Color[] colorArray) {
        super(f, f2, f3, f4);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(float f, float f2, float f3, Color[] colorArray) {
        super(f, f2, f3);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n, boolean bl, Color[] colorArray) {
        super(n, bl);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n, int n2, int n3, int n4, Color[] colorArray) {
        super(n, n2, n3, n4);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n, int n2, int n3, Color[] colorArray) {
        super(n, n2, n3);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n, Color[] colorArray) {
        super(n);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(ColorSpace colorSpace, float[] fArray, float f, Color[] colorArray) {
        super(colorSpace, fArray, f);
        this.initAlternativeColors(colorArray);
    }

    private void initAlternativeColors(Color[] colorArray) {
        if (colorArray != null) {
            this.alternativeColors = new Color[colorArray.length];
            System.arraycopy(colorArray, 0, this.alternativeColors, 0, colorArray.length);
        }
    }

    public Color[] getAlternativeColors() {
        if (this.alternativeColors != null) {
            Color[] colorArray = new Color[this.alternativeColors.length];
            System.arraycopy(this.alternativeColors, 0, colorArray, 0, this.alternativeColors.length);
            return colorArray;
        }
        return new Color[0];
    }

    public boolean hasAlternativeColors() {
        return this.alternativeColors != null && this.alternativeColors.length > 0;
    }

    public boolean hasSameAlternativeColors(ColorWithAlternatives colorWithAlternatives) {
        Color[] colorArray;
        if (!this.hasAlternativeColors()) {
            return !colorWithAlternatives.hasAlternativeColors();
        }
        if (!colorWithAlternatives.hasAlternativeColors()) {
            return false;
        }
        Color[] colorArray2 = this.getAlternativeColors();
        if (colorArray2.length != (colorArray = colorWithAlternatives.getAlternativeColors()).length) {
            return false;
        }
        int n = colorArray2.length;
        for (int i = 0; i < n; ++i) {
            Color color = colorArray2[i];
            Color color2 = colorArray[i];
            if (ColorUtil.isSameColor(color, color2)) continue;
            return false;
        }
        return true;
    }

    public Color getFirstAlternativeOfType(int n) {
        if (this.hasAlternativeColors()) {
            int n2 = this.alternativeColors.length;
            for (int i = 0; i < n2; ++i) {
                if (this.alternativeColors[i].getColorSpace().getType() != n) continue;
                return this.alternativeColors[i];
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.alternativeColors != null) {
            n = 37 * n + Arrays.hashCode(this.alternativeColors);
        }
        return n;
    }
}

