/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.IVFFileReader;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.IVFHeader;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.VP8Frame;

public class IVFStream
extends AbstractVideoPullBufferStream<DataSource> {
    private long timeLastRead = 0L;
    private long lastFrameTimestamp = 0L;
    private VP8Frame frame = new VP8Frame();
    private IVFFileReader ivfFileReader;
    private final long TIMEBASE;

    IVFStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        this.ivfFileReader = new IVFFileReader(dataSource.getLocator().getRemainder());
        IVFHeader header = this.ivfFileReader.getHeader();
        this.TIMEBASE = 1000000000 * header.getTimeScale() / header.getFramerate();
    }

    @Override
    protected void doRead(Buffer buffer) throws IOException {
        long nanos = 0L;
        VideoFormat format = (VideoFormat)buffer.getFormat();
        if (format == null && (format = (VideoFormat)this.getFormat()) != null) {
            buffer.setFormat((Format)format);
        }
        this.ivfFileReader.getNextFrame(this.frame, true);
        buffer.setData((Object)this.frame.getFrameData());
        buffer.setOffset(0);
        buffer.setLength(this.frame.getFrameLength());
        buffer.setTimeStamp(System.nanoTime());
        buffer.setFlags(32896);
        nanos = System.nanoTime() - this.timeLastRead;
        nanos = (this.frame.getTimestamp() - this.lastFrameTimestamp) * this.TIMEBASE - nanos;
        if (nanos > 0L) {
            try {
                Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.lastFrameTimestamp = this.frame.getTimestamp();
        this.timeLastRead = System.nanoTime();
    }
}

