/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.util.Logger;
import org.jitsi.util.function.Predicate;

public abstract class SinglePacketTransformer
implements PacketTransformer {
    private static final int EXCEPTIONS_TO_LOG = 1000;
    private static final Logger logger = Logger.getLogger(SinglePacketTransformer.class);
    private long exceptionsInReverseTransform;
    private long exceptionsInTransform;
    private final Predicate<RawPacket> packetPredicate;

    public SinglePacketTransformer() {
        this(null);
    }

    public SinglePacketTransformer(Predicate<RawPacket> packetPredicate) {
        this.packetPredicate = packetPredicate;
    }

    @Override
    public void close() {
    }

    public abstract RawPacket reverseTransform(RawPacket var1);

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        if (pkts != null) {
            for (int i = 0; i < pkts.length; ++i) {
                RawPacket pkt = pkts[i];
                if (pkt == null || this.packetPredicate != null && !this.packetPredicate.test(pkt)) continue;
                try {
                    pkts[i] = this.reverseTransform(pkt);
                    continue;
                }
                catch (Throwable t) {
                    ++this.exceptionsInReverseTransform;
                    if (this.exceptionsInReverseTransform % 1000L == 0L || this.exceptionsInReverseTransform == 1L) {
                        logger.error("Failed to reverse-transform RawPacket(s)!", t);
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        }
        return pkts;
    }

    public abstract RawPacket transform(RawPacket var1);

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        if (pkts != null) {
            for (int i = 0; i < pkts.length; ++i) {
                RawPacket pkt = pkts[i];
                if (pkt == null || this.packetPredicate != null && !this.packetPredicate.test(pkt)) continue;
                try {
                    pkts[i] = this.transform(pkt);
                    continue;
                }
                catch (Throwable t) {
                    ++this.exceptionsInTransform;
                    if (this.exceptionsInTransform % 1000L == 0L || this.exceptionsInTransform == 1L) {
                        logger.error("Failed to transform RawPacket(s)!", t);
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        }
        return pkts;
    }
}

