/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

public class RTPUtils {
    public static int sequenceNumberDiff(int a, int b) {
        int diff = a - b;
        if (diff < Short.MIN_VALUE) {
            diff += 65536;
        } else if (diff > 32768) {
            diff -= 65536;
        }
        return diff;
    }

    public static int subtractNumber(int a, int b) {
        return a - b & 0xFFFF;
    }

    public static int writeInt(byte[] buf, int off, int data) {
        if (buf == null || buf.length < off + 4) {
            return -1;
        }
        buf[off++] = (byte)(data >> 24);
        buf[off++] = (byte)(data >> 16);
        buf[off++] = (byte)(data >> 8);
        buf[off] = (byte)data;
        return 4;
    }

    public static int writeShort(byte[] buf, int off, short data) {
        buf[off++] = (byte)(data >> 8);
        buf[off] = (byte)data;
        return 2;
    }

    public static int readInt(byte[] buffer, int offset) {
        return (buffer[offset++] & 0xFF) << 24 | (buffer[offset++] & 0xFF) << 16 | (buffer[offset++] & 0xFF) << 8 | buffer[offset] & 0xFF;
    }

    public static long readUint32AsLong(byte[] buffer, int offset) {
        return (long)RTPUtils.readInt(buffer, offset) & 0xFFFFFFFFL;
    }

    public static int readUint16AsInt(byte[] buffer, int offset) {
        int b1 = 0xFF & buffer[offset + 0];
        int b2 = 0xFF & buffer[offset + 1];
        int val = b1 << 8 | b2;
        return val;
    }

    public static short readShort(byte[] buffer, int offset) {
        return (short)RTPUtils.readUint16AsInt(buffer, offset);
    }
}

