/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ICategory;
import com.google.gdata.data.Kind;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public class Category
implements ICategory {
    public static final char SCHEME_PREFIX = '{';
    public static final char SCHEME_SUFFIX = '}';
    private static final Pattern categoryPattern = Pattern.compile("(\\{([^\\}]+)\\})?(.+)");
    protected String scheme;
    protected String term;
    protected String label;
    protected String labelLang;

    public Category() {
    }

    public Category(String category) {
        Matcher m = categoryPattern.matcher(category);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid category: " + category);
        }
        if (m.group(2) != null) {
            this.scheme = m.group(2);
        }
        this.term = m.group(3);
    }

    public Category(String scheme, String term) {
        this(scheme, term, null);
    }

    public Category(String scheme, String term, String label) {
        this.scheme = scheme;
        if (term == null) {
            throw new NullPointerException("Invalid term. Cannot be null");
        }
        this.term = term;
        this.label = label;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String v) {
        this.scheme = v;
    }

    @Override
    public String getTerm() {
        return this.term;
    }

    public void setTerm(String v) {
        this.term = v;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String v) {
        this.label = v;
    }

    public String getLabelLang() {
        return this.labelLang;
    }

    public void setLabelLang(String v) {
        this.labelLang = v;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append('{');
            sb.append(this.scheme);
            sb.append('}');
        }
        sb.append(this.term);
        if (this.label != null) {
            sb.append("(");
            sb.append(this.label);
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Category)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 37 * result + this.term.hashCode();
        result = 37 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }

    public void generateAtom(XmlWriter w) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.scheme != null) {
            attrs.add(new XmlWriter.Attribute("scheme", this.scheme));
        }
        if (this.term != null) {
            attrs.add(new XmlWriter.Attribute("term", this.term));
        }
        if (this.label != null) {
            attrs.add(new XmlWriter.Attribute("label", this.label));
        }
        if (this.labelLang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.labelLang));
        }
        w.simpleElement(Namespaces.atomNs, "category", attrs, null);
    }

    public void generateRss(XmlWriter w) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.scheme != null) {
            attrs.add(new XmlWriter.Attribute("domain", this.scheme));
        }
        if (this.labelLang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.labelLang));
        }
        String value = this.term;
        if (this.term == null) {
            value = this.label;
        }
        w.simpleElement(Namespaces.rssNs, "category", attrs, value);
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        Set<Category> categorySet;
        ExtensionProfile extProfile;
        Kind.Adaptable adaptable;

        public AtomHandler() {
        }

        public AtomHandler(ExtensionProfile extProfile, Set<Category> categorySet, Kind.Adaptable adaptable) {
            this.extProfile = extProfile;
            this.categorySet = categorySet;
            this.adaptable = adaptable;
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) {
            if (namespace.equals("") && localName.equals("scheme")) {
                Category.this.scheme = value;
            } else if (namespace.equals("") && localName.equals("term")) {
                Category.this.term = value;
            } else if (namespace.equals("") && localName.equals("label")) {
                Category.this.label = value;
            }
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) {
            return null;
        }

        @Override
        public void processEndElement() throws ParseException {
            if (Category.this.term == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingTermAttribute);
            }
            Category.this.labelLang = this.xmlLang;
            if (this.categorySet != null) {
                this.categorySet.add(Category.this);
            }
            if (this.adaptable != null && this.extProfile.isAutoExtending() && Kind.isKindCategory(Category.this)) {
                try {
                    Kind.Adaptor adaptor = Kind.getAdaptor(Category.this.term, this.adaptable);
                    if (adaptor != null) {
                        this.extProfile.addDeclarations(adaptor);
                    }
                }
                catch (Kind.AdaptorException ae) {
                    throw new ParseException(CoreErrorDomain.ERR.cantLoadKindAdaptor, (Throwable)ae);
                }
            }
        }
    }
}

