/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementMetadataRegistryBuilder;
import com.google.gdata.model.ElementTransform;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

final class ElementMetadataRegistry {
    private final Schema schema;
    private final Map<TransformKey, ElementTransform> transforms;
    private final ConcurrentMap<TransformKey, ElementMetadata<?, ?>> cache = new MapMaker().makeMap();

    ElementMetadataRegistry(Schema schema, ElementMetadataRegistryBuilder elementBuilder) {
        this.schema = schema;
        this.transforms = this.getTransforms(elementBuilder);
    }

    private Map<TransformKey, ElementTransform> getTransforms(ElementMetadataRegistryBuilder elementBuilder) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<TransformKey, ElementCreatorImpl> entry : elementBuilder.getCreators().entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().toTransform());
        }
        return builder.build();
    }

    <D, E extends Element> ElementMetadata<D, E> bind(ElementKey<?, ?> parent, ElementKey<D, E> key, MetadataContext context) {
        ElementTransform transform;
        ElementMetadata<D, E> previous;
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        ElementMetadata<D, E> transformed = (ElementMetadata<D, E>)this.cache.get(transformKey);
        if (transformed == null && (previous = this.cache.putIfAbsent(transformKey, transformed = (transform = this.getTransform(transformKey, key)).toMetadata(this.schema, parent, key, context))) != null) {
            transformed = previous;
        }
        return transformed;
    }

    ElementTransform getTransform(ElementKey<?, ?> parent, ElementKey<?, ?> key, MetadataContext context) {
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        return this.getTransform(transformKey, key);
    }

    private ElementTransform getTransform(TransformKey transformKey, ElementKey<?, ?> key) {
        ArrayList matched = Lists.newArrayList();
        for (Map.Entry<TransformKey, ElementTransform> entry : this.transforms.entrySet()) {
            if (!entry.getKey().matches(transformKey)) continue;
            matched.add(entry.getValue());
        }
        switch (matched.size()) {
            case 0: {
                return ElementTransform.EMPTY;
            }
            case 1: {
                return (ElementTransform)matched.get(0);
            }
        }
        return ElementTransform.create(key, matched);
    }
}

