/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.StringTokenizer;
import net.java.sip.communicator.impl.protocol.icq.AimStatusEnum;
import net.java.sip.communicator.impl.protocol.icq.ServerStoredContactListIcqImpl;
import net.java.sip.communicator.service.protocol.AbstractContact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;

public class ContactIcqImpl
extends AbstractContact {
    Buddy joustSimBuddy = null;
    private boolean isLocal = false;
    private byte[] image = null;
    private PresenceStatus icqStatus = null;
    private ServerStoredContactListIcqImpl ssclCallback = null;
    private boolean isPersistent = false;
    private boolean isResolved = false;
    private String nickName = null;
    private String statusMessage = null;

    ContactIcqImpl(Buddy buddy, ServerStoredContactListIcqImpl ssclCallback, boolean isPersistent, boolean isResolved) {
        this.joustSimBuddy = buddy;
        this.ssclCallback = ssclCallback;
        this.isPersistent = isPersistent;
        this.isResolved = isResolved;
    }

    public String getUIN() {
        return this.joustSimBuddy.getScreenname().getFormatted();
    }

    public String getAddress() {
        return this.getUIN();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public byte[] getImage() {
        return this.image;
    }

    Buddy getJoustSimBuddy() {
        return this.joustSimBuddy;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("IcqContact[ uin=");
        buff.append(this.getAddress()).append(", alias=").append(this.getJoustSimBuddy().getAlias()).append("]");
        return buff.toString();
    }

    void setJoustSimBuddy(Buddy newBuddy) {
        this.joustSimBuddy = newBuddy;
    }

    void updatePresenceStatus(PresenceStatus status) {
        this.icqStatus = status;
    }

    public PresenceStatus getPresenceStatus() {
        if (this.icqStatus == null) {
            if (this.ssclCallback.getParentProvider().USING_ICQ) {
                return IcqStatusEnum.OFFLINE;
            }
            return AimStatusEnum.OFFLINE;
        }
        return this.icqStatus;
    }

    public String getDisplayName() {
        String alias = this.joustSimBuddy.getAlias();
        if (alias != null) {
            return alias;
        }
        if (this.nickName != null) {
            return this.nickName;
        }
        this.ssclCallback.addContactForUpdate(this);
        return this.getUIN();
    }

    protected void setNickname(String nickname) {
        this.nickName = nickname;
    }

    public ContactGroup getParentContactGroup() {
        return this.ssclCallback.findContactGroup(this);
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.ssclCallback.getParentProvider();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    void setPersistent(boolean persistent) {
        this.isPersistent = persistent;
    }

    void setResolved(boolean resolved) {
        this.isResolved = resolved;
    }

    public String getPersistentData() {
        if (this.nickName != null) {
            return "nickname=" + this.nickName + ";";
        }
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setPersistentData(String persistentData) {
        if (persistentData == null) {
            return;
        }
        StringTokenizer dataToks = new StringTokenizer(persistentData, ";");
        while (dataToks.hasMoreTokens()) {
            String[] data = dataToks.nextToken().split("=");
            if (!data[0].equals("nickname") || data.length <= 1) continue;
            this.nickName = data[1];
        }
    }

    protected void setImage(byte[] image) {
        this.image = image;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    protected void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }
}

