/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.MetaContactListServiceLick;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class TestMetaContactListPersistence
extends TestCase {
    private MclSlickFixture fixture = new MclSlickFixture(((Object)((Object)this)).getClass().getName());

    public TestMetaContactListPersistence(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        this.fixture = null;
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestMetaContactListPersistence("testCreateAndMoveMetaContact"));
        suite.addTest((Test)new TestMetaContactListPersistence("testReloadMetaContactListBundle"));
        suite.addTest((Test)new TestMetaContactListPersistence("testPartialContactListRestauration"));
        suite.addTest((Test)new TestMetaContactListPersistence("testCompleteContactListRestauration"));
        suite.addTest((Test)new TestMetaContactListPersistence("testPurgeLocalContactListCopy"));
        return suite;
    }

    public void testCreateAndMoveMetaContact() {
        String newContactID = "testCreateAndMoveMetaContact.ContactID";
        MetaContactGroup parentMetaGroup = this.fixture.metaClService.getRoot().getMetaContactSubgroup("SomePeople");
        this.fixture.metaClService.createMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, parentMetaGroup, newContactID);
        MetaContact newMetaContact = parentMetaGroup.getMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, newContactID);
        TestMetaContactListPersistence.assertNotNull((String)"create failed. couldn't find the new contact.", (Object)newMetaContact);
        this.fixture.metaClService.moveMetaContact(newMetaContact, this.fixture.metaClService.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReloadMetaContactListBundle() throws Exception {
        Object o;
        Object object = o = new Object();
        synchronized (object) {
            o.wait(1000L);
        }
        Bundle metaClBundle = this.findMetaClBundle();
        TestMetaContactListPersistence.assertNotNull((String)"Couldn't find the bundle that exports the meta contact list servce implementation that we're currently testing", (Object)metaClBundle);
        metaClBundle.stop();
        TestMetaContactListPersistence.assertTrue((String)("Couldn't stop the meta cl bundle. State was " + metaClBundle.getState()), (32 != metaClBundle.getState() && 16 != metaClBundle.getState() ? 1 : 0) != 0);
        metaClBundle.uninstall();
        TestMetaContactListPersistence.assertEquals((String)"Couldn't stop the meta cl bundle.", (int)1, (int)metaClBundle.getState());
        MclSlickFixture.mockPrServiceRegistration.unregister();
        MclSlickFixture.mockP1ServiceRegistration.unregister();
        MclSlickFixture.mockP2ServiceRegistration.unregister();
        MclSlickFixture.replacementMockPr = new MockProvider(MclSlickFixture.mockProvider.getAccountID().getUserID());
        MclSlickFixture.replacementMockP1 = new MockProvider(MclSlickFixture.mockP1.getAccountID().getUserID());
        MclSlickFixture.replacementMockP2 = new MockProvider(MclSlickFixture.mockP2.getAccountID().getUserID());
        MclSlickFixture.mockPrServiceRegistration = MetaContactListServiceLick.registerMockProviderService(MclSlickFixture.replacementMockPr);
        metaClBundle = MclSlickFixture.bundleContext.installBundle(metaClBundle.getLocation());
        TestMetaContactListPersistence.assertEquals((String)"Couldn't re-install meta cl bundle.", (int)2, (int)metaClBundle.getState());
        metaClBundle.start();
        TestMetaContactListPersistence.assertEquals((String)"Couldn't re-start meta cl bundle.", (int)32, (int)metaClBundle.getState());
        this.fixture.metaClService = (MetaContactListService)MclSlickFixture.bundleContext.getService(MclSlickFixture.bundleContext.getServiceReference(MetaContactListService.class.getName()));
        TestMetaContactListPersistence.assertNotNull((String)"The meta contact list service was not re-registered after reinstalling its bundle.", (Object)this.fixture.metaClService);
    }

    public void testPartialContactListRestauration() {
        ContactGroup oldProtoRoot = ((OperationSetPersistentPresence)MclSlickFixture.mockProvider.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        MclSlickFixture.assertGroupEquals((MockContactGroup)oldProtoRoot, this.fixture.metaClService.getRoot(), true);
        ContactGroup newProtoRoot = ((OperationSetPersistentPresence)MclSlickFixture.replacementMockPr.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        TestMetaContactListPersistence.assertEquals((String)"Newly loaded provider does not match the old one.", (Object)oldProtoRoot, (Object)newProtoRoot);
        Iterator subgroups = newProtoRoot.subgroups();
        while (subgroups.hasNext()) {
            this.assertUnresolvedContents((ContactGroup)subgroups.next());
        }
    }

    public void testCompleteContactListRestauration() {
        MclSlickFixture.mockP1ServiceRegistration = MetaContactListServiceLick.registerMockProviderService(MclSlickFixture.replacementMockP1);
        MclSlickFixture.mockP2ServiceRegistration = MetaContactListServiceLick.registerMockProviderService(MclSlickFixture.replacementMockP2);
        ContactGroup oldProtoMockP1Root = ((OperationSetPersistentPresence)MclSlickFixture.mockP1.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        ContactGroup oldProtoMockP2Root = ((OperationSetPersistentPresence)MclSlickFixture.mockP2.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        ContactGroup newProtoMockP1Root = ((OperationSetPersistentPresence)MclSlickFixture.replacementMockP1.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        TestMetaContactListPersistence.assertEquals((String)"Newly loaded provider does not match the old one.", (Object)oldProtoMockP1Root, (Object)newProtoMockP1Root);
        ContactGroup newProtoMockP2Root = ((OperationSetPersistentPresence)MclSlickFixture.replacementMockP2.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot();
        TestMetaContactListPersistence.assertEquals((String)"Newly loaded provider does not match the old one.", (Object)oldProtoMockP2Root, (Object)newProtoMockP2Root);
        Iterator subgroups = newProtoMockP1Root.subgroups();
        while (subgroups.hasNext()) {
            this.assertUnresolvedContents((ContactGroup)subgroups.next());
        }
        subgroups = newProtoMockP2Root.subgroups();
        while (subgroups.hasNext()) {
            this.assertUnresolvedContents((ContactGroup)subgroups.next());
        }
    }

    private void assertUnresolvedContents(ContactGroup root) {
        TestMetaContactListPersistence.assertEquals((String)("isResolved for grp:" + root.getGroupName()), (boolean)false, (boolean)root.isResolved());
        Iterator contacts = root.contacts();
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            TestMetaContactListPersistence.assertEquals((String)("isResolved for contact:" + contact.getDisplayName()), (boolean)false, (boolean)contact.isResolved());
        }
        Iterator subgroups = root.subgroups();
        while (subgroups.hasNext()) {
            this.assertUnresolvedContents((ContactGroup)subgroups.next());
        }
    }

    public void testPurgeLocalContactListCopy() {
        this.fixture.metaClService.purgeLocallyStoredContactListCopy();
    }

    private Bundle findMetaClBundle() {
        Bundle[] bundles = MclSlickFixture.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ServiceReference[] registeredServices = bundles[i].getRegisteredServices();
            if (registeredServices == null) continue;
            for (int j = 0; j < registeredServices.length; ++j) {
                Object service = MclSlickFixture.bundleContext.getService(registeredServices[j]);
                if (service != this.fixture.metaClService) continue;
                return bundles[i];
            }
        }
        return null;
    }
}

