/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.rtp;

import java.io.IOException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPControl;
import net.sf.fmj.media.protocol.BasicPushBufferDataSource;
import net.sf.fmj.media.protocol.BufferListener;
import net.sf.fmj.media.protocol.RTPSource;
import net.sf.fmj.media.protocol.Streamable;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.SSRCInfo;

public class DataSource
extends BasicPushBufferDataSource
implements Streamable,
RTPSource {
    public static final String RTP_CONTROL_CLASS_NAME = RTPControl.class.getName();
    static int SSRC_UNDEFINED = 0;
    private final RTPSourceStream[] srcStreams = new RTPSourceStream[1];
    Player streamplayer = null;
    RTPSessionMgr mgr = null;
    RTPControl rtpcontrol = new MyRTPControl();
    DataSource childsrc = null;
    int ssrc = SSRC_UNDEFINED;

    public DataSource() {
        this.setContentType("rtp");
    }

    @Override
    public void connect() throws IOException {
        if (this.srcStreams != null) {
            for (RTPSourceStream srcStream : this.srcStreams) {
                if (srcStream == null) continue;
                srcStream.connect();
            }
        }
        this.connected = true;
    }

    @Override
    public void disconnect() {
        if (this.srcStreams != null) {
            for (RTPSourceStream srcStream : this.srcStreams) {
                srcStream.close();
            }
        }
    }

    @Override
    public void flush() {
        this.srcStreams[0].reset();
    }

    @Override
    public String getCNAME() {
        if (this.mgr == null) {
            return null;
        }
        SSRCInfo info = this.mgr.getSSRCInfo(this.ssrc);
        if (info != null) {
            return info.getCNAME();
        }
        return null;
    }

    @Override
    public Object getControl(String type) {
        Class clazz;
        if (RTP_CONTROL_CLASS_NAME.equals(type)) {
            clazz = RTPControl.class;
        } else {
            try {
                clazz = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return this.getControl(clazz);
    }

    public <T> T getControl(Class<T> clazz) {
        for (Object control : this.getControls()) {
            if (!clazz.isInstance(control)) continue;
            Object t = control;
            return (T)t;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        return new RTPControl[]{this.rtpcontrol};
    }

    public RTPSessionMgr getMgr() {
        return this.mgr;
    }

    public Player getPlayer() {
        return this.streamplayer;
    }

    @Override
    public int getSSRC() {
        return this.ssrc;
    }

    @Override
    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.srcStreams;
    }

    @Override
    public boolean isPrefetchable() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void prebuffer() {
        this.started = true;
        this.srcStreams[0].prebuffer();
    }

    @Override
    public void setBufferListener(BufferListener listener) {
        this.srcStreams[0].setBufferListener(listener);
    }

    public void setBufferWhenStopped(boolean flag) {
        this.srcStreams[0].setBufferWhenStopped(flag);
    }

    public void setChild(DataSource source) {
        this.childsrc = source;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setControl(Object control) {
        this.rtpcontrol = (RTPControl)control;
    }

    @Override
    public void setLocator(MediaLocator mrl) {
        super.setLocator(mrl);
    }

    public void setMgr(RTPSessionMgr mgr) {
        this.mgr = mgr;
    }

    public void setPlayer(Player player) {
        this.streamplayer = player;
    }

    public void setSourceStream(RTPSourceStream stream) {
        if (this.srcStreams != null) {
            this.srcStreams[0] = stream;
        }
    }

    public void setSSRC(int ssrc) {
        this.ssrc = ssrc;
    }

    @Override
    public void start() throws IOException {
        super.start();
        if (this.childsrc != null) {
            this.childsrc.start();
        }
        if (this.srcStreams != null) {
            for (RTPSourceStream srcStream : this.srcStreams) {
                srcStream.start();
            }
        }
    }

    @Override
    public void stop() throws IOException {
        super.stop();
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
        if (this.srcStreams != null) {
            for (RTPSourceStream srcStream : this.srcStreams) {
                srcStream.stop();
            }
        }
    }

    class MyRTPControl
    extends RTPControlImpl {
        MyRTPControl() {
        }

        @Override
        public String getCNAME() {
            if (DataSource.this.mgr == null) {
                return null;
            }
            SSRCInfo info = DataSource.this.mgr.getSSRCInfo(DataSource.this.ssrc);
            if (info != null) {
                return info.getCNAME();
            }
            return null;
        }

        @Override
        public int getSSRC() {
            return DataSource.this.ssrc;
        }
    }
}

