/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;
import net.kano.joscar.snaccmd.FullRoomInfo;
import org.jetbrains.annotations.Nullable;

public final class MiniRoomInfo
implements LiveWritable {
    private final int exchange;
    private final String cookie;
    private final int instance;
    private final int totalSize;

    @Nullable
    public static MiniRoomInfo readMiniRoomInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 5) {
            return null;
        }
        int exchange = BinaryTools.getUShort(block, 0);
        short cookielen = BinaryTools.getUByte(block, 2);
        if (block.getLength() < 5 + cookielen) {
            return null;
        }
        ByteBlock cookieBlock = block.subBlock(3, cookielen);
        String cookie = BinaryTools.getAsciiString(cookieBlock);
        ByteBlock rest = block.subBlock(3 + cookielen);
        int instance = BinaryTools.getUShort(rest, 0);
        int size = rest.getOffset() + 2 - block.getOffset();
        return new MiniRoomInfo(exchange, cookie, instance, size);
    }

    private MiniRoomInfo(int exchange, String cookie, int instance, int totalSize) {
        DefensiveTools.checkRange(exchange, "exchange", 0);
        DefensiveTools.checkNull(cookie, "cookie");
        DefensiveTools.checkRange(instance, "instance", 0);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.exchange = exchange;
        this.cookie = cookie;
        this.instance = instance;
        this.totalSize = totalSize;
    }

    public MiniRoomInfo(FullRoomInfo roomInfo) {
        this.exchange = roomInfo.getExchange();
        this.cookie = roomInfo.getCookie();
        this.instance = roomInfo.getInstance();
        this.totalSize = -1;
    }

    public MiniRoomInfo(int exchange, String cookie, int instance) {
        this(exchange, cookie, instance, -1);
    }

    public final int getExchange() {
        return this.exchange;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final int getInstance() {
        return this.instance;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public boolean isSameRoom(MiniRoomInfo info) {
        return this.getExchange() == info.getExchange() && this.getInstance() == info.getInstance() && OscarTools.getRoomNameFromCookie(this.getCookie()).equals(OscarTools.getRoomNameFromCookie(info.getCookie()));
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.exchange);
        byte[] cookieBytes = BinaryTools.getAsciiBytes(this.cookie);
        BinaryTools.writeUByte(out, cookieBytes.length);
        out.write(cookieBytes);
        BinaryTools.writeUShort(out, this.instance);
    }

    public String toString() {
        return "MiniRoomInfo: exchange #" + this.exchange + ", instance #" + this.instance + ", cookie=" + this.cookie;
    }
}

