/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.thunderbird;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mork.Row;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdActivator;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;
import org.jitsi.service.configuration.ConfigurationService;

public class ThunderbirdContactSourceService
implements ExtendedContactSourceService,
PrefixedContactSourceService {
    public static final String PNAME_BASE_THUNDERBIRD_CONFIG = "net.java.sip.communicator.plugin.thunderbird.source";
    public static final String PNAME_FILENAME = "FILENAME";
    public static final String PNAME_DISPLAYNAME = "DISPLAYNAME";
    public static final String PNAME_INDEX = "INDEX";
    public static final String PNAME_PREFIX = "PREFIX";
    ConfigurationService config = ThunderbirdActivator.getConfigService();
    private final String baseConfigProperty;
    private String fileName;
    private final String displayName;
    private final int index;
    private String prefix;
    long lastDatabaseFileChange = 0L;
    Map<String, Map<String, Row>> database;
    String defaultScope;

    public ThunderbirdContactSourceService(String baseConfigProperty) {
        this.baseConfigProperty = baseConfigProperty;
        this.fileName = this.config.getString(baseConfigProperty + "." + PNAME_FILENAME);
        this.displayName = this.config.getString(baseConfigProperty + "." + PNAME_DISPLAYNAME);
        this.index = this.config.getInt(baseConfigProperty + "." + PNAME_INDEX, 0);
        this.prefix = this.config.getString(baseConfigProperty + "." + PNAME_PREFIX);
    }

    String getBaseConfigProperty() {
        return this.baseConfigProperty;
    }

    public int getType() {
        return 0;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ContactQuery createContactQuery(String queryString) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(queryString, 2);
        }
        catch (PatternSyntaxException pse) {
            pattern = Pattern.compile(Pattern.quote(queryString), 2);
        }
        if (pattern != null) {
            return this.createContactQuery(pattern);
        }
        return null;
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        return this.createContactQuery(queryString);
    }

    public ContactQuery createContactQuery(Pattern queryPattern) {
        return new ThunderbirdContactQuery(this, queryPattern);
    }

    public int getIndex() {
        return this.index;
    }

    public String getPhoneNumberPrefix() {
        return this.prefix;
    }

    void setPhoneNumberPrefix(String prefix) {
        this.prefix = prefix;
        this.config.setProperty(this.baseConfigProperty + "." + PNAME_PREFIX, (Object)prefix);
    }

    String getFilename() {
        return this.fileName;
    }

    void setFilename(String filename) {
        this.fileName = filename;
        this.config.setProperty(this.baseConfigProperty + "." + PNAME_FILENAME, (Object)filename);
    }
}

