/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import com.ircclouds.irc.api.IRCApi;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.plugin.irccommands.command.Join;
import org.easymock.EasyMock;

public class JoinTest
extends TestCase {
    public void testGoodInit() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        new Join(null, connection);
    }

    public void testBadInit() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{provider});
        try {
            new Join(provider, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyJoin() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        Join join = new Join(null, connection);
        try {
            join.execute("#test", "/join");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoinEmptyChannelNoPassword() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        Join join = new Join(null, connection);
        try {
            join.execute("#test", "/join ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoinWithChannelNoPassword() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        IRCApi client = (IRCApi)EasyMock.createMock(IRCApi.class);
        EasyMock.expect((Object)connection.getClient()).andReturn((Object)client);
        client.joinChannel((String)EasyMock.eq((Object)"#test"), (String)EasyMock.eq((Object)""));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{connection, client});
        Join join = new Join(null, connection);
        join.execute("#test", "/join #test");
    }

    public void testJoinWithChannelWithPassword() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        IRCApi client = (IRCApi)EasyMock.createMock(IRCApi.class);
        EasyMock.expect((Object)connection.getClient()).andReturn((Object)client);
        client.joinChannel((String)EasyMock.eq((Object)"#test"), (String)EasyMock.eq((Object)"top-secret"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{connection, client});
        Join join = new Join(null, connection);
        join.execute("#test", "/join #test top-secret");
    }
}

