/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatHtmlUtils;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public abstract class ChatConversationComponent
extends JPanel
implements Skinnable {
    private static final Logger logger = Logger.getLogger(ChatConversationComponent.class);
    protected final GridBagConstraints constraints = new GridBagConstraints();
    private static Color defaultColor = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_CONVERSATION_COMPONENT"));
    private static Color warningColor = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_CONVERSATION_WARNING_COMPONENT"));
    private Color backgroundColor = defaultColor;
    protected static final ResourceManagementService resources = GuiActivator.getResources();

    public ChatConversationComponent() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void loadSkin() {
        boolean defaultCol = false;
        if (this.backgroundColor == defaultColor) {
            defaultCol = true;
        }
        defaultColor = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_CONVERSATION_COMPONENT"));
        warningColor = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_CONVERSATION_WARNING_COMPONENT"));
        this.backgroundColor = defaultCol ? defaultColor : warningColor;
    }

    protected void setWarningStyle(boolean isWarningStyle) {
        this.backgroundColor = isWarningStyle ? warningColor : defaultColor;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.backgroundColor);
        g2.fillRoundRect(1, 1, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
    }

    protected void openFile(File downloadFile) {
        try {
            GuiActivator.getDesktopService().open(downloadFile);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_DOES_NOT_EXIST"));
        }
        catch (NullPointerException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_DOES_NOT_EXIST"));
        }
        catch (UnsupportedOperationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_OPEN_NOT_SUPPORTED"));
        }
        catch (SecurityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_OPEN_NO_PERMISSION"));
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_OPEN_NO_APPLICATION"));
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open file.", (Throwable)e);
            }
            this.showErrorMessage(resources.getI18NString("service.gui.FILE_OPEN_FAILED"));
        }
    }

    public String getDateString(Date date) {
        return ChatHtmlUtils.getDateString(date) + GuiUtils.formatTime((Date)date) + " ";
    }

    public abstract Date getDate();

    protected abstract void showErrorMessage(String var1);

    protected class ChatConversationButton
    extends JButton
    implements Skinnable {
        public ChatConversationButton() {
            this.init();
        }

        public ChatConversationButton(String text, Icon icon) {
            super(text, icon);
            this.init();
        }

        private void init() {
            this.loadSkin();
            this.setFont(this.getFont().deriveFont(1, 11.0f));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ChatConversationButton.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ChatConversationButton.this.setCursor(new Cursor(0));
                }
            });
        }

        public void loadSkin() {
            int color = GuiActivator.getResources().getColor("service.gui.CHAT_LINK_COLOR");
            this.setForeground(new Color(color));
        }
    }
}

