/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.wireformats.ContentValidationException;
import com.google.gdata.wireformats.WireFormat;
import com.google.gdata.wireformats.WireFormatGenerator;
import com.google.gdata.wireformats.output.CharacterGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import com.google.gdata.wireformats.output.OutputPropertiesBuilder;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class WireFormatOutputGenerator<T>
extends CharacterGenerator<T> {
    public abstract WireFormat getWireFormat();

    @Override
    public void generate(Writer w, OutputProperties outProps, T source) throws IOException {
        if (source instanceof Element) {
            Element elem = (Element)source;
            try {
                ElementMetadata<?, ?> outputMetadata = outProps.getRootMetadata();
                if (outputMetadata == null) {
                    throw new IllegalStateException("No metadata for " + elem.getElementKey());
                }
                if (!(elem = elem.resolve(outputMetadata)).getElementKey().equals(outputMetadata.getKey())) {
                    if ((outputMetadata = outputMetadata.getSchema().bind(elem.getElementKey(), outputMetadata.getContext())) == null) {
                        throw new IllegalStateException("Unable to rebind from " + outProps.getRootMetadata().getKey() + " to " + elem.getElementKey());
                    }
                    outProps = ((OutputPropertiesBuilder)new OutputPropertiesBuilder(outProps).setElementMetadata(outputMetadata)).build();
                }
                WireFormat wireFormat = this.getWireFormat();
                String encoding = WireFormatOutputGenerator.getCharsetEncoding(outProps);
                Charset cs = Charset.forName(encoding);
                WireFormatGenerator gen = wireFormat.createGenerator(outProps, w, cs, this.usePrettyPrint(outProps));
                gen.generate(elem);
            }
            catch (ContentValidationException e) {
                throw new IOException("Invalid content: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Output object was not an Element: " + source);
        }
        w.flush();
    }
}

