/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DSCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DSFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DSManager;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DataSource;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;

public class DirectShowSystem
extends DeviceSystem {
    private static final String LOCATOR_PROTOCOL = "directshow";
    private static final Logger logger = Logger.getLogger(DirectShowSystem.class);

    public DirectShowSystem() throws Exception {
        super(MediaType.VIDEO, LOCATOR_PROTOCOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialize() throws Exception {
        DSManager manager = new DSManager();
        try {
            int count;
            DSCaptureDevice[] devices = manager.getCaptureDevices();
            boolean captureDeviceInfoIsAdded = false;
            int n = count = devices == null ? 0 : devices.length;
            for (int i = 0; i < count; ++i) {
                DSCaptureDevice device = devices[i];
                Object[] dsFormats = device.getSupportedFormats();
                String name = device.getName();
                if (dsFormats.length == 0) {
                    logger.warn("Camera '" + name + "' reported no supported formats.");
                    continue;
                }
                ArrayList<AVFrameFormat> formats = new ArrayList<AVFrameFormat>(dsFormats.length);
                for (DSFormat dSFormat : dsFormats) {
                    AVFrameFormat format;
                    int pixelFormat = dSFormat.getPixelFormat();
                    int ffmpegPixFmt = DataSource.getFFmpegPixFmt(pixelFormat);
                    if (ffmpegPixFmt == -1 || formats.contains((Object)(format = new AVFrameFormat(ffmpegPixFmt, pixelFormat)))) continue;
                    formats.add(format);
                }
                if (formats.isEmpty()) {
                    logger.warn("No support for the formats of camera '" + name + "': " + Arrays.toString(dsFormats));
                    continue;
                }
                Object[] formatsArray = formats.toArray(new Format[formats.size()]);
                if (logger.isInfoEnabled()) {
                    logger.info("Support for the formats of camera '" + name + "': " + Arrays.toString(formatsArray));
                }
                CaptureDeviceInfo cdi = new CaptureDeviceInfo(name, new MediaLocator("directshow:" + name), (Format[])formatsArray);
                CaptureDeviceManager.addDevice((CaptureDeviceInfo)cdi);
                captureDeviceInfoIsAdded = true;
            }
            if (captureDeviceInfoIsAdded && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
                CaptureDeviceManager.commit();
            }
        }
        finally {
            manager.dispose();
        }
    }
}

