/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

public class OSUtils {
    public static final boolean IS_32_BIT;
    public static final boolean IS_64_BIT;
    public static final boolean IS_ANDROID;
    public static final boolean IS_LINUX;
    public static final boolean IS_LINUX32;
    public static final boolean IS_LINUX64;
    public static final boolean IS_MAC;
    public static final boolean IS_MAC32;
    public static final boolean IS_MAC64;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_WINDOWS32;
    public static final boolean IS_WINDOWS64;
    public static final boolean IS_WINDOWS_VISTA;
    public static final boolean IS_WINDOWS_7;
    public static final boolean IS_WINDOWS_8;
    public static final boolean IS_FREEBSD;

    protected OSUtils() {
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_WINDOWS_VISTA = false;
            IS_WINDOWS_7 = false;
            IS_WINDOWS_8 = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Linux")) {
            String javaVmName = System.getProperty("java.vm.name");
            if (javaVmName != null && javaVmName.equalsIgnoreCase("Dalvik")) {
                IS_ANDROID = true;
                IS_LINUX = false;
            } else {
                IS_ANDROID = false;
                IS_LINUX = true;
            }
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_WINDOWS_VISTA = false;
            IS_WINDOWS_7 = false;
            IS_WINDOWS_8 = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Mac")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = true;
            IS_WINDOWS = false;
            IS_WINDOWS_VISTA = false;
            IS_WINDOWS_7 = false;
            IS_WINDOWS_8 = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Windows")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = true;
            IS_WINDOWS_VISTA = osName.indexOf("Vista") != -1;
            IS_WINDOWS_7 = osName.indexOf("7") != -1;
            IS_WINDOWS_8 = osName.indexOf("8") != -1;
            IS_FREEBSD = false;
        } else if (osName.startsWith("FreeBSD")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_WINDOWS_VISTA = false;
            IS_WINDOWS_7 = false;
            IS_WINDOWS_8 = false;
            IS_FREEBSD = true;
        } else {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_WINDOWS_VISTA = false;
            IS_WINDOWS_7 = false;
            IS_WINDOWS_8 = false;
            IS_FREEBSD = false;
        }
        String osArch = System.getProperty("sun.arch.data.model");
        if (osArch == null) {
            IS_32_BIT = true;
            IS_64_BIT = false;
        } else if (osArch.indexOf("32") != -1) {
            IS_32_BIT = true;
            IS_64_BIT = false;
        } else if (osArch.indexOf("64") != -1) {
            IS_32_BIT = false;
            IS_64_BIT = true;
        } else {
            IS_32_BIT = false;
            IS_64_BIT = false;
        }
        IS_LINUX32 = IS_LINUX && IS_32_BIT;
        IS_LINUX64 = IS_LINUX && IS_64_BIT;
        IS_MAC32 = IS_MAC && IS_32_BIT;
        IS_MAC64 = IS_MAC && IS_64_BIT;
        IS_WINDOWS32 = IS_WINDOWS && IS_32_BIT;
        IS_WINDOWS64 = IS_WINDOWS && IS_64_BIT;
    }
}

