/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.X509CertificatePanel;
import net.java.sip.communicator.service.certificate.VerifyCertificateDialogService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

class VerifyCertificateDialogImpl
extends SIPCommDialog
implements VerifyCertificateDialogService.VerifyCertificateDialog {
    private static final Logger logger = Logger.getLogger(VerifyCertificateDialogImpl.class);
    private static final long serialVersionUID = 0L;
    private ResourceManagementService R = DesktopUtilActivator.getResources();
    private static final int MAX_MSG_PANE_WIDTH = 600;
    private static final int MAX_MSG_PANE_HEIGHT = 800;
    Certificate[] certs;
    String message;
    TransparentPanel certPanel;
    TransparentPanel contentPane;
    boolean certOpened = false;
    JButton certButton;
    SIPCommCheckBox alwaysTrustCheckBox = new SIPCommCheckBox(this.R.getI18NString("service.gui.ALWAYS_TRUST"), false);
    boolean isTrusted = false;

    public VerifyCertificateDialogImpl(Certificate[] certs, String title, String message) {
        super(false);
        this.setTitle(title != null ? title : this.R.getI18NString("service.gui.CERT_DIALOG_TITLE"));
        this.setModal(true);
        this.certs = certs;
        this.message = message;
        this.setDefaultCloseOperation(2);
        this.init();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new TransparentPanel(new BorderLayout(5, 5));
        TransparentPanel northPanel = new TransparentPanel(new BorderLayout(5, 5));
        northPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JLabel imgLabel = new JLabel(this.R.getImage("service.gui.icons.CERTIFICATE_WARNING"));
        imgLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        northPanel.add(imgLabel, "West");
        StyledHTMLEditorPane descriptionPane = new StyledHTMLEditorPane();
        descriptionPane.setOpaque(false);
        descriptionPane.setEditable(false);
        descriptionPane.setContentType("text/html");
        descriptionPane.setText(this.message);
        descriptionPane.setSize(new Dimension(600, 800));
        int height = descriptionPane.getPreferredSize().height;
        descriptionPane.setPreferredSize(new Dimension(600, height));
        northPanel.add(descriptionPane, "Center");
        this.contentPane.add((Component)((Object)northPanel), "North");
        this.certPanel = new TransparentPanel();
        this.contentPane.add((Component)((Object)this.certPanel), "Center");
        TransparentPanel southPanel = new TransparentPanel(new BorderLayout());
        this.contentPane.add((Component)((Object)southPanel), "South");
        this.certButton = new JButton();
        this.certButton.setText(this.R.getI18NString("service.gui.SHOW_CERT"));
        this.certButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialogImpl.this.actionShowCertificate();
            }
        });
        TransparentPanel firstButonPanel = new TransparentPanel(new FlowLayout(0));
        firstButonPanel.add(this.certButton);
        southPanel.add((Component)((Object)firstButonPanel), "West");
        TransparentPanel secondButonPanel = new TransparentPanel(new FlowLayout(2));
        JButton cancelButton = new JButton(this.R.getI18NString("service.gui.CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialogImpl.this.actionCancel();
            }
        });
        JButton continueButton = new JButton(this.R.getI18NString("service.gui.CONTINUE_ANYWAY"));
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialogImpl.this.actionContinue();
            }
        });
        secondButonPanel.add(continueButton);
        secondButonPanel.add(cancelButton);
        southPanel.add((Component)((Object)secondButonPanel), "East");
        this.getContentPane().add((Component)((Object)this.contentPane), "Center");
        this.pack();
    }

    private void actionShowCertificate() {
        if (this.certOpened) {
            this.certPanel.removeAll();
            this.certButton.setText(this.R.getI18NString("service.gui.SHOW_CERT"));
            this.certPanel.revalidate();
            this.certPanel.repaint();
            this.pack();
            this.certOpened = false;
            this.setLocationRelativeTo(this.getParent());
            return;
        }
        this.certPanel.setLayout(new BorderLayout(5, 5));
        this.certPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.certPanel.add(this.alwaysTrustCheckBox, "North");
        this.certPanel.add((Component)((Object)new X509CertificatePanel(this.certs)), "Center");
        this.certButton.setText(this.R.getI18NString("service.gui.HIDE_CERT"));
        this.certPanel.revalidate();
        this.certPanel.repaint();
        this.setPreferredSize(null);
        this.pack();
        this.certOpened = true;
        this.setLocationRelativeTo(this.getParent());
    }

    private void actionCancel() {
        this.isTrusted = false;
        this.dispose();
    }

    private void actionContinue() {
        this.isTrusted = true;
        this.dispose();
    }

    @Override
    protected void close(boolean isEscaped) {
        this.actionCancel();
    }

    public boolean isTrusted() {
        return this.isTrusted;
    }

    public boolean isAlwaysTrustSelected() {
        return this.alwaysTrustCheckBox.isSelected();
    }

    @Override
    public void setVisible(boolean isVisible) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VerifyCertificateDialogImpl.super.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Cannot show certificate verification dialog", (Throwable)e);
        }
    }
}

