/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public final class JVideoComponent
extends JComponent {
    private Image image;
    private boolean scaleKeepAspectRatio = false;

    public JVideoComponent() {
        this.setDoubleBuffered(false);
        this.setOpaque(false);
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.scaleKeepAspectRatio) {
            if (this.image != null) {
                int y;
                int x;
                int h;
                int w;
                Dimension preferredSize = this.getPreferredSize();
                Dimension size = this.getSize();
                if ((float)size.width / (float)preferredSize.width < (float)size.height / (float)preferredSize.height) {
                    w = size.width;
                    h = size.width * preferredSize.height / preferredSize.width;
                    x = 0;
                    y = (size.height - h) / 2;
                } else {
                    w = size.height * preferredSize.width / preferredSize.height;
                    h = size.height;
                    x = (size.width - w) / 2;
                    y = 0;
                }
                g.drawImage(this.image, x, y, w, h, null);
            }
        } else if (this.image != null) {
            Dimension size = this.getSize();
            g.drawImage(this.image, 0, 0, size.width, size.height, null);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }
}

