/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.icq.MetaFullInfoAckCmd;
import net.kano.joscar.snaccmd.icq.MetaFullInfoSetCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconService;

public class OperationSetServerStoredAccountInfoIcqImpl
extends AbstractOperationSetServerStoredAccountInfo {
    private static final Logger logger = Logger.getLogger(OperationSetServerStoredAccountInfoIcqImpl.class);
    private InfoRetreiver infoRetreiver = null;
    private String uin = null;
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private int reqID = 0;
    public static final Map<Class<? extends ServerStoredDetails.GenericDetail>, int[]> supportedTypes = new Hashtable<Class<? extends ServerStoredDetails.GenericDetail>, int[]>();
    private ServerStoredDetails.ImageDetail accountImage = null;
    private IconUpdateListener iconListener = null;
    static ServerStoredDetails.GenderDetail[] genders;
    private static Locale[] spokenLanguages;
    static String[] occupations;
    static String[] interestsCategories;
    private static final Map<Integer, String> countryIndexToLocaleString;

    public OperationSetServerStoredAccountInfoIcqImpl(InfoRetreiver infoRetreiver, String uin, ProtocolProviderServiceIcqImpl icqProvider) {
        this.infoRetreiver = infoRetreiver;
        this.uin = uin;
        this.icqProvider = icqProvider;
    }

    public Iterator<ServerStoredDetails.GenericDetail> getAllAvailableDetails() {
        this.assertConnected();
        List<ServerStoredDetails.GenericDetail> ds = this.infoRetreiver.getContactDetails(this.uin);
        ServerStoredDetails.ImageDetail img = this.getImage();
        if (img != null) {
            ds.add((ServerStoredDetails.GenericDetail)img);
        }
        return ds.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        this.assertConnected();
        if (detailClass.equals(ServerStoredDetails.ImageDetail.class)) {
            Vector<ServerStoredDetails.ImageDetail> res = new Vector<ServerStoredDetails.ImageDetail>();
            res.add(this.getImage());
            return res.iterator();
        }
        return this.infoRetreiver.getDetails(this.uin, detailClass);
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(Class<T> detailClass) {
        this.assertConnected();
        if (ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass)) {
            Vector<ServerStoredDetails.ImageDetail> res = new Vector<ServerStoredDetails.ImageDetail>();
            res.add(this.getImage());
            Iterator tIt = res.iterator();
            return tIt;
        }
        return this.infoRetreiver.getDetailsAndDescendants(this.uin, detailClass);
    }

    public int getMaxDetailInstances(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return supportedTypes.get(detailClass)[0];
    }

    public Iterator<Class<? extends ServerStoredDetails.GenericDetail>> getSupportedDetailTypes() {
        return supportedTypes.keySet().iterator();
    }

    public boolean isDetailClassSupported(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return supportedTypes.get(detailClass) != null;
    }

    public boolean isDetailClassEditable(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return this.isDetailClassSupported(detailClass) && ServerStoredDetails.ImageDetail.class.isAssignableFrom(detailClass);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.icqProvider == null) {
            throw new IllegalStateException("The icq provider must be non-null and signed on the ICQ service before being able to communicate.");
        }
        if (!this.icqProvider.isRegistered()) {
            throw new IllegalStateException("The icq provider must be signed on the ICQ service before being able to communicate.");
        }
    }

    public void addDetail(ServerStoredDetails.GenericDetail detail) throws IllegalArgumentException, OperationFailedException, ArrayIndexOutOfBoundsException {
        this.assertConnected();
        if (!this.isDetailClassSupported(detail.getClass())) {
            throw new IllegalArgumentException("implementation does not support such details " + detail.getClass());
        }
        Vector<ServerStoredDetails.GenericDetail> alreadySetDetails = new Vector<ServerStoredDetails.GenericDetail>();
        Iterator<ServerStoredDetails.GenericDetail> iter = this.getDetails(detail.getClass());
        while (iter.hasNext()) {
            alreadySetDetails.add(iter.next());
        }
        if (alreadySetDetails.size() >= this.getMaxDetailInstances(detail.getClass())) {
            throw new ArrayIndexOutOfBoundsException("Max count for this detail is already reached");
        }
        if (detail instanceof ServerStoredDetails.ImageDetail) {
            if (this.iconListener == null) {
                this.iconListener = new IconUpdateListener();
                this.icqProvider.getAimConnection().getExternalServiceManager().getIconServiceArbiter().addIconRequestListener(new IconUpdateListener());
            }
            this.icqProvider.getAimConnection().getMyBuddyIconManager().requestSetIcon(ByteBlock.wrap(((ServerStoredDetails.ImageDetail)detail).getBytes()));
            this.infoRetreiver.detailsChanged(this.uin);
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.icqProvider, 1, null, detail);
            return;
        }
        alreadySetDetails.add(detail);
        SuccessResponseListener responseListener = new SuccessResponseListener();
        MetaFullInfoSetCmd cmd = new MetaFullInfoSetCmd((long)Integer.parseInt(this.uin), this.reqID++);
        int typeOfDetail = supportedTypes.get(detail.getClass())[1];
        try {
            switch (typeOfDetail) {
                case 420: {
                    cmd.setCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)detail).getLocale()));
                    break;
                }
                case 340: {
                    cmd.setNickName(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 320: {
                    cmd.setFirstName(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 330: {
                    cmd.setLastName(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 350: {
                    cmd.setEmail(((ServerStoredDetails.StringDetail)detail).getString(), false);
                    break;
                }
                case 400: {
                    cmd.setHomeCity(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 410: {
                    cmd.setHomeState(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 630: {
                    cmd.setHomePhone(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 640: {
                    cmd.setHomeFax(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 610: {
                    cmd.setAddress(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 650: {
                    cmd.setCellPhone(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 620: {
                    cmd.setHomeZip(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 380: {
                    if (detail.equals((Object)ServerStoredDetails.GenderDetail.FEMALE)) {
                        cmd.setGender(1);
                        break;
                    }
                    if (detail.equals((Object)ServerStoredDetails.GenderDetail.MALE)) {
                        cmd.setGender(2);
                        break;
                    }
                    cmd.setGender(0);
                    break;
                }
                case 531: {
                    cmd.setHomePage(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 570: {
                    cmd.setBirthDay(((ServerStoredDetails.BirthDateDetail)detail).getCalendar().getTime());
                    break;
                }
                case 390: {
                    int[] langs = new int[3];
                    Arrays.fill(langs, -1);
                    int count = 0;
                    Iterator<ServerStoredDetails.GenericDetail> i = this.getDetails(ServerStoredDetails.SpokenLanguageDetail.class);
                    while (i.hasNext()) {
                        ServerStoredDetails.GenericDetail item = i.next();
                        langs[count++] = OperationSetServerStoredAccountInfoIcqImpl.getLanguageCode(((ServerStoredDetails.SpokenLanguageDetail)item).getLocale());
                    }
                    langs[count] = OperationSetServerStoredAccountInfoIcqImpl.getLanguageCode(((ServerStoredDetails.SpokenLanguageDetail)detail).getLocale());
                    cmd.setLanguages(langs[0], langs[1], langs[2]);
                    break;
                }
                case 800: {
                    cmd.setOriginCity(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 810: {
                    cmd.setOriginState(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 820: {
                    cmd.setOriginCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)detail).getLocale()));
                    break;
                }
                case 670: {
                    cmd.setWorkCity(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 680: {
                    cmd.setWorkState(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 710: {
                    cmd.setWorkPhone(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 720: {
                    cmd.setWorkFax(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 660: {
                    cmd.setWorkAddress(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 700: {
                    cmd.setWorkZip(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 690: {
                    cmd.setWorkCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)detail).getLocale()));
                    break;
                }
                case 430: {
                    cmd.setWorkCompany(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 440: {
                    cmd.setWorkDepartment(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 450: {
                    cmd.setWorkPosition(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 460: {
                    cmd.setWorkOccupationCode(OperationSetServerStoredAccountInfoIcqImpl.getOccupationCode(((ServerStoredDetails.StringDetail)detail).getString()));
                    break;
                }
                case 730: {
                    cmd.setWorkWebPage(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 600: {
                    cmd.setNotes(((ServerStoredDetails.StringDetail)detail).getString());
                    break;
                }
                case 490: {
                    ArrayList<InterestDetail> interests = new ArrayList<InterestDetail>();
                    Iterator<ServerStoredDetails.GenericDetail> intIter = this.getDetails(InterestDetail.class);
                    while (intIter.hasNext()) {
                        InterestDetail item = (InterestDetail)intIter.next();
                        interests.add(item);
                    }
                    this.setInterests(cmd, interests);
                    break;
                }
                case 790: {
                    int offset = ((ServerStoredDetails.TimeZoneDetail)detail).getTimeZone().getRawOffset() / 3600000;
                    cmd.setTimeZone(offset);
                }
            }
        }
        catch (IOException ex) {
            throw new OperationFailedException("Cannot add Detail!", 2);
        }
        this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(cmd, responseListener);
        responseListener.waitForEvent(5000);
        if (!responseListener.success) {
            if (responseListener.timeout) {
                throw new OperationFailedException("Adding Detail Failed!", 2);
            }
            throw new OperationFailedException("Adding Detail Failed!", 1);
        }
        this.infoRetreiver.detailsChanged(this.uin);
        this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.icqProvider, 1, null, detail);
    }

    private void setInterests(MetaFullInfoSetCmd cmd, List<InterestDetail> interests) throws IOException {
        int interestCount = interests.size();
        int[] interestsCategories = new int[interestCount];
        String[] interestsStr = new String[interestCount];
        for (int k = 0; k < interestCount; ++k) {
            interestsStr[k] = interests.get(k).getInterest();
            interestsCategories[k] = OperationSetServerStoredAccountInfoIcqImpl.getInterestCode(interestsStr[k]);
        }
        cmd.setInterests(interestsCategories, interestsStr);
    }

    public boolean removeDetail(ServerStoredDetails.GenericDetail detail) throws OperationFailedException {
        this.assertConnected();
        boolean isFound = false;
        ArrayList<ServerStoredDetails.GenericDetail> foundValues = new ArrayList<ServerStoredDetails.GenericDetail>();
        Iterator<ServerStoredDetails.GenericDetail> iter = this.infoRetreiver.getDetails(this.uin, detail.getClass());
        while (iter.hasNext()) {
            ServerStoredDetails.GenericDetail item = iter.next();
            if (item.equals((Object)detail)) {
                isFound = true;
                foundValues.add(detail);
                continue;
            }
            foundValues.add(item);
        }
        if (!isFound) {
            return false;
        }
        SuccessResponseListener responseListener = new SuccessResponseListener();
        MetaFullInfoSetCmd cmd = new MetaFullInfoSetCmd((long)Integer.parseInt(this.uin), this.reqID++);
        int typeOfDetail = supportedTypes.get(detail.getClass())[1];
        try {
            switch (typeOfDetail) {
                case 420: {
                    cmd.setCountry(-1);
                    break;
                }
                case 340: {
                    cmd.setNickName(null);
                    break;
                }
                case 320: {
                    cmd.setFirstName(null);
                    break;
                }
                case 330: {
                    cmd.setLastName(null);
                    break;
                }
                case 350: {
                    cmd.setEmail(null, false);
                    break;
                }
                case 400: {
                    cmd.setHomeCity(null);
                    break;
                }
                case 410: {
                    cmd.setHomeState(null);
                    break;
                }
                case 630: {
                    cmd.setHomePhone(null);
                    break;
                }
                case 640: {
                    cmd.setHomeFax(null);
                    break;
                }
                case 610: {
                    cmd.setAddress(null);
                    break;
                }
                case 650: {
                    cmd.setCellPhone(null);
                    break;
                }
                case 620: {
                    cmd.setHomeZip(null);
                    break;
                }
                case 380: {
                    cmd.setGender(0);
                    break;
                }
                case 531: {
                    cmd.setHomePage(null);
                    break;
                }
                case 570: {
                    cmd.setBirthDay(null);
                    break;
                }
                case 390: {
                    int[] langs = new int[3];
                    Arrays.fill(langs, -1);
                    cmd.setLanguages(langs[0], langs[1], langs[2]);
                    break;
                }
                case 800: {
                    cmd.setOriginCity(null);
                    break;
                }
                case 810: {
                    cmd.setOriginState(null);
                    break;
                }
                case 820: {
                    cmd.setOriginCountry(-1);
                    break;
                }
                case 670: {
                    cmd.setWorkCity(null);
                    break;
                }
                case 680: {
                    cmd.setWorkState(null);
                    break;
                }
                case 710: {
                    cmd.setWorkPhone(null);
                    break;
                }
                case 720: {
                    cmd.setWorkFax(null);
                    break;
                }
                case 660: {
                    cmd.setWorkAddress(null);
                    break;
                }
                case 700: {
                    cmd.setWorkZip(null);
                    break;
                }
                case 690: {
                    cmd.setWorkCountry(-1);
                    break;
                }
                case 430: {
                    cmd.setWorkCompany(null);
                    break;
                }
                case 440: {
                    cmd.setWorkDepartment(null);
                    break;
                }
                case 450: {
                    cmd.setWorkPosition(null);
                    break;
                }
                case 460: {
                    cmd.setWorkOccupationCode(0);
                    break;
                }
                case 730: {
                    cmd.setWorkWebPage(null);
                    break;
                }
                case 600: {
                    cmd.setNotes(null);
                    break;
                }
                case 490: {
                    cmd.setInterests(new int[]{0}, new String[]{""});
                    break;
                }
                case 790: {
                    cmd.setTimeZone(0);
                }
            }
        }
        catch (IOException ex) {
            throw new OperationFailedException("Cannot add Detail!", 2);
        }
        this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(cmd, responseListener);
        responseListener.waitForEvent(5000);
        if (!responseListener.success && responseListener.timeout) {
            throw new OperationFailedException("Replacing Detail Failed!", 2);
        }
        if (responseListener.success) {
            this.infoRetreiver.detailsChanged(this.uin);
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.icqProvider, 2, detail, null);
            return true;
        }
        return false;
    }

    public boolean replaceDetail(ServerStoredDetails.GenericDetail currentDetailValue, ServerStoredDetails.GenericDetail newDetailValue) throws ClassCastException, OperationFailedException {
        this.assertConnected();
        if (!newDetailValue.getClass().equals(currentDetailValue.getClass())) {
            throw new ClassCastException("New value to be replaced is not as the current one");
        }
        if (currentDetailValue.equals((Object)newDetailValue)) {
            return true;
        }
        boolean isFound = false;
        Vector<ServerStoredDetails.GenericDetail> alreadySetDetails = new Vector<ServerStoredDetails.GenericDetail>();
        Iterator<ServerStoredDetails.GenericDetail> iter = this.infoRetreiver.getDetails(this.uin, currentDetailValue.getClass());
        while (iter.hasNext()) {
            ServerStoredDetails.GenericDetail item = iter.next();
            if (item.equals((Object)currentDetailValue)) {
                isFound = true;
                alreadySetDetails.add(newDetailValue);
                continue;
            }
            alreadySetDetails.add(item);
        }
        if (!isFound) {
            return false;
        }
        if (newDetailValue instanceof ServerStoredDetails.ImageDetail) {
            if (this.iconListener == null) {
                this.iconListener = new IconUpdateListener();
                this.icqProvider.getAimConnection().getExternalServiceManager().getIconServiceArbiter().addIconRequestListener(new IconUpdateListener());
            }
            this.icqProvider.getAimConnection().getMyBuddyIconManager().requestSetIcon(ByteBlock.wrap(((ServerStoredDetails.ImageDetail)newDetailValue).getBytes()));
            this.infoRetreiver.detailsChanged(this.uin);
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.icqProvider, 3, currentDetailValue, newDetailValue);
            return true;
        }
        SuccessResponseListener responseListener = new SuccessResponseListener();
        MetaFullInfoSetCmd cmd = new MetaFullInfoSetCmd((long)Integer.parseInt(this.uin), this.reqID++);
        int typeOfDetail = supportedTypes.get(newDetailValue.getClass())[1];
        try {
            switch (typeOfDetail) {
                case 420: {
                    cmd.setCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)newDetailValue).getLocale()));
                    break;
                }
                case 340: {
                    cmd.setNickName(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 320: {
                    cmd.setFirstName(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 330: {
                    cmd.setLastName(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 350: {
                    cmd.setEmail(((ServerStoredDetails.StringDetail)newDetailValue).getString(), false);
                    break;
                }
                case 400: {
                    cmd.setHomeCity(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 410: {
                    cmd.setHomeState(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 630: {
                    cmd.setHomePhone(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 640: {
                    cmd.setHomeFax(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 610: {
                    cmd.setAddress(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 650: {
                    cmd.setCellPhone(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 620: {
                    cmd.setHomeZip(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 380: {
                    if (newDetailValue.equals((Object)ServerStoredDetails.GenderDetail.FEMALE)) {
                        cmd.setGender(1);
                        break;
                    }
                    if (newDetailValue.equals((Object)ServerStoredDetails.GenderDetail.MALE)) {
                        cmd.setGender(2);
                        break;
                    }
                    cmd.setGender(0);
                    break;
                }
                case 531: {
                    cmd.setHomePage(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 570: {
                    cmd.setBirthDay(((ServerStoredDetails.BirthDateDetail)newDetailValue).getCalendar().getTime());
                    break;
                }
                case 390: {
                    int[] langs = new int[3];
                    Arrays.fill(langs, -1);
                    int count = 0;
                    Iterator<ServerStoredDetails.GenericDetail> i = this.getDetails(ServerStoredDetails.SpokenLanguageDetail.class);
                    while (i.hasNext()) {
                        ServerStoredDetails.GenericDetail item = i.next();
                        if (item.equals((Object)currentDetailValue)) {
                            langs[count++] = OperationSetServerStoredAccountInfoIcqImpl.getLanguageCode(((ServerStoredDetails.SpokenLanguageDetail)newDetailValue).getLocale());
                            continue;
                        }
                        langs[count++] = OperationSetServerStoredAccountInfoIcqImpl.getLanguageCode(((ServerStoredDetails.SpokenLanguageDetail)item).getLocale());
                    }
                    cmd.setLanguages(langs[0], langs[1], langs[2]);
                    break;
                }
                case 800: {
                    cmd.setOriginCity(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 810: {
                    cmd.setOriginState(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 820: {
                    cmd.setOriginCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)newDetailValue).getLocale()));
                    break;
                }
                case 670: {
                    cmd.setWorkCity(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 680: {
                    cmd.setWorkState(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 710: {
                    cmd.setWorkPhone(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 720: {
                    cmd.setWorkFax(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 660: {
                    cmd.setWorkAddress(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 700: {
                    cmd.setWorkZip(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 690: {
                    cmd.setWorkCountry(OperationSetServerStoredAccountInfoIcqImpl.getCountryCode(((ServerStoredDetails.CountryDetail)newDetailValue).getLocale()));
                    break;
                }
                case 430: {
                    cmd.setWorkCompany(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 440: {
                    cmd.setWorkDepartment(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 450: {
                    cmd.setWorkPosition(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 460: {
                    cmd.setWorkOccupationCode(OperationSetServerStoredAccountInfoIcqImpl.getOccupationCode(((ServerStoredDetails.StringDetail)newDetailValue).getString()));
                    break;
                }
                case 730: {
                    cmd.setWorkWebPage(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 600: {
                    cmd.setNotes(((ServerStoredDetails.StringDetail)newDetailValue).getString());
                    break;
                }
                case 490: {
                    ArrayList<InterestDetail> interests = new ArrayList<InterestDetail>();
                    Iterator<ServerStoredDetails.GenericDetail> intIter = this.getDetails(InterestDetail.class);
                    while (intIter.hasNext()) {
                        InterestDetail item = (InterestDetail)intIter.next();
                        if (item.equals(currentDetailValue)) {
                            interests.add((InterestDetail)newDetailValue);
                            continue;
                        }
                        interests.add(item);
                    }
                    this.setInterests(cmd, interests);
                    break;
                }
                case 790: {
                    int offset = ((ServerStoredDetails.TimeZoneDetail)newDetailValue).getTimeZone().getRawOffset() / 3600000;
                    cmd.setTimeZone(offset);
                }
            }
        }
        catch (IOException ex) {
            throw new OperationFailedException("Cannot add Detail!", 2);
        }
        this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(cmd, responseListener);
        responseListener.waitForEvent(5000);
        if (!responseListener.success && responseListener.timeout) {
            throw new OperationFailedException("Replacing Detail Failed!", 2);
        }
        if (responseListener.success) {
            this.infoRetreiver.detailsChanged(this.uin);
            this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.icqProvider, 3, currentDetailValue, newDetailValue);
            return true;
        }
        return false;
    }

    public void save() throws OperationFailedException {
    }

    private ServerStoredDetails.ImageDetail getImage() {
        if (this.accountImage != null) {
            return this.accountImage;
        }
        if (this.iconListener == null) {
            this.iconListener = new IconUpdateListener();
            this.icqProvider.getAimConnection().getExternalServiceManager().getIconServiceArbiter().addIconRequestListener(new IconUpdateListener());
        }
        ExtraInfoData infoData = new ExtraInfoData(1, ByteBlock.EMPTY_BLOCK);
        this.icqProvider.getAimConnection().getExternalServiceManager().getIconServiceArbiter().requestIcon(new Screenname(this.uin), infoData);
        this.iconListener.waitForImage(22000L);
        return this.accountImage;
    }

    static Locale getCountry(int code) {
        if (code == 0 || code == 9999) {
            return null;
        }
        String cryStr = countryIndexToLocaleString.get(code);
        return cryStr == null ? null : new Locale("", cryStr);
    }

    static int getCountryCode(Locale cLocale) {
        if (cLocale == null) {
            return 0;
        }
        for (Map.Entry<Integer, String> entry : countryIndexToLocaleString.entrySet()) {
            Integer key = entry.getKey();
            String countryString = entry.getValue().toUpperCase();
            if (!countryString.equals(cLocale.getCountry())) continue;
            return key;
        }
        return 0;
    }

    static Locale getSpokenLanguage(int code) {
        if (code == 0 || code == 255) {
            return null;
        }
        return spokenLanguages[code];
    }

    static int getLanguageCode(Locale locale) {
        for (int i = 1; i < spokenLanguages.length; ++i) {
            if (!spokenLanguages[i].equals(locale)) continue;
            return i;
        }
        return -1;
    }

    static int getOccupationCode(String occupationStr) {
        for (int i = 0; i < occupations.length; ++i) {
            if (!occupations[i].equals(occupationStr)) continue;
            return i;
        }
        return 0;
    }

    static int getInterestCode(String value) {
        for (int i = 0; i < occupations.length; ++i) {
            if (!occupations[i].equals(value)) continue;
            return i;
        }
        return 0;
    }

    static {
        supportedTypes.put(ServerStoredDetails.ImageDetail.class, new int[]{1});
        supportedTypes.put(ServerStoredDetails.CountryDetail.class, new int[]{1, 420});
        supportedTypes.put(ServerStoredDetails.NicknameDetail.class, new int[]{1, 340});
        supportedTypes.put(ServerStoredDetails.FirstNameDetail.class, new int[]{1, 320});
        supportedTypes.put(ServerStoredDetails.LastNameDetail.class, new int[]{1, 330});
        supportedTypes.put(ServerStoredDetails.EmailAddressDetail.class, new int[]{5, 350});
        supportedTypes.put(ServerStoredDetails.CityDetail.class, new int[]{1, 400});
        supportedTypes.put(ServerStoredDetails.ProvinceDetail.class, new int[]{1, 410});
        supportedTypes.put(ServerStoredDetails.PhoneNumberDetail.class, new int[]{1, 630});
        supportedTypes.put(ServerStoredDetails.FaxDetail.class, new int[]{1, 640});
        supportedTypes.put(ServerStoredDetails.AddressDetail.class, new int[]{1, 610});
        supportedTypes.put(ServerStoredDetails.MobilePhoneDetail.class, new int[]{1, 650});
        supportedTypes.put(ServerStoredDetails.PostalCodeDetail.class, new int[]{1, 620});
        supportedTypes.put(ServerStoredDetails.GenderDetail.class, new int[]{1, 380});
        supportedTypes.put(ServerStoredDetails.WebPageDetail.class, new int[]{1, 531});
        supportedTypes.put(ServerStoredDetails.BirthDateDetail.class, new int[]{1, 570});
        supportedTypes.put(ServerStoredDetails.SpokenLanguageDetail.class, new int[]{3, 390});
        supportedTypes.put(OriginCityDetail.class, new int[]{1, 800});
        supportedTypes.put(OriginProvinceDetail.class, new int[]{1, 810});
        supportedTypes.put(OriginCountryDetail.class, new int[]{1, 820});
        supportedTypes.put(ServerStoredDetails.WorkCityDetail.class, new int[]{1, 670});
        supportedTypes.put(ServerStoredDetails.WorkProvinceDetail.class, new int[]{1, 680});
        supportedTypes.put(ServerStoredDetails.WorkPhoneDetail.class, new int[]{1, 710});
        supportedTypes.put(WorkFaxDetail.class, new int[]{1, 720});
        supportedTypes.put(ServerStoredDetails.WorkAddressDetail.class, new int[]{1, 660});
        supportedTypes.put(ServerStoredDetails.WorkPostalCodeDetail.class, new int[]{1, 700});
        supportedTypes.put(ServerStoredDetails.WorkCountryDetail.class, new int[]{1, 690});
        supportedTypes.put(ServerStoredDetails.WorkOrganizationNameDetail.class, new int[]{1, 430});
        supportedTypes.put(WorkDepartmentNameDetail.class, new int[]{1, 440});
        supportedTypes.put(WorkPositionNameDetail.class, new int[]{1, 450});
        supportedTypes.put(WorkOcupationDetail.class, new int[]{1, 460});
        supportedTypes.put(ServerStoredDetails.WorkPageDetail.class, new int[]{1, 730});
        supportedTypes.put(NotesDetail.class, new int[]{1, 600});
        supportedTypes.put(InterestDetail.class, new int[]{10, 490});
        supportedTypes.put(ServerStoredDetails.TimeZoneDetail.class, new int[]{1, 790});
        genders = new ServerStoredDetails.GenderDetail[]{null, ServerStoredDetails.GenderDetail.FEMALE, ServerStoredDetails.GenderDetail.MALE};
        spokenLanguages = new Locale[]{null, new Locale("ar"), new Locale("bh"), new Locale("bg"), new Locale("my"), new Locale("zh", "hk"), new Locale("ca"), Locale.CHINA, new Locale("hr"), new Locale("cs"), new Locale("da"), new Locale("nl"), new Locale("en"), new Locale("eo"), new Locale("et"), new Locale("fa"), new Locale("fi"), new Locale("fr"), new Locale("gd"), new Locale("de"), new Locale("el"), new Locale("he"), new Locale("hi"), new Locale("hu"), new Locale("is"), new Locale("id"), new Locale("it"), new Locale("ja"), new Locale("km"), new Locale("ko"), new Locale("lo"), new Locale("lv"), new Locale("lt"), new Locale("ms"), new Locale("no"), new Locale("pl"), new Locale("pt"), new Locale("ro"), new Locale("ru"), new Locale("sr"), new Locale("sk"), new Locale("sl"), new Locale("so"), new Locale("es"), new Locale("sw"), new Locale("sv"), new Locale("tl"), new Locale("tt"), new Locale("th"), new Locale("tr"), new Locale("uk"), new Locale("ur"), new Locale("vi"), new Locale("yi"), new Locale("yo"), new Locale("af"), new Locale("bs"), new Locale("fa"), new Locale("sq"), new Locale("hy"), new Locale("pa"), new Locale("ch"), new Locale("mn"), new Locale("zh"), Locale.TAIWAN, new Locale("mk"), new Locale("sd"), new Locale("cy"), new Locale("az"), new Locale("ku"), new Locale("gu"), new Locale("ta"), new Locale("be"), null};
        occupations = new String[]{"not specified", "academic", "administrative", "art/entertainment", "college student", "computers", "community & social", "education", "engineering", "financial services", "government", "high school student", "home", "ICQ - providing help", "law", "managerial", "manufacturing", "medical/health", "military", "non-government organization", "professional", "retail", "retired", "science & research", "sports", "technical", "university student", "web building", "other services"};
        interestsCategories = new String[]{"not specified", "art", "cars", "celebrity fans", "collections", "computers", "culture", "fitness", "games", "hobbies", "ICQ - help", "internet", "lifestyle", "movies", "music", "outdoors", "parenting", "pets and animals", "religion", "science", "skills", "sports", "web design", "ecology", "news and media", "government", "business", "mystics", "travel", "astronomy", "space", "clothing", "parties", "women", "social science", "60's", "70's", "40's", "50's", "finance and corporate", "entertainment", "consumer electronics", "retail stores", "health and beauty", "media", "household products", "mail order catalogue", "business services", "audio and visual", "sporting and athletic", "publishing", "home automation"};
        countryIndexToLocaleString = new Hashtable<Integer, String>();
        countryIndexToLocaleString.put(1, "us");
        countryIndexToLocaleString.put(101, "ai");
        countryIndexToLocaleString.put(102, "ag");
        countryIndexToLocaleString.put(1021, "ag");
        countryIndexToLocaleString.put(103, "bs");
        countryIndexToLocaleString.put(104, "bb");
        countryIndexToLocaleString.put(105, "bm");
        countryIndexToLocaleString.put(106, "vg");
        countryIndexToLocaleString.put(107, "ca");
        countryIndexToLocaleString.put(108, "ky");
        countryIndexToLocaleString.put(109, "dm");
        countryIndexToLocaleString.put(110, "do");
        countryIndexToLocaleString.put(111, "gd");
        countryIndexToLocaleString.put(112, "jm");
        countryIndexToLocaleString.put(113, "ms");
        countryIndexToLocaleString.put(114, "kn");
        countryIndexToLocaleString.put(1141, "kn");
        countryIndexToLocaleString.put(115, "kn");
        countryIndexToLocaleString.put(116, "vc");
        countryIndexToLocaleString.put(117, "tt");
        countryIndexToLocaleString.put(118, "tc");
        countryIndexToLocaleString.put(120, "ag");
        countryIndexToLocaleString.put(121, "pr");
        countryIndexToLocaleString.put(122, "lc");
        countryIndexToLocaleString.put(123, "vi");
        countryIndexToLocaleString.put(178, "es");
        countryIndexToLocaleString.put(20, "eg");
        countryIndexToLocaleString.put(212, "ma");
        countryIndexToLocaleString.put(213, "dz");
        countryIndexToLocaleString.put(216, "tn");
        countryIndexToLocaleString.put(218, "ly");
        countryIndexToLocaleString.put(220, "gm");
        countryIndexToLocaleString.put(221, "sn");
        countryIndexToLocaleString.put(222, "mr");
        countryIndexToLocaleString.put(223, "ml");
        countryIndexToLocaleString.put(224, "pg");
        countryIndexToLocaleString.put(225, "ci");
        countryIndexToLocaleString.put(226, "bf");
        countryIndexToLocaleString.put(227, "ne");
        countryIndexToLocaleString.put(228, "tg");
        countryIndexToLocaleString.put(229, "bj");
        countryIndexToLocaleString.put(230, "mu");
        countryIndexToLocaleString.put(231, "lr");
        countryIndexToLocaleString.put(232, "sl");
        countryIndexToLocaleString.put(233, "gh");
        countryIndexToLocaleString.put(234, "ng");
        countryIndexToLocaleString.put(235, "td");
        countryIndexToLocaleString.put(236, "cf");
        countryIndexToLocaleString.put(237, "cm");
        countryIndexToLocaleString.put(238, "cv");
        countryIndexToLocaleString.put(239, "st");
        countryIndexToLocaleString.put(240, "gq");
        countryIndexToLocaleString.put(241, "ga");
        countryIndexToLocaleString.put(242, "cg");
        countryIndexToLocaleString.put(243, "cd");
        countryIndexToLocaleString.put(244, "ao");
        countryIndexToLocaleString.put(245, "gw");
        countryIndexToLocaleString.put(248, "sc");
        countryIndexToLocaleString.put(249, "sd");
        countryIndexToLocaleString.put(250, "rw");
        countryIndexToLocaleString.put(251, "et");
        countryIndexToLocaleString.put(252, "so");
        countryIndexToLocaleString.put(253, "dj");
        countryIndexToLocaleString.put(254, "ke");
        countryIndexToLocaleString.put(255, "tz");
        countryIndexToLocaleString.put(256, "ug");
        countryIndexToLocaleString.put(257, "bi");
        countryIndexToLocaleString.put(258, "mz");
        countryIndexToLocaleString.put(260, "zm");
        countryIndexToLocaleString.put(261, "mg");
        countryIndexToLocaleString.put(263, "zw");
        countryIndexToLocaleString.put(264, "na");
        countryIndexToLocaleString.put(265, "mw");
        countryIndexToLocaleString.put(266, "ls");
        countryIndexToLocaleString.put(267, "bw");
        countryIndexToLocaleString.put(268, "sz");
        countryIndexToLocaleString.put(269, "yt");
        countryIndexToLocaleString.put(2691, "km");
        countryIndexToLocaleString.put(27, "za");
        countryIndexToLocaleString.put(290, "sh");
        countryIndexToLocaleString.put(291, "er");
        countryIndexToLocaleString.put(297, "aw");
        countryIndexToLocaleString.put(299, "gl");
        countryIndexToLocaleString.put(30, "gr");
        countryIndexToLocaleString.put(31, "nl");
        countryIndexToLocaleString.put(32, "be");
        countryIndexToLocaleString.put(33, "fr");
        countryIndexToLocaleString.put(34, "es");
        countryIndexToLocaleString.put(350, "gi");
        countryIndexToLocaleString.put(351, "pt");
        countryIndexToLocaleString.put(352, "lu");
        countryIndexToLocaleString.put(353, "ie");
        countryIndexToLocaleString.put(354, "is");
        countryIndexToLocaleString.put(355, "al");
        countryIndexToLocaleString.put(356, "mt");
        countryIndexToLocaleString.put(357, "cy");
        countryIndexToLocaleString.put(358, "fi");
        countryIndexToLocaleString.put(359, "bg");
        countryIndexToLocaleString.put(36, "hu");
        countryIndexToLocaleString.put(370, "lt");
        countryIndexToLocaleString.put(371, "lv");
        countryIndexToLocaleString.put(372, "ee");
        countryIndexToLocaleString.put(373, "md");
        countryIndexToLocaleString.put(374, "am");
        countryIndexToLocaleString.put(375, "by");
        countryIndexToLocaleString.put(376, "ad");
        countryIndexToLocaleString.put(377, "mc");
        countryIndexToLocaleString.put(378, "sm");
        countryIndexToLocaleString.put(379, "va");
        countryIndexToLocaleString.put(380, "ua");
        countryIndexToLocaleString.put(3811, "cs");
        countryIndexToLocaleString.put(382, "cs");
        countryIndexToLocaleString.put(385, "hr");
        countryIndexToLocaleString.put(386, "si");
        countryIndexToLocaleString.put(387, "ba");
        countryIndexToLocaleString.put(389, "mk");
        countryIndexToLocaleString.put(39, "it");
        countryIndexToLocaleString.put(40, "ro");
        countryIndexToLocaleString.put(41, "ch");
        countryIndexToLocaleString.put(4101, "li");
        countryIndexToLocaleString.put(42, "cz");
        countryIndexToLocaleString.put(4201, "sk");
        countryIndexToLocaleString.put(43, "at");
        countryIndexToLocaleString.put(44, "gb");
        countryIndexToLocaleString.put(45, "dk");
        countryIndexToLocaleString.put(46, "se");
        countryIndexToLocaleString.put(47, "no");
        countryIndexToLocaleString.put(48, "pl");
        countryIndexToLocaleString.put(49, "de");
        countryIndexToLocaleString.put(501, "bz");
        countryIndexToLocaleString.put(502, "gt");
        countryIndexToLocaleString.put(503, "sv");
        countryIndexToLocaleString.put(504, "hn");
        countryIndexToLocaleString.put(505, "ni");
        countryIndexToLocaleString.put(506, "cr");
        countryIndexToLocaleString.put(507, "pa");
        countryIndexToLocaleString.put(508, "pm");
        countryIndexToLocaleString.put(509, "ht");
        countryIndexToLocaleString.put(51, "pe");
        countryIndexToLocaleString.put(52, "mx");
        countryIndexToLocaleString.put(53, "cu");
        countryIndexToLocaleString.put(54, "ar");
        countryIndexToLocaleString.put(55, "br");
        countryIndexToLocaleString.put(56, "cl");
        countryIndexToLocaleString.put(57, "co");
        countryIndexToLocaleString.put(58, "ve");
        countryIndexToLocaleString.put(590, "gp");
        countryIndexToLocaleString.put(5901, "an");
        countryIndexToLocaleString.put(5902, "an");
        countryIndexToLocaleString.put(591, "bo");
        countryIndexToLocaleString.put(592, "gy");
        countryIndexToLocaleString.put(593, "ec");
        countryIndexToLocaleString.put(594, "gy");
        countryIndexToLocaleString.put(595, "py");
        countryIndexToLocaleString.put(596, "mq");
        countryIndexToLocaleString.put(597, "sr");
        countryIndexToLocaleString.put(598, "uy");
        countryIndexToLocaleString.put(599, "an");
        countryIndexToLocaleString.put(60, "my");
        countryIndexToLocaleString.put(61, "au");
        countryIndexToLocaleString.put(6101, "cc");
        countryIndexToLocaleString.put(6102, "cc");
        countryIndexToLocaleString.put(62, "id");
        countryIndexToLocaleString.put(63, "ph");
        countryIndexToLocaleString.put(64, "nz");
        countryIndexToLocaleString.put(65, "sg");
        countryIndexToLocaleString.put(66, "th");
        countryIndexToLocaleString.put(671, "gu");
        countryIndexToLocaleString.put(672, "cx");
        countryIndexToLocaleString.put(6722, "nf");
        countryIndexToLocaleString.put(673, "bn");
        countryIndexToLocaleString.put(674, "nr");
        countryIndexToLocaleString.put(675, "pg");
        countryIndexToLocaleString.put(676, "to");
        countryIndexToLocaleString.put(677, "sb");
        countryIndexToLocaleString.put(678, "vu");
        countryIndexToLocaleString.put(679, "fj");
        countryIndexToLocaleString.put(680, "pw");
        countryIndexToLocaleString.put(681, "wf");
        countryIndexToLocaleString.put(682, "ck");
        countryIndexToLocaleString.put(683, "nu");
        countryIndexToLocaleString.put(684, "as");
        countryIndexToLocaleString.put(685, "ws");
        countryIndexToLocaleString.put(686, "ki");
        countryIndexToLocaleString.put(687, "nc");
        countryIndexToLocaleString.put(688, "tv");
        countryIndexToLocaleString.put(689, "pf");
        countryIndexToLocaleString.put(690, "tk");
        countryIndexToLocaleString.put(691, "fm");
        countryIndexToLocaleString.put(692, "mh");
        countryIndexToLocaleString.put(7, "ru");
        countryIndexToLocaleString.put(705, "kz");
        countryIndexToLocaleString.put(706, "kg");
        countryIndexToLocaleString.put(708, "tj");
        countryIndexToLocaleString.put(709, "tm");
        countryIndexToLocaleString.put(711, "uz");
        countryIndexToLocaleString.put(81, "jp");
        countryIndexToLocaleString.put(82, "kr");
        countryIndexToLocaleString.put(84, "vn");
        countryIndexToLocaleString.put(850, "kp");
        countryIndexToLocaleString.put(852, "hk");
        countryIndexToLocaleString.put(853, "mo");
        countryIndexToLocaleString.put(855, "kh");
        countryIndexToLocaleString.put(856, "la");
        countryIndexToLocaleString.put(86, "cn");
        countryIndexToLocaleString.put(880, "bd");
        countryIndexToLocaleString.put(886, "tw");
        countryIndexToLocaleString.put(90, "tr");
        countryIndexToLocaleString.put(91, "in");
        countryIndexToLocaleString.put(92, "pk");
        countryIndexToLocaleString.put(93, "af");
        countryIndexToLocaleString.put(94, "lk");
        countryIndexToLocaleString.put(95, "mm");
        countryIndexToLocaleString.put(960, "mv");
        countryIndexToLocaleString.put(961, "lb");
        countryIndexToLocaleString.put(962, "jo");
        countryIndexToLocaleString.put(963, "sy");
        countryIndexToLocaleString.put(964, "iq");
        countryIndexToLocaleString.put(965, "kw");
        countryIndexToLocaleString.put(966, "sa");
        countryIndexToLocaleString.put(967, "ye");
        countryIndexToLocaleString.put(968, "om");
        countryIndexToLocaleString.put(971, "ae");
        countryIndexToLocaleString.put(972, "il");
        countryIndexToLocaleString.put(973, "bh");
        countryIndexToLocaleString.put(974, "qa");
        countryIndexToLocaleString.put(975, "bt");
        countryIndexToLocaleString.put(976, "mn");
        countryIndexToLocaleString.put(977, "np");
        countryIndexToLocaleString.put(98, "ir");
        countryIndexToLocaleString.put(994, "az");
        countryIndexToLocaleString.put(995, "ge");
    }

    private class IconUpdateListener
    implements IconRequestListener {
        private IconUpdateListener() {
        }

        @Override
        public void buddyIconCleared(IconService iconService, Screenname screenname, ExtraInfoData extraInfoData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buddyIconUpdated(IconService iconService, Screenname screenname, ExtraInfoData extraInfoData, ByteBlock byteBlock) {
            if (byteBlock != null && screenname.getFormatted().equals(OperationSetServerStoredAccountInfoIcqImpl.this.uin)) {
                IconUpdateListener iconUpdateListener = this;
                synchronized (iconUpdateListener) {
                    byte[] img = byteBlock.toByteArray();
                    if (img != null && img.length > 0) {
                        OperationSetServerStoredAccountInfoIcqImpl.this.accountImage = new ServerStoredDetails.ImageDetail("Account Image", img);
                    }
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForImage(long waitFor) {
            IconUpdateListener iconUpdateListener = this;
            synchronized (iconUpdateListener) {
                block6: {
                    try {
                        if (OperationSetServerStoredAccountInfoIcqImpl.this.accountImage == null) {
                            this.wait(waitFor);
                        }
                    }
                    catch (InterruptedException ex) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                    }
                }
            }
        }
    }

    public static class OriginCountryDetail
    extends ServerStoredDetails.CountryDetail {
        public OriginCountryDetail(Locale locale) {
            super(locale);
        }
    }

    public static class InterestDetail
    extends ServerStoredDetails.InterestDetail {
        private String category = null;

        public InterestDetail(String value, String category) {
            super(value);
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }
    }

    public static class NotesDetail
    extends ServerStoredDetails.StringDetail {
        public NotesDetail(String value) {
            super("Notes", value);
        }
    }

    public static class WorkOcupationDetail
    extends ServerStoredDetails.StringDetail {
        public WorkOcupationDetail(String value) {
            super("Work Ocupation", value);
        }
    }

    public static class WorkPositionNameDetail
    extends ServerStoredDetails.StringDetail {
        public WorkPositionNameDetail(String workPos) {
            super("Work Position", workPos);
        }
    }

    public static class WorkDepartmentNameDetail
    extends ServerStoredDetails.NameDetail {
        public WorkDepartmentNameDetail(String workDepartmentName) {
            super("Work Department Name", workDepartmentName);
        }
    }

    public static class WorkFaxDetail
    extends ServerStoredDetails.PhoneNumberDetail {
        public WorkFaxDetail(String number) {
            super(number);
            this.detailDisplayName = "WorkFax";
        }
    }

    public static class OriginPostalCodeDetail
    extends ServerStoredDetails.PostalCodeDetail {
        public OriginPostalCodeDetail(String postalCode) {
            super(postalCode);
        }
    }

    public static class OriginProvinceDetail
    extends ServerStoredDetails.ProvinceDetail {
        public OriginProvinceDetail(String workProvince) {
            super(workProvince);
        }
    }

    public static class OriginCityDetail
    extends ServerStoredDetails.CityDetail {
        public OriginCityDetail(String cityName) {
            super(cityName);
        }
    }

    private static class SuccessResponseListener
    implements SnacRequestListener {
        public Object waitingForResponseLock = new Object();
        private boolean ran = false;
        boolean success = false;
        private boolean timeout = false;

        private SuccessResponseListener() {
        }

        @Override
        public void handleSent(SnacRequestSentEvent evt) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTimeout(SnacRequestTimeoutEvent event) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Timeout!");
            }
            Object object = this.waitingForResponseLock;
            synchronized (object) {
                if (this.ran) {
                    return;
                }
                this.ran = true;
                this.timeout = true;
                this.waitingForResponseLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent evt) {
            Object object = this.waitingForResponseLock;
            synchronized (object) {
                MetaFullInfoAckCmd cmd;
                if (this.ran) {
                    return;
                }
                this.ran = true;
                if (evt.getSnacCommand() instanceof MetaFullInfoAckCmd && (cmd = (MetaFullInfoAckCmd)evt.getSnacCommand()).isCommandSuccesful()) {
                    this.success = true;
                }
                this.waitingForResponseLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(int milliseconds) {
            Object object = this.waitingForResponseLock;
            synchronized (object) {
                if (this.ran) {
                    return;
                }
                try {
                    this.waitingForResponseLock.wait(milliseconds);
                }
                catch (InterruptedException exc) {
                    logger.error((Object)"Interrupted while waiting for response.", (Throwable)exc);
                }
            }
        }
    }
}

