/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snac.CmdType;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateClassInfo
implements Writable {
    private static final int RATECLASSINFO_SIZE = 35;
    private final int rateClass;
    private final long windowSize;
    private final long warnAvg;
    private final long limitedAvg;
    private final long clearAvg;
    private final long disconnectAvg;
    private final long currentAvg;
    private final long max;
    private final long timeSinceLastCommand;
    private final int currentState;
    private List<CmdType> commands = null;

    @Nullable
    public static RateClassInfo readRateClassInfo(ByteBlock block) {
        if (block.getLength() < 35) {
            return null;
        }
        return new RateClassInfo(block);
    }

    private RateClassInfo(ByteBlock block) {
        this.rateClass = BinaryTools.getUShort(block, 0);
        this.windowSize = BinaryTools.getUInt(block, 2);
        this.clearAvg = BinaryTools.getUInt(block, 6);
        this.warnAvg = BinaryTools.getUInt(block, 10);
        this.limitedAvg = BinaryTools.getUInt(block, 14);
        this.disconnectAvg = BinaryTools.getUInt(block, 18);
        this.currentAvg = BinaryTools.getUInt(block, 22);
        this.max = BinaryTools.getUInt(block, 26);
        if (block.getLength() >= 34) {
            this.timeSinceLastCommand = BinaryTools.getUInt(block, 30);
            this.currentState = block.getLength() >= 35 ? (int)BinaryTools.getUByte(block, 34) : -1;
        } else {
            this.timeSinceLastCommand = 0L;
            this.currentState = -1;
        }
    }

    synchronized void setCommands(Collection<? extends CmdType> commands) {
        this.commands = DefensiveTools.getSafeListCopy(commands, "commands");
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, long timeSinceLastCommand, int currentState) {
        DefensiveTools.checkRange(rateClass, "rateClass", 0);
        DefensiveTools.checkRange(windowSize, "windowSize", 0L);
        DefensiveTools.checkRange(clearAvg, "clearAvg", 0L);
        DefensiveTools.checkRange(warnAvg, "warnAvg", 0L);
        DefensiveTools.checkRange(limitedAvg, "limitedAvg", 0L);
        DefensiveTools.checkRange(disconnectAvg, "disconnectAvg", 0L);
        DefensiveTools.checkRange(currentAvg, "currentAvg", 0L);
        DefensiveTools.checkRange(max, "max", 0L);
        DefensiveTools.checkRange(timeSinceLastCommand, "timeSinceLastCommand", -1L);
        DefensiveTools.checkRange(currentState, "currentState", -1);
        this.rateClass = rateClass;
        this.windowSize = windowSize;
        this.clearAvg = clearAvg;
        this.warnAvg = warnAvg;
        this.limitedAvg = limitedAvg;
        this.disconnectAvg = disconnectAvg;
        this.currentAvg = currentAvg;
        this.max = max;
        this.timeSinceLastCommand = timeSinceLastCommand;
        this.currentState = currentState;
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max, 0L, 0);
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, Collection<? extends CmdType> cmds) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max);
        this.setCommands(cmds);
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, long lastTime, int currentState, Collection<? extends CmdType> cmds) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max, lastTime, currentState);
        this.setCommands(cmds);
    }

    public final int getRateClass() {
        return this.rateClass;
    }

    public final long getWindowSize() {
        return this.windowSize;
    }

    public final long getWarnAvg() {
        return this.warnAvg;
    }

    public final long getLimitedAvg() {
        return this.limitedAvg;
    }

    public final long getClearAvg() {
        return this.clearAvg;
    }

    public final long getDisconnectAvg() {
        return this.disconnectAvg;
    }

    public final long getCurrentAvg() {
        return this.currentAvg;
    }

    public final long getMax() {
        return this.max;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public long getTimeSinceLastCommand() {
        return this.timeSinceLastCommand;
    }

    public final synchronized List<CmdType> getCommands() {
        return this.commands;
    }

    @Override
    public long getWritableLength() {
        return 35L;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.rateClass);
        BinaryTools.writeUInt(out, this.windowSize);
        BinaryTools.writeUInt(out, this.clearAvg);
        BinaryTools.writeUInt(out, this.warnAvg);
        BinaryTools.writeUInt(out, this.limitedAvg);
        BinaryTools.writeUInt(out, this.disconnectAvg);
        BinaryTools.writeUInt(out, this.currentAvg);
        BinaryTools.writeUInt(out, this.max);
        if (this.timeSinceLastCommand != -1L) {
            BinaryTools.writeUInt(out, this.timeSinceLastCommand);
            if (this.currentState != -1) {
                BinaryTools.writeUByte(out, this.currentState);
            }
        }
    }

    public synchronized String toString() {
        return "RateClassInfo for class " + this.rateClass + ", currentAvg=" + this.currentAvg + ", windowSize=" + this.windowSize + ", clearAvg=" + this.clearAvg + ", warnAvg=" + this.warnAvg + ", limitedAvg=" + this.limitedAvg + ", disconnectAvg=" + this.disconnectAvg + ", max=" + this.max + ", timeSinceLastCommand=" + this.timeSinceLastCommand + ", currentState=" + this.currentState + ", families: " + (this.commands == null ? "none" : "" + this.commands.size());
    }
}

