/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.accountinfo;

import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import net.java.sip.communicator.plugin.accountinfo.AccountInfoActivator;
import net.java.sip.communicator.plugin.accountinfo.AccountInfoMenuItemComponent;
import net.java.sip.communicator.plugin.accountinfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.FramedImageWithMenu;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.SelectAvatarMenu;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;

public class AccountDetailsPanel
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(AccountDetailsPanel.class);
    private final Map<Class<? extends ServerStoredDetails.GenericDetail>, JTextField> detailToTextField = new HashMap<Class<? extends ServerStoredDetails.GenericDetail>, JTextField>();
    ProtocolProviderService protocolProvider;
    private OperationSetServerStoredAccountInfo accountInfoOpSet;
    private JTextField displayNameField;
    private JTextField firstNameField;
    private JTextField middleNameField;
    private JTextField lastNameField;
    private JTextField nicknameField;
    private JTextField urlField;
    private JTextField streetAddressField;
    private JTextField cityField;
    private JTextField regionField;
    private JTextField postalCodeField;
    private JTextField countryField;
    private JTextField phoneField;
    private JTextField workPhoneField;
    private JTextField mobilePhoneField;
    private JTextField emailField;
    private JTextField workEmailField;
    private JTextField organizationField;
    private JTextField jobTitleField;
    private JTextArea aboutMeArea;
    private JTextField genderField;
    private JTextField ageField;
    private JDateChooser birthDayCalendar;
    private JRadioButton globalIcon;
    private JRadioButton localIcon;
    private FramedImageWithMenu imageWithMenu;
    private JButton applyButton = new JButton(Resources.getString("service.gui.APPLY"));
    private JPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private ServerStoredDetails.DisplayNameDetail displayNameDetail;
    private ServerStoredDetails.FirstNameDetail firstNameDetail;
    private ServerStoredDetails.MiddleNameDetail middleNameDetail;
    private ServerStoredDetails.LastNameDetail lastNameDetail;
    private ServerStoredDetails.NicknameDetail nicknameDetail;
    private ServerStoredDetails.URLDetail urlDetail;
    private ServerStoredDetails.AddressDetail streetAddressDetail;
    private ServerStoredDetails.CityDetail cityDetail;
    private ServerStoredDetails.ProvinceDetail regionDetail;
    private ServerStoredDetails.PostalCodeDetail postalCodeDetail;
    private ServerStoredDetails.CountryDetail countryDetail;
    private ServerStoredDetails.PhoneNumberDetail phoneDetail;
    private ServerStoredDetails.WorkPhoneDetail workPhoneDetail;
    private ServerStoredDetails.MobilePhoneDetail mobilePhoneDetail;
    private ServerStoredDetails.EmailAddressDetail emailDetail;
    private ServerStoredDetails.WorkEmailAddressDetail workEmailDetail;
    private ServerStoredDetails.WorkOrganizationNameDetail organizationDetail;
    private ServerStoredDetails.JobTitleDetail jobTitleDetail;
    private ServerStoredDetails.AboutMeDetail aboutMeDetail;
    private ServerStoredDetails.GenderDetail genderDetail;
    private ServerStoredDetails.BirthDateDetail birthDateDetail;
    private ServerStoredDetails.ImageDetail avatarDetail;
    private JPanel valuesPanel;
    private JScrollPane mainScrollPane;
    private AccountInfoMenuItemComponent.AccountInfoDialog dialog;

    public AccountDetailsPanel(AccountInfoMenuItemComponent.AccountInfoDialog dialog, ProtocolProviderService protocolProvider) {
        this.dialog = dialog;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(600, 400));
        this.protocolProvider = protocolProvider;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.accountInfoOpSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
        if (this.accountInfoOpSet == null) {
            this.initUnsupportedPanel();
        } else {
            this.initSummaryPanel();
            if (protocolProvider.isRegistered()) {
                this.loadDetails();
            }
        }
    }

    private void initUnsupportedPanel() {
        JTextArea unsupportedTextArea = new JTextArea(Resources.getString("plugin.accountinfo.NOT_SUPPORTED"));
        unsupportedTextArea.setEditable(false);
        unsupportedTextArea.setOpaque(false);
        TransparentPanel unsupportedPanel = new TransparentPanel();
        unsupportedPanel.setBorder(BorderFactory.createEmptyBorder(50, 20, 50, 20));
        unsupportedPanel.add(unsupportedTextArea);
        this.add((Component)unsupportedPanel, "North");
    }

    private void initSummaryPanel() {
        TransparentPanel summaryPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        summaryPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        TransparentPanel leftPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel avatarPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel radioButtonPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        this.globalIcon = new JRadioButton(Resources.getString("plugin.accountinfo.GLOBAL_ICON"));
        this.globalIcon.setSelected(true);
        this.globalIcon.setOpaque(false);
        this.globalIcon.setEnabled(false);
        this.localIcon = new JRadioButton(Resources.getString("plugin.accountinfo.LOCAL_ICON"));
        this.localIcon.setOpaque(false);
        this.localIcon.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.globalIcon);
        group.add(this.localIcon);
        radioButtonPanel.add(this.globalIcon);
        radioButtonPanel.add(this.localIcon);
        avatarPanel.add((Component)radioButtonPanel, "North");
        leftPanel.add((Component)avatarPanel, "North");
        summaryPanel.add((Component)leftPanel, "West");
        this.detailToTextField.put(ServerStoredDetails.ImageDetail.class, new JTextField());
        this.imageWithMenu = new FramedImageWithMenu(Resources.getImage("service.gui.DEFAULT_USER_PHOTO"), Resources.getImage("service.gui.DEFAULT_USER_PHOTO").getIconWidth(), Resources.getImage("service.gui.DEFAULT_USER_PHOTO").getIconHeight());
        SelectAvatarMenu selectAvatarMenu = new SelectAvatarMenu(this.imageWithMenu);
        selectAvatarMenu.setAccountID(this.protocolProvider.getAccountID());
        this.imageWithMenu.setPopupMenu((JPopupMenu)selectAvatarMenu);
        avatarPanel.add((Component)this.imageWithMenu, "South");
        this.globalIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDetailsPanel.this.imageWithMenu.setEnabled(false);
            }
        });
        this.localIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDetailsPanel.this.imageWithMenu.setEnabled(true);
            }
        });
        this.imageWithMenu.setEnabled(false);
        this.valuesPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        this.valuesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints first = new GridBagConstraints();
        first.gridx = 0;
        first.gridy = 0;
        first.weightx = 0.0;
        first.anchor = 21;
        first.gridwidth = 1;
        first.insets = new Insets(4, 4, 4, 4);
        first.fill = 2;
        GridBagConstraints second = new GridBagConstraints();
        second.gridx = 1;
        second.gridy = 0;
        second.weightx = 2.0;
        second.anchor = 21;
        second.gridwidth = 1;
        second.insets = first.insets;
        second.fill = 2;
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.DisplayNameDetail.class)) {
            this.displayNameField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.DISPLAY_NAME")), first);
            this.valuesPanel.add((Component)this.displayNameField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.DisplayNameDetail.class, this.displayNameField);
        }
        this.firstNameField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.FIRST_NAME")), first);
        this.valuesPanel.add((Component)this.firstNameField, second);
        ++second.gridy;
        first.gridy = second.gridy++;
        this.detailToTextField.put(ServerStoredDetails.FirstNameDetail.class, this.firstNameField);
        this.middleNameField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.MIDDLE_NAME")), first);
        this.valuesPanel.add((Component)this.middleNameField, second);
        first.gridy = second.gridy++;
        this.detailToTextField.put(ServerStoredDetails.MiddleNameDetail.class, this.middleNameField);
        this.lastNameField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.LAST_NAME")), first);
        this.valuesPanel.add((Component)this.lastNameField, second);
        first.gridy = second.gridy++;
        this.detailToTextField.put(ServerStoredDetails.LastNameDetail.class, this.lastNameField);
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.NicknameDetail.class)) {
            this.nicknameField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.NICKNAME")), first);
            this.valuesPanel.add((Component)this.nicknameField, second);
            first.gridy = second.gridy;
            this.detailToTextField.put(ServerStoredDetails.NicknameDetail.class, this.nicknameField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.URLDetail.class)) {
            this.urlField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.URL")), first);
            this.valuesPanel.add((Component)this.urlField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.URLDetail.class, this.urlField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.GenderDetail.class)) {
            this.genderField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.GENDER")), first);
            this.valuesPanel.add((Component)this.genderField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.GenderDetail.class, this.genderField);
        }
        this.birthDayCalendar = new JDateChooser();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.BDAY")), first);
        this.valuesPanel.add((Component)this.birthDayCalendar, second);
        this.birthDayCalendar.setDateFormatString(Resources.getString("plugin.accountinfo.BDAY_FORMAT"));
        this.birthDayCalendar.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date date;
                if (evt.getPropertyName().equals("date") && (date = (Date)evt.getNewValue()) != null) {
                    Calendar currentDate = Calendar.getInstance();
                    Calendar c = Calendar.getInstance();
                    c.setTime(date);
                    int age = currentDate.get(1) - c.get(1);
                    if (currentDate.get(2) < c.get(2)) {
                        --age;
                    }
                    if (currentDate.get(2) == c.get(2) && currentDate.get(5) < c.get(5)) {
                        --age;
                    }
                    String ageDetail = Integer.toString(age).trim();
                    AccountDetailsPanel.this.ageField.setText(ageDetail);
                }
            }
        });
        ++second.gridy;
        first.gridy = second.gridy++;
        this.ageField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.AGE")), first);
        this.valuesPanel.add((Component)this.ageField, second);
        first.gridy = second.gridy++;
        this.ageField.setEditable(false);
        this.detailToTextField.put(ServerStoredDetails.BirthDateDetail.class, new JTextField());
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.AddressDetail.class)) {
            this.streetAddressField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.STREET")), first);
            this.valuesPanel.add((Component)this.streetAddressField, second);
            first.gridy = second.gridy;
            this.detailToTextField.put(ServerStoredDetails.AddressDetail.class, this.streetAddressField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.CityDetail.class)) {
            this.cityField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.CITY")), first);
            this.valuesPanel.add((Component)this.cityField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.CityDetail.class, this.cityField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.ProvinceDetail.class)) {
            this.regionField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.REGION")), first);
            this.valuesPanel.add((Component)this.regionField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.ProvinceDetail.class, this.regionField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.PostalCodeDetail.class)) {
            this.postalCodeField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.POST")), first);
            this.valuesPanel.add((Component)this.postalCodeField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.PostalCodeDetail.class, this.postalCodeField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.CountryDetail.class)) {
            this.countryField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.COUNTRY")), first);
            this.valuesPanel.add((Component)this.countryField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.CountryDetail.class, this.countryField);
        }
        this.emailField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.EMAIL")), first);
        this.valuesPanel.add((Component)this.emailField, second);
        ++second.gridy;
        first.gridy = second.gridy++;
        this.detailToTextField.put(ServerStoredDetails.EmailAddressDetail.class, this.emailField);
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkEmailAddressDetail.class)) {
            this.workEmailField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.WORK_EMAIL")), first);
            this.valuesPanel.add((Component)this.workEmailField, second);
            first.gridy = second.gridy;
            this.detailToTextField.put(ServerStoredDetails.WorkEmailAddressDetail.class, this.workEmailField);
        }
        this.phoneField = new JTextField();
        this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.PHONE")), first);
        this.valuesPanel.add((Component)this.phoneField, second);
        ++second.gridy;
        first.gridy = second.gridy++;
        this.detailToTextField.put(ServerStoredDetails.PhoneNumberDetail.class, this.phoneField);
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkPhoneDetail.class)) {
            this.workPhoneField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.WORK_PHONE")), first);
            this.valuesPanel.add((Component)this.workPhoneField, second);
            first.gridy = second.gridy;
            this.detailToTextField.put(ServerStoredDetails.WorkPhoneDetail.class, this.workPhoneField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.MobilePhoneDetail.class)) {
            this.mobilePhoneField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.MOBILE_PHONE")), first);
            this.valuesPanel.add((Component)this.mobilePhoneField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.MobilePhoneDetail.class, this.mobilePhoneField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkOrganizationNameDetail.class)) {
            this.organizationField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.ORGANIZATION")), first);
            this.valuesPanel.add((Component)this.organizationField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.WorkOrganizationNameDetail.class, this.organizationField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.JobTitleDetail.class)) {
            this.jobTitleField = new JTextField();
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.JOB_TITLE")), first);
            this.valuesPanel.add((Component)this.jobTitleField, second);
            first.gridy = ++second.gridy;
            this.detailToTextField.put(ServerStoredDetails.JobTitleDetail.class, this.jobTitleField);
        }
        if (this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.AboutMeDetail.class)) {
            this.aboutMeArea = new JTextArea(3, 0);
            this.valuesPanel.add((Component)new JLabel(Resources.getString("plugin.accountinfo.ABOUT_ME")), first);
            second.gridheight = 3;
            JScrollPane areaScrollPane = new JScrollPane(this.aboutMeArea);
            areaScrollPane.setOpaque(false);
            areaScrollPane.setBorder(BorderFactory.createEmptyBorder());
            areaScrollPane.setVerticalScrollBarPolicy(20);
            this.valuesPanel.add((Component)areaScrollPane, second);
            first.gridy = ++second.gridy;
            DefaultStyledDocument doc = new DefaultStyledDocument();
            doc.setDocumentFilter(new DocumentFilter(){
                private final int MAX_CHARACTERS = Integer.valueOf(Resources.getString("plugin.accountinfo.ABOUT_ME_MAX_CHARACTERS"));

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
                    if (fb.getDocument().getLength() + str.length() <= this.MAX_CHARACTERS) {
                        super.insertString(fb, offs, str, a);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
                    if (fb.getDocument().getLength() + str.length() - length <= this.MAX_CHARACTERS) {
                        super.replace(fb, offs, length, str, a);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            });
            this.aboutMeArea.setDocument(doc);
            this.aboutMeArea.setBorder(this.firstNameField.getBorder());
            this.aboutMeArea.setLineWrap(true);
            this.aboutMeArea.setWrapStyleWord(true);
            this.aboutMeArea.setPreferredSize(new Dimension(50, 100));
            this.aboutMeArea.setMinimumSize(new Dimension(50, 100));
            this.detailToTextField.put(ServerStoredDetails.AboutMeDetail.class, new JTextField());
        }
        this.mainScrollPane = new JScrollPane((Component)summaryPanel, 20, 31);
        this.mainScrollPane.getViewport().setOpaque(false);
        this.mainScrollPane.setOpaque(false);
        this.mainScrollPane.setBorder(BorderFactory.createEmptyBorder());
        summaryPanel.add((Component)this.valuesPanel, "Center");
        this.add(this.mainScrollPane);
        this.applyButton.addActionListener(new SubmitActionListener());
        JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountDetailsPanel.this.dialog.close(false);
                AccountDetailsPanel.this.mainScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(cancelButton);
        this.add(this.buttonPanel);
        for (Component component : this.valuesPanel.getComponents()) {
            component.setEnabled(false);
        }
        if (this.aboutMeArea != null) {
            this.aboutMeArea.setEnabled(false);
        }
        this.applyButton.setEnabled(false);
    }

    public void loadDetails() {
        if (this.accountInfoOpSet != null) {
            new DetailsLoadWorker().start();
        }
    }

    private void loadDetail(ServerStoredDetails.GenericDetail detail) {
        if (detail.getClass().equals(ServerStoredDetails.AboutMeDetail.class)) {
            this.aboutMeDetail = (ServerStoredDetails.AboutMeDetail)detail;
            this.aboutMeArea.setText((String)detail.getDetailValue());
            return;
        }
        if (detail instanceof ServerStoredDetails.BirthDateDetail) {
            this.birthDateDetail = (ServerStoredDetails.BirthDateDetail)detail;
            Calendar calendarDetail = (Calendar)this.birthDateDetail.getDetailValue();
            this.birthDayCalendar.setCalendar(calendarDetail);
            return;
        }
        JTextField field = this.detailToTextField.get(detail.getClass());
        if (field != null) {
            if (detail instanceof ServerStoredDetails.ImageDetail) {
                this.localIcon.setSelected(true);
                this.avatarDetail = (ServerStoredDetails.ImageDetail)detail;
                byte[] avatarImage = this.avatarDetail.getBytes();
                this.imageWithMenu.setImageIcon(avatarImage);
            } else if (detail instanceof ServerStoredDetails.URLDetail) {
                this.urlDetail = (ServerStoredDetails.URLDetail)detail;
                this.urlField.setText(this.urlDetail.getURL().toString());
            } else {
                Object obj = detail.getDetailValue();
                if (obj instanceof String) {
                    field.setText((String)obj);
                } else if (obj != null) {
                    field.setText(obj.toString());
                }
                if (detail.getClass().equals(ServerStoredDetails.DisplayNameDetail.class)) {
                    this.displayNameDetail = (ServerStoredDetails.DisplayNameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.FirstNameDetail.class)) {
                    this.firstNameDetail = (ServerStoredDetails.FirstNameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.MiddleNameDetail.class)) {
                    this.middleNameDetail = (ServerStoredDetails.MiddleNameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.LastNameDetail.class)) {
                    this.lastNameDetail = (ServerStoredDetails.LastNameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.NicknameDetail.class)) {
                    this.nicknameDetail = (ServerStoredDetails.NicknameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.URLDetail.class)) {
                    this.urlDetail = (ServerStoredDetails.URLDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.GenderDetail.class)) {
                    this.genderDetail = (ServerStoredDetails.GenderDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.AddressDetail.class)) {
                    this.streetAddressDetail = (ServerStoredDetails.AddressDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.CityDetail.class)) {
                    this.cityDetail = (ServerStoredDetails.CityDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.ProvinceDetail.class)) {
                    this.regionDetail = (ServerStoredDetails.ProvinceDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.PostalCodeDetail.class)) {
                    this.postalCodeDetail = (ServerStoredDetails.PostalCodeDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.CountryDetail.class)) {
                    this.countryDetail = (ServerStoredDetails.CountryDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.PhoneNumberDetail.class)) {
                    this.phoneDetail = (ServerStoredDetails.PhoneNumberDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.WorkPhoneDetail.class)) {
                    this.workPhoneDetail = (ServerStoredDetails.WorkPhoneDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.MobilePhoneDetail.class)) {
                    this.mobilePhoneDetail = (ServerStoredDetails.MobilePhoneDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.EmailAddressDetail.class)) {
                    this.emailDetail = (ServerStoredDetails.EmailAddressDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.WorkEmailAddressDetail.class)) {
                    this.workEmailDetail = (ServerStoredDetails.WorkEmailAddressDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.WorkOrganizationNameDetail.class)) {
                    this.organizationDetail = (ServerStoredDetails.WorkOrganizationNameDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.JobTitleDetail.class)) {
                    this.jobTitleDetail = (ServerStoredDetails.JobTitleDetail)detail;
                } else if (detail.getClass().equals(ServerStoredDetails.AboutMeDetail.class)) {
                    this.aboutMeDetail = (ServerStoredDetails.AboutMeDetail)detail;
                }
            }
        }
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    private class SubmitActionListener
    implements ActionListener {
        private SubmitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerStoredDetails.DisplayNameDetail newDetail;
            String text;
            ServerStoredDetails.ImageDetail newDetail2;
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.ImageDetail.class) && AccountDetailsPanel.this.globalIcon.isSelected()) {
                GlobalDisplayDetailsService serv = AccountInfoActivator.getGlobalDisplayDetailsService();
                byte[] newIcon = serv.getGlobalDisplayAvatar();
                newDetail2 = null;
                if (newIcon != null) {
                    newDetail2 = new ServerStoredDetails.ImageDetail("avatar", serv.getGlobalDisplayAvatar());
                }
                if (AccountDetailsPanel.this.avatarDetail != null || newDetail2 != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.avatarDetail, (ServerStoredDetails.GenericDetail)newDetail2);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.DisplayNameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.DisplayNameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.DisplayNameDetail(text);
                }
                if (AccountDetailsPanel.this.displayNameDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.displayNameDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.FirstNameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.FirstNameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.FirstNameDetail(text);
                }
                if (AccountDetailsPanel.this.firstNameDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.firstNameDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.MiddleNameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.MiddleNameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.MiddleNameDetail(text);
                }
                if (AccountDetailsPanel.this.middleNameDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.middleNameDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.LastNameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.LastNameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.LastNameDetail(text);
                }
                if (AccountDetailsPanel.this.lastNameDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.lastNameDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.NicknameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.NicknameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.NicknameDetail(text);
                }
                if (AccountDetailsPanel.this.nicknameDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.nicknameDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.URLDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.URLDetail.class)).getText();
                URL url = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    try {
                        url = new URL(text);
                    }
                    catch (MalformedURLException e1) {
                        AccountDetailsPanel.this.logger.debug((Object)"Failed to update URL detail due to malformed URL.");
                    }
                }
                newDetail2 = null;
                if (url != null) {
                    newDetail2 = new ServerStoredDetails.URLDetail("URL", url);
                }
                if (AccountDetailsPanel.this.urlDetail != null || newDetail2 != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.urlDetail, (ServerStoredDetails.GenericDetail)newDetail2);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.GenderDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.GenderDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.GenderDetail(text);
                }
                if (AccountDetailsPanel.this.genderDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.genderDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.BirthDateDetail.class)) {
                ServerStoredDetails.BirthDateDetail newDetail3 = null;
                if (AccountDetailsPanel.this.birthDayCalendar.getDate() != null) {
                    newDetail3 = new ServerStoredDetails.BirthDateDetail(AccountDetailsPanel.this.birthDayCalendar.getCalendar());
                }
                if (AccountDetailsPanel.this.birthDateDetail != null || newDetail3 != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.birthDateDetail, (ServerStoredDetails.GenericDetail)newDetail3);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.AddressDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.AddressDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.AddressDetail(text);
                }
                if (AccountDetailsPanel.this.streetAddressDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.streetAddressDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.CityDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.CityDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.CityDetail(text);
                }
                if (AccountDetailsPanel.this.cityDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.cityDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.ProvinceDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.ProvinceDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.ProvinceDetail(text);
                }
                if (AccountDetailsPanel.this.regionDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.regionDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.PostalCodeDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.PostalCodeDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.PostalCodeDetail(text);
                }
                if (AccountDetailsPanel.this.postalCodeDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.postalCodeDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.CountryDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.CountryDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.CountryDetail(text);
                }
                if (AccountDetailsPanel.this.countryDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.countryDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.EmailAddressDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.EmailAddressDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.EmailAddressDetail(text);
                }
                if (AccountDetailsPanel.this.emailDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.emailDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkEmailAddressDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.WorkEmailAddressDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.WorkEmailAddressDetail(text);
                }
                if (AccountDetailsPanel.this.workEmailDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.workEmailDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.PhoneNumberDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.PhoneNumberDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.PhoneNumberDetail(text);
                }
                if (AccountDetailsPanel.this.phoneDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.phoneDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkPhoneDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.WorkPhoneDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.WorkPhoneDetail(text);
                }
                if (AccountDetailsPanel.this.workPhoneDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.workPhoneDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.MobilePhoneDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.MobilePhoneDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.MobilePhoneDetail(text);
                }
                if (AccountDetailsPanel.this.mobilePhoneDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.mobilePhoneDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.WorkOrganizationNameDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.WorkOrganizationNameDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.WorkOrganizationNameDetail(text);
                }
                if (AccountDetailsPanel.this.organizationDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.organizationDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.JobTitleDetail.class)) {
                text = ((JTextField)AccountDetailsPanel.this.detailToTextField.get(ServerStoredDetails.JobTitleDetail.class)).getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.JobTitleDetail(text);
                }
                if (AccountDetailsPanel.this.jobTitleDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.jobTitleDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            if (AccountDetailsPanel.this.accountInfoOpSet.isDetailClassSupported(ServerStoredDetails.AboutMeDetail.class)) {
                text = AccountDetailsPanel.this.aboutMeArea.getText();
                newDetail = null;
                if (!StringUtils.isNullOrEmpty((String)text, (boolean)true)) {
                    newDetail = new ServerStoredDetails.AboutMeDetail(text);
                }
                if (AccountDetailsPanel.this.aboutMeDetail != null || newDetail != null) {
                    this.changeDetail((ServerStoredDetails.GenericDetail)AccountDetailsPanel.this.aboutMeDetail, (ServerStoredDetails.GenericDetail)newDetail);
                }
            }
            try {
                AccountDetailsPanel.this.dialog.close(false);
                AccountDetailsPanel.this.accountInfoOpSet.save();
            }
            catch (OperationFailedException e1) {
                AccountDetailsPanel.this.logger.debug((Object)"Failed to update account details.", (Throwable)e1);
            }
        }

        private void changeDetail(ServerStoredDetails.GenericDetail oldDetail, ServerStoredDetails.GenericDetail newDetail) {
            try {
                if (newDetail == null) {
                    AccountDetailsPanel.this.accountInfoOpSet.removeDetail(oldDetail);
                } else if (oldDetail == null) {
                    AccountDetailsPanel.this.accountInfoOpSet.addDetail(newDetail);
                } else {
                    AccountDetailsPanel.this.accountInfoOpSet.replaceDetail(oldDetail, newDetail);
                }
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                AccountDetailsPanel.this.logger.debug((Object)("Failed to update account details. " + newDetail.getDetailDisplayName() + " " + e1));
            }
            catch (OperationFailedException e1) {
                AccountDetailsPanel.this.logger.debug((Object)("Failed to update account details. " + newDetail.getDetailDisplayName() + " " + (Object)((Object)e1)));
            }
        }
    }

    private class DetailsLoadWorker
    extends SwingWorker {
        private DetailsLoadWorker() {
        }

        protected Object construct() throws Exception {
            return AccountDetailsPanel.this.accountInfoOpSet.getAllAvailableDetails();
        }

        protected void finished() {
            Iterator allDetails = (Iterator)this.get();
            if (allDetails == null) {
                return;
            }
            while (allDetails.hasNext()) {
                ServerStoredDetails.GenericDetail detail = (ServerStoredDetails.GenericDetail)allDetails.next();
                AccountDetailsPanel.this.loadDetail(detail);
            }
            boolean isAnyDetailEditable = false;
            for (Class editable : AccountDetailsPanel.this.detailToTextField.keySet()) {
                if (!AccountDetailsPanel.this.accountInfoOpSet.isDetailClassEditable(editable)) continue;
                isAnyDetailEditable = true;
                if (editable.equals(ServerStoredDetails.AboutMeDetail.class)) {
                    AccountDetailsPanel.this.aboutMeArea.setEnabled(true);
                    continue;
                }
                if (editable.equals(ServerStoredDetails.BirthDateDetail.class)) {
                    AccountDetailsPanel.this.birthDayCalendar.setEnabled(true);
                    continue;
                }
                if (editable.equals(ServerStoredDetails.ImageDetail.class)) {
                    AccountDetailsPanel.this.globalIcon.setEnabled(true);
                    AccountDetailsPanel.this.localIcon.setEnabled(true);
                    AccountDetailsPanel.this.imageWithMenu.setEnabled(true);
                    continue;
                }
                JTextField field = (JTextField)AccountDetailsPanel.this.detailToTextField.get(editable);
                field.setEnabled(true);
            }
            if (isAnyDetailEditable) {
                AccountDetailsPanel.this.applyButton.setEnabled(true);
            }
        }
    }
}

