/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.createforms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chatroomslist.createforms.ChatRoomNamePanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;

public class CreateChatRoomDialog
extends SIPCommDialog
implements ActionListener {
    private ChatRoomNamePanel chatRoomPanel = new ChatRoomNamePanel();
    private JButton addButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CREATE"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private ChatRoomProviderWrapper chatRoomProvider;

    public CreateChatRoomDialog(ChatRoomProviderWrapper provider) {
        this.chatRoomProvider = provider;
        this.init();
    }

    private void init() {
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM"));
        this.setSize(620, 450);
        this.setPreferredSize(new Dimension(620, 450));
        this.getRootPane().setDefaultButton(this.addButton);
        this.addButton.setName("create");
        this.cancelButton.setName("cancel");
        this.addButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CREATE"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.addButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.cancelButton);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.mainPanel.add((Component)((Object)this.chatRoomPanel), "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("create")) {
            String chatRoomName = this.chatRoomPanel.getChatRoomName();
            GuiActivator.getMUCService().createChatRoom(chatRoomName, this.chatRoomProvider.getProtocolProvider(), null, "", true);
        }
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }
}

