/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.configuration;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import net.java.sip.communicator.slick.configuration.ConfigurationServiceLick;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.xml.XMLUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestConfigurationServicePersistency
extends TestCase {
    private static final String property1 = "p1";
    private static final String property1Value = "p1.value";
    private static final String property1Value2 = "p1.value.2";
    private static final String property1Path = "parent.";
    private static final String systemProperty = "SYSTEM_PROPERTY";
    private static final String systemPropertyValue = "I AM the SyS guy";
    private static final String systemPropertyValue2 = "sys guy's new face";
    private static final String systemPropertyPath = "parent.";
    private static final String addedProperty = "ADDED_PROPERTY";
    private static final String addedPropertyValue = "added";
    private static final String addedPropertyValue2 = "and then re-aded";
    private static final String addedPropertyPath = "parent.";
    private static final String innerProperty = "INNER_PROPERTY";
    private static final String innerPropertyValue = "I am an insider";
    private static final String innerPropertyValue2 = "I am a modified inner";
    private static final String innerPropertyPath = "parent.innerprops.";
    private static final String confFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sip-communicator>\n   <parent>\n      <p1 value=\"p1.value\"/>\n      <SYSTEM_PROPERTY value=\"I AM the SyS guy\" system=\"true\"/>\n      <innerprops>\n          <INNER_PROPERTY value=\"I am an insider\"/>\n      </innerprops>\n   </parent>\n</sip-communicator>\n";
    private static final String confFileContent2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sip-communicator>\n    <parent>\n       <p1 value=\"p1.value.2\"/>\n       <SYSTEM_PROPERTY value=\"sys guy's new face\" system=\"true\"/>\n       <innerprops>\n           <INNER_PROPERTY value=\"I am a modified inner\"/>\n       </innerprops>\n    </parent>\n</sip-communicator>\n";
    private static final String ourConfFileName = "test.persistency.sip-communicator.xml";
    private String originalConfFileName = null;
    private File confFile = null;
    private ConfigurationService configurationService = null;

    public TestConfigurationServicePersistency(String name) {
        super(name);
        BundleContext context = ConfigurationServiceLick.bc;
        ServiceReference ref = context.getServiceReference(ConfigurationService.class.getName());
        this.configurationService = (ConfigurationService)context.getService(ref);
    }

    protected void setUp() throws Exception {
        String confDirLocation = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION", System.getProperty("user.home"));
        String confDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME", ".sip-communicator");
        this.confFile = new File(confDirLocation + File.separator + confDirName, ourConfFileName);
        this.configurationService.purgeStoredConfiguration();
        this.originalConfFileName = System.getProperty("net.java.sip.communicator.CONFIGURATION_FILE_NAME");
        System.setProperty("net.java.sip.communicator.CONFIGURATION_FILE_NAME", ourConfFileName);
        this.confFile.getParentFile().mkdir();
        this.confFile.createNewFile();
        FileOutputStream out = new FileOutputStream(this.confFile);
        out.write(confFileContent.getBytes());
        out.flush();
        out.close();
        this.configurationService.reloadConfiguration();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.confFile.delete();
        this.configurationService.purgeStoredConfiguration();
        System.setProperty("net.java.sip.communicator.CONFIGURATION_FILE_NAME", this.originalConfFileName);
        super.tearDown();
    }

    public void testLoadConfiguration() {
        Object returnedValueObj = this.configurationService.getProperty("parent.p1");
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly loaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        String returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly loaded", (String)property1Value, (String)returnedValue);
        returnedValueObj = this.configurationService.getProperty("parent.SYSTEM_PROPERTY");
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly loaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        returnedValue = System.getProperty("parent.SYSTEM_PROPERTY");
        TestConfigurationServicePersistency.assertNotNull((String)"A system property was not resolved", (Object)returnedValue);
        TestConfigurationServicePersistency.assertEquals((String)"A system property was not resolved", (String)systemPropertyValue, (String)returnedValue);
        returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly loaded", (String)systemPropertyValue, (String)returnedValue);
        returnedValueObj = this.configurationService.getProperty("parent.innerprops.INNER_PROPERTY").toString();
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly loaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly loaded", (String)innerPropertyValue, (String)returnedValue);
    }

    public void testReLoadConfiguration() throws Exception {
        this.configurationService.setProperty("parent.ADDED_PROPERTY", (Object)addedPropertyValue);
        FileOutputStream out = new FileOutputStream(this.confFile);
        out.write(confFileContent2.getBytes());
        out.flush();
        out.close();
        this.configurationService.reloadConfiguration();
        Object returnedValueObj = this.configurationService.getProperty("parent.p1");
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly loaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        String returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly reloaded", (String)property1Value2, (String)returnedValue);
        returnedValueObj = this.configurationService.getProperty("parent.SYSTEM_PROPERTY");
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly reloaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly reloaded", (String)systemPropertyValue2, (String)returnedValue);
        returnedValue = System.getProperty("parent.SYSTEM_PROPERTY");
        TestConfigurationServicePersistency.assertNotNull((String)"A system property was not resolved", (Object)returnedValue);
        TestConfigurationServicePersistency.assertEquals((String)"A system property was not resolved", (String)systemPropertyValue2, (String)returnedValue);
        returnedValueObj = this.configurationService.getProperty("parent.innerprops.INNER_PROPERTY");
        TestConfigurationServicePersistency.assertNotNull((String)"configuration not properly reloaded", (Object)returnedValueObj);
        TestConfigurationServicePersistency.assertTrue((String)"returned prop is not a String", (boolean)(returnedValueObj instanceof String));
        returnedValue = returnedValueObj.toString();
        TestConfigurationServicePersistency.assertEquals((String)"configuration not properly reloaded", (String)innerPropertyValue2, (String)returnedValue);
        returnedValueObj = this.configurationService.getProperty("parent.ADDED_PROPERTY");
        TestConfigurationServicePersistency.assertNull((String)"reload didn't remove newly added properties", (Object)returnedValueObj);
    }

    public void testStoreConfiguration() throws Exception {
        this.configurationService.setProperty("parent.ADDED_PROPERTY", (Object)addedPropertyValue2);
        this.configurationService.setProperty("parent.p1", (Object)property1Value2);
        this.configurationService.setProperty("parent.SYSTEM_PROPERTY", (Object)systemPropertyValue2);
        this.configurationService.setProperty("parent.innerprops.INNER_PROPERTY", (Object)innerPropertyValue2);
        this.configurationService.storeConfiguration();
        this.configurationService.reloadConfiguration();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(this.confFile);
        Node root = document.getFirstChild();
        Element parent = XMLUtils.findChild((Element)((Element)root), (String)"parent");
        Element property1Node = XMLUtils.findChild((Element)parent, (String)property1);
        Element systemPropertyNode = XMLUtils.findChild((Element)parent, (String)systemProperty);
        Element addedPropertyNode = XMLUtils.findChild((Element)parent, (String)addedProperty);
        Element innerpropNode = XMLUtils.findChild((Element)parent, (String)"innerprops");
        Element innerPropertyNode = XMLUtils.findChild((Element)innerpropNode, (String)innerProperty);
        String xmlProp1Value = XMLUtils.getAttribute((Node)property1Node, (String)"value");
        String xmlProp2Value = XMLUtils.getAttribute((Node)systemPropertyNode, (String)"value");
        String xmlAddedPropertyValue = XMLUtils.getAttribute((Node)addedPropertyNode, (String)"value");
        String xmlInnerPropertyValue = XMLUtils.getAttribute((Node)innerPropertyNode, (String)"value");
        TestConfigurationServicePersistency.assertEquals((String)"property1 was incorrectly stored", (String)property1Value2, (String)xmlProp1Value);
        TestConfigurationServicePersistency.assertEquals((String)"System property was incorrectly stored", (String)systemPropertyValue2, (String)xmlProp2Value);
        TestConfigurationServicePersistency.assertEquals((String)"The added property was incorrectly stored", (String)addedPropertyValue2, (String)xmlAddedPropertyValue);
        TestConfigurationServicePersistency.assertEquals((String)"The inner property was incorrectly stored", (String)innerPropertyValue2, (String)xmlInnerPropertyValue);
    }
}

