/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jibri;

import java.util.Collection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class JibriIq
extends IQ {
    public static final String ACTION_ATTR_NAME = "action";
    public static final String ELEMENT_NAME = "jibri";
    public static final String NAMESPACE = "http://jitsi.org/protocol/jibri";
    static final String STATUS_ATTR_NAME = "status";
    static final String STREAM_ID_ATTR_NAME = "streamid";
    static final String ROOM_ATTR_NAME = "room";
    private Action action = Action.UNDEFINED;
    private XMPPError error;
    private Status status = Status.UNDEFINED;
    private String streamId = null;
    private String room = null;

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getChildElementXML() {
        Collection extensions;
        StringBuilder xml = new StringBuilder();
        xml.append('<').append(ELEMENT_NAME);
        xml.append(" xmlns='").append(NAMESPACE).append("' ");
        if (this.action != Action.UNDEFINED) {
            this.printStringAttribute(xml, ACTION_ATTR_NAME, this.action.toString());
        }
        if (this.status != Status.UNDEFINED) {
            this.printStringAttribute(xml, STATUS_ATTR_NAME, this.status.toString());
        }
        if (this.room != null) {
            this.printStringAttribute(xml, ROOM_ATTR_NAME, this.room);
        }
        if (this.streamId != null) {
            this.printStringAttribute(xml, STREAM_ID_ATTR_NAME, this.streamId);
        }
        if ((extensions = this.getExtensions()).size() > 0) {
            xml.append(">");
            for (PacketExtension extension : extensions) {
                xml.append(extension.toXML());
            }
            xml.append("</").append(ELEMENT_NAME).append(">");
        } else {
            xml.append("/>");
        }
        return xml.toString();
    }

    private void printStringAttribute(StringBuilder xml, String attrName, String attr) {
        if (!org.jitsi.util.StringUtils.isNullOrEmpty((String)attr)) {
            attr = StringUtils.escapeForXML((String)attr);
            xml.append(attrName).append("='").append(attr).append("' ");
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setXMPPError(XMPPError error) {
        this.error = error;
    }

    public XMPPError getError() {
        return this.error;
    }

    public static enum Status {
        ON("on"),
        OFF("off"),
        PENDING("pending"),
        RETRYING("retrying"),
        FAILED("failed"),
        BUSY("busy"),
        UNDEFINED("undefined");

        private String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Status parse(String status) {
            if (org.jitsi.util.StringUtils.isNullOrEmpty((String)status)) {
                return UNDEFINED;
            }
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }

    public static enum Action {
        START("start"),
        STOP("stop"),
        UNDEFINED("undefined");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Action parse(String action) {
            if (org.jitsi.util.StringUtils.isNullOrEmpty((String)action)) {
                return UNDEFINED;
            }
            try {
                return Action.valueOf(action.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

