/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.generators;

import djb.Curve25519;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.cryptozrtp.AsymmetricCipherKeyPair;
import org.bouncycastle.cryptozrtp.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.cryptozrtp.KeyGenerationParameters;
import org.bouncycastle.cryptozrtp.params.Djb25519KeyGenerationParameters;
import org.bouncycastle.cryptozrtp.params.Djb25519PrivateKeyParameters;
import org.bouncycastle.cryptozrtp.params.Djb25519PublicKeyParameters;
import org.bouncycastle.mathzrtp.ec.ECConstants;

public class Djb25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    RandomGenerator random;

    @Override
    public void init(KeyGenerationParameters param) {
        Djb25519KeyGenerationParameters ecP = (Djb25519KeyGenerationParameters)param;
        this.random = ecP.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int nBitLength = 256;
        byte[] k = new byte[32];
        this.random.nextBytes(k);
        byte[] P = new byte[32];
        Curve25519.keygen(P, null, k);
        return new AsymmetricCipherKeyPair(new Djb25519PublicKeyParameters(P), new Djb25519PrivateKeyParameters(k));
    }
}

