/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.ScreenInformation;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.plugin.desktoputil.WindowUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigPropertyVetoException;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;

public class SIPCommDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(SIPCommDialog.class);
    private ActionMap amap;
    private InputMap imap;
    private boolean isSaveSizeAndLocation = true;

    public SIPCommDialog() {
        this.init();
    }

    public SIPCommDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public SIPCommDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public SIPCommDialog(Window owner) {
        super(owner);
        this.init();
        if (owner == null) {
            SIPCommFrame.updateIconImages(this);
        }
    }

    public SIPCommDialog(boolean isSaveSizeAndLocation) {
        this();
        this.isSaveSizeAndLocation = isSaveSizeAndLocation;
    }

    public SIPCommDialog(Dialog owner, boolean isSaveSizeAndLocation) {
        this(owner);
        this.isSaveSizeAndLocation = isSaveSizeAndLocation;
    }

    public SIPCommDialog(Frame owner, boolean isSaveSizeAndLocation) {
        this(owner);
        this.isSaveSizeAndLocation = isSaveSizeAndLocation;
    }

    public SIPCommDialog(Window owner, boolean isSaveSizeAndLocation) {
        this(owner);
        this.isSaveSizeAndLocation = isSaveSizeAndLocation;
    }

    private void init() {
        if (!OSUtils.IS_MAC) {
            this.setContentPane(new SIPCommFrame.MainContentPane());
        }
        this.addWindowListener(new DialogWindowAdapter());
        this.initInputMap();
        WindowUtils.addWindow(this);
    }

    private void initInputMap() {
        this.amap = this.getRootPane().getActionMap();
        this.amap.put("close", new CloseAction());
        this.imap = this.getRootPane().getInputMap(2);
        this.imap.put(KeyStroke.getKeyStroke(27, 0), "close");
        if (OSUtils.IS_MAC) {
            this.imap.put(KeyStroke.getKeyStroke(87, 256), "close");
            this.imap.put(KeyStroke.getKeyStroke(87, 128), "close");
        }
    }

    protected void addKeyBinding(KeyStroke keyStroke, Action action) {
        String actionID = action.getClass().getName();
        this.amap.put(actionID, action);
        this.imap.put(keyStroke, actionID);
    }

    private void saveSizeAndLocation() {
        try {
            SIPCommFrame.saveSizeAndLocation(this, true, true);
        }
        catch (ConfigPropertyVetoException e1) {
            logger.error((Object)"The proposed property change represents an unacceptable value");
        }
    }

    private void setSizeAndLocation() {
        ConfigurationService config = DesktopUtilActivator.getConfigurationService();
        String className = this.getClass().getName().replaceAll("\\$", "_");
        int width = config.getInt(className + ".width", 0);
        int height = config.getInt(className + ".height", 0);
        String xString = config.getString(className + ".x");
        String yString = config.getString(className + ".y");
        if (width > 0 && height > 0) {
            this.setSize(width, height);
        }
        if (xString != null && yString != null) {
            int y;
            int x = Integer.parseInt(xString);
            if (ScreenInformation.isTitleOnScreen(new Rectangle(x, y = Integer.parseInt(yString), width, height)) || config.getBoolean("net.sip.communicator.util.swing.USE_CALCULATED_POSITIONING", true)) {
                this.setLocation(x, y);
            }
        } else {
            this.setCenterLocation();
        }
    }

    private void setCenterLocation() {
        this.setLocationRelativeTo(this.getParent());
    }

    private void ensureOnScreenLocationAndSize() {
        ConfigurationService config = DesktopUtilActivator.getConfigurationService();
        if (!config.getBoolean("net.sip.communicator.util.swing.USE_CALCULATED_POSITIONING", true)) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle virtualBounds = ScreenInformation.getScreenBounds();
        int borderDistance = 10;
        if (!virtualBounds.contains(x, y)) {
            if (x < virtualBounds.x) {
                x = virtualBounds.x + 10;
            } else if (x > virtualBounds.x && (x = virtualBounds.x + virtualBounds.width - width - 10) < virtualBounds.x + 10) {
                x = virtualBounds.x + 10;
            }
            if (y < virtualBounds.y) {
                y = virtualBounds.y + 10;
            } else if (y > virtualBounds.y && (y = virtualBounds.y + virtualBounds.height - height - 10) < virtualBounds.y + 10) {
                y = virtualBounds.y + 10;
            }
            this.setLocation(x, y);
        }
        if (!virtualBounds.contains(x, y, width, height)) {
            if (x + width > virtualBounds.x + virtualBounds.width && (x = virtualBounds.x + virtualBounds.width - width - 10) < virtualBounds.x + 10) {
                x = virtualBounds.x + 10;
                width = virtualBounds.width - 20;
            }
            if (y + height > virtualBounds.y + virtualBounds.height && (y = virtualBounds.y + virtualBounds.height - height - 10) < virtualBounds.y + 10) {
                y = virtualBounds.y + 10;
                height = virtualBounds.height - 20;
            }
            this.setPreferredSize(new Dimension(width, height));
            this.setSize(width, height);
            this.setLocation(x, y);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.pack();
            if (this.isSaveSizeAndLocation) {
                this.setSizeAndLocation();
            } else {
                this.pack();
                this.setCenterLocation();
            }
            this.ensureOnScreenLocationAndSize();
            JButton button = this.getRootPane().getDefaultButton();
            if (button != null) {
                button.requestFocus();
            }
        }
        super.setVisible(isVisible);
    }

    @Override
    public void dispose() {
        if (this.isSaveSizeAndLocation) {
            this.saveSizeAndLocation();
        }
        super.dispose();
    }

    protected void close(boolean escaped) {
    }

    public class DialogWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            if (SIPCommDialog.this.isSaveSizeAndLocation) {
                SIPCommDialog.this.saveSizeAndLocation();
            }
            SIPCommDialog.this.close(false);
        }
    }

    private class CloseAction
    extends UIAction {
        private static final long serialVersionUID = 0L;

        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SIPCommDialog.this.isSaveSizeAndLocation) {
                SIPCommDialog.this.saveSizeAndLocation();
            }
            SIPCommDialog.this.close(true);
        }
    }
}

