/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.util.Logger;

public abstract class SwingWorker {
    private static final Logger logger = Logger.getLogger(SwingWorker.class);
    private static ExecutorService executorService;
    private final Callable<Object> callable = new Callable<Object>(){

        @Override
        public Object call() {
            Object value = null;
            try {
                value = SwingWorker.this.construct();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingWorker.this.catchException(t);
                    }
                });
            }
            if (!Thread.currentThread().isInterrupted()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingWorker.this.finished();
                    }
                });
            }
            return value;
        }
    };
    private Future<?> future;

    protected void catchException(Throwable exception) {
        logger.error((Object)"unhandled exception caught", exception);
    }

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Future<?> future;
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            future = this.future;
        }
        Object value = null;
        if (future != null) {
            boolean interrupted = false;
            while (true) {
                try {
                    value = future.get();
                }
                catch (CancellationException ce) {
                }
                catch (ExecutionException ee) {
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Future<?> future;
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            future = this.future;
        }
        if (future != null) {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = SwingWorker.class;
        synchronized (SwingWorker.class) {
            if (executorService == null) {
                executorService = Executors.newCachedThreadPool();
            }
            ExecutorService executorService = SwingWorker.executorService;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = this;
            synchronized (object) {
                if (this.future != null && !this.future.isDone()) {
                    throw new IllegalStateException("future");
                }
                this.future = executorService.submit(this.callable);
            }
            return;
        }
    }
}

