/*
 * Decompiled with CFR 0.152.
 */
package ch.imvs.sdes4j.srtp;

import ch.imvs.sdes4j.KeyParam;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class SrtpKeyParam
implements KeyParam {
    public static final String KEYMETHOD_INLINE = "inline";
    private final String keyMethod = "inline";
    private byte[] key;
    private int lifetime;
    private int mki;
    private int mkiLength;

    public SrtpKeyParam(String keyMethod, byte[] key, int lifetime, int mki, int mkiLength) {
        if (!keyMethod.equals(KEYMETHOD_INLINE)) {
            throw new IllegalArgumentException("key method must be inline");
        }
        if (mkiLength < 0 || mkiLength > 128) {
            throw new IllegalArgumentException("mki length must be in range 1..128 inclusive or 0 to indicate default");
        }
        this.key = key;
        this.lifetime = lifetime;
        this.mki = mki;
        this.mkiLength = mkiLength;
    }

    public SrtpKeyParam(String keyParam) {
        if (!keyParam.startsWith("inline:")) {
            throw new IllegalArgumentException("Unknown key method in <" + keyParam + ">");
        }
        keyParam = keyParam.substring(KEYMETHOD_INLINE.length() + 1);
        String[] parts = keyParam.split("\\|");
        this.key = Base64.decodeBase64((String)parts[0]);
        if (this.key.length == 0) {
            throw new IllegalArgumentException("key must be present");
        }
        int partIndex = 1;
        if (parts.length > 1 && !parts[1].contains(":")) {
            this.lifetime = parts[1].startsWith("2^") ? (int)Math.pow(2.0, Double.valueOf(parts[1].substring(2))) : Integer.valueOf(parts[1]);
            ++partIndex;
        }
        if (parts.length > partIndex && parts[partIndex].contains(":")) {
            String[] mkiParts = parts[partIndex].split(":");
            this.mki = Integer.valueOf(mkiParts[0]);
            this.mkiLength = Integer.valueOf(mkiParts[1]);
            if (this.mkiLength < 1 || this.mkiLength > 128) {
                throw new IllegalArgumentException("mki length must be in range 1..128 inclusive");
            }
        }
    }

    public String getKeyMethod() {
        return KEYMETHOD_INLINE;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getMki() {
        return this.mki;
    }

    public int getMkiLength() {
        return this.mkiLength;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEYMETHOD_INLINE);
        sb.append(':');
        sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])this.key, (boolean)false)));
        if (this.lifetime > 0) {
            sb.append('|');
            sb.append(this.lifetime);
        }
        if (this.mkiLength > 0) {
            sb.append('|');
            sb.append(this.mki);
            sb.append(':');
            sb.append(this.mkiLength);
        }
        return sb.toString();
    }
}

