/*
 * Decompiled with CFR 0.152.
 */
package ch.imvs.sdes4j.srtp;

import ch.imvs.sdes4j.SessionParam;
import ch.imvs.sdes4j.srtp.FecKeySessionParam;
import ch.imvs.sdes4j.srtp.FecOrderSessionParam;
import ch.imvs.sdes4j.srtp.KdrSessionParam;
import ch.imvs.sdes4j.srtp.NoAuthSessionParam;
import ch.imvs.sdes4j.srtp.PlainSrtcpSessionParam;
import ch.imvs.sdes4j.srtp.PlainSrtpSessionParam;
import ch.imvs.sdes4j.srtp.WshSessionParam;

public abstract class SrtpSessionParam
implements SessionParam {
    SrtpSessionParam() {
    }

    public static SrtpSessionParam create(String param) {
        if (param.startsWith("KDR=")) {
            return new KdrSessionParam(param);
        }
        if (param.equals("UNENCRYPTED_SRTP")) {
            return new PlainSrtpSessionParam();
        }
        if (param.equals("UNENCRYPTED_SRTCP")) {
            return new PlainSrtcpSessionParam();
        }
        if (param.equals("UNAUTHENTICATED_SRTP")) {
            return new NoAuthSessionParam();
        }
        if (param.startsWith("FEC_ORDER=")) {
            return new FecOrderSessionParam(param);
        }
        if (param.startsWith("FEC_KEY=")) {
            return new FecKeySessionParam(param);
        }
        if (param.startsWith("WSH=")) {
            return new WshSessionParam(param);
        }
        throw new IllegalArgumentException("Unknown session parameter");
    }
}

