/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h263p;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;

public class JNIEncoder
extends AbstractCodec {
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final Format[] DEFAULT_OUTPUT_FORMATS = new Format[]{new VideoFormat("h263-1998")};
    private static final int IFRAME_INTERVAL = 300;
    private static final String PLUGIN_NAME = "H.263+ Encoder";
    private long avcontext = 0L;
    private long avFrame = 0L;
    private int encFrameLen = 0;
    private int framesSinceLastIFrame = 301;
    private long rawFrameBuffer = 0L;

    public JNIEncoder() {
        this.inputFormats = new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            FFmpeg.avcodec_close((long)this.avcontext);
            FFmpeg.av_free((long)this.avcontext);
            this.avcontext = 0L;
            FFmpeg.avcodec_free_frame((long)this.avFrame);
            this.avFrame = 0L;
            FFmpeg.av_free((long)this.rawFrameBuffer);
            this.rawFrameBuffer = 0L;
        }
    }

    private Format[] getMatchingOutputFormats(Format in) {
        VideoFormat videoIn = (VideoFormat)in;
        return new VideoFormat[]{new VideoFormat("h263-1998", videoIn.getSize(), -1, Format.byteArray, videoIn.getFrameRate())};
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return DEFAULT_OUTPUT_FORMATS;
        }
        if (!(in instanceof VideoFormat) || null == AbstractCodec2.matches(in, this.inputFormats)) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(in);
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        if (this.inputFormat == null) {
            throw new ResourceUnavailableException("No input format selected");
        }
        if (this.outputFormat == null) {
            throw new ResourceUnavailableException("No output format selected");
        }
        VideoFormat outputVideoFormat = (VideoFormat)this.outputFormat;
        Dimension size = outputVideoFormat.getSize();
        int width = size.width;
        int height = size.height;
        long avcodec = FFmpeg.avcodec_find_encoder((int)20);
        this.avcontext = FFmpeg.avcodec_alloc_context3((long)avcodec);
        FFmpeg.avcodeccontext_set_pix_fmt((long)this.avcontext, (int)0);
        FFmpeg.avcodeccontext_set_size((long)this.avcontext, (int)width, (int)height);
        FFmpeg.avcodeccontext_set_qcompress((long)this.avcontext, (float)0.6f);
        int bitRate = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoBitrate() * 1000;
        int frameRate = (int)outputVideoFormat.getFrameRate();
        if (frameRate == -1) {
            frameRate = 30;
        }
        FFmpeg.avcodeccontext_set_bit_rate((long)this.avcontext, (int)bitRate);
        FFmpeg.avcodeccontext_set_bit_rate_tolerance((long)this.avcontext, (int)(bitRate / (frameRate - 1)));
        FFmpeg.avcodeccontext_set_time_base((long)this.avcontext, (int)1, (int)frameRate);
        FFmpeg.avcodeccontext_set_mb_decision((long)this.avcontext, (int)0);
        FFmpeg.avcodeccontext_add_flags((long)this.avcontext, (int)2048);
        FFmpeg.avcodeccontext_add_flags((long)this.avcontext, (int)0x2000000);
        FFmpeg.avcodeccontext_add_flags((long)this.avcontext, (int)0x1000000);
        FFmpeg.avcodeccontext_add_flags((long)this.avcontext, (int)0x10000000);
        FFmpeg.avcodeccontext_set_me_method((long)this.avcontext, (int)6);
        FFmpeg.avcodeccontext_set_me_subpel_quality((long)this.avcontext, (int)2);
        FFmpeg.avcodeccontext_set_me_range((long)this.avcontext, (int)18);
        FFmpeg.avcodeccontext_set_me_cmp((long)this.avcontext, (int)256);
        FFmpeg.avcodeccontext_set_scenechange_threshold((long)this.avcontext, (int)40);
        FFmpeg.avcodeccontext_set_gop_size((long)this.avcontext, (int)300);
        if (FFmpeg.avcodec_open2((long)this.avcontext, (long)avcodec, (String[])new String[0]) < 0) {
            throw new ResourceUnavailableException("Could not open codec. (size= " + width + "x" + height + ")");
        }
        this.encFrameLen = width * height * 3 / 2;
        this.rawFrameBuffer = FFmpeg.av_malloc((int)this.encFrameLen);
        this.avFrame = FFmpeg.avcodec_alloc_frame();
        int sizeInBytes = width * height;
        FFmpeg.avframe_set_data((long)this.avFrame, (long)this.rawFrameBuffer, (long)sizeInBytes, (long)(sizeInBytes / 4));
        FFmpeg.avframe_set_linesize((long)this.avFrame, (int)width, (int)(width / 2), (int)(width / 2));
        this.opened = true;
        super.open();
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        byte[] out;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.matches(this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if (inBuffer.getLength() < 3) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        FFmpeg.memcpy((long)this.rawFrameBuffer, (byte[])((byte[])inBuffer.getData()), (int)inBuffer.getOffset(), (int)this.encFrameLen);
        if (this.framesSinceLastIFrame >= 300) {
            FFmpeg.avframe_set_key_frame((long)this.avFrame, (boolean)true);
            this.framesSinceLastIFrame = 0;
        } else {
            ++this.framesSinceLastIFrame;
            FFmpeg.avframe_set_key_frame((long)this.avFrame, (boolean)false);
        }
        Object outData = outBuffer.getData();
        if (outData instanceof byte[]) {
            out = (byte[])outData;
            if (out.length < this.encFrameLen) {
                out = null;
            }
        } else {
            out = null;
        }
        if (out == null) {
            out = new byte[this.encFrameLen];
        }
        int outputLength = FFmpeg.avcodec_encode_video((long)this.avcontext, (byte[])out, (int)out.length, (long)this.avFrame);
        outBuffer.setData((Object)out);
        outBuffer.setLength(outputLength);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.inputFormats)) {
            return null;
        }
        YUVFormat yuvFormat = (YUVFormat)format;
        if (yuvFormat.getOffsetU() > yuvFormat.getOffsetV()) {
            return null;
        }
        this.inputFormat = AbstractCodec2.specialize(yuvFormat, Format.byteArray);
        return this.inputFormat;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        this.outputFormat = new VideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate());
        return this.outputFormat;
    }
}

