/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.rtcp;

import java.util.Arrays;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class CompoundPacketEngine
implements TransformEngine,
PacketTransformer {
    private static final int MAX_INDIVIDUAL = 20;
    private final int[] counts = new int[20];

    private static int getLengthInBytes(byte[] buf, int off, int len) {
        if (len < 4) {
            return -1;
        }
        int v = (buf[off] & 0xC0) >>> 6;
        if (2 != v) {
            return -1;
        }
        int lengthInWords = (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
        int lengthInBytes = (lengthInWords + 1) * 4;
        if (len < lengthInBytes) {
            return -1;
        }
        return lengthInBytes;
    }

    @Override
    public void close() {
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return null;
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        int len;
        int i;
        int needed = 0;
        boolean needToSplit = false;
        Arrays.fill(this.counts, 0);
        for (i = 0; i < pkts.length; ++i) {
            int l;
            RawPacket pkt = pkts[i];
            int individual = 0;
            if (pkt == null) continue;
            byte[] buf = pkt.getBuffer();
            int off = pkt.getOffset();
            len = pkt.getLength();
            while ((l = CompoundPacketEngine.getLengthInBytes(buf, off, len)) >= 0) {
                ++individual;
                off += l;
                len -= l;
            }
            if (individual == 0) {
                pkts[i] = null;
            }
            if (individual > 1) {
                needToSplit = true;
            }
            needed += individual;
            this.counts[i] = individual;
        }
        if (!needToSplit) {
            return pkts;
        }
        if (needed > 20) {
            return pkts;
        }
        if (needed > pkts.length) {
            RawPacket[] newPkts = new RawPacket[needed];
            System.arraycopy(pkts, 0, newPkts, 0, pkts.length);
            pkts = newPkts;
        }
        for (i = 0; i < pkts.length; ++i) {
            int j;
            if (this.counts[i] <= 1) continue;
            for (j = 0; j < pkts.length && pkts[j] != null; ++j) {
            }
            byte[] oldBuf = pkts[i].getBuffer();
            int oldOff = pkts[i].getOffset();
            int oldLen = pkts[i].getLength();
            len = CompoundPacketEngine.getLengthInBytes(oldBuf, oldOff, oldLen);
            byte[] buf = new byte[len];
            System.arraycopy(oldBuf, oldOff, buf, 0, len);
            pkts[j] = new RawPacket(buf, 0, len);
            int n = j;
            this.counts[n] = this.counts[n] + 1;
            pkts[i].setOffset(oldOff + len);
            pkts[i].setLength(oldLen - len);
            int n2 = i--;
            this.counts[n2] = this.counts[n2] - 1;
        }
        return pkts;
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }
}

