/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.AccountManagerUtils;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountUninstallationPersistence
extends TestCase {
    public TestAccountUninstallationPersistence(String testName) {
        super(testName);
    }

    public void testAccountUninstallationPersistence() throws Exception {
        Bundle providerBundle = SipSlickFixture.providerBundle;
        providerBundle.stop();
        TestAccountUninstallationPersistence.assertTrue((String)("Couldn't stop the protocol provider bundle. State was " + providerBundle.getState()), (32 != providerBundle.getState() && 16 != providerBundle.getState() ? 1 : 0) != 0);
        providerBundle.uninstall();
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't stop the protocol provider bundle.", (int)1, (int)providerBundle.getState());
        providerBundle = SipSlickFixture.bc.installBundle(providerBundle.getLocation());
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't re-install protocol provider bundle.", (int)2, (int)providerBundle.getState());
        AccountManagerUtils.startBundleAndWaitStoredAccountsLoaded((BundleContext)SipSlickFixture.bc, (Bundle)providerBundle, (String)"SIP");
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't re-start protocol provider bundle.", (int)32, (int)providerBundle.getState());
        ServiceReference[] sipProviderRefs = null;
        try {
            sipProviderRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(PROTOCOL_NAME=SIP)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallationPersistence.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallationPersistence.assertTrue((String)"A SIP Protocol Provider Service was still regged as an osgi service after it was explicitly uninstalled", (sipProviderRefs == null || sipProviderRefs.length == 0 ? 1 : 0) != 0);
        ServiceReference confReference = SipSlickFixture.bc.getServiceReference(ConfigurationService.class.getName());
        ConfigurationService configurationService = (ConfigurationService)SipSlickFixture.bc.getService(confReference);
        configurationService.purgeStoredConfiguration();
    }
}

