/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ActionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.CommonPolicyParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ConditionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.IdentityType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.OneType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RuleType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RulesetType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.TransformationsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.ContentType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DataType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DescriptionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.EncodingType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.MimeType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.PresContentParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvidePersonPermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvideServicePermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryRefType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ExternalType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ListType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.AuidsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.ExtensionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.NamespacesType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.XCapCapsParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.XCapCapsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.CannotDeleteType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.UniquenessFailureType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapErrorParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapErrorType;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestXCapParse
extends TestCase {
    private static String RESOURCE_LISTS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><resource-lists xmlns=\"urn:ietf:params:xml:ns:resource-lists\"                xmlns:ext=\"extension\"                xmlns:xsi=\"htt//www.w3.org/2001/XMLSchema-instance\">                xsi:schemaLocation=\"resource-lists.xsd \">  <list name=\"list1\" ext:name=\"ext list1\">    <entry uri=\"sip:entry1@example.com\"           ext:uri=\"sip:user1@example.com\">      <display-name>Entry1</display-name>      <ext:display-name>Ext:Entry1</ext:display-name>    </entry>    <entry uri=\"sip:entry2@example.com\">      <display-name xml:lang=\"en-US\">Entry2</display-name>    </entry>    <list name=\"sub_group1\"/>    <external anchor=\"anchor_uri\">      <display-name xml:lang=\"en-US\">External</display-name>    </external>    <entry-ref ref=\"ref_uri\">      <display-name xml:lang=\"en-US\">Entry1</display-name>    </entry-ref>    <ext:entry uri=\"sip:user1@example.com\"                ext:uri=\"sip:user1@example.com\"/>  </list>  <list name=\"list2\">    <display-name xml:lang=\"en-US\">List2</display-name>  </list></resource-lists>";
    private static String XCAP_CAPS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xcap-caps xmlns=\"urn:ietf:params:xml:ns:xcap-caps\"           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"           xsi:schemaLocation=\"xcap-caps.xsd \">  <auids>    <auid>resource-lists</auid>    <auid>rls-services</auid>  </auids>  <extensions>    <!-- No extensions defined -->  </extensions>  <namespaces>    <namespace>urn:ietf:params:xml:ns:xcap-caps</namespace>    <namespace>urn:ietf:params:xml:ns:xcap-error</namespace>    <namespace>urn:ietf:params:xml:ns:resource-lists</namespace>  </namespaces></xcap-caps>";
    private static String PRES_CONTENT_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><content xmlns=\"urn:oma:xml:prs:pres-content\">  <mime-type>image/png</mime-type>  <encoding>base64</encoding>  <description>Description</description>  <description xml:lang=\"en-US\">Description</description>  <data>Data</data></content>";
    private static String XCAP_ERROR_CANNOT_DELETE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">  <cannot-delete phrase=\"Cannot Delete\"/></xcap-error>";
    private static String XCAP_ERROR_UNIQUENESS_FAILURE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">  <uniqueness-failure>    <exists field=\"field\">      <alt-value>sip:entry@example.com</alt-value>  </exists>  </uniqueness-failure></xcap-error>";
    private static String PRES_RULES_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><cr:ruleset xmlns=\"urn:ietf:params:xml:ns:pres-rules\"            xmlns:pr=\"urn:ietf:params:xml:ns:pres-rules\"            xmlns:cr=\"urn:ietf:params:xml:ns:common-policy\">  <cr:rule id=\"rule1\">    <cr:conditions>      <cr:identity>        <cr:one id=\"sip:entry@example.com\"/>      </cr:identity>    </cr:conditions>    <cr:actions>      <pr:sub-handling>allow</pr:sub-handling>    </cr:actions>    <cr:transformations>      <pr:provide-services>        <pr:service-uri-scheme>sip</pr:service-uri-scheme>        <pr:service-uri-scheme>mailto</pr:service-uri-scheme>      </pr:provide-services>      <pr:provide-persons>        <pr:all-persons/>     </pr:provide-persons>     <pr:provide-activities>true</pr:provide-activities>     <pr:provide-user-input>bare</pr:provide-user-input>     <pr:provide-unknown-attribute        ns=\"urn:vendor-specific:foo-namespace\"        name=\"foo\">true</pr:provide-unknown-attribute>    </cr:transformations>  </cr:rule></cr:ruleset>";

    public static Test suite() {
        return new TestSuite(TestXCapParse.class);
    }

    public static void testResourceListsParse() throws Exception {
        ResourceListsType originalResourceLists = ResourceListsParser.fromXml((String)RESOURCE_LISTS_XML);
        TestXCapParse.validateResourceLists(originalResourceLists);
        String xml = ResourceListsParser.toXml((ResourceListsType)originalResourceLists);
        ResourceListsType storedResourceLists = ResourceListsParser.fromXml((String)xml);
        TestXCapParse.validateResourceLists(storedResourceLists);
    }

    public static void testXCapCapsParse() throws Exception {
        XCapCapsType originalXCapCaps = XCapCapsParser.fromXml((String)XCAP_CAPS_XML);
        TestXCapParse.validateXCapCaps(originalXCapCaps);
    }

    public static void testPresContentParse() throws Exception {
        ContentType originalContent = PresContentParser.fromXml((String)PRES_CONTENT_XML);
        TestXCapParse.validatePresContent(originalContent);
        String xml = PresContentParser.toXml((ContentType)originalContent);
        ContentType storedContent = PresContentParser.fromXml((String)xml);
        TestXCapParse.validatePresContent(storedContent);
    }

    public static void testXCapErrorParse() throws Exception {
        XCapErrorType cannotDelete = XCapErrorParser.fromXml((String)XCAP_ERROR_CANNOT_DELETE_XML);
        TestXCapParse.validateXCapErrorConnotDelete(cannotDelete);
        XCapErrorType uniquenessFailure = XCapErrorParser.fromXml((String)XCAP_ERROR_UNIQUENESS_FAILURE_XML);
        TestXCapParse.validateXCapErrorUniquenessFailure(uniquenessFailure);
    }

    public static void testPresRulesParse() throws Exception {
        RulesetType originalRuleset = CommonPolicyParser.fromXml((String)PRES_RULES_XML);
        TestXCapParse.validatePresRules(originalRuleset);
        String xml = CommonPolicyParser.toXml((RulesetType)originalRuleset);
        RulesetType storedRuleset = CommonPolicyParser.fromXml((String)xml);
        TestXCapParse.validatePresRules(storedRuleset);
    }

    private static void validatePresRules(RulesetType ruleset) {
        TestXCapParse.assertNotNull((String)"pres-rules cannot be null", (Object)ruleset);
        TestXCapParse.assertTrue((String)"The rules we set is not read properly", (ruleset.getRules().size() == 1 ? 1 : 0) != 0);
        RuleType rule = (RuleType)ruleset.getRules().get(0);
        TestXCapParse.assertNotNull((String)"The rules[0] we set is not read properly", (Object)rule.getConditions());
        TestXCapParse.assertNotNull((String)"The rules[0] we set is not read properly", (Object)rule.getActions());
        TestXCapParse.assertNotNull((String)"The rules[0] we set is not read properly", (Object)rule.getTransformations());
        TestXCapParse.assertEquals((String)"The rules[0] id we set is not read properly", (String)rule.getId(), (String)"rule1");
        ConditionsType conditions = rule.getConditions();
        TestXCapParse.assertTrue((String)"The conditions we set is not read properly", (conditions.getIdentities().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The conditions we set is not read properly", (conditions.getSpheres().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The conditions we set is not read properly", (conditions.getValidities().size() == 0 ? 1 : 0) != 0);
        IdentityType identity = (IdentityType)conditions.getIdentities().get(0);
        TestXCapParse.assertTrue((String)"The identity we set is not read properly", (identity.getOneList().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The identity we set is not read properly", (identity.getManyList().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The identity we set is not read properly", (identity.getAny().size() == 0 ? 1 : 0) != 0);
        OneType one = (OneType)identity.getOneList().get(0);
        TestXCapParse.assertEquals((String)"The one we set is not read properly", (String)one.getId(), (String)"sip:entry@example.com");
        TestXCapParse.assertNull((String)"The one we set is not read properly", (Object)one.getAny());
        ActionsType actions = rule.getActions();
        TestXCapParse.assertNotNull((String)"The actions sub-handling we set is not read properly", (Object)actions.getSubHandling());
        TestXCapParse.assertEquals((String)"The actions sub-handling we set is not read properly", (String)actions.getSubHandling().value(), (String)"allow");
        TestXCapParse.assertTrue((String)"The actions we set is not read properly", (actions.getAny().size() == 0 ? 1 : 0) != 0);
        TransformationsType transfomations = rule.getTransformations();
        TestXCapParse.assertNull((String)"The transfomations we set is not read properly", (Object)transfomations.getDevicePermission());
        TestXCapParse.assertNotNull((String)"The transfomations we set is not read properly", (Object)transfomations.getServicePermission());
        ProvideServicePermissionType servicePermission = transfomations.getServicePermission();
        TestXCapParse.assertNull((String)"The servicePermission we set is not read properly", (Object)servicePermission.getAllServices());
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (servicePermission.getOccurrences().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (servicePermission.getClasses().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (servicePermission.getServiceUriList().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (servicePermission.getServiceUriSchemeList().size() == 2 ? 1 : 0) != 0);
        TestXCapParse.assertEquals((String)"The getServiceUriSchemeList[0] we set is not read properly", (String)((ProvideServicePermissionType.ServiceUriSchemeType)servicePermission.getServiceUriSchemeList().get(0)).getValue(), (String)"sip");
        TestXCapParse.assertEquals((String)"The getServiceUriSchemeList[1] we set is not read properly", (String)((ProvideServicePermissionType.ServiceUriSchemeType)servicePermission.getServiceUriSchemeList().get(1)).getValue(), (String)"mailto");
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (servicePermission.getAny().size() == 0 ? 1 : 0) != 0);
        ProvidePersonPermissionType personPermission = transfomations.getPersonPermission();
        TestXCapParse.assertNotNull((String)"The servicePermission we set is not read properly", (Object)personPermission.getAllPersons());
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (personPermission.getOccurrences().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The servicePermission we set is not read properly", (personPermission.getClasses().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The personPermission we set is not read properly", (personPermission.getAny().size() == 0 ? 1 : 0) != 0);
    }

    private static void validateXCapErrorUniquenessFailure(XCapErrorType xCapError) {
        TestXCapParse.assertNotNull((String)"xcap-error cannot be null", (Object)xCapError);
        TestXCapParse.assertNotNull((String)"uniqueness-failure cannot be null", (Object)xCapError.getError());
        TestXCapParse.assertTrue((String)"The uniqueness-failure elements we set is not read properly", (boolean)(xCapError.getError() instanceof UniquenessFailureType));
        UniquenessFailureType uniquenessFailure = (UniquenessFailureType)xCapError.getError();
        TestXCapParse.assertNull((String)"The phrase we set is not read properly", (Object)uniquenessFailure.getPhrase());
        TestXCapParse.assertTrue((String)"The exists elements we set is not read properly", (uniquenessFailure.getExists().size() == 1 ? 1 : 0) != 0);
        UniquenessFailureType.ExistsType exists1 = (UniquenessFailureType.ExistsType)uniquenessFailure.getExists().get(0);
        TestXCapParse.assertEquals((String)"The exists[0] element we set is not read properly", (String)exists1.getField(), (String)"field");
        TestXCapParse.assertTrue((String)"The exists[0]altValue we set is not read properly", (exists1.getAltValue().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertEquals((String)"The exists[0]altValue[0] we set is not read properly", (String)((String)exists1.getAltValue().get(0)), (String)"sip:entry@example.com");
    }

    private static void validateXCapErrorConnotDelete(XCapErrorType xCapError) {
        TestXCapParse.assertNotNull((String)"xcap-error cannot be null", (Object)xCapError);
        TestXCapParse.assertNotNull((String)"cannot-delete cannot be null", (Object)xCapError.getError());
        TestXCapParse.assertTrue((String)"The cannot-delete elements we set is not read properly", (boolean)(xCapError.getError() instanceof CannotDeleteType));
        CannotDeleteType cannotDelete = (CannotDeleteType)xCapError.getError();
        TestXCapParse.assertEquals((String)"The phrase we set is not read properly", (String)cannotDelete.getPhrase(), (String)"Cannot Delete");
    }

    private static void validateResourceLists(ResourceListsType resourceLists) {
        TestXCapParse.assertNotNull((String)"resource-lists cannot be null", (Object)resourceLists);
        TestXCapParse.assertTrue((String)"The first level lists we set is not read properly", (resourceLists.getList().size() == 2 ? 1 : 0) != 0);
        ListType list1 = (ListType)resourceLists.getList().get(0);
        TestXCapParse.assertEquals((String)"The lists[1] name we set is not read properly", (String)list1.getName(), (String)"list1");
        TestXCapParse.assertEquals((String)"The lists[1] name we set is not read properly", (String)list1.getName(), (String)"list1");
        TestXCapParse.assertNull((String)"The lists[1] display-name we set is not read properly", (Object)list1.getDisplayName());
        TestXCapParse.assertTrue((String)"The lists[1] entries we set is not read properly", (list1.getEntries().size() == 2 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The lists[1] lists we set is not read properly", (list1.getLists().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The lists[1] externals we set is not read properly", (list1.getExternals().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The lists[1] entryRefs we set is not read properly", (list1.getEntryRefs().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The lists[1] custom attriutes we set is not read properly", (list1.getAnyAttributes().size() == 1 ? 1 : 0) != 0);
        TestXCapParse.assertTrue((String)"The lists[1] custom elements we set is not read properly", (list1.getAnyAttributes().size() == 1 ? 1 : 0) != 0);
        String list1ExtAttribute = (String)list1.getAnyAttributes().get(new QName("extension", "name", "ext"));
        TestXCapParse.assertNotNull((String)"The lists[1]ext:display-name attribute we set is not read properly", (Object)list1ExtAttribute);
        TestXCapParse.assertEquals((String)"The lists[1]ext:display-name attribute we set is not read properly", (String)list1ExtAttribute, (String)"ext list1");
        Element list1ExtElement = (Element)list1.getAny().get(0);
        TestXCapParse.assertEquals((String)"The lists[1]ext:entry attribute we set is not read properly", (String)list1ExtElement.getLocalName(), (String)"entry");
        TestXCapParse.assertEquals((String)"The lists[1]ext:entry attribute we set is not read properly", (String)XMLUtils.getNamespaceUri((Node)list1ExtElement), (String)"extension");
        TestXCapParse.assertEquals((String)"The lists[1]ext:entry attribute we set is not read properly", (String)list1ExtElement.getPrefix(), (String)"ext");
        EntryType lis1Entry1 = (EntryType)list1.getEntries().get(0);
        TestXCapParse.assertNotNull((String)"The lists[1]entry[1] name we set is not read properly", (Object)lis1Entry1.getUri());
        TestXCapParse.assertEquals((String)"The lists[1]entry[1] name we set is not read properly", (String)lis1Entry1.getUri(), (String)"sip:entry1@example.com");
        TestXCapParse.assertNotNull((String)"The lists[1]entry[1] display-name we set is not read properly", (Object)lis1Entry1.getDisplayName());
        TestXCapParse.assertEquals((String)"The lists[1]entry[1] display-name we set is not read properly", (String)lis1Entry1.getDisplayName().getValue(), (String)"Entry1");
        TestXCapParse.assertNull((String)"The lists[1]entry[1] display-name we set is not read properly", (Object)lis1Entry1.getDisplayName().getLang());
        String enty1ExtAttribute = (String)lis1Entry1.getAnyAttributes().get(new QName("extension", "uri", "ext"));
        TestXCapParse.assertNotNull((String)"The lists[1]entry[1]ext:uri attribute we set is not read properly", (Object)enty1ExtAttribute);
        TestXCapParse.assertEquals((String)"The lists[1]entry[1]ext:uri attribute we set is not read properly", (String)enty1ExtAttribute, (String)"sip:user1@example.com");
        Element enty1ExtElement = (Element)lis1Entry1.getAny().get(0);
        TestXCapParse.assertEquals((String)"The lists[1]entry[1]ext:entry element we set is not read properly", (String)enty1ExtElement.getLocalName(), (String)"display-name");
        TestXCapParse.assertEquals((String)"The lists[1]entry[1]ext:dispaly-name element we set is not read properly", (String)XMLUtils.getNamespaceUri((Node)enty1ExtElement), (String)"extension");
        TestXCapParse.assertEquals((String)"The lists[1]entry[1]ext:dispaly-name element we set is not read properly", (String)enty1ExtElement.getPrefix(), (String)"ext");
        TestXCapParse.assertEquals((String)"The lists[1]entry[1]ext:dispaly-name element we set is not read properly", (String)enty1ExtElement.getTextContent(), (String)"Ext:Entry1");
        EntryType lis1Entry2 = (EntryType)list1.getEntries().get(1);
        TestXCapParse.assertNotNull((String)"The lists[1]entry[2] display-name we set is not read properly", (Object)lis1Entry2.getDisplayName());
        TestXCapParse.assertNotNull((String)"The lists[1]entry[2] name we set is not read properly", (Object)lis1Entry2.getUri());
        TestXCapParse.assertEquals((String)"The lists[1]entry[2] name we set is not read properly", (String)lis1Entry2.getUri(), (String)"sip:entry2@example.com");
        TestXCapParse.assertEquals((String)"The lists[1]entry[2] display-name we set is not read properly", (String)lis1Entry2.getDisplayName().getValue(), (String)"Entry2");
        TestXCapParse.assertEquals((String)"The lists[1]entry[2] display-name we set is not read properly", (String)lis1Entry2.getDisplayName().getLang(), (String)"en-US");
        EntryRefType list1EntryRef = (EntryRefType)list1.getEntryRefs().get(0);
        TestXCapParse.assertEquals((String)"The lists[1]entryRef[1] name we set is not read properly", (String)list1EntryRef.getRef(), (String)"ref_uri");
        TestXCapParse.assertNotNull((String)"The lists[1]entryRef[1] display-name we set is not read properly", (Object)list1EntryRef.getDisplayName());
        TestXCapParse.assertEquals((String)"The llists[1]entryRef[1] display-name we set is not read properly", (String)list1EntryRef.getDisplayName().getValue(), (String)"Entry1");
        TestXCapParse.assertEquals((String)"The lists[1]entryRef[1]display-name we set is not read properly", (String)list1EntryRef.getDisplayName().getLang(), (String)"en-US");
        ExternalType list1External = (ExternalType)list1.getExternals().get(0);
        TestXCapParse.assertEquals((String)"The lists[1]external[1] name we set is not read properly", (String)list1External.getAnchor(), (String)"anchor_uri");
        TestXCapParse.assertNotNull((String)"The lists[1]external[1] display-name we set is not read properly", (Object)list1External.getDisplayName());
        TestXCapParse.assertEquals((String)"The llists[1]external[1] display-name we set is not read properly", (String)list1External.getDisplayName().getValue(), (String)"External");
        TestXCapParse.assertEquals((String)"The lists[1]external[1]display-name we set is not read properly", (String)list1External.getDisplayName().getLang(), (String)"en-US");
        ListType list2 = (ListType)resourceLists.getList().get(1);
        TestXCapParse.assertEquals((String)"The lists[2] name we set is not read properly", (String)list2.getName(), (String)"list2");
        TestXCapParse.assertNotNull((String)"The lists[2] display-name we set is not read properly", (Object)list2.getDisplayName());
        TestXCapParse.assertEquals((String)"The lists[2] display-name we set is not read properly", (String)list2.getDisplayName().getValue(), (String)"List2");
        TestXCapParse.assertEquals((String)"The lists[2] display-name we set is not read properly", (String)list2.getDisplayName().getLang(), (String)"en-US");
    }

    private static void validateXCapCaps(XCapCapsType xCapCaps) {
        TestXCapParse.assertNotNull((String)"xcap-caps cannot be null", (Object)xCapCaps);
        AuidsType auids = xCapCaps.getAuids();
        NamespacesType namespaces = xCapCaps.getNamespaces();
        ExtensionsType extensions = xCapCaps.getExtensions();
        TestXCapParse.assertNotNull((String)"The auids we set is not read properly", (Object)auids);
        TestXCapParse.assertTrue((String)"The auids we set is not read properly", (auids.getAuid().size() == 2 ? 1 : 0) != 0);
        TestXCapParse.assertNotNull((String)"The namespaces we set is not read properly", (Object)namespaces);
        TestXCapParse.assertTrue((String)"The namespaces we set is not read properly", (namespaces.getNamespace().size() == 3 ? 1 : 0) != 0);
        TestXCapParse.assertNotNull((String)"The auids we set is not read properly", (Object)extensions);
        TestXCapParse.assertTrue((String)"The extensions we set is not read properly", (extensions.getExtension().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertEquals((String)"The auids[0] name we set is not read properly", (String)((String)auids.getAuid().get(0)), (String)"resource-lists");
        TestXCapParse.assertEquals((String)"The auids[1] name we set is not read properly", (String)((String)auids.getAuid().get(1)), (String)"rls-services");
        TestXCapParse.assertEquals((String)"The namespaces[0] name we set is not read properly", (String)((String)namespaces.getNamespace().get(0)), (String)"urn:ietf:params:xml:ns:xcap-caps");
        TestXCapParse.assertEquals((String)"The namespaces[1] name we set is not read properly", (String)((String)namespaces.getNamespace().get(1)), (String)"urn:ietf:params:xml:ns:xcap-error");
        TestXCapParse.assertEquals((String)"The namespaces[2] name we set is not read properly", (String)((String)namespaces.getNamespace().get(2)), (String)"urn:ietf:params:xml:ns:resource-lists");
    }

    private static void validatePresContent(ContentType presContent) {
        TestXCapParse.assertNotNull((String)"pres-content cannot be null", (Object)presContent);
        DataType data = presContent.getData();
        MimeType mimeType = presContent.getMimeType();
        EncodingType encoding = presContent.getEncoding();
        TestXCapParse.assertNotNull((String)"The data we set is not read properly", (Object)data);
        TestXCapParse.assertEquals((String)"The data we set is not read properly", (String)data.getValue(), (String)"Data");
        TestXCapParse.assertTrue((String)"The data custom elements we set is not read properly", (data.getAnyAttributes().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertNotNull((String)"The mime-type we set is not read properly", (Object)mimeType);
        TestXCapParse.assertEquals((String)"The mime-type we set is not read properly", (String)mimeType.getValue(), (String)"image/png");
        TestXCapParse.assertTrue((String)"The mime-type custom elements we set is not read properly", (mimeType.getAnyAttributes().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertNotNull((String)"The encoding we set is not read properly", (Object)encoding);
        TestXCapParse.assertEquals((String)"The encoding we set is not read properly", (String)encoding.getValue(), (String)"base64");
        TestXCapParse.assertTrue((String)"The encoding custom elements we set is not read properly", (encoding.getAnyAttributes().size() == 0 ? 1 : 0) != 0);
        TestXCapParse.assertNotNull((String)"The description we set is not read properly", (Object)presContent.getDescription());
        TestXCapParse.assertTrue((String)"The description we set is not read properly", (presContent.getDescription().size() == 2 ? 1 : 0) != 0);
        DescriptionType description1 = (DescriptionType)presContent.getDescription().get(0);
        TestXCapParse.assertEquals((String)"The description[0] we set is not read properly", (String)description1.getValue(), (String)"Description");
        TestXCapParse.assertNull((String)"The description[0] display-name we set is not read properly", (Object)description1.getLang());
        TestXCapParse.assertTrue((String)"The description[0] custom elements we set is not read properly", (description1.getAnyAttributes().size() == 0 ? 1 : 0) != 0);
        DescriptionType description2 = (DescriptionType)presContent.getDescription().get(1);
        TestXCapParse.assertEquals((String)"The description[1] we set is not read properly", (String)description2.getValue(), (String)"Description");
        TestXCapParse.assertEquals((String)"The description[1] we set is not read properly", (String)description2.getLang(), (String)"en-US");
        TestXCapParse.assertTrue((String)"The description[1] custom elements we set is not read properly", (description2.getAnyAttributes().size() == 0 ? 1 : 0) != 0);
    }
}

