/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.IRCUser;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.UserActionMsg;
import com.ircclouds.irc.api.domain.messages.UserNotice;
import com.ircclouds.irc.api.domain.messages.UserPrivMsg;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.PresenceWatcher;
import net.java.sip.communicator.util.Logger;

class BasicPollerPresenceWatcher
implements PresenceWatcher {
    private static final Logger LOGGER = Logger.getLogger(BasicPollerPresenceWatcher.class);
    private static final long INITIAL_PRESENCE_WATCHER_DELAY = 10000L;
    private static final long PRESENCE_WATCHER_PERIOD = 60000L;
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final OperationSetPersistentPresenceIrcImpl operationSet;
    private final Set<String> nickWatchList;

    BasicPollerPresenceWatcher(IRCApi irc, IIRCState connectionState, OperationSetPersistentPresenceIrcImpl operationSet, Set<String> nickWatchList, AtomicReference<String> serverIdentity) {
        if (irc == null) {
            throw new IllegalArgumentException("irc cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (operationSet == null) {
            throw new IllegalArgumentException("operationSet cannot be null");
        }
        this.operationSet = operationSet;
        if (nickWatchList == null) {
            throw new IllegalArgumentException("nickWatchList cannot be null");
        }
        this.nickWatchList = nickWatchList;
        this.setUpPresenceWatcher(serverIdentity);
        LOGGER.debug((Object)"Basic Poller presence watcher initialized.");
    }

    private void setUpPresenceWatcher(AtomicReference<String> serverIdentity) {
        List<List<String>> queryList = Collections.synchronizedList(new LinkedList());
        Timer presenceWatcher = new Timer();
        this.irc.addListener((IMessageListener)new PresenceReplyListener(presenceWatcher, queryList));
        PresenceWatcherTask task = new PresenceWatcherTask(this.nickWatchList, queryList, serverIdentity);
        presenceWatcher.schedule((TimerTask)task, 10000L, 60000L);
        LOGGER.trace((Object)"Basic Poller presence watcher set up.");
    }

    @Override
    public void add(String nick) {
        this.nickWatchList.add(nick);
    }

    @Override
    public void remove(String nick) {
        this.nickWatchList.remove(nick);
    }

    private final class PresenceReplyListener
    extends AbstractIrcMessageListener {
        private static final int RPL_ISON = 303;
        private static final int ERR_NOSUCHNICK = 401;
        private final Timer timer;
        private final List<List<String>> queryList;

        public PresenceReplyListener(Timer timer, List<List<String>> queryList) {
            super(BasicPollerPresenceWatcher.this.irc, BasicPollerPresenceWatcher.this.connectionState);
            if (timer == null) {
                throw new IllegalArgumentException("timer cannot be null");
            }
            this.timer = timer;
            if (queryList == null) {
                throw new IllegalArgumentException("queryList cannot be null");
            }
            this.queryList = queryList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNickChange(NickMessage msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            String oldNick = msg.getSource().getNick();
            String newNick = msg.getNewNick();
            if (oldNick == null || newNick == null) {
                LOGGER.error((Object)("Incomplete nick change message. Old nick: '" + oldNick + "', new nick: '" + newNick + "'."));
                return;
            }
            Set set = BasicPollerPresenceWatcher.this.nickWatchList;
            synchronized (set) {
                if (BasicPollerPresenceWatcher.this.nickWatchList.contains(oldNick)) {
                    this.update(oldNick, IrcStatusEnum.OFFLINE);
                }
                if (BasicPollerPresenceWatcher.this.nickWatchList.contains(newNick)) {
                    this.update(newNick, IrcStatusEnum.ONLINE);
                }
            }
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            if (msg == null || msg.getNumericCode() == null) {
                return;
            }
            switch (msg.getNumericCode()) {
                case 303: {
                    String[] nicks = msg.getText().substring(1).split(" ");
                    List<Object> offline = this.queryList.isEmpty() ? new LinkedList() : this.queryList.remove(0);
                    for (String nick : nicks) {
                        this.update(nick, IrcStatusEnum.ONLINE);
                        offline.remove(nick);
                    }
                    for (String string : offline) {
                        this.update(string, IrcStatusEnum.OFFLINE);
                    }
                    break;
                }
                case 401: {
                    String errortext = msg.getText();
                    int n = errortext.indexOf(32);
                    if (n == -1) {
                        LOGGER.info((Object)"ERR_NOSUCHNICK message does not have expected format.");
                        return;
                    }
                    String errNick = errortext.substring(0, n);
                    this.update(errNick, IrcStatusEnum.OFFLINE);
                    break;
                }
            }
        }

        public void onUserPrivMessage(UserPrivMsg msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            IRCUser user = msg.getSource();
            this.update(user.getNick(), IrcStatusEnum.ONLINE);
        }

        public void onUserNotice(UserNotice msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            IRCUser user = msg.getSource();
            this.update(user.getNick(), IrcStatusEnum.ONLINE);
        }

        public void onUserAction(UserActionMsg msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            IRCUser user = msg.getSource();
            this.update(user.getNick(), IrcStatusEnum.ONLINE);
        }

        public void onChannelJoin(ChanJoinMessage msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            String user = msg.getSource().getNick();
            this.update(user, IrcStatusEnum.ONLINE);
        }

        @Override
        public void onUserQuit(QuitMessage msg) {
            super.onUserQuit(msg);
            String user = msg.getSource().getNick();
            if (user == null) {
                return;
            }
            if (this.localUser(user)) {
                this.timer.cancel();
                this.updateAll(IrcStatusEnum.OFFLINE);
            } else {
                this.update(user, IrcStatusEnum.OFFLINE);
            }
        }

        @Override
        public void onError(ErrorMessage msg) {
            super.onError(msg);
            this.timer.cancel();
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        @Override
        public void onClientError(ClientErrorMessage msg) {
            super.onClientError(msg);
            this.timer.cancel();
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        private void update(String nick, IrcStatusEnum status) {
            if (!BasicPollerPresenceWatcher.this.nickWatchList.contains(nick)) {
                return;
            }
            BasicPollerPresenceWatcher.this.operationSet.updateNickContactPresence(nick, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAll(IrcStatusEnum status) {
            LinkedList list;
            Set set = BasicPollerPresenceWatcher.this.nickWatchList;
            synchronized (set) {
                list = new LinkedList(BasicPollerPresenceWatcher.this.nickWatchList);
            }
            for (String nick : list) {
                BasicPollerPresenceWatcher.this.operationSet.updateNickContactPresence(nick, status);
            }
        }
    }

    private final class PresenceWatcherTask
    extends TimerTask {
        private static final int ISON_RESPONSE_STATIC_MESSAGE_OVERHEAD = 18;
        private final Set<String> watchList;
        private final List<List<String>> queryList;
        private final AtomicReference<String> serverIdentity;

        public PresenceWatcherTask(Set<String> watchList, List<List<String>> queryList, AtomicReference<String> serverIdentity) {
            if (watchList == null) {
                throw new IllegalArgumentException("watchList cannot be null");
            }
            this.watchList = watchList;
            if (queryList == null) {
                throw new IllegalArgumentException("queryList cannot be null");
            }
            this.queryList = queryList;
            if (serverIdentity == null) {
                throw new IllegalArgumentException("serverIdentity reference cannot be null");
            }
            this.serverIdentity = serverIdentity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<String> list;
            if (this.watchList.isEmpty()) {
                LOGGER.trace((Object)"Watch list is empty. Not querying for online presence.");
                return;
            }
            if (this.serverIdentity.get() == null) {
                LOGGER.trace((Object)"Server identity not available yet. Skipping this presence status query.");
                return;
            }
            LOGGER.trace((Object)"Watch list contains nicks: querying presence status.");
            StringBuilder query = new StringBuilder();
            Set<String> set = this.watchList;
            synchronized (set) {
                list = new LinkedList<String>(this.watchList);
            }
            LinkedList<String> nicks = new LinkedList<String>();
            int maxQueryLength = 505 - this.overhead();
            for (String nick : list) {
                if (query.length() + nick.length() >= maxQueryLength) {
                    this.queryList.add(nicks);
                    BasicPollerPresenceWatcher.this.irc.rawMessage(this.createQuery(query));
                    query.delete(0, query.length());
                    nicks = new LinkedList();
                }
                query.append(nick);
                query.append(' ');
                nicks.add(nick);
            }
            if (query.length() > 0) {
                this.queryList.add(nicks);
                BasicPollerPresenceWatcher.this.irc.rawMessage(this.createQuery(query));
            }
        }

        private String createQuery(StringBuilder nicklist) {
            return "ISON " + nicklist;
        }

        private int overhead() {
            return 18 + this.serverIdentity.get().length() + BasicPollerPresenceWatcher.this.connectionState.getNickname().length();
        }
    }
}

