/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.branding;

import java.lang.reflect.Method;
import java.util.Hashtable;
import net.java.sip.communicator.plugin.branding.AboutWindowPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class BrandingActivator
extends AbstractServiceDependentActivator {
    private final Logger logger = Logger.getLogger(BrandingActivator.class);
    private static BundleContext bundleContext;
    private static ResourceManagementService resourcesService;

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void start(Object dependentService) {
        this.registerMenuEntry((UIService)dependentService);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void registerMenuEntry(UIService uiService) {
        if (uiService == null || !uiService.useMacOSXScreenMenuBar() || !this.registerMenuEntryMacOSX(uiService)) {
            this.registerMenuEntryNonMacOSX(uiService);
        }
    }

    private boolean registerMenuEntryMacOSX(UIService uiService) {
        try {
            Class<?> clazz = Class.forName("net.java.sip.communicator.plugin.branding.MacOSXAboutRegistration");
            Method method = clazz.getMethod("run", null);
            Object result = method.invoke(null, (Object[])null);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to register Mac OS X-specific About handling.", (Throwable)ex);
        }
        return false;
    }

    private void registerMenuEntryNonMacOSX(UIService uiService) {
        Hashtable<String, String> helpMenuFilter = new Hashtable<String, String>();
        helpMenuFilter.put("CONTAINER_ID", Container.CONTAINER_HELP_MENU.getID());
        bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new PluginComponentFactory(Container.CONTAINER_HELP_MENU){

            protected PluginComponent getPluginInstance() {
                return new AboutWindowPluginComponent(this.getContainer(), this);
            }
        }, helpMenuFilter);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"ABOUT WINDOW ... [REGISTERED]");
        }
        Hashtable<String, String> chatHelpMenuFilter = new Hashtable<String, String>();
        chatHelpMenuFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_HELP_MENU.getID());
        bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new PluginComponentFactory(Container.CONTAINER_CHAT_HELP_MENU){

            protected PluginComponent getPluginInstance() {
                return new AboutWindowPluginComponent(this.getContainer(), this);
            }
        }, chatHelpMenuFilter);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"CHAT ABOUT WINDOW ... [REGISTERED]");
        }
    }

    static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourcesService;
    }
}

