/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.java.sip.communicator.impl.history.DBStructSerializer;
import net.java.sip.communicator.impl.history.HistoryReaderImpl;
import net.java.sip.communicator.impl.history.HistoryServiceImpl;
import net.java.sip.communicator.impl.history.HistoryWriterImpl;
import net.java.sip.communicator.impl.history.InteractiveHistoryReaderImpl;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.InteractiveHistoryReader;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class HistoryImpl
implements History {
    private static Logger log = Logger.getLogger(HistoryImpl.class);
    public static final String SUPPORTED_FILETYPE = "xml";
    private HistoryID id;
    private HistoryRecordStructure historyRecordStructure;
    private HistoryServiceImpl historyServiceImpl;
    private File directory;
    private HistoryReader reader;
    private InteractiveHistoryReader interactiveReader;
    private HistoryWriter writer;
    private SortedMap<String, Object> historyDocuments = new TreeMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HistoryImpl(HistoryID id, File directory, HistoryRecordStructure historyRecordStructure, HistoryServiceImpl historyServiceImpl) {
        try {
            log.logEntry();
            this.id = id;
            this.directory = directory;
            this.historyServiceImpl = historyServiceImpl;
            this.historyRecordStructure = historyRecordStructure;
            this.reader = null;
            this.writer = null;
            this.reloadDocumentList();
        }
        finally {
            log.logExit();
        }
    }

    @Override
    public HistoryID getID() {
        return this.id;
    }

    @Override
    public HistoryRecordStructure getHistoryRecordsStructure() {
        return this.historyRecordStructure;
    }

    @Override
    public void setHistoryRecordsStructure(HistoryRecordStructure structure) {
        this.historyRecordStructure = structure;
        try {
            File dbDatFile = new File(this.directory, "dbstruct.dat");
            DBStructSerializer dbss = new DBStructSerializer(this.historyServiceImpl);
            dbss.writeHistory(dbDatFile, this);
        }
        catch (IOException e) {
            log.debug((Object)"Could not create new history structure");
        }
    }

    @Override
    public HistoryReader getReader() {
        if (this.reader == null) {
            this.reader = new HistoryReaderImpl(this);
        }
        return this.reader;
    }

    @Override
    public InteractiveHistoryReader getInteractiveReader() {
        if (this.interactiveReader == null) {
            this.interactiveReader = new InteractiveHistoryReaderImpl(this);
        }
        return this.interactiveReader;
    }

    @Override
    public HistoryWriter getWriter() {
        if (this.writer == null) {
            this.writer = new HistoryWriterImpl(this);
        }
        return this.writer;
    }

    protected HistoryServiceImpl getHistoryServiceImpl() {
        return this.historyServiceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadDocumentList() {
        SortedMap<String, Object> sortedMap = this.historyDocuments;
        synchronized (sortedMap) {
            this.historyDocuments.clear();
            File[] files = this.directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String filename;
                if (files[i].isDirectory() || !(filename = files[i].getName()).endsWith(SUPPORTED_FILETYPE)) continue;
                this.historyDocuments.put(filename, files[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document createDocument(String filename) {
        Document retVal = null;
        SortedMap<String, Object> sortedMap = this.historyDocuments;
        synchronized (sortedMap) {
            if (this.historyDocuments.containsKey(filename)) {
                retVal = this.getDocumentForFile(filename);
            } else {
                retVal = this.historyServiceImpl.getDocumentBuilder().newDocument();
                retVal.appendChild(retVal.createElement("history"));
                this.historyDocuments.put(filename, retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String filename) throws InvalidParameterException, IOException {
        File file = new File(this.directory, filename);
        SortedMap<String, Object> sortedMap = this.historyDocuments;
        synchronized (sortedMap) {
            if (!this.historyDocuments.containsKey(filename)) {
                throw new InvalidParameterException("The requested filename does not exist in the document list.");
            }
            Object obj = this.historyDocuments.get(filename);
            if (obj instanceof Document) {
                Document doc;
                Document document = doc = (Document)obj;
                synchronized (document) {
                    XMLUtils.writeXML((Document)doc, (File)file);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String filename, Document doc) throws InvalidParameterException, IOException {
        File file = new File(this.directory, filename);
        SortedMap<String, Object> sortedMap = this.historyDocuments;
        synchronized (sortedMap) {
            if (!this.historyDocuments.containsKey(filename)) {
                throw new InvalidParameterException("The requested filename does not exist in the document list.");
            }
            Document document = doc;
            synchronized (document) {
                XMLUtils.writeXML((Document)doc, (File)file);
            }
        }
    }

    protected Iterator<String> getFileList() {
        return this.historyDocuments.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDocumentForFile(String filename) throws InvalidParameterException, RuntimeException {
        Document retVal = null;
        SortedMap<String, Object> sortedMap = this.historyDocuments;
        synchronized (sortedMap) {
            if (!this.historyDocuments.containsKey(filename)) {
                throw new InvalidParameterException("The requested filename does not exist in the document list.");
            }
            Object obj = this.historyDocuments.get(filename);
            if (obj instanceof Document) {
                retVal = (Document)obj;
            } else if (obj instanceof File) {
                block10: {
                    File file = (File)obj;
                    try {
                        retVal = this.historyServiceImpl.parse(file);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occured while parsing XML document.", (Throwable)e);
                        retVal = this.getFixedDocument(file);
                        if (retVal != null) break block10;
                        return null;
                    }
                }
                if (this.historyServiceImpl.isCacheEnabled()) {
                    this.historyDocuments.put(filename, retVal);
                }
            }
        }
        return retVal;
    }

    public Document getFixedDocument(File file) {
        log.info((Object)("Will try to fix file : " + file));
        StringBuffer resultDocStr = new StringBuffer("<history>");
        try {
            BufferedReader inReader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = inReader.readLine()) != null) {
                String record;
                if (line.indexOf("<record") == -1 || (record = this.getRecordNodeString(line, inReader).toString()) == null || !this.isValidXML(record)) continue;
                resultDocStr.append(record);
            }
        }
        catch (Exception ex1) {
            log.error((Object)("File cannot be fixed. Erro reading! " + ex1.getLocalizedMessage()));
        }
        resultDocStr.append("</history>");
        try {
            Document result = this.historyServiceImpl.parse(new ByteArrayInputStream(resultDocStr.toString().getBytes("UTF-8")));
            log.trace((Object)"File fixed will write to disk!");
            XMLUtils.writeXML((Document)result, (File)file);
            return result;
        }
        catch (Exception ex) {
            System.out.println("again cannot parse " + ex.getMessage());
            return null;
        }
    }

    private StringBuffer getRecordNodeString(String startingLine, BufferedReader inReader) {
        try {
            StringBuffer result = new StringBuffer(startingLine);
            String line = null;
            while ((line = inReader.readLine()) != null) {
                if (line.indexOf("</record>") != -1) {
                    result.append(line);
                    break;
                }
                result.append(line);
            }
            return result;
        }
        catch (IOException ex) {
            log.info((Object)("Error reading record " + ex.getLocalizedMessage()));
            return null;
        }
    }

    private boolean isValidXML(String str) {
        try {
            this.historyServiceImpl.parse(new ByteArrayInputStream(str.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            log.error((Object)("not valid xml " + str + " " + ex.getMessage()));
            return false;
        }
        return true;
    }
}

