/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.impl.history.HistoryImpl;
import net.java.sip.communicator.impl.history.HistoryReaderImpl;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HistoryWriterImpl
implements HistoryWriter {
    public static final int MAX_RECORDS_PER_FILE = 150;
    private static final String CDATA_SUFFIX = "_CDATA";
    private Object docCreateLock = new Object();
    private Object docWriteLock = new Object();
    private HistoryImpl historyImpl;
    private String[] structPropertyNames;
    private Document currentDoc = null;
    private String currentFile = null;
    private int currentDocElements = -1;

    protected HistoryWriterImpl(HistoryImpl historyImpl) {
        this.historyImpl = historyImpl;
        HistoryRecordStructure struct = this.historyImpl.getHistoryRecordsStructure();
        this.structPropertyNames = struct.getPropertyNames();
    }

    @Override
    public void addRecord(HistoryRecord record) throws IOException {
        this.addRecord(record.getPropertyNames(), record.getPropertyValues(), record.getTimestamp(), -1);
    }

    @Override
    public void addRecord(String[] propertyValues) throws IOException {
        this.addRecord(this.structPropertyNames, propertyValues, new Date(), -1);
    }

    @Override
    public void addRecord(String[] propertyValues, Date timestamp) throws IOException {
        this.addRecord(this.structPropertyNames, propertyValues, timestamp, -1);
    }

    @Override
    public void addRecord(String[] propertyValues, int maxNumberOfRecords) throws IOException {
        this.addRecord(this.structPropertyNames, propertyValues, new Date(), maxNumberOfRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(String[] propertyNames, String[] propertyValues, Date date, int maxNumberOfRecords) throws InvalidParameterException, IOException {
        Object object = this.docCreateLock;
        synchronized (object) {
            if (this.currentDoc == null || this.currentDocElements > 150) {
                this.createNewDoc(date, this.currentDoc == null);
            }
        }
        object = this.currentDoc;
        synchronized (object) {
            Node root;
            Node node = root = this.currentDoc.getFirstChild();
            synchronized (node) {
                if (maxNumberOfRecords > -1 && this.currentDocElements >= maxNumberOfRecords) {
                    this.removeFirstRecord(root);
                }
                Element elem = this.createRecord(this.currentDoc, propertyNames, propertyValues, date);
                root.appendChild(elem);
                ++this.currentDocElements;
            }
        }
        object = this.docWriteLock;
        synchronized (object) {
            if (this.historyImpl.getHistoryServiceImpl().isCacheEnabled()) {
                this.historyImpl.writeFile(this.currentFile);
            } else {
                this.historyImpl.writeFile(this.currentFile, this.currentDoc);
            }
        }
    }

    private Element createRecord(Document doc, String[] propertyNames, String[] propertyValues, Date date) {
        Element elem = doc.createElement("record");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        elem.setAttribute("timestamp", sdf.format(date));
        for (int i = 0; i < propertyNames.length; ++i) {
            Text value;
            Element propertyElement;
            String propertyName = propertyNames[i];
            if (propertyName.endsWith(CDATA_SUFFIX)) {
                if (propertyValues[i] == null) continue;
                propertyName = propertyName.replaceFirst(CDATA_SUFFIX, "");
                propertyElement = doc.createElement(propertyName);
                value = doc.createCDATASection(XmlEscapers.xmlContentEscaper().escape(propertyValues[i].replaceAll("\u0000", " ")));
                propertyElement.appendChild(value);
                elem.appendChild(propertyElement);
                continue;
            }
            if (propertyValues[i] == null) continue;
            propertyElement = doc.createElement(propertyName);
            value = doc.createTextNode(XmlEscapers.xmlContentEscaper().escape(propertyValues[i].replaceAll("\u0000", " ")));
            propertyElement.appendChild(value);
            elem.appendChild(propertyElement);
        }
        return elem;
    }

    private void removeFirstRecord(Node root) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        NodeList nodes = ((Element)root).getElementsByTagName("record");
        Node oldestNode = null;
        Date oldestTimeStamp = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Date timestamp;
            Node node = nodes.item(i);
            String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
            try {
                timestamp = sdf.parse(ts);
            }
            catch (ParseException e) {
                timestamp = new Date(Long.parseLong(ts));
            }
            if (oldestNode != null && !oldestTimeStamp.after(timestamp)) continue;
            oldestNode = node;
            oldestTimeStamp = timestamp;
        }
        if (oldestNode != null) {
            root.removeChild(oldestNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRecord(String[] propertyValues, Date timestamp, String timestampProperty) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Iterator<String> fileIterator = HistoryReaderImpl.filterFilesByDate(this.historyImpl.getFileList(), timestamp, null).iterator();
        String filename = null;
        while (fileIterator.hasNext()) {
            filename = fileIterator.next();
            Document doc = this.historyImpl.getDocumentForFile(filename);
            if (doc == null) continue;
            NodeList nodes = doc.getElementsByTagName("record");
            boolean changed = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Date nodeTimeStamp;
                Node nestedNode;
                Node node = nodes.item(i);
                Element idNode = XMLUtils.findChild((Element)((Element)node), (String)timestampProperty);
                if (idNode == null || (nestedNode = idNode.getFirstChild()) == null) continue;
                String nodeValue = nestedNode.getNodeValue();
                try {
                    nodeTimeStamp = sdf.parse(nodeValue);
                }
                catch (ParseException e) {
                    nodeTimeStamp = new Date(Long.parseLong(nodeValue));
                }
                if (nodeTimeStamp.before(timestamp)) continue;
                Element newElem = this.createRecord(doc, this.structPropertyNames, propertyValues, timestamp);
                doc.getFirstChild().insertBefore(newElem, node);
                changed = true;
                break;
            }
            if (!changed) continue;
            Object object = this.docWriteLock;
            synchronized (object) {
                this.historyImpl.writeFile(filename, doc);
            }
            if (!filename.equals(this.currentFile)) break;
            this.currentDoc = doc;
            break;
        }
    }

    private void createNewDoc(Date date, boolean loadLastFile) {
        boolean loaded = false;
        if (loadLastFile) {
            Iterator<String> files = this.historyImpl.getFileList();
            String file = null;
            while (files.hasNext()) {
                file = files.next();
            }
            if (file != null) {
                this.currentDoc = this.historyImpl.getDocumentForFile(file);
                this.currentFile = file;
                loaded = true;
            }
            if (this.currentDoc == null) {
                loaded = false;
            }
        }
        if (!loaded) {
            this.currentFile = Long.toString(date.getTime());
            this.currentFile = this.currentFile + ".xml";
            this.currentDoc = this.historyImpl.createDocument(this.currentFile);
        }
        this.currentDocElements = this.currentDoc.getFirstChild().getChildNodes().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(String idProperty, String idValue, String property, String newValue) throws IOException {
        Iterator<String> fileIterator = this.historyImpl.getFileList();
        String filename = null;
        while (fileIterator.hasNext()) {
            filename = fileIterator.next();
            Document doc = this.historyImpl.getDocumentForFile(filename);
            if (doc == null) continue;
            NodeList nodes = doc.getElementsByTagName("record");
            boolean changed = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                String nodeValue;
                Node nestedNode;
                Node node = nodes.item(i);
                Element idNode = XMLUtils.findChild((Element)((Element)node), (String)idProperty);
                if (idNode == null || (nestedNode = idNode.getFirstChild()) == null || !(nodeValue = nestedNode.getNodeValue()).equals(idValue)) continue;
                Element changedNode = XMLUtils.findChild((Element)((Element)node), (String)property);
                if (changedNode != null) {
                    Node changedNestedNode = changedNode.getFirstChild();
                    changedNestedNode.setNodeValue(newValue);
                } else {
                    Element propertyElement = this.currentDoc.createElement(property);
                    Text value = this.currentDoc.createTextNode(newValue.replaceAll("\u0000", " "));
                    propertyElement.appendChild(value);
                    node.appendChild(propertyElement);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                ((Element)node).setAttribute("timestamp", sdf.format(new Date()));
                changed = true;
                break;
            }
            if (!changed) continue;
            Object object = this.docWriteLock;
            synchronized (object) {
                this.historyImpl.writeFile(filename, doc);
            }
            if (!filename.equals(this.currentFile)) break;
            this.currentDoc = doc;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(HistoryWriter.HistoryRecordUpdater updater) throws IOException {
        Iterator<String> fileIterator = this.historyImpl.getFileList();
        String filename = null;
        while (fileIterator.hasNext()) {
            filename = fileIterator.next();
            Document doc = this.historyImpl.getDocumentForFile(filename);
            if (doc == null) continue;
            NodeList nodes = doc.getElementsByTagName("record");
            boolean changed = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                updater.setHistoryRecord(this.createHistoryRecordFromNode(node));
                if (!updater.isMatching()) continue;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                ((Element)node).setAttribute("timestamp", sdf.format(new Date()));
                Map<String, String> updates = updater.getUpdateChanges();
                for (String nodeName : updates.keySet()) {
                    Element changedNode = XMLUtils.findChild((Element)((Element)node), (String)nodeName);
                    if (changedNode == null) continue;
                    Node changedNestedNode = changedNode.getFirstChild();
                    changedNestedNode.setNodeValue(updates.get(nodeName));
                    changed = true;
                }
            }
            if (!changed) continue;
            Object object = this.docWriteLock;
            synchronized (object) {
                this.historyImpl.writeFile(filename, doc);
            }
            if (!filename.equals(this.currentFile)) break;
            this.currentDoc = doc;
            break;
        }
    }

    private HistoryRecord createHistoryRecordFromNode(Node node) {
        HistoryRecordStructure structure = this.historyImpl.getHistoryRecordsStructure();
        String[] propertyValues = new String[structure.getPropertyCount()];
        int i = 0;
        for (String propertyName : structure.getPropertyNames()) {
            Element childNode = XMLUtils.findChild((Element)((Element)node), (String)propertyName);
            if (childNode == null) {
                ++i;
                continue;
            }
            propertyValues[i] = childNode.getTextContent();
            ++i;
        }
        return new HistoryRecord(structure, propertyValues);
    }
}

