/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.data.Rating;
import com.explodingpixels.macwidgets.ITunesRatingTableCellRenderer;
import com.explodingpixels.macwidgets.ITunesTableHeaderRenderer;
import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.widgets.TableHeaderUtils;
import com.explodingpixels.widgets.TableUtils;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ITunesTableUI
extends BasicTableUI {
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private static final Color TABLE_GRID_COLOR = new Color(0xD9D9D9);
    private static final Color SELECTION_ACTIVE_SELECTION_FOREGROUND_COLOR = Color.WHITE;
    private static final Color SELECTION_ACTIVE_SELECTION_BACKGROUND_COLOR = new Color(4030687);
    private static final Color SELECTION_INACTIVE_SELECTION_FOREGROUND_COLOR = Color.BLACK;
    private static final Color SELECTION_INACTIVE_SELECTION_BACKGROUND_COLOR = new Color(0xC0C0C0);
    private static final Color SELECTION_ACTIVE_BOTTOM_BORDER_COLOR = new Color(125, 170, 234);
    private static final Color SELECTION_INACTIVE_BOTTOM_BORDER_COLOR = new Color(224, 224, 224);

    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.setOpaque(false);
        this.table.setFont(MacFontUtils.ITUNES_FONT);
        this.table.setGridColor(TABLE_GRID_COLOR);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setDefaultRenderer(new ITunesTableHeaderRenderer(this.table));
        this.table.setShowHorizontalLines(false);
        TableHeaderUtils.makeHeaderFillEmptySpace(this.table);
        TableUtils.makeStriped(this.table, EVEN_ROW_COLOR);
        this.table.setDefaultRenderer(Rating.class, new ITunesRatingTableCellRenderer());
        this.table.setDefaultRenderer(Object.class, this.createTransparentTableCellRenderer());
        this.table.setDefaultEditor(Object.class, this.createDefaultTableCellEditor());
        this.makeTableActive();
        WindowUtils.installWindowFocusListener(this.createWindowFocusListener(), this.table);
    }

    protected void installListeners() {
        super.installListeners();
    }

    private void makeTableActive() {
        this.table.setSelectionForeground(SELECTION_ACTIVE_SELECTION_FOREGROUND_COLOR);
        this.table.setSelectionBackground(SELECTION_ACTIVE_SELECTION_BACKGROUND_COLOR);
    }

    private void makeTableInactive() {
        this.table.setSelectionForeground(SELECTION_INACTIVE_SELECTION_FOREGROUND_COLOR);
        this.table.setSelectionBackground(SELECTION_INACTIVE_SELECTION_BACKGROUND_COLOR);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    private TableCellRenderer createTransparentTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JComponent) {
                    JComponent jcomponent = (JComponent)component;
                    jcomponent.setOpaque(isSelected);
                    jcomponent.setBorder(table.isRowSelected(row) ? ITunesTableUI.this.getSelectedRowBorder() : ITunesTableUI.this.getRowBorder());
                }
                return component;
            }
        };
    }

    private TableCellEditor createDefaultTableCellEditor() {
        JTextField textField = new JTextField();
        textField.setFont(MacFontUtils.ITUNES_FONT);
        textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return new DefaultCellEditor(textField);
    }

    private WindowFocusListener createWindowFocusListener() {
        return new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                ITunesTableUI.this.makeTableActive();
            }

            public void windowLostFocus(WindowEvent e) {
                ITunesTableUI.this.makeTableInactive();
            }
        };
    }

    private Border getRowBorder() {
        return BorderFactory.createEmptyBorder(0, 5, 0, 5);
    }

    private Border getSelectedRowBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getSelectedRowBottomHighlight()), BorderFactory.createEmptyBorder(1, 5, 0, 5));
    }

    private Color getSelectedRowBottomHighlight() {
        return WindowUtils.isParentWindowFocused(this.table) ? SELECTION_ACTIVE_BOTTOM_BORDER_COLOR : SELECTION_INACTIVE_BOTTOM_BORDER_COLOR;
    }
}

